/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valacreationmethod.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valareport.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMemberAccessModule*) vala_ccode_control_flow_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = (ValaCCodeMemberAccessModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3;
			ValaDataType* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_type = (_tmp3 = (_tmp2 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp3);
		}
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaMethod* _tmp4;
		ValaMethod* m;
		_tmp4 = NULL;
		m = (_tmp4 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp5;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeFunctionCall* _tmp9;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp12;
				char* _tmp11;
				char* _tmp10;
				ValaCCodeMemberAccess* _tmp13;
				_tmp5 = NULL;
				base_class = (_tmp5 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp9 = NULL;
				vcast = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strdup_printf ("%s_CLASS", _tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp9);
				_tmp12 = NULL;
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("%s_parent_class", _tmp10 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp11 = (g_free (_tmp11), NULL);
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp13 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp13 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp14;
					ValaInterface* base_iface;
					char* _tmp16;
					char* _tmp15;
					char* _tmp17;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp19;
					ValaCCodeIdentifier* _tmp18;
					_tmp14 = NULL;
					base_iface = (_tmp14 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
					_tmp16 = NULL;
					_tmp15 = NULL;
					_tmp17 = NULL;
					parent_iface_var = (_tmp17 = g_strdup_printf ("%s_%s_parent_iface", _tmp15 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp16 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp15 = (g_free (_tmp15), NULL), _tmp17);
					_tmp19 = NULL;
					_tmp18 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (parent_iface_var)), vala_symbol_get_name ((ValaSymbol*) m))));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* inst;
				gboolean _tmp21;
				ValaClass* _tmp23;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp26;
				char* _tmp25;
				char* _tmp24;
				ValaCCodeFunctionCall* _tmp27;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp28;
				_tmp20 = NULL;
				inst = (_tmp20 = pub_inst, (_tmp20 == NULL) ? NULL : vala_ccode_node_ref (_tmp20));
				_tmp21 = FALSE;
				if (vala_member_access_get_inner (expr) != NULL) {
					_tmp21 = !vala_expression_is_pure (vala_member_access_get_inner (expr));
				} else {
					_tmp21 = FALSE;
				}
				if (_tmp21) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp22;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					_tmp22 = NULL;
					inst = (_tmp22 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp22);
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr), (ValaCCodeNode*) ctemp);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				}
				_tmp23 = NULL;
				base_class = (_tmp23 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
				_tmp26 = NULL;
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp27 = NULL;
				vclass = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("%s_GET_CLASS", _tmp24 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp25 = (g_free (_tmp25), NULL), _tmp24 = (g_free (_tmp24), NULL), _tmp27);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp28 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp28 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vclass, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vclass == NULL) ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL));
			} else {
				ValaCCodeIdentifier* _tmp30;
				char* _tmp29;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp30 = vala_ccode_identifier_new (_tmp29 = vala_method_get_cname (vala_method_get_base_method (m)))));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				_tmp29 = (g_free (_tmp29), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp32;
				char* _tmp31;
				_tmp32 = NULL;
				_tmp31 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp32 = vala_ccode_identifier_new (_tmp31 = vala_method_get_cname (vala_method_get_base_interface_method (m)))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				_tmp31 = (g_free (_tmp31), NULL);
			} else {
				if (VALA_IS_CREATION_METHOD (m)) {
					ValaCCodeIdentifier* _tmp34;
					char* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = vala_method_get_real_cname (m))));
					(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
					_tmp33 = (g_free (_tmp33), NULL);
				} else {
					ValaCCodeIdentifier* _tmp36;
					char* _tmp35;
					_tmp36 = NULL;
					_tmp35 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp36 = vala_ccode_identifier_new (_tmp35 = vala_method_get_cname (m))));
					(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
					_tmp35 = (g_free (_tmp35), NULL);
				}
			}
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaCCodeExpression* _tmp37;
			_tmp37 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp37 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (expr), 1)));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaField* _tmp38;
				ValaField* f;
				_tmp38 = NULL;
				f = (_tmp38 = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* instance_target_type;
					ValaClass* _tmp40;
					ValaTypeSymbol* _tmp39;
					ValaClass* cl;
					gboolean _tmp41;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					gboolean _tmp43;
					gboolean _tmp47;
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					_tmp40 = NULL;
					_tmp39 = NULL;
					cl = (_tmp40 = (_tmp39 = vala_data_type_get_data_type (instance_target_type), VALA_IS_CLASS (_tmp39) ? ((ValaClass*) _tmp39) : NULL), (_tmp40 == NULL) ? NULL : vala_code_node_ref (_tmp40));
					_tmp41 = FALSE;
					if (vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl)) {
						gboolean _tmp42;
						_tmp42 = FALSE;
						if (cl == NULL) {
							_tmp42 = TRUE;
						} else {
							_tmp42 = !vala_class_get_is_compact (cl);
						}
						_tmp41 = _tmp42;
					} else {
						_tmp41 = FALSE;
					}
					is_gtypeinstance = _tmp41;
					inst = NULL;
					_tmp43 = FALSE;
					if (is_gtypeinstance) {
						_tmp43 = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
					} else {
						_tmp43 = FALSE;
					}
					if (_tmp43) {
						ValaCCodeExpression* _tmp44;
						_tmp44 = NULL;
						inst = (_tmp44 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp44);
					} else {
						ValaCCodeExpression* _tmp46;
						ValaCCodeExpression* _tmp45;
						_tmp46 = NULL;
						_tmp45 = NULL;
						inst = (_tmp46 = (_tmp45 = pub_inst, (_tmp45 == NULL) ? NULL : vala_ccode_node_ref (_tmp45)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp46);
					}
					_tmp47 = FALSE;
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						_tmp47 = TRUE;
					} else {
						gboolean _tmp48;
						_tmp48 = FALSE;
						if (vala_member_access_get_inner (expr) != NULL) {
							_tmp48 = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr)));
						} else {
							_tmp48 = FALSE;
						}
						_tmp47 = _tmp48;
					}
					if (_tmp47) {
						ValaCCodeMemberAccess* _tmp50;
						char* _tmp49;
						_tmp50 = NULL;
						_tmp49 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp50 = vala_ccode_member_access_new_pointer (inst, _tmp49 = vala_field_get_cname (f))));
						(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
						_tmp49 = (g_free (_tmp49), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp52;
						char* _tmp51;
						_tmp52 = NULL;
						_tmp51 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp52 = vala_ccode_member_access_new (inst, _tmp51 = vala_field_get_cname (f), FALSE)));
						(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
						_tmp51 = (g_free (_tmp51), NULL);
					}
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp53;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp56;
						char* _tmp55;
						char* _tmp54;
						ValaCCodeFunctionCall* _tmp57;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						_tmp53 = NULL;
						cl = (_tmp53 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f)), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
						_tmp56 = NULL;
						_tmp55 = NULL;
						_tmp54 = NULL;
						_tmp57 = NULL;
						cast = (_tmp57 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (_tmp55 = g_strconcat (_tmp54 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)), _tmp55 = (g_free (_tmp55), NULL), _tmp54 = (g_free (_tmp54), NULL), _tmp57);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp58;
								/* Accessing the field from a static or class constructor*/
								_tmp58 = NULL;
								klass = (_tmp58 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp58);
							} else {
								ValaCCodeIdentifier* _tmp59;
								ValaCCodeFunctionCall* _tmp60;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp61;
								ValaCCodeExpression* _tmp63;
								ValaCCodeExpression* _tmp62;
								/* Accessing the field from within an instance method*/
								_tmp59 = NULL;
								_tmp60 = NULL;
								k = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)), _tmp60);
								_tmp61 = NULL;
								vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("self")));
								(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
								_tmp63 = NULL;
								_tmp62 = NULL;
								klass = (_tmp63 = (_tmp62 = (ValaCCodeExpression*) k, (_tmp62 == NULL) ? NULL : vala_ccode_node_ref (_tmp62)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp63);
								(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
							}
						} else {
							ValaCCodeIdentifier* _tmp64;
							ValaCCodeFunctionCall* _tmp65;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp67;
							ValaCCodeExpression* _tmp66;
							/* Accessing the field of an instance*/
							_tmp64 = NULL;
							_tmp65 = NULL;
							k = (_tmp65 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)), _tmp65);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
							_tmp67 = NULL;
							_tmp66 = NULL;
							klass = (_tmp67 = (_tmp66 = (ValaCCodeExpression*) k, (_tmp66 == NULL) ? NULL : vala_ccode_node_ref (_tmp66)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp67);
							(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							ValaCCodeIdentifier* _tmp70;
							char* _tmp69;
							char* _tmp68;
							ValaCCodeFunctionCall* _tmp71;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp72;
							ValaCCodeFunctionCall* _tmp73;
							ValaCCodeFunctionCall* ccall2;
							ValaCCodeMemberAccess* _tmp75;
							char* _tmp74;
							_tmp70 = NULL;
							_tmp69 = NULL;
							_tmp68 = NULL;
							_tmp71 = NULL;
							ccall = (_tmp71 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (_tmp69 = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp68 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), _tmp69 = (g_free (_tmp69), NULL), _tmp68 = (g_free (_tmp68), NULL), _tmp71);
							_tmp72 = NULL;
							_tmp73 = NULL;
							ccall2 = (_tmp73 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), _tmp73);
							vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) cast);
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
							_tmp75 = NULL;
							_tmp74 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp75 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, _tmp74 = vala_field_get_cname (f))));
							(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
							_tmp74 = (g_free (_tmp74), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
						} else {
							ValaCCodeMemberAccess* _tmp77;
							char* _tmp76;
							_tmp77 = NULL;
							_tmp76 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp77 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, _tmp76 = vala_field_get_cname (f))));
							(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
							_tmp76 = (g_free (_tmp76), NULL);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
						(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
					} else {
						ValaCCodeIdentifier* _tmp79;
						char* _tmp78;
						_tmp79 = NULL;
						_tmp78 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp79 = vala_ccode_identifier_new (_tmp78 = vala_field_get_cname (f))));
						(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
						_tmp78 = (g_free (_tmp78), NULL);
					}
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
					ValaConstant* _tmp80;
					ValaConstant* c;
					char* fn;
					_tmp80 = NULL;
					c = (_tmp80 = VALA_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp80 == NULL) ? NULL : vala_code_node_ref (_tmp80));
					fn = vala_symbol_get_full_name ((ValaSymbol*) c);
					if (_vala_strcmp0 (fn, "GLib.Log.FILE") == 0) {
						char* s;
						ValaCCodeConstant* _tmp82;
						char* _tmp81;
						s = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) expr))));
						_tmp82 = NULL;
						_tmp81 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp82 = vala_ccode_constant_new (_tmp81 = g_strdup_printf ("\"%s\"", s))));
						(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
						_tmp81 = (g_free (_tmp81), NULL);
						s = (g_free (s), NULL);
					} else {
						if (_vala_strcmp0 (fn, "GLib.Log.LINE") == 0) {
							gint i;
							ValaCCodeConstant* _tmp84;
							char* _tmp83;
							i = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) expr));
							_tmp84 = NULL;
							_tmp83 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp84 = vala_ccode_constant_new (_tmp83 = g_strdup_printf ("%d", i))));
							(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
							_tmp83 = (g_free (_tmp83), NULL);
						} else {
							if (_vala_strcmp0 (fn, "GLib.Log.METHOD") == 0) {
								char* s;
								ValaCCodeConstant* _tmp87;
								char* _tmp86;
								s = g_strdup ("");
								if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
									char* _tmp85;
									_tmp85 = NULL;
									s = (_tmp85 = vala_symbol_get_full_name ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_method), s = (g_free (s), NULL), _tmp85);
								}
								_tmp87 = NULL;
								_tmp86 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp87 = vala_ccode_constant_new (_tmp86 = g_strdup_printf ("\"%s\"", s))));
								(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
								_tmp86 = (g_free (_tmp86), NULL);
								s = (g_free (s), NULL);
							} else {
								ValaCCodeIdentifier* _tmp89;
								char* _tmp88;
								_tmp89 = NULL;
								_tmp88 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp89 = vala_ccode_identifier_new (_tmp88 = vala_constant_get_cname (c))));
								(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
								_tmp88 = (g_free (_tmp88), NULL);
							}
						}
					}
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
					fn = (g_free (fn), NULL);
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
						ValaProperty* _tmp90;
						ValaProperty* prop;
						gboolean _tmp110;
						gboolean _tmp111;
						gboolean _tmp112;
						_tmp90 = NULL;
						prop = (_tmp90 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90));
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp91;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp94;
								char* _tmp93;
								char* _tmp92;
								ValaCCodeFunctionCall* _tmp95;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp98;
								char* _tmp97;
								char* _tmp96;
								ValaCCodeMemberAccess* _tmp100;
								char* _tmp99;
								ValaCCodeFunctionCall* _tmp101;
								ValaCCodeFunctionCall* ccall;
								_tmp91 = NULL;
								base_class = (_tmp91 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp91 == NULL) ? NULL : vala_code_node_ref (_tmp91));
								_tmp94 = NULL;
								_tmp93 = NULL;
								_tmp92 = NULL;
								_tmp95 = NULL;
								vcast = (_tmp95 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new (_tmp93 = g_strdup_printf ("%s_CLASS", _tmp92 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)), _tmp93 = (g_free (_tmp93), NULL), _tmp92 = (g_free (_tmp92), NULL), _tmp95);
								_tmp98 = NULL;
								_tmp97 = NULL;
								_tmp96 = NULL;
								vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new (_tmp97 = g_strdup_printf ("%s_parent_class", _tmp96 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
								(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
								_tmp97 = (g_free (_tmp97), NULL);
								_tmp96 = (g_free (_tmp96), NULL);
								_tmp100 = NULL;
								_tmp99 = NULL;
								_tmp101 = NULL;
								ccall = (_tmp101 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp99 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)), _tmp99 = (g_free (_tmp99), NULL), _tmp101);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
								(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp102;
									ValaInterface* base_iface;
									char* _tmp104;
									char* _tmp103;
									char* _tmp105;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp108;
									char* _tmp107;
									ValaCCodeIdentifier* _tmp106;
									ValaCCodeFunctionCall* _tmp109;
									ValaCCodeFunctionCall* ccall;
									_tmp102 = NULL;
									base_iface = (_tmp102 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp102 == NULL) ? NULL : vala_code_node_ref (_tmp102));
									_tmp104 = NULL;
									_tmp103 = NULL;
									_tmp105 = NULL;
									parent_iface_var = (_tmp105 = g_strdup_printf ("%s_%s_parent_iface", _tmp103 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp104 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp104 = (g_free (_tmp104), NULL), _tmp103 = (g_free (_tmp103), NULL), _tmp105);
									_tmp108 = NULL;
									_tmp107 = NULL;
									_tmp106 = NULL;
									_tmp109 = NULL;
									ccall = (_tmp109 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp108 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new (parent_iface_var)), _tmp107 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)), _tmp107 = (g_free (_tmp107), NULL), (_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)), _tmp109);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
									(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
									(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
									return;
								}
							}
						}
						_tmp110 = FALSE;
						_tmp111 = FALSE;
						_tmp112 = FALSE;
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop))) {
							_tmp112 = VALA_SYMBOL (((ValaCCodeBaseModule*) self)->current_type_symbol) == vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
						} else {
							_tmp112 = FALSE;
						}
						if (_tmp112) {
							_tmp111 = vala_property_get_base_property (prop) == NULL;
						} else {
							_tmp111 = FALSE;
						}
						if (_tmp111) {
							_tmp110 = vala_property_get_base_interface_property (prop) == NULL;
						} else {
							_tmp110 = FALSE;
						}
						if (_tmp110) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp113;
							ValaCCodeMemberAccess* _tmp115;
							char* _tmp114;
							inst = NULL;
							_tmp113 = NULL;
							inst = (_tmp113 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp113);
							_tmp115 = NULL;
							_tmp114 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp115 = vala_ccode_member_access_new_pointer (inst, _tmp114 = vala_field_get_cname (vala_property_get_field (prop)))));
							(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
							_tmp114 = (g_free (_tmp114), NULL);
							(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp116;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp123;
								ValaCCodeFunctionCall* _tmp124;
								ValaCCodeFunctionCall* ccall;
								_tmp116 = NULL;
								base_property = (_tmp116 = prop, (_tmp116 == NULL) ? NULL : vala_code_node_ref (_tmp116));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp118;
									ValaProperty* _tmp117;
									_tmp118 = NULL;
									_tmp117 = NULL;
									base_property = (_tmp118 = (_tmp117 = vala_property_get_base_property (prop), (_tmp117 == NULL) ? NULL : vala_code_node_ref (_tmp117)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp118);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp120;
										ValaProperty* _tmp119;
										_tmp120 = NULL;
										_tmp119 = NULL;
										base_property = (_tmp120 = (_tmp119 = vala_property_get_base_interface_property (prop), (_tmp119 == NULL) ? NULL : vala_code_node_ref (_tmp119)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp120);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp121;
									_tmp121 = NULL;
									getter_cname = (_tmp121 = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), getter_cname = (g_free (getter_cname), NULL), _tmp121);
								} else {
									char* _tmp122;
									_tmp122 = NULL;
									getter_cname = (_tmp122 = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), getter_cname = (g_free (getter_cname), NULL), _tmp122);
								}
								_tmp123 = NULL;
								_tmp124 = NULL;
								ccall = (_tmp124 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp123 = vala_ccode_identifier_new (getter_cname))), (_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)), _tmp124);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property access to real struct types is handled differently
								 The value is returned by out parameter*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp125;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_property_accessor_get_value_type (vala_property_get_get_accessor (base_property)), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
									gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
									_tmp125 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp125 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
									(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
									(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
									(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
									(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								} else {
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								}
								(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							} else {
								ValaCCodeIdentifier* _tmp126;
								ValaCCodeFunctionCall* _tmp127;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeConstant* _tmp128;
								ValaCCodeCommaExpression* ccomma;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp131;
								ValaCCodeConstant* _tmp132;
								_tmp126 = NULL;
								_tmp127 = NULL;
								ccall = (_tmp127 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp126 = vala_ccode_identifier_new ("g_object_get"))), (_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL)), _tmp127);
								vala_ccode_function_call_add_argument (ccall, pub_inst);
								/* property name is second argument of g_object_get*/
								_tmp128 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp128 = vala_property_get_canonical_cconstant (prop)));
								(_tmp128 == NULL) ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL));
								/* g_object_get always returns owned values
								 therefore, property getters of properties
								 without accessor methods need to be marked as owned*/
								if (!vala_data_type_get_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)))) {
									ValaDataType* owned_value_type;
									/* only report error for types where there actually
									 is a difference between `owned' and `unowned'*/
									owned_value_type = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)));
									vala_data_type_set_value_owned (owned_value_type, TRUE);
									if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, owned_value_type)) {
										char* _tmp130;
										char* _tmp129;
										_tmp130 = NULL;
										_tmp129 = NULL;
										vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_get_get_accessor (prop)), _tmp130 = g_strdup_printf ("unowned return value for getter of property `%s' not supported without accessor", _tmp129 = vala_symbol_get_full_name ((ValaSymbol*) prop)));
										_tmp130 = (g_free (_tmp130), NULL);
										_tmp129 = (g_free (_tmp129), NULL);
									}
									(owned_value_type == NULL) ? NULL : (owned_value_type = (vala_code_node_unref (owned_value_type), NULL));
								}
								ccomma = vala_ccode_comma_expression_new ();
								temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, NULL);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
								gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
								_tmp131 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp131 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
								(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
								_tmp132 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp132 = vala_ccode_constant_new ("NULL")));
								(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
								(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
								(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
							}
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
							ValaEnumValue* _tmp133;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp135;
							char* _tmp134;
							_tmp133 = NULL;
							ev = (_tmp133 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp133 == NULL) ? NULL : vala_code_node_ref (_tmp133));
							_tmp135 = NULL;
							_tmp134 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp135 = vala_ccode_constant_new (_tmp134 = vala_enum_value_get_cname (ev))));
							(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
							_tmp134 = (g_free (_tmp134), NULL);
							(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
								ValaLocalVariable* _tmp136;
								ValaLocalVariable* local;
								ValaCCodeExpression* _tmp137;
								_tmp136 = NULL;
								local = (_tmp136 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp136 == NULL) ? NULL : vala_code_node_ref (_tmp136));
								_tmp137 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp137 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))));
								(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
								(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
									ValaFormalParameter* _tmp138;
									ValaFormalParameter* p;
									_tmp138 = NULL;
									p = (_tmp138 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp138 == NULL) ? NULL : vala_code_node_ref (_tmp138));
									if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "this") == 0) {
										gboolean _tmp139;
										_tmp139 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp139 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp139 = FALSE;
										}
										if (_tmp139) {
											ValaCCodeExpression* _tmp140;
											/* use closure*/
											_tmp140 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp140 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "self")));
											(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
										} else {
											ValaStruct* _tmp142;
											ValaTypeSymbol* _tmp141;
											ValaStruct* st;
											gboolean _tmp143;
											_tmp142 = NULL;
											_tmp141 = NULL;
											st = (_tmp142 = (_tmp141 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_STRUCT (_tmp141) ? ((ValaStruct*) _tmp141) : NULL), (_tmp142 == NULL) ? NULL : vala_code_node_ref (_tmp142));
											_tmp143 = FALSE;
											if (st != NULL) {
												_tmp143 = !vala_struct_is_simple_type (st);
											} else {
												_tmp143 = FALSE;
											}
											if (_tmp143) {
												ValaCCodeIdentifier* _tmp144;
												_tmp144 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp144 = vala_ccode_identifier_new ("(*self)")));
												(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
											} else {
												ValaCCodeIdentifier* _tmp145;
												_tmp145 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp145 = vala_ccode_identifier_new ("self")));
												(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
											}
											(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
										}
									} else {
										gboolean _tmp146;
										_tmp146 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp146 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp146 = FALSE;
										}
										if (_tmp146) {
											ValaCCodeExpression* _tmp147;
											/* use closure*/
											_tmp147 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp147 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))));
											(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
										} else {
											ValaStruct* _tmp149;
											ValaTypeSymbol* _tmp148;
											ValaStruct* type_as_struct;
											gboolean _tmp150;
											_tmp149 = NULL;
											_tmp148 = NULL;
											type_as_struct = (_tmp149 = (_tmp148 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), VALA_IS_STRUCT (_tmp148) ? ((ValaStruct*) _tmp148) : NULL), (_tmp149 == NULL) ? NULL : vala_code_node_ref (_tmp149));
											_tmp150 = FALSE;
											if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
												_tmp150 = TRUE;
											} else {
												gboolean _tmp151;
												gboolean _tmp152;
												_tmp151 = FALSE;
												_tmp152 = FALSE;
												if (type_as_struct != NULL) {
													_tmp152 = !vala_struct_is_simple_type (type_as_struct);
												} else {
													_tmp152 = FALSE;
												}
												if (_tmp152) {
													_tmp151 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
												} else {
													_tmp151 = FALSE;
												}
												_tmp150 = _tmp151;
											}
											if (_tmp150) {
												ValaCCodeIdentifier* _tmp154;
												char* _tmp153;
												_tmp154 = NULL;
												_tmp153 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp154 = vala_ccode_identifier_new (_tmp153 = g_strdup_printf ("(*%s)", vala_symbol_get_name ((ValaSymbol*) p)))));
												(_tmp154 == NULL) ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL));
												_tmp153 = (g_free (_tmp153), NULL);
											} else {
												gboolean _tmp155;
												gboolean _tmp156;
												gboolean _tmp157;
												_tmp155 = FALSE;
												_tmp156 = FALSE;
												_tmp157 = FALSE;
												if (((ValaCCodeBaseModule*) self)->current_property_accessor != NULL) {
													_tmp157 = vala_property_accessor_get_writable (((ValaCCodeBaseModule*) self)->current_property_accessor);
												} else {
													_tmp157 = FALSE;
												}
												if (_tmp157) {
													_tmp156 = vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) self)->current_property_accessor) == p;
												} else {
													_tmp156 = FALSE;
												}
												if (_tmp156) {
													_tmp155 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) self)->current_property_accessor)));
												} else {
													_tmp155 = FALSE;
												}
												/* Property setters of non simple structs shall replace all occurences
												 of the "value" formal parameter with a dereferencing version of that
												 parameter.*/
												if (_tmp155) {
													ValaCCodeIdentifier* _tmp158;
													_tmp158 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp158 = vala_ccode_identifier_new ("(*value)")));
													(_tmp158 == NULL) ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL));
												} else {
													ValaCCodeIdentifier* _tmp159;
													_tmp159 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp159 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) p))));
													(_tmp159 == NULL) ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL));
												}
											}
											(type_as_struct == NULL) ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL));
										}
									}
									(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
								}
							}
						}
					}
				}
			}
		}
	}
	(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
	(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




