/* valaccodebasemodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodebasemodule.h>
#include <gee/hashset.h>
#include <gee/collection.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeincludedirective.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valacodevisitor.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valareport.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodenewline.h>
#include <vala/valavaluetype.h>
#include <vala/valascope.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeenumvalue.h>
#include <vala/valalockable.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valavoidtype.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valapointertype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodeforstatement.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valaswitchlabel.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <gee/map.h>
#include <vala/valamemberinitializer.h>
#include <vala/valanulltype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignal.h>
#include <vala/valadynamicsignal.h>
#include <vala/valadynamicproperty.h>
#include <vala/valainvalidtype.h>




struct _ValaCCodeBaseModulePrivate {
	ValaCodeContext* _context;
	gint next_array_dup_id;
};

#define VALA_CCODE_BASE_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModulePrivate))
enum  {
	VALA_CCODE_BASE_MODULE_DUMMY_PROPERTY
};
static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference);
static ValaCCodeExpression* vala_ccode_base_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
static ValaCCodeIncludeDirective* vala_ccode_base_module_get_internal_include (ValaCCodeBaseModule* self, const char* filename);
static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file);
static char* vala_ccode_base_module_get_define_for_filename (const char* filename);
static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context);
static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en);
static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev);
static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m);
static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c);
static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f);
static gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p);
static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop);
static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc);
static void vala_ccode_base_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c);
static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d);
static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b);
static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt);
static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt);
static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local);
static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list);
static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type);
static char* vala_ccode_base_module_generate_array_dup_wrapper (ValaCCodeBaseModule* self, ValaArrayType* array_type);
static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type);
static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression);
static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt);
static void vala_ccode_base_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt);
static void vala_ccode_base_module_visit_string_switch_statement (ValaCCodeBaseModule* self, ValaSwitchStatement* stmt);
static void vala_ccode_base_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt);
static void vala_ccode_base_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section);
static void vala_ccode_base_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt);
static void vala_ccode_base_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt);
static void vala_ccode_base_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt);
static void vala_ccode_base_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt);
static void vala_ccode_base_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt);
static void vala_ccode_base_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt);
static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag);
static void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma);
static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);
static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym);
static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt);
static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt);
static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr);
static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr);
static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr);
static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr);
static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr);
static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr);
static void vala_ccode_base_module_real_visit_parenthesized_expression (ValaCCodeModule* base, ValaParenthesizedExpression* expr);
static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr);
static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr);
static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr);
static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr);
static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr);
static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr);
static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr);
static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type);
static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr);
static void vala_ccode_base_module_real_visit_conditional_expression (ValaCCodeModule* base, ValaConditionalExpression* expr);
static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l);
static ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static char* vala_ccode_base_module_generate_delegate_wrapper (ValaCCodeBaseModule* self, ValaMethod* m, ValaDelegate* d);
static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static gpointer vala_ccode_base_module_parent_class = NULL;
static void vala_ccode_base_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeBaseModule* self;
	GeeSet* _tmp0;
	GeeSet* _tmp1;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeBaseModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeBaseModule*) (vala_ccode_module_construct (object_type, codegen, next)));
	_tmp0 = NULL;
	self->predefined_marshal_set = (_tmp0 = ((GeeSet*) (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_hash, g_str_equal))), (self->predefined_marshal_set == NULL ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL))), _tmp0);
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:VOID");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:BOOLEAN");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:CHAR");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:UCHAR");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:INT");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:UINT");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:LONG");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:ULONG");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:ENUM");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:FLAGS");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:FLOAT");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:DOUBLE");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:STRING");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:POINTER");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:OBJECT");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "STRING:OBJECT,POINTER");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "VOID:UINT,POINTER");
	gee_collection_add (((GeeCollection*) (self->predefined_marshal_set)), "BOOLEAN:FLAGS");
	_tmp1 = NULL;
	self->c_keywords = (_tmp1 = ((GeeSet*) (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_hash, g_str_equal))), (self->c_keywords == NULL ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL))), _tmp1);
	/* C99 keywords*/
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "_Bool");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "_Complex");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "_Imaginary");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "auto");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "break");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "case");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "char");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "const");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "continue");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "default");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "do");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "double");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "else");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "enum");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "extern");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "float");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "for");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "goto");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "if");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "inline");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "int");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "long");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "register");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "restrict");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "return");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "short");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "signed");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "sizeof");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "static");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "struct");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "switch");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "typedef");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "union");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "unsigned");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "void");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "volatile");
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "while");
	/* MSVC keywords*/
	gee_collection_add (((GeeCollection*) (self->c_keywords)), "cdecl");
	return self;
}


ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_base_module_construct (VALA_TYPE_CCODE_BASE_MODULE, codegen, next);
}


static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_val_if_fail (type_reference != NULL, NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* cpointer;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeMemberAccess* cnamemember;
	ValaCCodeAssignment* cnameassign;
	ValaCCodeMemberAccess* _tmp0;
	ValaCCodeUnaryExpression* _tmp1;
	ValaCCodeUnaryExpression* gvaluearg;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cvalueinit;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeFunctionCall* cvalueset;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeExpression* _tmp9;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_val_if_fail (canonical_cconstant != NULL, NULL);
	g_return_val_if_fail (property_type != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	/* this property is used as a construction parameter*/
	cpointer = vala_ccode_identifier_new ("__params_it");
	ccomma = vala_ccode_comma_expression_new ();
	/* set name in array for current parameter*/
	cnamemember = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (cpointer)), "name");
	cnameassign = vala_ccode_assignment_new (((ValaCCodeExpression*) (cnamemember)), ((ValaCCodeExpression*) (canonical_cconstant)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cnameassign)));
	_tmp0 = NULL;
	_tmp1 = NULL;
	gvaluearg = (_tmp1 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (cpointer)), "value"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	/* initialize GValue in array for current parameter*/
	_tmp2 = NULL;
	_tmp3 = NULL;
	cvalueinit = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("g_value_init"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	vala_ccode_function_call_add_argument (cvalueinit, ((ValaCCodeExpression*) (gvaluearg)));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cvalueinit, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_data_type_get_type_id (property_type)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cvalueinit)));
	/* set GValue for current parameter*/
	_tmp6 = NULL;
	_tmp7 = NULL;
	cvalueset = (_tmp7 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_module_get_value_setter_function (((ValaCCodeModule*) (self)), property_type))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp7);
	vala_ccode_function_call_add_argument (cvalueset, ((ValaCCodeExpression*) (gvaluearg)));
	vala_ccode_function_call_add_argument (cvalueset, value);
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cvalueset)));
	/* move pointer to next parameter in array*/
	_tmp8 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, ((ValaCCodeExpression*) (cpointer)))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	return (_tmp9 = ((ValaCCodeExpression*) (ccomma)), (cpointer == NULL ? NULL : (cpointer = (vala_ccode_node_unref (cpointer), NULL))), (cnamemember == NULL ? NULL : (cnamemember = (vala_ccode_node_unref (cnamemember), NULL))), (cnameassign == NULL ? NULL : (cnameassign = (vala_ccode_node_unref (cnameassign), NULL))), (gvaluearg == NULL ? NULL : (gvaluearg = (vala_ccode_node_unref (gvaluearg), NULL))), (cvalueinit == NULL ? NULL : (cvalueinit = (vala_ccode_node_unref (cvalueinit), NULL))), (cvalueset == NULL ? NULL : (cvalueset = (vala_ccode_node_unref (cvalueset), NULL))), _tmp9);
}


static ValaCCodeIncludeDirective* vala_ccode_base_module_get_internal_include (ValaCCodeBaseModule* self, const char* filename) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->_context) == NULL);
}


static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_free (self);
}


static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_move (self);
}


static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeBinaryExpression* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeParenthesizedExpression* _tmp6;
	ValaCCodeParenthesizedExpression* cineq;
	ValaCCodeBlock* _tmp7;
	ValaCCodeBlock* cblock;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeIfStatement* _tmp11;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp13;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeConstant* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeReturnStatement* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeReturnStatement* _tmp24;
	g_return_if_fail (self != NULL);
	fun = vala_ccode_function_new ("_vala_strcmp0", "int");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("str1", "const char *")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("str2", "const char *")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp2 = vala_ccode_function_copy (fun)))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	/* (str1 != str2)*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp6 = NULL;
	cineq = (_tmp6 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ("str1")))), ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ("str2"))))))))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp6);
	_tmp7 = NULL;
	vala_ccode_function_set_block (fun, (_tmp7 = vala_ccode_block_new ()));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	cblock = vala_ccode_block_new ();
	/* if (str1 == NULL)*/
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp11 = NULL;
	cif = (_tmp11 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_identifier_new ("str1")))), ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ("NULL")))))))), ((ValaCCodeStatement*) (cblock)), NULL), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp11);
	/* return -(str1 != str2);*/
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp13 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_MINUS, ((ValaCCodeExpression*) (cineq)))))))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) (cif)));
	_tmp14 = NULL;
	cblock = (_tmp14 = vala_ccode_block_new (), (cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL))), _tmp14);
	/* if (str2 == NULL)*/
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("str2")))), ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_constant_new ("NULL")))))))), ((ValaCCodeStatement*) (cblock)), NULL), (cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL))), _tmp18);
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	/* return (str1 != str2);*/
	_tmp19 = NULL;
	vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp19 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (cineq)))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) (cif)));
	/* strcmp (str1, str2)*/
	_tmp20 = NULL;
	_tmp21 = NULL;
	ccall = (_tmp21 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("strcmp"))))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ("str1")))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new ("str2")))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	/* return strcmp (str1, str2);*/
	_tmp24 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), ((ValaCCodeNode*) ((_tmp24 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (fun)));
	(fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)));
	(cineq == NULL ? NULL : (cineq = (vala_ccode_node_unref (cineq), NULL)));
	(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
	(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
}


static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* _tmp0;
	ValaCCodeFragment* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* _tmp10;
	ValaCCodeFragment* _tmp11;
	ValaCCodeFragment* _tmp12;
	ValaCCodeFragment* _tmp13;
	GeeSet* _tmp14;
	GeeSet* _tmp15;
	ValaCCodeIncludeDirective* _tmp16;
	ValaCCodeIncludeDirective* _tmp17;
	GeeList* used_includes;
	char* _tmp22;
	char* _tmp57;
	char* _tmp58;
	char* header_define;
	ValaCCodeComment* comment;
	char* _tmp65;
	ValaCCodeWriter* _tmp66;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* _tmp68;
	ValaCCodeNewline* _tmp69;
	ValaCCodeIdentifier* _tmp70;
	ValaCCodeNewline* _tmp71;
	ValaCCodeNewline* _tmp72;
	ValaCCodeNewline* _tmp73;
	ValaCCodeNewline* _tmp74;
	ValaCCodeNewline* _tmp75;
	ValaCCodeNewline* _tmp76;
	ValaCCodeIdentifier* _tmp77;
	ValaCCodeNewline* _tmp78;
	ValaCCodeNewline* _tmp79;
	ValaCCodeWriter* _tmp81;
	char* _tmp80;
	ValaCCodeFragment* _tmp83;
	ValaCCodeFragment* _tmp84;
	ValaCCodeFragment* _tmp85;
	ValaCCodeFragment* _tmp86;
	ValaCCodeFragment* _tmp87;
	ValaCCodeFragment* _tmp88;
	ValaCCodeFragment* _tmp89;
	ValaCCodeFragment* _tmp90;
	ValaCCodeFragment* _tmp91;
	ValaCCodeFragment* _tmp92;
	ValaCCodeFragment* _tmp93;
	ValaCCodeFragment* _tmp94;
	ValaCCodeFragment* _tmp95;
	ValaCCodeFragment* _tmp96;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (source_file != NULL);
	_tmp0 = NULL;
	self->header_begin = (_tmp0 = vala_ccode_fragment_new (), (self->header_begin == NULL ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL))), _tmp0);
	_tmp1 = NULL;
	self->header_type_declaration = (_tmp1 = vala_ccode_fragment_new (), (self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL))), _tmp1);
	_tmp2 = NULL;
	self->header_type_definition = (_tmp2 = vala_ccode_fragment_new (), (self->header_type_definition == NULL ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL))), _tmp2);
	_tmp3 = NULL;
	self->header_type_member_declaration = (_tmp3 = vala_ccode_fragment_new (), (self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL))), _tmp3);
	_tmp4 = NULL;
	self->header_constant_declaration = (_tmp4 = vala_ccode_fragment_new (), (self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL))), _tmp4);
	_tmp5 = NULL;
	self->source_begin = (_tmp5 = vala_ccode_fragment_new (), (self->source_begin == NULL ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL))), _tmp5);
	_tmp6 = NULL;
	self->source_include_directives = (_tmp6 = vala_ccode_fragment_new (), (self->source_include_directives == NULL ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL))), _tmp6);
	_tmp7 = NULL;
	self->source_type_declaration = (_tmp7 = vala_ccode_fragment_new (), (self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL))), _tmp7);
	_tmp8 = NULL;
	self->source_type_definition = (_tmp8 = vala_ccode_fragment_new (), (self->source_type_definition == NULL ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL))), _tmp8);
	_tmp9 = NULL;
	self->source_type_member_declaration = (_tmp9 = vala_ccode_fragment_new (), (self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL))), _tmp9);
	_tmp10 = NULL;
	self->source_constant_declaration = (_tmp10 = vala_ccode_fragment_new (), (self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL))), _tmp10);
	_tmp11 = NULL;
	self->source_type_member_definition = (_tmp11 = vala_ccode_fragment_new (), (self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL))), _tmp11);
	_tmp12 = NULL;
	self->source_signal_marshaller_definition = (_tmp12 = vala_ccode_fragment_new (), (self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL))), _tmp12);
	_tmp13 = NULL;
	self->source_signal_marshaller_declaration = (_tmp13 = vala_ccode_fragment_new (), (self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL))), _tmp13);
	_tmp14 = NULL;
	self->user_marshal_set = (_tmp14 = ((GeeSet*) (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_hash, g_str_equal))), (self->user_marshal_set == NULL ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL))), _tmp14);
	self->next_temp_var_id = 0;
	self->string_h_needed = FALSE;
	self->gvaluecollector_h_needed = FALSE;
	self->gio_h_needed = FALSE;
	self->dbus_glib_h_needed = FALSE;
	self->requires_free_checked = FALSE;
	self->requires_array_free = FALSE;
	self->requires_array_move = FALSE;
	self->requires_strcmp0 = FALSE;
	_tmp15 = NULL;
	self->wrappers = (_tmp15 = ((GeeSet*) (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_hash, g_str_equal))), (self->wrappers == NULL ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL))), _tmp15);
	_tmp16 = NULL;
	vala_ccode_fragment_append (self->header_begin, ((ValaCCodeNode*) ((_tmp16 = vala_ccode_include_directive_new ("glib.h", FALSE)))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_fragment_append (self->header_begin, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_include_directive_new ("glib-object.h", FALSE)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	if (vala_code_context_get_basedir (self->priv->_context) != NULL || vala_code_context_get_library (self->priv->_context) != NULL) {
		ValaCCodeIncludeDirective* _tmp19;
		char* _tmp18;
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp19 = vala_ccode_include_directive_new ((_tmp18 = vala_source_file_get_cinclude_filename (source_file)), FALSE)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		_tmp18 = (g_free (_tmp18), NULL);
	} else {
		ValaCCodeIncludeDirective* _tmp21;
		char* _tmp20;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp21 = vala_ccode_include_directive_new ((_tmp20 = vala_source_file_get_cinclude_filename (source_file)), TRUE)))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
		_tmp20 = (g_free (_tmp20), NULL);
	}
	used_includes = ((GeeList*) (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_str_equal)));
	gee_collection_add (((GeeCollection*) (used_includes)), "glib.h");
	gee_collection_add (((GeeCollection*) (used_includes)), "glib-object.h");
	_tmp22 = NULL;
	gee_collection_add (((GeeCollection*) (used_includes)), (_tmp22 = vala_source_file_get_cinclude_filename (source_file)));
	_tmp22 = (g_free (_tmp22), NULL);
	{
		GeeList* filename_collection;
		int filename_it;
		filename_collection = vala_source_file_get_header_external_includes (source_file);
		for (filename_it = 0; filename_it < gee_collection_get_size (GEE_COLLECTION (filename_collection)); filename_it = filename_it + 1) {
			char* filename;
			filename = ((char*) (gee_list_get (GEE_LIST (filename_collection), filename_it)));
			{
				if (!gee_collection_contains (((GeeCollection*) (used_includes)), filename)) {
					ValaCCodeIncludeDirective* _tmp23;
					_tmp23 = NULL;
					vala_ccode_fragment_append (self->header_begin, ((ValaCCodeNode*) ((_tmp23 = vala_ccode_include_directive_new (filename, FALSE)))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
					gee_collection_add (((GeeCollection*) (used_includes)), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (gee_collection_object_unref (filename_collection), NULL)));
	}
	{
		GeeList* filename_collection;
		int filename_it;
		filename_collection = vala_source_file_get_header_internal_includes (source_file);
		for (filename_it = 0; filename_it < gee_collection_get_size (GEE_COLLECTION (filename_collection)); filename_it = filename_it + 1) {
			char* filename;
			filename = ((char*) (gee_list_get (GEE_LIST (filename_collection), filename_it)));
			{
				if (!gee_collection_contains (((GeeCollection*) (used_includes)), filename)) {
					ValaCCodeIncludeDirective* _tmp24;
					_tmp24 = NULL;
					vala_ccode_fragment_append (self->header_begin, ((ValaCCodeNode*) ((_tmp24 = vala_ccode_base_module_get_internal_include (self, filename)))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
					gee_collection_add (((GeeCollection*) (used_includes)), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (gee_collection_object_unref (filename_collection), NULL)));
	}
	{
		GeeList* filename_collection;
		int filename_it;
		filename_collection = vala_source_file_get_source_external_includes (source_file);
		for (filename_it = 0; filename_it < gee_collection_get_size (GEE_COLLECTION (filename_collection)); filename_it = filename_it + 1) {
			char* filename;
			filename = ((char*) (gee_list_get (GEE_LIST (filename_collection), filename_it)));
			{
				if (!gee_collection_contains (((GeeCollection*) (used_includes)), filename)) {
					ValaCCodeIncludeDirective* _tmp25;
					_tmp25 = NULL;
					vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp25 = vala_ccode_include_directive_new (filename, FALSE)))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
					gee_collection_add (((GeeCollection*) (used_includes)), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (gee_collection_object_unref (filename_collection), NULL)));
	}
	{
		GeeList* filename_collection;
		int filename_it;
		filename_collection = vala_source_file_get_source_internal_includes (source_file);
		for (filename_it = 0; filename_it < gee_collection_get_size (GEE_COLLECTION (filename_collection)); filename_it = filename_it + 1) {
			char* filename;
			filename = ((char*) (gee_list_get (GEE_LIST (filename_collection), filename_it)));
			{
				if (!gee_collection_contains (((GeeCollection*) (used_includes)), filename)) {
					ValaCCodeIncludeDirective* _tmp26;
					_tmp26 = NULL;
					vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp26 = vala_ccode_base_module_get_internal_include (self, filename)))));
					(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
					gee_collection_add (((GeeCollection*) (used_includes)), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (gee_collection_object_unref (filename_collection), NULL)));
	}
	{
		GeeSet* symbol_collection;
		GeeIterator* symbol_it;
		symbol_collection = vala_source_file_get_source_symbol_dependencies (source_file);
		symbol_it = gee_iterable_iterator (GEE_ITERABLE (symbol_collection));
		while (gee_iterator_next (symbol_it)) {
			ValaSymbol* symbol;
			symbol = ((ValaSymbol*) (gee_iterator_get (symbol_it)));
			{
				if (!vala_symbol_get_external (symbol) && vala_symbol_get_external_package (symbol)) {
					vala_code_node_accept (((ValaCodeNode*) (symbol)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
				}
				(symbol == NULL ? NULL : (symbol = (vala_code_node_unref (symbol), NULL)));
			}
		}
		(symbol_it == NULL ? NULL : (symbol_it = (gee_collection_object_unref (symbol_it), NULL)));
		(symbol_collection == NULL ? NULL : (symbol_collection = (gee_collection_object_unref (symbol_collection), NULL)));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeList* cycle_file_collection;
			int cycle_file_it;
			cycle_file_collection = vala_source_file_get_cycle (source_file)->files;
			for (cycle_file_it = 0; cycle_file_it < gee_collection_get_size (GEE_COLLECTION (cycle_file_collection)); cycle_file_it = cycle_file_it + 1) {
				ValaSourceFile* _tmp56;
				ValaSourceFile* cycle_file;
				_tmp56 = NULL;
				cycle_file = (_tmp56 = ((ValaSourceFile*) (gee_list_get (GEE_LIST (cycle_file_collection), cycle_file_it))), (_tmp56 == NULL ? NULL : vala_source_file_ref (_tmp56)));
				{
					{
						GeeList* node_collection;
						int node_it;
						node_collection = vala_source_file_get_nodes (cycle_file);
						for (node_it = 0; node_it < gee_collection_get_size (GEE_COLLECTION (node_collection)); node_it = node_it + 1) {
							ValaCodeNode* node;
							node = ((ValaCodeNode*) (gee_list_get (GEE_LIST (node_collection), node_it)));
							{
								if (VALA_IS_STRUCT (node)) {
									ValaStruct* _tmp27;
									ValaStruct* st;
									ValaCCodeTypeDefinition* _tmp32;
									ValaCCodeVariableDeclarator* _tmp31;
									char* _tmp30;
									char* _tmp29;
									char* _tmp28;
									_tmp27 = NULL;
									st = (_tmp27 = VALA_STRUCT (node), (_tmp27 == NULL ? NULL : vala_code_node_ref (_tmp27)));
									_tmp32 = NULL;
									_tmp31 = NULL;
									_tmp30 = NULL;
									_tmp29 = NULL;
									_tmp28 = NULL;
									vala_ccode_fragment_append (self->header_type_declaration, ((ValaCCodeNode*) ((_tmp32 = vala_ccode_type_definition_new ((_tmp29 = g_strdup_printf ("struct _%s", (_tmp28 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (st)), FALSE)))), ((ValaCCodeDeclarator*) ((_tmp31 = vala_ccode_variable_declarator_new ((_tmp30 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (st)), FALSE)))))))))));
									(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
									(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
									_tmp30 = (g_free (_tmp30), NULL);
									_tmp29 = (g_free (_tmp29), NULL);
									_tmp28 = (g_free (_tmp28), NULL);
									(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
								} else {
									if (VALA_IS_CLASS (node)) {
										ValaClass* _tmp33;
										ValaClass* cl;
										ValaCCodeTypeDefinition* _tmp38;
										ValaCCodeVariableDeclarator* _tmp37;
										char* _tmp36;
										char* _tmp35;
										char* _tmp34;
										ValaCCodeTypeDefinition* _tmp44;
										ValaCCodeVariableDeclarator* _tmp43;
										char* _tmp42;
										char* _tmp41;
										char* _tmp40;
										char* _tmp39;
										_tmp33 = NULL;
										cl = (_tmp33 = VALA_CLASS (node), (_tmp33 == NULL ? NULL : vala_code_node_ref (_tmp33)));
										_tmp38 = NULL;
										_tmp37 = NULL;
										_tmp36 = NULL;
										_tmp35 = NULL;
										_tmp34 = NULL;
										vala_ccode_fragment_append (self->header_type_declaration, ((ValaCCodeNode*) ((_tmp38 = vala_ccode_type_definition_new ((_tmp35 = g_strdup_printf ("struct _%s", (_tmp34 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))), ((ValaCCodeDeclarator*) ((_tmp37 = vala_ccode_variable_declarator_new ((_tmp36 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))))))))));
										(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
										(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
										_tmp36 = (g_free (_tmp36), NULL);
										_tmp35 = (g_free (_tmp35), NULL);
										_tmp34 = (g_free (_tmp34), NULL);
										_tmp44 = NULL;
										_tmp43 = NULL;
										_tmp42 = NULL;
										_tmp41 = NULL;
										_tmp40 = NULL;
										_tmp39 = NULL;
										vala_ccode_fragment_append (self->header_type_declaration, ((ValaCCodeNode*) ((_tmp44 = vala_ccode_type_definition_new ((_tmp40 = g_strdup_printf ("struct _%sClass", (_tmp39 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))), ((ValaCCodeDeclarator*) ((_tmp43 = vala_ccode_variable_declarator_new ((_tmp42 = g_strdup_printf ("%sClass", (_tmp41 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))))))))))));
										(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
										(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
										_tmp42 = (g_free (_tmp42), NULL);
										_tmp41 = (g_free (_tmp41), NULL);
										_tmp40 = (g_free (_tmp40), NULL);
										_tmp39 = (g_free (_tmp39), NULL);
										(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
									} else {
										if (VALA_IS_INTERFACE (node)) {
											ValaInterface* _tmp45;
											ValaInterface* iface;
											ValaCCodeTypeDefinition* _tmp50;
											ValaCCodeVariableDeclarator* _tmp49;
											char* _tmp48;
											char* _tmp47;
											char* _tmp46;
											ValaCCodeTypeDefinition* _tmp55;
											ValaCCodeVariableDeclarator* _tmp54;
											char* _tmp53;
											char* _tmp52;
											char* _tmp51;
											_tmp45 = NULL;
											iface = (_tmp45 = VALA_INTERFACE (node), (_tmp45 == NULL ? NULL : vala_code_node_ref (_tmp45)));
											_tmp50 = NULL;
											_tmp49 = NULL;
											_tmp48 = NULL;
											_tmp47 = NULL;
											_tmp46 = NULL;
											vala_ccode_fragment_append (self->header_type_declaration, ((ValaCCodeNode*) ((_tmp50 = vala_ccode_type_definition_new ((_tmp47 = g_strdup_printf ("struct _%s", (_tmp46 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))), ((ValaCCodeDeclarator*) ((_tmp49 = vala_ccode_variable_declarator_new ((_tmp48 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (iface)), FALSE)))))))))));
											(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
											(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
											_tmp48 = (g_free (_tmp48), NULL);
											_tmp47 = (g_free (_tmp47), NULL);
											_tmp46 = (g_free (_tmp46), NULL);
											_tmp55 = NULL;
											_tmp54 = NULL;
											_tmp53 = NULL;
											_tmp52 = NULL;
											_tmp51 = NULL;
											vala_ccode_fragment_append (self->header_type_declaration, ((ValaCCodeNode*) ((_tmp55 = vala_ccode_type_definition_new ((_tmp52 = g_strdup_printf ("struct _%s", (_tmp51 = vala_interface_get_type_cname (iface)))), ((ValaCCodeDeclarator*) ((_tmp54 = vala_ccode_variable_declarator_new ((_tmp53 = vala_interface_get_type_cname (iface)))))))))));
											(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
											(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
											_tmp53 = (g_free (_tmp53), NULL);
											_tmp52 = (g_free (_tmp52), NULL);
											_tmp51 = (g_free (_tmp51), NULL);
											(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
										}
									}
								}
								(node == NULL ? NULL : (node = (vala_code_node_unref (node), NULL)));
							}
						}
						(node_collection == NULL ? NULL : (node_collection = (gee_collection_object_unref (node_collection), NULL)));
					}
					(cycle_file == NULL ? NULL : (cycle_file = (vala_source_file_unref (cycle_file), NULL)));
				}
			}
		}
	}
	vala_source_file_accept_children (source_file, ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (vala_report_get_errors () > 0) {
		(used_includes == NULL ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL)));
		return;
	}
	_tmp57 = NULL;
	_tmp58 = NULL;
	header_define = (_tmp58 = vala_ccode_base_module_get_define_for_filename ((_tmp57 = vala_source_file_get_cinclude_filename (source_file))), (_tmp57 = (g_free (_tmp57), NULL)), _tmp58);
	/* generate hardcoded "well-known" macros */
	if (self->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp59;
		_tmp59 = NULL;
		vala_ccode_fragment_append (self->source_begin, ((ValaCCodeNode*) ((_tmp59 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))")))));
		(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
	}
	if (self->requires_array_free) {
		vala_ccode_base_module_append_vala_array_free (self);
	}
	if (self->requires_array_move) {
		vala_ccode_base_module_append_vala_array_move (self);
	}
	if (self->requires_strcmp0) {
		vala_ccode_base_module_append_vala_strcmp0 (self);
	}
	if (self->string_h_needed) {
		ValaCCodeIncludeDirective* _tmp60;
		_tmp60 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp60 = vala_ccode_include_directive_new ("string.h", FALSE)))));
		(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
	}
	if (self->gvaluecollector_h_needed) {
		ValaCCodeIncludeDirective* _tmp61;
		_tmp61 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp61 = vala_ccode_include_directive_new ("gobject/gvaluecollector.h", FALSE)))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
	}
	if (self->gio_h_needed) {
		ValaCCodeIncludeDirective* _tmp62;
		_tmp62 = NULL;
		vala_ccode_fragment_append (self->header_begin, ((ValaCCodeNode*) ((_tmp62 = vala_ccode_include_directive_new ("gio/gio.h", FALSE)))));
		(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
	}
	if (self->dbus_glib_h_needed) {
		ValaCCodeIncludeDirective* _tmp63;
		_tmp63 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, ((ValaCCodeNode*) ((_tmp63 = vala_ccode_include_directive_new ("dbus/dbus-glib.h", FALSE)))));
		(_tmp63 == NULL ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp64;
		_tmp64 = NULL;
		comment = (_tmp64 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (vala_ccode_node_unref (comment), NULL))), _tmp64);
	}
	_tmp65 = NULL;
	_tmp66 = NULL;
	writer = (_tmp66 = vala_ccode_writer_new ((_tmp65 = vala_source_file_get_cheader_filename (source_file))), (_tmp65 = (g_free (_tmp65), NULL)), _tmp66);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp67;
		_tmp67 = NULL;
		vala_report_error (NULL, (_tmp67 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer))));
		_tmp67 = (g_free (_tmp67), NULL);
		(used_includes == NULL ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL)));
		header_define = (g_free (header_define), NULL);
		(comment == NULL ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)));
		(writer == NULL ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL)));
		return;
	}
	if (comment != NULL) {
		vala_ccode_node_write (((ValaCCodeNode*) (comment)), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	_tmp68 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp68 = vala_ccode_newline_new ()))));
	(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) (self->header_begin)));
	_tmp69 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp69 = vala_ccode_newline_new ()))));
	(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
	_tmp70 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp70 = vala_ccode_identifier_new ("G_BEGIN_DECLS")))));
	(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
	_tmp71 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp71 = vala_ccode_newline_new ()))));
	(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
	_tmp72 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp72 = vala_ccode_newline_new ()))));
	(_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)));
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) (self->header_type_declaration)));
	_tmp73 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp73 = vala_ccode_newline_new ()))));
	(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) (self->header_type_definition)));
	_tmp74 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp74 = vala_ccode_newline_new ()))));
	(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) (self->header_type_member_declaration)));
	_tmp75 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp75 = vala_ccode_newline_new ()))));
	(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) (self->header_constant_declaration)));
	_tmp76 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp76 = vala_ccode_newline_new ()))));
	(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
	_tmp77 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp77 = vala_ccode_identifier_new ("G_END_DECLS")))));
	(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
	_tmp78 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp78 = vala_ccode_newline_new ()))));
	(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
	_tmp79 = NULL;
	vala_ccode_fragment_append (((ValaCCodeFragment*) (once)), ((ValaCCodeNode*) ((_tmp79 = vala_ccode_newline_new ()))));
	(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
	vala_ccode_node_write (((ValaCCodeNode*) (once)), writer);
	vala_ccode_writer_close (writer);
	_tmp81 = NULL;
	_tmp80 = NULL;
	writer = (_tmp81 = vala_ccode_writer_new ((_tmp80 = vala_source_file_get_csource_filename (source_file))), (writer == NULL ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL))), _tmp81);
	_tmp80 = (g_free (_tmp80), NULL);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp82;
		_tmp82 = NULL;
		vala_report_error (NULL, (_tmp82 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer))));
		_tmp82 = (g_free (_tmp82), NULL);
		(used_includes == NULL ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL)));
		header_define = (g_free (header_define), NULL);
		(comment == NULL ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)));
		(writer == NULL ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL)));
		(once == NULL ? NULL : (once = (vala_ccode_node_unref (once), NULL)));
		return;
	}
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->priv->_context));
	if (comment != NULL) {
		vala_ccode_node_write (((ValaCCodeNode*) (comment)), writer);
	}
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_begin)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_include_directives)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined (((ValaCCodeNode*) (self->source_type_declaration)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined (((ValaCCodeNode*) (self->source_type_definition)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (((ValaCCodeNode*) (self->source_type_member_declaration)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_type_member_declaration)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_constant_declaration)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (((ValaCCodeNode*) (self->source_signal_marshaller_declaration)), writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_signal_marshaller_declaration)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_type_member_definition)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (((ValaCCodeNode*) (self->source_signal_marshaller_definition)), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp83 = NULL;
	self->header_begin = (_tmp83 = NULL, (self->header_begin == NULL ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL))), _tmp83);
	_tmp84 = NULL;
	self->header_type_declaration = (_tmp84 = NULL, (self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL))), _tmp84);
	_tmp85 = NULL;
	self->header_type_definition = (_tmp85 = NULL, (self->header_type_definition == NULL ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL))), _tmp85);
	_tmp86 = NULL;
	self->header_type_member_declaration = (_tmp86 = NULL, (self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL))), _tmp86);
	_tmp87 = NULL;
	self->header_constant_declaration = (_tmp87 = NULL, (self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL))), _tmp87);
	_tmp88 = NULL;
	self->source_begin = (_tmp88 = NULL, (self->source_begin == NULL ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL))), _tmp88);
	_tmp89 = NULL;
	self->source_include_directives = (_tmp89 = NULL, (self->source_include_directives == NULL ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL))), _tmp89);
	_tmp90 = NULL;
	self->source_type_declaration = (_tmp90 = NULL, (self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL))), _tmp90);
	_tmp91 = NULL;
	self->source_type_definition = (_tmp91 = NULL, (self->source_type_definition == NULL ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL))), _tmp91);
	_tmp92 = NULL;
	self->source_type_member_declaration = (_tmp92 = NULL, (self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL))), _tmp92);
	_tmp93 = NULL;
	self->source_constant_declaration = (_tmp93 = NULL, (self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL))), _tmp93);
	_tmp94 = NULL;
	self->source_type_member_definition = (_tmp94 = NULL, (self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL))), _tmp94);
	_tmp95 = NULL;
	self->source_signal_marshaller_definition = (_tmp95 = NULL, (self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL))), _tmp95);
	_tmp96 = NULL;
	self->source_signal_marshaller_declaration = (_tmp96 = NULL, (self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL))), _tmp96);
	(used_includes == NULL ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL)));
	header_define = (g_free (header_define), NULL);
	(comment == NULL ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (vala_ccode_node_unref (once), NULL)));
}


static char* vala_ccode_base_module_get_define_for_filename (const char* filename) {
	GString* define;
	const char* _tmp0;
	char* i;
	const char* _tmp3;
	char* _tmp4;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	_tmp0 = NULL;
	i = (_tmp0 = filename, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* _tmp2;
		const char* _tmp1;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		i = (_tmp2 = (_tmp1 = g_utf8_next_char (i), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (i = (g_free (i), NULL)), _tmp2);
	}
	g_string_append (define, "__");
	_tmp3 = NULL;
	_tmp4 = NULL;
	return (_tmp4 = (_tmp3 = define->str, (_tmp3 == NULL ? NULL : g_strdup (_tmp3))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), _tmp4);
}


static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaDataType* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaDataType* _tmp5;
	ValaTypeSymbol* _tmp4;
	ValaDataType* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypeSymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypeSymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypeSymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypeSymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypeSymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypeSymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypeSymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypeSymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypeSymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypeSymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypeSymbol* _tmp28;
	ValaDataType* _tmp31;
	ValaTypeSymbol* _tmp30;
	ValaDataType* _tmp33;
	ValaTypeSymbol* _tmp32;
	ValaDataType* _tmp35;
	ValaTypeSymbol* _tmp34;
	ValaDataType* _tmp37;
	ValaTypeSymbol* _tmp36;
	ValaDataType* _tmp39;
	ValaClass* _tmp38;
	ValaMethod* _tmp40;
	ValaSymbol* glib_ns;
	ValaTypeSymbol* _tmp41;
	ValaTypeSymbol* _tmp42;
	ValaErrorType* _tmp43;
	ValaClass* _tmp44;
	ValaClass* _tmp45;
	ValaTypeSymbol* _tmp46;
	ValaTypeSymbol* _tmp47;
	ValaDataType* _tmp49;
	ValaTypeSymbol* _tmp48;
	ValaStruct* _tmp50;
	ValaTypeSymbol* _tmp51;
	ValaSymbol* gee_ns;
	ValaSymbol* dbus_ns;
	GeeList* source_files;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (context != NULL);
	vala_ccode_base_module_set_context (self, context);
	vala_code_context_find_header_cycles (context);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->root_symbol = (_tmp1 = (_tmp0 = ((ValaSymbol*) (vala_code_context_get_root (context))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->root_symbol == NULL ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->bool_type = (_tmp3 = ((ValaDataType*) (vala_value_type_new ((_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool")))))), (self->bool_type == NULL ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL))), _tmp3);
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->char_type = (_tmp5 = ((ValaDataType*) (vala_value_type_new ((_tmp4 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "char")))))), (self->char_type == NULL ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL))), _tmp5);
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->uchar_type = (_tmp7 = ((ValaDataType*) (vala_value_type_new ((_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar")))))), (self->uchar_type == NULL ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL))), _tmp7);
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->unichar_type = (_tmp9 = ((ValaDataType*) (vala_value_type_new ((_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar")))))), (self->unichar_type == NULL ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL))), _tmp9);
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->short_type = (_tmp11 = ((ValaDataType*) (vala_value_type_new ((_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short")))))), (self->short_type == NULL ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->ushort_type = (_tmp13 = ((ValaDataType*) (vala_value_type_new ((_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort")))))), (self->ushort_type == NULL ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL))), _tmp13);
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->int_type = (_tmp15 = ((ValaDataType*) (vala_value_type_new ((_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int")))))), (self->int_type == NULL ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->uint_type = (_tmp17 = ((ValaDataType*) (vala_value_type_new ((_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint")))))), (self->uint_type == NULL ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->long_type = (_tmp19 = ((ValaDataType*) (vala_value_type_new ((_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long")))))), (self->long_type == NULL ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL))), _tmp19);
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->ulong_type = (_tmp21 = ((ValaDataType*) (vala_value_type_new ((_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong")))))), (self->ulong_type == NULL ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL))), _tmp21);
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->int8_type = (_tmp23 = ((ValaDataType*) (vala_value_type_new ((_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8")))))), (self->int8_type == NULL ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL))), _tmp23);
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint8_type = (_tmp25 = ((ValaDataType*) (vala_value_type_new ((_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint8")))))), (self->uint8_type == NULL ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL))), _tmp25);
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->int32_type = (_tmp27 = ((ValaDataType*) (vala_value_type_new ((_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int32")))))), (self->int32_type == NULL ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->uint32_type = (_tmp29 = ((ValaDataType*) (vala_value_type_new ((_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint32")))))), (self->uint32_type == NULL ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL))), _tmp29);
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_code_node_unref (_tmp28), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->int64_type = (_tmp31 = ((ValaDataType*) (vala_value_type_new ((_tmp30 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int64")))))), (self->int64_type == NULL ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL))), _tmp31);
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL)));
	_tmp33 = NULL;
	_tmp32 = NULL;
	self->uint64_type = (_tmp33 = ((ValaDataType*) (vala_value_type_new ((_tmp32 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64")))))), (self->uint64_type == NULL ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL))), _tmp33);
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL)));
	_tmp35 = NULL;
	_tmp34 = NULL;
	self->float_type = (_tmp35 = ((ValaDataType*) (vala_value_type_new ((_tmp34 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "float")))))), (self->float_type == NULL ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL))), _tmp35);
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL)));
	_tmp37 = NULL;
	_tmp36 = NULL;
	self->double_type = (_tmp37 = ((ValaDataType*) (vala_value_type_new ((_tmp36 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double")))))), (self->double_type == NULL ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL))), _tmp37);
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL)));
	_tmp39 = NULL;
	_tmp38 = NULL;
	self->string_type = (_tmp39 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) ((_tmp38 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))))))), (self->string_type == NULL ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL))), _tmp39);
	(_tmp38 == NULL ? NULL : (_tmp38 = (vala_code_node_unref (_tmp38), NULL)));
	_tmp40 = NULL;
	self->substring_method = (_tmp40 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (vala_data_type_get_data_type (self->string_type)))), "substring")), (self->substring_method == NULL ? NULL : (self->substring_method = (vala_code_node_unref (self->substring_method), NULL))), _tmp40);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	_tmp41 = NULL;
	self->gtype_type = (_tmp41 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), (self->gtype_type == NULL ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL))), _tmp41);
	_tmp42 = NULL;
	self->gobject_type = (_tmp42 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL))), _tmp42);
	_tmp43 = NULL;
	self->gerror_type = (_tmp43 = vala_error_type_new (NULL, NULL, NULL), (self->gerror_type == NULL ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL))), _tmp43);
	_tmp44 = NULL;
	self->glist_type = (_tmp44 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL))), _tmp44);
	_tmp45 = NULL;
	self->gslist_type = (_tmp45 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL))), _tmp45);
	_tmp46 = NULL;
	self->gstringbuilder_type = (_tmp46 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StringBuilder")), (self->gstringbuilder_type == NULL ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL))), _tmp46);
	_tmp47 = NULL;
	self->garray_type = (_tmp47 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL))), _tmp47);
	_tmp49 = NULL;
	_tmp48 = NULL;
	self->gquark_type = (_tmp49 = ((ValaDataType*) (vala_value_type_new ((_tmp48 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark")))))), (self->gquark_type == NULL ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL))), _tmp49);
	(_tmp48 == NULL ? NULL : (_tmp48 = (vala_code_node_unref (_tmp48), NULL)));
	_tmp50 = NULL;
	self->mutex_type = (_tmp50 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StaticRecMutex")), (self->mutex_type == NULL ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL))), _tmp50);
	_tmp51 = NULL;
	self->type_module_type = (_tmp51 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL))), _tmp51);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp52;
		_tmp52 = NULL;
		self->module_init_fragment = (_tmp52 = vala_ccode_fragment_new (), (self->module_init_fragment == NULL ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL))), _tmp52);
		{
			GeeList* parameter_collection;
			int parameter_it;
			parameter_collection = vala_method_get_parameters (vala_code_context_get_module_init_method (context));
			for (parameter_it = 0; parameter_it < gee_collection_get_size (GEE_COLLECTION (parameter_collection)); parameter_it = parameter_it + 1) {
				ValaFormalParameter* parameter;
				parameter = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (parameter_collection), parameter_it)));
				{
					if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (parameter)) == self->type_module_type) {
						char* _tmp54;
						const char* _tmp53;
						self->in_plugin = TRUE;
						_tmp54 = NULL;
						_tmp53 = NULL;
						self->module_init_param_name = (_tmp54 = (_tmp53 = vala_symbol_get_name (((ValaSymbol*) (parameter))), (_tmp53 == NULL ? NULL : g_strdup (_tmp53))), (self->module_init_param_name = (g_free (self->module_init_param_name), NULL)), _tmp54);
						(parameter == NULL ? NULL : (parameter = (vala_code_node_unref (parameter), NULL)));
						break;
					}
					(parameter == NULL ? NULL : (parameter = (vala_code_node_unref (parameter), NULL)));
				}
			}
			(parameter_collection == NULL ? NULL : (parameter_collection = (gee_collection_object_unref (parameter_collection), NULL)));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaInterface* _tmp55;
		ValaInterface* _tmp56;
		ValaInterface* _tmp57;
		ValaInterface* _tmp58;
		ValaInterface* _tmp59;
		_tmp55 = NULL;
		self->iterable_type = (_tmp55 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")), (self->iterable_type == NULL ? NULL : (self->iterable_type = (vala_code_node_unref (self->iterable_type), NULL))), _tmp55);
		_tmp56 = NULL;
		self->iterator_type = (_tmp56 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->iterator_type == NULL ? NULL : (self->iterator_type = (vala_code_node_unref (self->iterator_type), NULL))), _tmp56);
		_tmp57 = NULL;
		self->collection_type = (_tmp57 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Collection")), (self->collection_type == NULL ? NULL : (self->collection_type = (vala_code_node_unref (self->collection_type), NULL))), _tmp57);
		_tmp58 = NULL;
		self->list_type = (_tmp58 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->list_type == NULL ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL))), _tmp58);
		_tmp59 = NULL;
		self->map_type = (_tmp59 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->map_type == NULL ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL))), _tmp59);
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaTypeSymbol* _tmp60;
		_tmp60 = NULL;
		self->dbus_object_type = (_tmp60 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Object")), (self->dbus_object_type == NULL ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL))), _tmp60);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeList* file_collection;
		int file_it;
		file_collection = source_files;
		for (file_it = 0; file_it < gee_collection_get_size (GEE_COLLECTION (file_collection)); file_it = file_it + 1) {
			ValaSourceFile* file;
			file = ((ValaSourceFile*) (gee_list_get (GEE_LIST (file_collection), file_it)));
			{
				if (!vala_source_file_get_external_package (file)) {
					vala_source_file_accept (file, ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
				}
				(file == NULL ? NULL : (file = (vala_source_file_unref (file), NULL)));
			}
		}
	}
	(glib_ns == NULL ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (vala_code_node_unref (gee_ns), NULL)));
	(dbus_ns == NULL ? NULL : (dbus_ns = (vala_code_node_unref (dbus_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL)));
}


static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en) {
	ValaCCodeBaseModule * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaCCodeNewline* _tmp11;
	ValaCCodeNewline* _tmp12;
	char* _tmp13;
	char* _tmp14;
	char* macro;
	ValaCCodeMacroReplacement* _tmp16;
	char* _tmp15;
	ValaCCodeInitializerList* clist;
	ValaCCodeInitializerList* clist_ev;
	ValaCCodeInitializerList* _tmp24;
	ValaCCodeConstant* _tmp25;
	ValaCCodeConstant* _tmp26;
	ValaCCodeConstant* _tmp27;
	ValaCCodeVariableDeclarator* enum_decl;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeBlock* type_init;
	char* _tmp30;
	char* _tmp31;
	char* fun_name;
	ValaCCodeFunction* regfun;
	ValaCCodeBlock* regblock;
	ValaCCodeDeclaration* _tmp32;
	char* _tmp33;
	char* _tmp34;
	char* type_id_name;
	ValaCCodeVariableDeclarator* _tmp36;
	ValaCCodeConstant* _tmp35;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp43;
	char* _tmp42;
	char* _tmp41;
	ValaCCodeIdentifier* _tmp44;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeAssignment* _tmp46;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeFunctionCall* _tmp49;
	ValaCCodeFunctionCall* cond;
	ValaCCodeBinaryExpression* _tmp52;
	ValaCCodeConstant* _tmp51;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp54;
	ValaCCodeConstant* _tmp53;
	ValaCCodeNewline* _tmp57;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (en != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->cenum = (_tmp1 = vala_ccode_enum_new ((_tmp0 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (en)), FALSE))), (self->cenum == NULL ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL))), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) (en))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp3;
		ValaCCodeFragment* _tmp2;
		ValaCCodeFragment* _tmp5;
		ValaCCodeFragment* _tmp4;
		_tmp3 = NULL;
		_tmp2 = NULL;
		decl_frag = (_tmp3 = (_tmp2 = self->header_type_declaration, (_tmp2 == NULL ? NULL : vala_ccode_node_ref (_tmp2))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp3);
		_tmp5 = NULL;
		_tmp4 = NULL;
		def_frag = (_tmp5 = (_tmp4 = self->header_type_definition, (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp5);
	} else {
		ValaCCodeFragment* _tmp7;
		ValaCCodeFragment* _tmp6;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		_tmp7 = NULL;
		_tmp6 = NULL;
		decl_frag = (_tmp7 = (_tmp6 = self->source_type_declaration, (_tmp6 == NULL ? NULL : vala_ccode_node_ref (_tmp6))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp7);
		_tmp9 = NULL;
		_tmp8 = NULL;
		def_frag = (_tmp9 = (_tmp8 = self->source_type_definition, (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp9);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (en)))) != NULL) {
		ValaCCodeComment* _tmp10;
		_tmp10 = NULL;
		vala_ccode_fragment_append (def_frag, ((ValaCCodeNode*) ((_tmp10 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (en)))))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	}
	vala_ccode_fragment_append (def_frag, ((ValaCCodeNode*) (self->cenum)));
	_tmp11 = NULL;
	vala_ccode_fragment_append (def_frag, ((ValaCCodeNode*) ((_tmp11 = vala_ccode_newline_new ()))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	vala_code_node_accept_children (((ValaCodeNode*) (en)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (!vala_enum_get_has_type_id (en)) {
		(decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)));
		(def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)));
		return;
	}
	_tmp12 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_newline_new ()))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	_tmp14 = NULL;
	macro = (_tmp14 = g_strdup_printf ("(%s_get_type ())", (_tmp13 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (en)), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (decl_frag, ((ValaCCodeNode*) ((_tmp16 = vala_ccode_macro_replacement_new ((_tmp15 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (en)))), macro)))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp15 = (g_free (_tmp15), NULL);
	clist = vala_ccode_initializer_list_new ();
	/* or during visit time? */
	clist_ev = NULL;
	{
		GeeList* ev_collection;
		int ev_it;
		ev_collection = vala_enum_get_values (en);
		for (ev_it = 0; ev_it < gee_collection_get_size (GEE_COLLECTION (ev_collection)); ev_it = ev_it + 1) {
			ValaEnumValue* ev;
			ev = ((ValaEnumValue*) (gee_list_get (GEE_LIST (ev_collection), ev_it)));
			{
				ValaCCodeInitializerList* _tmp17;
				ValaCCodeConstant* _tmp19;
				char* _tmp18;
				ValaCCodeIdentifier* _tmp22;
				char* _tmp21;
				char* _tmp20;
				ValaCCodeConstant* _tmp23;
				_tmp17 = NULL;
				clist_ev = (_tmp17 = vala_ccode_initializer_list_new (), (clist_ev == NULL ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL))), _tmp17);
				_tmp19 = NULL;
				_tmp18 = NULL;
				vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_constant_new ((_tmp18 = vala_enum_value_get_cname (ev)))))));
				(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
				_tmp18 = (g_free (_tmp18), NULL);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp20 = NULL;
				vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = g_strdup_printf ("\"%s\"", (_tmp20 = vala_enum_value_get_cname (ev)))))))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
				_tmp21 = (g_free (_tmp21), NULL);
				_tmp20 = (g_free (_tmp20), NULL);
				_tmp23 = NULL;
				vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp23 = vala_enum_value_get_canonical_cconstant (ev)))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				vala_ccode_initializer_list_append (clist, ((ValaCCodeExpression*) (clist_ev)));
				(ev == NULL ? NULL : (ev = (vala_code_node_unref (ev), NULL)));
			}
		}
		(ev_collection == NULL ? NULL : (ev_collection = (gee_collection_object_unref (ev_collection), NULL)));
	}
	_tmp24 = NULL;
	clist_ev = (_tmp24 = vala_ccode_initializer_list_new (), (clist_ev == NULL ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL))), _tmp24);
	_tmp25 = NULL;
	vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_constant_new ("0")))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	_tmp26 = NULL;
	vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_constant_new ("NULL")))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	vala_ccode_initializer_list_append (clist_ev, ((ValaCCodeExpression*) ((_tmp27 = vala_ccode_constant_new ("NULL")))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	vala_ccode_initializer_list_append (clist, ((ValaCCodeExpression*) (clist_ev)));
	enum_decl = vala_ccode_variable_declarator_new_with_initializer ("values[]", ((ValaCCodeExpression*) (clist)));
	cdecl_ = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeDeclaration* _tmp28;
		_tmp28 = NULL;
		cdecl_ = (_tmp28 = vala_ccode_declaration_new ("const GFlagsValue"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp28);
	} else {
		ValaCCodeDeclaration* _tmp29;
		_tmp29 = NULL;
		cdecl_ = (_tmp29 = vala_ccode_declaration_new ("const GEnumValue"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp29);
	}
	vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (enum_decl)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	type_init = vala_ccode_block_new ();
	vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) (cdecl_)));
	_tmp30 = NULL;
	_tmp31 = NULL;
	fun_name = (_tmp31 = g_strdup_printf ("%s_get_type", (_tmp30 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (en)), NULL))), (_tmp30 = (g_free (_tmp30), NULL)), _tmp31);
	regfun = vala_ccode_function_new (fun_name, "GType");
	regblock = vala_ccode_block_new ();
	_tmp32 = NULL;
	cdecl_ = (_tmp32 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp32);
	_tmp33 = NULL;
	_tmp34 = NULL;
	type_id_name = (_tmp34 = g_strdup_printf ("%s_type_id", (_tmp33 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (en)), NULL))), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34);
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp36 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_constant_new ("0")))))))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_block_add_statement (regblock, ((ValaCCodeNode*) (cdecl_)));
	reg_call = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeIdentifier* _tmp37;
		_tmp38 = NULL;
		_tmp37 = NULL;
		reg_call = (_tmp38 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp37 = vala_ccode_identifier_new ("g_flags_register_static"))))), (reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL))), _tmp38);
		(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
	} else {
		ValaCCodeFunctionCall* _tmp40;
		ValaCCodeIdentifier* _tmp39;
		_tmp40 = NULL;
		_tmp39 = NULL;
		reg_call = (_tmp40 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ("g_enum_register_static"))))), (reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL))), _tmp40);
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
	}
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_constant_new ((_tmp42 = g_strdup_printf ("\"%s\"", (_tmp41 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (en)), FALSE)))))))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp44 = NULL;
	vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp44 = vala_ccode_identifier_new ("values")))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) ((_tmp47 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp46 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp45 = vala_ccode_identifier_new (type_id_name)))), ((ValaCCodeExpression*) (reg_call)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
	(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
	(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	_tmp48 = NULL;
	_tmp49 = NULL;
	cond = (_tmp49 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp48 = vala_ccode_identifier_new ("G_UNLIKELY"))))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL))), _tmp49);
	_tmp52 = NULL;
	_tmp51 = NULL;
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (cond, ((ValaCCodeExpression*) ((_tmp52 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp50 = vala_ccode_identifier_new (type_id_name)))), ((ValaCCodeExpression*) ((_tmp51 = vala_ccode_constant_new ("0")))))))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
	(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
	(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
	cif = vala_ccode_if_statement_new (((ValaCCodeExpression*) (cond)), ((ValaCCodeStatement*) (type_init)), NULL);
	vala_ccode_block_add_statement (regblock, ((ValaCCodeNode*) (cif)));
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (regblock, ((ValaCCodeNode*) ((_tmp54 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp53 = vala_ccode_constant_new (type_id_name)))))))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
	if (vala_symbol_get_access (((ValaSymbol*) (en))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp55;
		_tmp55 = NULL;
		vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp55 = vala_ccode_function_copy (regfun)))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
	} else {
		ValaCCodeFunction* _tmp56;
		_tmp56 = NULL;
		vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp56 = vala_ccode_function_copy (regfun)))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
	}
	vala_ccode_function_set_block (regfun, regblock);
	_tmp57 = NULL;
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) ((_tmp57 = vala_ccode_newline_new ()))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (regfun)));
	(decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)));
	macro = (g_free (macro), NULL);
	(clist == NULL ? NULL : (clist = (vala_ccode_node_unref (clist), NULL)));
	(clist_ev == NULL ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)));
	(enum_decl == NULL ? NULL : (enum_decl = (vala_ccode_node_unref (enum_decl), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(type_init == NULL ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL)));
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL ? NULL : (regfun = (vala_ccode_node_unref (regfun), NULL)));
	(regblock == NULL ? NULL : (regblock = (vala_ccode_node_unref (regblock), NULL)));
	type_id_name = (g_free (type_id_name), NULL);
	(reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)));
	(cond == NULL ? NULL : (cond = (vala_ccode_node_unref (cond), NULL)));
	(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
}


static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (ev != NULL);
	if (vala_enum_value_get_value (ev) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_enum_value_get_cname (ev)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept (((ValaCodeNode*) (vala_enum_value_get_value (ev))), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp3 = vala_ccode_enum_value_new ((_tmp2 = vala_enum_value_get_cname (ev)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_enum_value_get_value (ev))))))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (m != NULL);
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		ValaCCodeExpression* l;
		ValaCCodeExpression* _tmp2;
		char* _tmp1;
		ValaCCodeMemberAccess* _tmp0;
		char* _tmp4;
		char* _tmp3;
		ValaCCodeIdentifier* _tmp6;
		char* _tmp5;
		ValaCCodeFunctionCall* _tmp7;
		ValaCCodeFunctionCall* initf;
		ValaCCodeUnaryExpression* _tmp8;
		ValaCCodeExpressionStatement* _tmp9;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* fc;
		ValaCCodeUnaryExpression* _tmp12;
		l = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("self")));
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		l = (_tmp2 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_member_access_new_pointer (l, "priv")))), (_tmp1 = vala_ccode_base_module_get_symbol_lock_name (self, ((ValaSymbol*) (m))))))), (l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL))), _tmp2);
		_tmp1 = (g_free (_tmp1), NULL);
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_struct_add_field (self->instance_priv_struct, (_tmp3 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (self->mutex_type)), FALSE)), (_tmp4 = vala_ccode_base_module_get_symbol_lock_name (self, ((ValaSymbol*) (m)))));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp7 = NULL;
		initf = (_tmp7 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new ((_tmp5 = vala_method_get_cname (vala_struct_get_default_construction_method (self->mutex_type)))))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp7);
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (initf, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		_tmp9 = NULL;
		vala_ccode_fragment_append (self->instance_init_fragment, ((ValaCCodeNode*) ((_tmp9 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (initf)))))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		self->requires_free_checked = TRUE;
		_tmp10 = NULL;
		_tmp11 = NULL;
		fc = (_tmp11 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ("g_static_rec_mutex_free"))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		if (self->instance_finalize_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp13;
			_tmp13 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, ((ValaCCodeNode*) ((_tmp13 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
		}
		(l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL)));
		(initf == NULL ? NULL : (initf = (vala_ccode_node_unref (initf), NULL)));
		(fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)));
	}
}


static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (c != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (c)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (!(VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c)))) {
		char* _tmp0;
		ValaCCodeMacroReplacement* _tmp1;
		ValaCCodeMacroReplacement* cdefine;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cdefine = (_tmp1 = vala_ccode_macro_replacement_new_with_expression ((_tmp0 = vala_constant_get_cname (c)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_constant_get_initializer (c)))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
		if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (c)))) {
			vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) (cdefine)));
		} else {
			vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) (cdefine)));
		}
		(cdefine == NULL ? NULL : (cdefine = (vala_ccode_node_unref (cdefine), NULL)));
	} else {
		char* _tmp2;
		ValaCCodeDeclaration* _tmp3;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* _tmp7;
		char* _tmp6;
		char* _tmp5;
		_tmp2 = NULL;
		_tmp3 = NULL;
		cdecl_ = (_tmp3 = vala_ccode_declaration_new ((_tmp2 = vala_data_type_get_const_cname (vala_constant_get_type_reference (c)))), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c))) {
			char* _tmp4;
			_tmp4 = NULL;
			arr = (_tmp4 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), _tmp4);
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp7 = vala_ccode_variable_declarator_new_with_initializer ((_tmp6 = g_strdup_printf ("%s%s", (_tmp5 = vala_constant_get_cname (c)), arr)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_constant_get_initializer (c))))))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
		_tmp5 = (g_free (_tmp5), NULL);
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (c)))) {
			vala_ccode_fragment_append (self->header_constant_declaration, ((ValaCCodeNode*) (cdecl_)));
		} else {
			vala_ccode_fragment_append (self->source_constant_declaration, ((ValaCCodeNode*) (cdecl_)));
		}
		(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		arr = (g_free (arr), NULL);
	}
}


static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	char* field_ctype;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (f != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (f)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (((ValaSymbol*) (f))), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	is_gtypeinstance = (cl != NULL && !vala_class_get_is_compact (cl));
	lhs = NULL;
	st = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp2;
		_tmp2 = NULL;
		field_ctype = (_tmp2 = g_strconcat ("volatile ", field_ctype, NULL), (field_ctype = (g_free (field_ctype), NULL)), _tmp2);
	}
	if (vala_symbol_get_access (((ValaSymbol*) (f))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
			ValaCCodeStruct* _tmp4;
			ValaCCodeStruct* _tmp3;
			ValaCCodeExpression* _tmp7;
			char* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			_tmp4 = NULL;
			_tmp3 = NULL;
			st = (_tmp4 = (_tmp3 = self->instance_struct, (_tmp3 == NULL ? NULL : vala_ccode_node_ref (_tmp3))), (st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL))), _tmp4);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			lhs = (_tmp7 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("self")))), (_tmp6 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		} else {
			if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
				ValaCCodeStruct* _tmp9;
				ValaCCodeStruct* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				st = (_tmp9 = (_tmp8 = self->type_struct, (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL))), _tmp9);
			} else {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp11;
				char* _tmp10;
				char* _tmp12;
				ValaCCodeVariableDeclarator* _tmp13;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp14;
				ValaCCodeDeclaration* var_def;
				ValaCCodeExpression* _tmp17;
				char* _tmp16;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp11 = vala_ccode_variable_declarator_new ((_tmp10 = vala_field_get_cname (f)))))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
				_tmp10 = (g_free (_tmp10), NULL);
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
				_tmp12 = NULL;
				_tmp13 = NULL;
				var_decl = (_tmp13 = vala_ccode_variable_declarator_new ((_tmp12 = vala_field_get_cname (f))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
				_tmp14 = NULL;
				vala_ccode_variable_declarator_set_initializer (var_decl, (_tmp14 = vala_ccode_base_module_default_value_for_type (self, vala_field_get_field_type (f), TRUE)));
				(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp15;
					ValaCCodeExpression* init;
					_tmp15 = NULL;
					init = (_tmp15 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_field_get_initializer (f))))), (_tmp15 == NULL ? NULL : vala_ccode_node_ref (_tmp15)));
					if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL ? NULL : (init = (vala_ccode_node_unref (init), NULL)));
				}
				var_def = vala_ccode_declaration_new (field_ctype);
				vala_ccode_declaration_add_declarator (var_def, ((ValaCCodeDeclarator*) (var_decl)));
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) (var_def)));
				_tmp17 = NULL;
				_tmp16 = NULL;
				lhs = (_tmp17 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp16 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp17);
				_tmp16 = (g_free (_tmp16), NULL);
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)));
				(var_def == NULL ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL)));
			}
		}
	} else {
		if (vala_symbol_get_access (((ValaSymbol*) (f))) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				if (is_gtypeinstance) {
					ValaCCodeStruct* _tmp19;
					ValaCCodeStruct* _tmp18;
					ValaCCodeExpression* _tmp23;
					char* _tmp22;
					ValaCCodeMemberAccess* _tmp21;
					ValaCCodeIdentifier* _tmp20;
					_tmp19 = NULL;
					_tmp18 = NULL;
					st = (_tmp19 = (_tmp18 = self->instance_priv_struct, (_tmp18 == NULL ? NULL : vala_ccode_node_ref (_tmp18))), (st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL))), _tmp19);
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp20 = NULL;
					lhs = (_tmp23 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ("self")))), "priv")))), (_tmp22 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp23);
					_tmp22 = (g_free (_tmp22), NULL);
					(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
					(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
				} else {
					ValaCCodeStruct* _tmp25;
					ValaCCodeStruct* _tmp24;
					ValaCCodeExpression* _tmp28;
					char* _tmp27;
					ValaCCodeIdentifier* _tmp26;
					_tmp25 = NULL;
					_tmp24 = NULL;
					st = (_tmp25 = (_tmp24 = self->instance_struct, (_tmp24 == NULL ? NULL : vala_ccode_node_ref (_tmp24))), (st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL))), _tmp25);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp26 = NULL;
					lhs = (_tmp28 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new ("self")))), (_tmp27 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp28);
					_tmp27 = (g_free (_tmp27), NULL);
					(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
				}
			} else {
				if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
					ValaCCodeStruct* _tmp30;
					ValaCCodeStruct* _tmp29;
					_tmp30 = NULL;
					_tmp29 = NULL;
					st = (_tmp30 = (_tmp29 = self->type_struct, (_tmp29 == NULL ? NULL : vala_ccode_node_ref (_tmp29))), (st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL))), _tmp30);
				} else {
					ValaCCodeDeclaration* cdecl_;
					char* _tmp31;
					ValaCCodeVariableDeclarator* _tmp32;
					ValaCCodeVariableDeclarator* var_decl;
					ValaCCodeExpression* _tmp35;
					char* _tmp34;
					cdecl_ = vala_ccode_declaration_new (field_ctype);
					_tmp31 = NULL;
					_tmp32 = NULL;
					var_decl = (_tmp32 = vala_ccode_variable_declarator_new ((_tmp31 = vala_field_get_cname (f))), (_tmp31 = (g_free (_tmp31), NULL)), _tmp32);
					if (vala_field_get_initializer (f) != NULL) {
						ValaCCodeExpression* _tmp33;
						ValaCCodeExpression* init;
						_tmp33 = NULL;
						init = (_tmp33 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_field_get_initializer (f))))), (_tmp33 == NULL ? NULL : vala_ccode_node_ref (_tmp33)));
						if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
							vala_ccode_variable_declarator_set_initializer (var_decl, init);
						}
						(init == NULL ? NULL : (init = (vala_ccode_node_unref (init), NULL)));
					}
					vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (var_decl)));
					vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
					_tmp35 = NULL;
					_tmp34 = NULL;
					lhs = (_tmp35 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp34 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp35);
					_tmp34 = (g_free (_tmp34), NULL);
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)));
				}
			}
		}
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		char* _tmp36;
		_tmp36 = NULL;
		vala_ccode_struct_add_field (st, field_ctype, (_tmp36 = vala_field_get_cname (f)));
		_tmp36 = (g_free (_tmp36), NULL);
		if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f)) && !vala_field_get_no_array_length (f)) {
			ValaArrayType* _tmp37;
			ValaArrayType* array_type;
			/* create fields to store array dimensions*/
			_tmp37 = NULL;
			array_type = (_tmp37 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp37 == NULL ? NULL : vala_code_node_ref (_tmp37)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaDataType* len_type;
					char* _tmp39;
					char* _tmp38;
					len_type = vala_data_type_copy (self->int_type);
					_tmp39 = NULL;
					_tmp38 = NULL;
					vala_ccode_struct_add_field (st, (_tmp38 = vala_data_type_get_cname (len_type)), (_tmp39 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (f))), dim)));
					_tmp39 = (g_free (_tmp39), NULL);
					_tmp38 = (g_free (_tmp38), NULL);
					(len_type == NULL ? NULL : (len_type = (vala_code_node_unref (len_type), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
				ValaDelegateType* _tmp40;
				ValaDelegateType* delegate_type;
				_tmp40 = NULL;
				delegate_type = (_tmp40 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
				if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
					char* _tmp41;
					/* create field to store delegate target*/
					_tmp41 = NULL;
					vala_ccode_struct_add_field (st, "gpointer", (_tmp41 = vala_ccode_base_module_get_delegate_target_cname (self, vala_symbol_get_name (((ValaSymbol*) (f))))));
					_tmp41 = (g_free (_tmp41), NULL);
				}
				(delegate_type == NULL ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL)));
			}
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp42;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* _tmp44;
			ValaCCodeAssignment* _tmp43;
			_tmp42 = NULL;
			rhs = (_tmp42 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_field_get_initializer (f))))), (_tmp42 == NULL ? NULL : vala_ccode_node_ref (_tmp42)));
			_tmp44 = NULL;
			_tmp43 = NULL;
			vala_ccode_fragment_append (self->instance_init_fragment, ((ValaCCodeNode*) ((_tmp44 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp43 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
			(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
			(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f)) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaArrayType* _tmp45;
				ValaArrayType* array_type;
				ValaMemberAccess* this_access;
				ValaDataType* _tmp46;
				ValaCCodeIdentifier* _tmp47;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp45 = NULL;
				array_type = (_tmp45 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp45 == NULL ? NULL : vala_code_node_ref (_tmp45)));
				this_access = vala_member_access_new_simple ("this", NULL);
				_tmp46 = NULL;
				vala_expression_set_value_type (((ValaExpression*) (this_access)), (_tmp46 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (vala_code_node_unref (_tmp46), NULL)));
				_tmp47 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (this_access)), ((ValaCCodeNode*) ((_tmp47 = vala_ccode_identifier_new ("self")))));
				(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
				ma = vala_member_access_new (((ValaExpression*) (this_access)), vala_symbol_get_name (((ValaSymbol*) (f))), NULL);
				vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (f)));
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp49;
						ValaCCodeAssignment* _tmp48;
						array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaExpression*) (ma)), dim);
						size = ((ValaExpression*) (gee_list_get (((GeeList*) (sizes)), dim - 1)));
						_tmp49 = NULL;
						_tmp48 = NULL;
						vala_ccode_fragment_append (self->instance_init_fragment, ((ValaCCodeNode*) ((_tmp49 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp48 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (size)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
						(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
						(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
						(array_len_lhs == NULL ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL)));
						(size == NULL ? NULL : (size = (vala_code_node_unref (size), NULL)));
					}
				}
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
				(this_access == NULL ? NULL : (this_access = (vala_code_node_unref (this_access), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				(sizes == NULL ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL)));
			}
			(rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)));
		}
		if (vala_ccode_base_module_requires_destroy (self, vala_field_get_field_type (f)) && self->instance_finalize_fragment != NULL) {
			ValaMemberAccess* this_access;
			ValaDataType* _tmp50;
			ValaCCodeIdentifier* _tmp51;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp53;
			ValaCCodeExpression* _tmp52;
			this_access = vala_member_access_new_simple ("this", NULL);
			_tmp50 = NULL;
			vala_expression_set_value_type (((ValaExpression*) (this_access)), (_tmp50 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (vala_code_node_unref (_tmp50), NULL)));
			_tmp51 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (this_access)), ((ValaCCodeNode*) ((_tmp51 = vala_ccode_identifier_new ("self")))));
			(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
			ma = vala_member_access_new (((ValaExpression*) (this_access)), vala_symbol_get_name (((ValaSymbol*) (f))), NULL);
			vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (f)));
			_tmp53 = NULL;
			_tmp52 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, ((ValaCCodeNode*) ((_tmp53 = vala_ccode_expression_statement_new ((_tmp52 = vala_ccode_base_module_get_unref_expression (self, lhs, vala_field_get_field_type (f), ((ValaExpression*) (ma)))))))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
			(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
			(this_access == NULL ? NULL : (this_access = (vala_code_node_unref (this_access), NULL)));
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			char* _tmp54;
			_tmp54 = NULL;
			vala_ccode_struct_add_field (st, field_ctype, (_tmp54 = vala_field_get_cname (f)));
			_tmp54 = (g_free (_tmp54), NULL);
		} else {
			/* add array length fields where necessary */
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f)) && !vala_field_get_no_array_length (f)) {
				ValaArrayType* _tmp55;
				ValaArrayType* array_type;
				_tmp55 = NULL;
				array_type = (_tmp55 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp55 == NULL ? NULL : vala_code_node_ref (_tmp55)));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaDataType* len_type;
						char* _tmp56;
						ValaCCodeDeclaration* _tmp57;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp60;
						char* _tmp59;
						char* _tmp58;
						len_type = vala_data_type_copy (self->int_type);
						_tmp56 = NULL;
						_tmp57 = NULL;
						cdecl_ = (_tmp57 = vala_ccode_declaration_new ((_tmp56 = vala_data_type_get_cname (len_type))), (_tmp56 = (g_free (_tmp56), NULL)), _tmp57);
						_tmp60 = NULL;
						_tmp59 = NULL;
						_tmp58 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp60 = vala_ccode_variable_declarator_new ((_tmp59 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), (_tmp58 = vala_field_get_cname (f)), dim)))))));
						(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
						_tmp59 = (g_free (_tmp59), NULL);
						_tmp58 = (g_free (_tmp58), NULL);
						if (vala_symbol_get_access (((ValaSymbol*) (f))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
						}
						(len_type == NULL ? NULL : (len_type = (vala_code_node_unref (len_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
				}
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
					ValaDelegateType* _tmp61;
					ValaDelegateType* delegate_type;
					_tmp61 = NULL;
					delegate_type = (_tmp61 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp61 == NULL ? NULL : vala_code_node_ref (_tmp61)));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp64;
						char* _tmp63;
						char* _tmp62;
						/* create field to store delegate target*/
						cdecl_ = vala_ccode_declaration_new ("gpointer");
						_tmp64 = NULL;
						_tmp63 = NULL;
						_tmp62 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp64 = vala_ccode_variable_declarator_new ((_tmp63 = vala_ccode_base_module_get_delegate_target_cname (self, (_tmp62 = vala_field_get_cname (f)))))))));
						(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
						_tmp63 = (g_free (_tmp63), NULL);
						_tmp62 = (g_free (_tmp62), NULL);
						if (vala_symbol_get_access (((ValaSymbol*) (f))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) (cdecl_)));
						}
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
					(delegate_type == NULL ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL)));
				}
			}
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp65;
				ValaCCodeExpression* rhs;
				_tmp65 = NULL;
				rhs = (_tmp65 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_field_get_initializer (f))))), (_tmp65 == NULL ? NULL : vala_ccode_node_ref (_tmp65)));
				if (!vala_ccode_base_module_is_constant_ccode_expression (self, rhs)) {
					if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (f))))) {
						ValaCCodeExpressionStatement* _tmp67;
						ValaCCodeAssignment* _tmp66;
						_tmp67 = NULL;
						_tmp66 = NULL;
						vala_ccode_fragment_append (self->class_init_fragment, ((ValaCCodeNode*) ((_tmp67 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp66 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
						(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
						(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
					} else {
						vala_code_node_set_error (((ValaCodeNode*) (f)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (f))), "Non-constant field initializers not supported in this context");
						(rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)));
						(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
						(lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)));
						(st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL)));
						field_ctype = (g_free (field_ctype), NULL);
						return;
					}
				}
				(rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)));
			}
		}
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	(lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (vala_ccode_node_unref (st), NULL)));
	field_ctype = (g_free (field_ctype), NULL);
}


static gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp4;
	ValaCCodeExpression* _tmp3;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp5;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1)));
			return (_tmp2 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary)) && vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary)), (cbinary == NULL ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL))), _tmp2);
		}
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	cparenthesized = (_tmp4 = ((_tmp3 = cexpr, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp3) ? ((ValaCCodeParenthesizedExpression*) (_tmp3)) : NULL))), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4)));
	return (_tmp5 = (NULL != cparenthesized && vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized))), (cparenthesized == NULL ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL))), _tmp5);
}


/**
 * Returns whether the passed cexpr is a pure expression, i.e. an
 * expression without side-effects.
 */
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp6;
	ValaCCodeExpression* _tmp5;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr) || VALA_IS_CCODE_IDENTIFIER (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1)));
			return (_tmp2 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary)) && vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary)), (cbinary == NULL ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL))), _tmp2);
		} else {
			if (VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
				ValaCCodeMemberAccess* _tmp3;
				ValaCCodeMemberAccess* cma;
				gboolean _tmp4;
				_tmp3 = NULL;
				cma = (_tmp3 = VALA_CCODE_MEMBER_ACCESS (cexpr), (_tmp3 == NULL ? NULL : vala_ccode_node_ref (_tmp3)));
				return (_tmp4 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_member_access_get_inner (cma)), (cma == NULL ? NULL : (cma = (vala_ccode_node_unref (cma), NULL))), _tmp4);
			}
		}
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	cparenthesized = (_tmp6 = ((_tmp5 = cexpr, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp5) ? ((ValaCCodeParenthesizedExpression*) (_tmp5)) : NULL))), (_tmp6 == NULL ? NULL : vala_ccode_node_ref (_tmp6)));
	return (_tmp7 = (NULL != cparenthesized && vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized))), (cparenthesized == NULL ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL))), _tmp7);
}


static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (p != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (p)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		char* ctypename;
		const char* _tmp0;
		char* cname;
		ValaCCodeFormalParameter* _tmp4;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (p));
		_tmp0 = NULL;
		cname = (_tmp0 = vala_symbol_get_name (((ValaSymbol*) (p))), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
		/* pass non-simple structs always by reference*/
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)))) {
			ValaStruct* _tmp1;
			ValaStruct* st;
			_tmp1 = NULL;
			st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
			if (!vala_struct_is_simple_type (st) && vala_formal_parameter_get_direction (p) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p))) {
				char* _tmp2;
				_tmp2 = NULL;
				ctypename = (_tmp2 = g_strconcat (ctypename, ("*"), NULL), (ctypename = (g_free (ctypename), NULL)), _tmp2);
			}
			(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		}
		if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp3;
			_tmp3 = NULL;
			ctypename = (_tmp3 = g_strconcat (ctypename, ("*"), NULL), (ctypename = (g_free (ctypename), NULL)), _tmp3);
		}
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (p)), ((ValaCCodeNode*) ((_tmp4 = vala_ccode_formal_parameter_new (cname, ctypename)))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		ctypename = (g_free (ctypename), NULL);
		cname = (g_free (cname), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp5;
		_tmp5 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (p)), ((ValaCCodeNode*) ((_tmp5 = vala_ccode_formal_parameter_new_with_ellipsis ()))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	}
}


static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop) {
	ValaCCodeBaseModule * self;
	gint old_next_temp_var_id;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (prop != NULL);
	old_next_temp_var_id = self->next_temp_var_id;
	self->next_temp_var_id = 0;
	vala_code_node_accept_children (((ValaCodeNode*) (prop)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	self->next_temp_var_id = old_next_temp_var_id;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (((ValaSymbol*) (prop))), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (cl != NULL && vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (cl)), self->gobject_type) && vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		/* GObject property
		 FIXME: omit real struct types for now since they
		 cannot be expressed as gobject property yet
		 don't register private properties*/
		if (!vala_data_type_is_real_struct_type (vala_property_get_property_type (prop)) && vala_symbol_get_access (((ValaSymbol*) (prop))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeEnumValue* _tmp3;
			char* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_ccode_enum_add_value (self->prop_enum, (_tmp3 = vala_ccode_enum_value_new ((_tmp2 = vala_property_get_upper_case_cname (prop)), NULL)));
			(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
			_tmp2 = (g_free (_tmp2), NULL);
		}
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc) {
	ValaCCodeBaseModule * self;
	ValaPropertyAccessor* _tmp1;
	ValaPropertyAccessor* _tmp0;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	gboolean returns_real_struct;
	ValaTypeSymbol* _tmp6;
	ValaTypeSymbol* t;
	ValaReferenceType* this_type;
	char* _tmp9;
	ValaCCodeFormalParameter* _tmp10;
	ValaCCodeFormalParameter* cselfparam;
	ValaDataType* value_type;
	ValaCCodeFormalParameter* cvalueparam;
	ValaPropertyAccessor* _tmp83;
	ValaDataType* _tmp84;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (acc != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_property_accessor = (_tmp1 = (_tmp0 = acc, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL))), _tmp1);
	self->current_method_inner_error = FALSE;
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
	if (vala_property_accessor_get_readable (acc) && !returns_real_struct) {
		ValaDataType* _tmp4;
		ValaDataType* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		self->current_return_type = (_tmp4 = (_tmp3 = vala_property_get_property_type (prop), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3))), (self->current_return_type == NULL ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL))), _tmp4);
	} else {
		ValaDataType* _tmp5;
		_tmp5 = NULL;
		self->current_return_type = (_tmp5 = ((ValaDataType*) (vala_void_type_new ())), (self->current_return_type == NULL ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL))), _tmp5);
	}
	vala_code_node_accept_children (((ValaCodeNode*) (acc)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp6 = NULL;
	t = (_tmp6 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (prop)))), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
	this_type = NULL;
	if (VALA_IS_CLASS (t)) {
		ValaReferenceType* _tmp7;
		_tmp7 = NULL;
		this_type = (_tmp7 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (t)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp7);
	} else {
		ValaReferenceType* _tmp8;
		_tmp8 = NULL;
		this_type = (_tmp8 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (t)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp8);
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	cselfparam = (_tmp10 = vala_ccode_formal_parameter_new ("self", (_tmp9 = vala_data_type_get_cname (((ValaDataType*) (this_type))))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10);
	value_type = vala_data_type_copy (vala_property_get_property_type (prop));
	cvalueparam = NULL;
	if (returns_real_struct) {
		ValaCCodeFormalParameter* _tmp13;
		char* _tmp12;
		char* _tmp11;
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		cvalueparam = (_tmp13 = vala_ccode_formal_parameter_new ("value", (_tmp12 = g_strconcat ((_tmp11 = vala_data_type_get_cname (value_type)), "*", NULL))), (cvalueparam == NULL ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL))), _tmp13);
		_tmp12 = (g_free (_tmp12), NULL);
		_tmp11 = (g_free (_tmp11), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp15;
		char* _tmp14;
		_tmp15 = NULL;
		_tmp14 = NULL;
		cvalueparam = (_tmp15 = vala_ccode_formal_parameter_new ("value", (_tmp14 = vala_data_type_get_cname (value_type))), (cvalueparam == NULL ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL))), _tmp15);
		_tmp14 = (g_free (_tmp14), NULL);
	}
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeFunctionDeclarator* vdeclarator;
		ValaCCodeBlock* block;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp39;
		vdeclarator = NULL;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp18;
			char* _tmp17;
			char* _tmp16;
			char* _tmp19;
			ValaCCodeDeclaration* _tmp20;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp22;
			char* _tmp21;
			_tmp18 = NULL;
			_tmp17 = NULL;
			_tmp16 = NULL;
			self->function = (_tmp18 = vala_ccode_function_new ((_tmp16 = vala_property_accessor_get_cname (acc)), (_tmp17 = vala_data_type_get_cname (self->current_return_type))), (self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL))), _tmp18);
			_tmp17 = (g_free (_tmp17), NULL);
			_tmp16 = (g_free (_tmp16), NULL);
			_tmp19 = NULL;
			_tmp20 = NULL;
			vdecl = (_tmp20 = vala_ccode_declaration_new ((_tmp19 = vala_data_type_get_cname (self->current_return_type))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20);
			_tmp22 = NULL;
			_tmp21 = NULL;
			vdeclarator = (_tmp22 = vala_ccode_function_declarator_new ((_tmp21 = g_strdup_printf ("get_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))), (vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL))), _tmp22);
			_tmp21 = (g_free (_tmp21), NULL);
			vala_ccode_declaration_add_declarator (vdecl, ((ValaCCodeDeclarator*) (vdeclarator)));
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL)));
		} else {
			ValaCCodeFunction* _tmp24;
			char* _tmp23;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp26;
			char* _tmp25;
			_tmp24 = NULL;
			_tmp23 = NULL;
			self->function = (_tmp24 = vala_ccode_function_new ((_tmp23 = vala_property_accessor_get_cname (acc)), "void"), (self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL))), _tmp24);
			_tmp23 = (g_free (_tmp23), NULL);
			vdecl = vala_ccode_declaration_new ("void");
			_tmp26 = NULL;
			_tmp25 = NULL;
			vdeclarator = (_tmp26 = vala_ccode_function_declarator_new ((_tmp25 = g_strdup_printf ("set_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))), (vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL))), _tmp26);
			_tmp25 = (g_free (_tmp25), NULL);
			vala_ccode_declaration_add_declarator (vdecl, ((ValaCCodeDeclarator*) (vdeclarator)));
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL)));
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc) || returns_real_struct) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
			vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
		}
		if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (prop))) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc)) && vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFunction* _tmp27;
			/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
			_tmp27 = NULL;
			vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp27 = vala_ccode_function_copy (self->function)))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
		} else {
			ValaCCodeFunction* _tmp28;
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp28 = NULL;
			vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp28 = vala_ccode_function_copy (self->function)))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->function, block);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (prop))))) {
			ValaInterface* _tmp29;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp33;
			ValaCCodeIdentifier* _tmp32;
			char* _tmp31;
			char* _tmp30;
			_tmp29 = NULL;
			iface = (_tmp29 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (prop)))), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29)));
			_tmp33 = NULL;
			_tmp32 = NULL;
			_tmp31 = NULL;
			_tmp30 = NULL;
			vcast = (_tmp33 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp30 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (iface)), NULL))))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp33);
			(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
			_tmp31 = (g_free (_tmp31), NULL);
			_tmp30 = (g_free (_tmp30), NULL);
			(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
		} else {
			ValaClass* _tmp34;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp38;
			ValaCCodeIdentifier* _tmp37;
			char* _tmp36;
			char* _tmp35;
			_tmp34 = NULL;
			cl = (_tmp34 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (prop)))), (_tmp34 == NULL ? NULL : vala_code_node_ref (_tmp34)));
			_tmp38 = NULL;
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp35 = NULL;
			vcast = (_tmp38 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp37 = vala_ccode_identifier_new ((_tmp36 = g_strdup_printf ("%s_GET_CLASS", (_tmp35 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (cl)), NULL))))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp38);
			(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
			_tmp36 = (g_free (_tmp36), NULL);
			_tmp35 = (g_free (_tmp35), NULL);
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
		}
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ("self")))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeMemberAccess* _tmp41;
			char* _tmp40;
			ValaCCodeFunctionCall* _tmp42;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp43;
			_tmp41 = NULL;
			_tmp40 = NULL;
			_tmp42 = NULL;
			vcall = (_tmp42 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp41 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), (_tmp40 = g_strdup_printf ("get_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL))), (_tmp40 = (g_free (_tmp40), NULL)), _tmp42);
			_tmp43 = NULL;
			vala_ccode_function_call_add_argument (vcall, ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_identifier_new ("self")))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
			if (returns_real_struct) {
				ValaCCodeIdentifier* _tmp44;
				ValaCCodeExpressionStatement* _tmp45;
				_tmp44 = NULL;
				vala_ccode_function_call_add_argument (vcall, ((ValaCCodeExpression*) ((_tmp44 = vala_ccode_identifier_new ("value")))));
				(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
				_tmp45 = NULL;
				vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp45 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (vcall)))))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
			} else {
				ValaCCodeReturnStatement* _tmp46;
				_tmp46 = NULL;
				vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp46 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (vcall)))))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
			}
			(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
		} else {
			ValaCCodeMemberAccess* _tmp48;
			char* _tmp47;
			ValaCCodeFunctionCall* _tmp49;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp50;
			ValaCCodeIdentifier* _tmp51;
			ValaCCodeExpressionStatement* _tmp52;
			_tmp48 = NULL;
			_tmp47 = NULL;
			_tmp49 = NULL;
			vcall = (_tmp49 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp48 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), (_tmp47 = g_strdup_printf ("set_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL))), (_tmp47 = (g_free (_tmp47), NULL)), _tmp49);
			_tmp50 = NULL;
			vala_ccode_function_call_add_argument (vcall, ((ValaCCodeExpression*) ((_tmp50 = vala_ccode_identifier_new ("self")))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
			_tmp51 = NULL;
			vala_ccode_function_call_add_argument (vcall, ((ValaCCodeExpression*) ((_tmp51 = vala_ccode_identifier_new ("value")))));
			(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
			_tmp52 = NULL;
			vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp52 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (vcall)))))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
			(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (self->function)));
		(vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)));
		(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
		(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* cname;
		ValaObjectType* base_type;
		ValaTypeSymbol* _tmp76;
		ValaTypeSymbol* typesymbol;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		cname = NULL;
		if (is_virtual) {
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp54;
				char* _tmp53;
				_tmp54 = NULL;
				_tmp53 = NULL;
				cname = (_tmp54 = g_strdup_printf ("%s_real_get_%s", (_tmp53 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (t)), NULL)), vala_symbol_get_name (((ValaSymbol*) (prop)))), (cname = (g_free (cname), NULL)), _tmp54);
				_tmp53 = (g_free (_tmp53), NULL);
			} else {
				char* _tmp56;
				char* _tmp55;
				_tmp56 = NULL;
				_tmp55 = NULL;
				cname = (_tmp56 = g_strdup_printf ("%s_real_set_%s", (_tmp55 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (t)), NULL)), vala_symbol_get_name (((ValaSymbol*) (prop)))), (cname = (g_free (cname), NULL)), _tmp56);
				_tmp55 = (g_free (_tmp55), NULL);
			}
		} else {
			char* _tmp57;
			_tmp57 = NULL;
			cname = (_tmp57 = vala_property_accessor_get_cname (acc), (cname = (g_free (cname), NULL)), _tmp57);
		}
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc) || returns_real_struct) {
			ValaCCodeFunction* _tmp58;
			_tmp58 = NULL;
			self->function = (_tmp58 = vala_ccode_function_new (cname, "void"), (self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL))), _tmp58);
		} else {
			ValaCCodeFunction* _tmp60;
			char* _tmp59;
			_tmp60 = NULL;
			_tmp59 = NULL;
			self->function = (_tmp60 = vala_ccode_function_new (cname, (_tmp59 = vala_data_type_get_cname (vala_property_get_property_type (prop)))), (self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL))), _tmp60);
			_tmp59 = (g_free (_tmp59), NULL);
		}
		base_type = NULL;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			if (is_virtual) {
				ValaCCodeFormalParameter* _tmp64;
				char* _tmp63;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaObjectType* _tmp61;
					_tmp61 = NULL;
					base_type = (_tmp61 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_property (prop)))))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), _tmp61);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaObjectType* _tmp62;
						_tmp62 = NULL;
						base_type = (_tmp62 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_interface_property (prop)))))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), _tmp62);
					}
				}
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp64 = NULL;
				_tmp63 = NULL;
				vala_ccode_function_add_parameter (self->function, (_tmp64 = vala_ccode_formal_parameter_new ("base", (_tmp63 = vala_data_type_get_cname (((ValaDataType*) (base_type)))))));
				(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
				_tmp63 = (g_free (_tmp63), NULL);
			} else {
				vala_ccode_function_add_parameter (self->function, cselfparam);
			}
		}
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc) || returns_real_struct) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (!is_virtual) {
			if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (prop))) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc)) && vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp65;
				/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
				_tmp65 = NULL;
				vala_ccode_fragment_append (self->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp65 = vala_ccode_function_copy (self->function)))));
				(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
			} else {
				ValaCCodeFunction* _tmp66;
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp66 = NULL;
				vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp66 = vala_ccode_function_copy (self->function)))));
				(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
			}
		}
		vala_ccode_function_set_block (self->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_property_accessor_get_body (acc))))));
		if (is_virtual) {
			char* _tmp67;
			ValaCCodeDeclaration* _tmp68;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp71;
			ValaCCodeExpression* _tmp70;
			ValaCCodeIdentifier* _tmp69;
			_tmp67 = NULL;
			_tmp68 = NULL;
			cdecl_ = (_tmp68 = vala_ccode_declaration_new ((_tmp67 = vala_data_type_get_cname (((ValaDataType*) (this_type))))), (_tmp67 = (g_free (_tmp67), NULL)), _tmp68);
			_tmp71 = NULL;
			_tmp70 = NULL;
			_tmp69 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp71 = vala_ccode_variable_declarator_new_with_initializer ("self", (_tmp70 = vala_ccode_base_module_transform_expression (self, ((ValaCCodeExpression*) ((_tmp69 = vala_ccode_identifier_new ("base")))), ((ValaDataType*) (base_type)), ((ValaDataType*) (this_type)), NULL)))))));
			(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
			(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
			(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), ((ValaCCodeNode*) (cdecl_)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		}
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp73;
			ValaCCodeConstant* _tmp72;
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp73 = NULL;
			_tmp72 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp73 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp72 = vala_ccode_constant_new ("NULL")))))))));
			(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
			(_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), ((ValaCCodeNode*) (cdecl_)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		}
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE && !is_virtual) {
			if (returns_real_struct) {
				ValaCCodeStatement* _tmp74;
				_tmp74 = NULL;
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), ((ValaCCodeNode*) ((_tmp74 = vala_ccode_base_module_create_property_type_check_statement (self, prop, FALSE, t, TRUE, "self")))));
				(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
			} else {
				ValaCCodeStatement* _tmp75;
				_tmp75 = NULL;
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), ((ValaCCodeNode*) ((_tmp75 = vala_ccode_base_module_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self")))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
			}
		}
		/* notify on property changes*/
		_tmp76 = NULL;
		typesymbol = (_tmp76 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (prop)))), (_tmp76 == NULL ? NULL : vala_code_node_ref (_tmp76)));
		if (vala_typesymbol_is_subtype_of (typesymbol, self->gobject_type) && vala_property_get_notify (prop) && vala_symbol_get_access (((ValaSymbol*) (prop))) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE && vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE && !vala_data_type_is_real_struct_type (vala_property_get_property_type (prop)) && (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc))) {
			ValaCCodeIdentifier* _tmp77;
			ValaCCodeFunctionCall* _tmp78;
			ValaCCodeFunctionCall* notify_call;
			ValaCCodeCastExpression* _tmp80;
			ValaCCodeIdentifier* _tmp79;
			ValaCCodeConstant* _tmp81;
			ValaCCodeExpressionStatement* _tmp82;
			/* FIXME: use better means to detect gobject properties*/
			_tmp77 = NULL;
			_tmp78 = NULL;
			notify_call = (_tmp78 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp77 = vala_ccode_identifier_new ("g_object_notify"))))), (_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL))), _tmp78);
			_tmp80 = NULL;
			_tmp79 = NULL;
			vala_ccode_function_call_add_argument (notify_call, ((ValaCCodeExpression*) ((_tmp80 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) ((_tmp79 = vala_ccode_identifier_new ("self")))), "GObject *")))));
			(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
			(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
			_tmp81 = NULL;
			vala_ccode_function_call_add_argument (notify_call, ((ValaCCodeExpression*) ((_tmp81 = vala_property_get_canonical_cconstant (prop)))));
			(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
			_tmp82 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->function), ((ValaCCodeNode*) ((_tmp82 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (notify_call)))))));
			(_tmp82 == NULL ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)));
			(notify_call == NULL ? NULL : (notify_call = (vala_ccode_node_unref (notify_call), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (self->function)));
		cname = (g_free (cname), NULL);
		(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
		(typesymbol == NULL ? NULL : (typesymbol = (vala_code_node_unref (typesymbol), NULL)));
	}
	_tmp83 = NULL;
	self->current_property_accessor = (_tmp83 = NULL, (self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL))), _tmp83);
	_tmp84 = NULL;
	self->current_return_type = (_tmp84 = NULL, (self->current_return_type == NULL ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL))), _tmp84);
	(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (vala_code_node_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL)));
	(value_type == NULL ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)));
}


static void vala_ccode_base_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp0;
	ValaClass* cl;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (c != NULL);
	self->current_method_inner_error = FALSE;
	self->in_constructor = TRUE;
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS || vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC) {
		self->in_static_or_class_ctor = TRUE;
	}
	vala_code_node_accept_children (((ValaCodeNode*) (c)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	self->in_static_or_class_ctor = FALSE;
	self->in_constructor = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (c)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeFunction* _tmp3;
		char* _tmp2;
		char* _tmp1;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeFormalParameter* _tmp6;
		ValaCCodeFunction* _tmp7;
		ValaCCodeBlock* cblock;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp8;
		ValaCCodeDeclaration* _tmp11;
		char* _tmp10;
		char* _tmp9;
		ValaCCodeVariableDeclarator* _tmp12;
		ValaCCodeDeclaration* _tmp13;
		ValaCCodeVariableDeclarator* _tmp14;
		ValaCCodeIdentifier* _tmp15;
		ValaCCodeFunctionCall* _tmp16;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp18;
		char* _tmp17;
		ValaCCodeIdentifier* _tmp21;
		char* _tmp20;
		char* _tmp19;
		ValaCCodeFunctionCall* _tmp22;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpressionStatement* _tmp25;
		ValaCCodeAssignment* _tmp24;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeFunctionCall* _tmp27;
		ValaCCodeIdentifier* _tmp26;
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeFunctionCall* _tmp30;
		ValaCCodeIdentifier* _tmp29;
		ValaCCodeExpressionStatement* _tmp33;
		ValaCCodeAssignment* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeFunctionCall* _tmp36;
		ValaCCodeMemberAccess* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeExpressionStatement* _tmp42;
		ValaCCodeAssignment* _tmp41;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeFunctionCall* _tmp44;
		ValaCCodeIdentifier* _tmp43;
		ValaCCodeDeclaration* _tmp47;
		char* _tmp46;
		char* _tmp45;
		ValaCCodeVariableDeclarator* _tmp48;
		ValaCCodeReturnStatement* _tmp52;
		ValaCCodeIdentifier* _tmp51;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->function = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_constructor", (_tmp1 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (cl)), NULL)))), "GObject *"), (self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL))), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp1 = (g_free (_tmp1), NULL);
		vala_ccode_function_set_modifiers (self->function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp4 = vala_ccode_formal_parameter_new ("type", "GType")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp5 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp6 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		_tmp7 = NULL;
		vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp7 = vala_ccode_function_copy (self->function)))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		cblock = vala_ccode_block_new ();
		cdecl_ = vala_ccode_declaration_new ("GObject *");
		_tmp8 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp8 = vala_ccode_variable_declarator_new ("obj")))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdecl_)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%sClass *", (_tmp9 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp11);
		_tmp10 = (g_free (_tmp10), NULL);
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp12 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp12 = vala_ccode_variable_declarator_new ("klass")))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdecl_)));
		_tmp13 = NULL;
		cdecl_ = (_tmp13 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp13);
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp14 = vala_ccode_variable_declarator_new ("parent_class")))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdecl_)));
		_tmp15 = NULL;
		_tmp16 = NULL;
		ccall = (_tmp16 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("g_type_class_peek"))))), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), _tmp16);
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new ((_tmp17 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (cl)))))))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp22 = NULL;
		ccast = (_tmp22 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (cl)), NULL))))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
		vala_ccode_function_call_add_argument (ccast, ((ValaCCodeExpression*) (ccall)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp25 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp24 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new ("klass")))), ((ValaCCodeExpression*) (ccast)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		_tmp27 = NULL;
		_tmp26 = NULL;
		ccall = (_tmp27 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new ("g_type_class_peek_parent"))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp27);
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		_tmp28 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new ("klass")))));
		(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
		_tmp30 = NULL;
		_tmp29 = NULL;
		ccast = (_tmp30 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp29 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))))), (ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL))), _tmp30);
		(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
		vala_ccode_function_call_add_argument (ccast, ((ValaCCodeExpression*) (ccall)));
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp33 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp32 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new ("parent_class")))), ((ValaCCodeExpression*) (ccast)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
		(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
		(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		ccall = (_tmp36 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp35 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new ("parent_class")))), "constructor"))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp36);
		(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
		(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
		_tmp37 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_identifier_new ("type")))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp38 = vala_ccode_identifier_new ("n_construct_properties")))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ("construct_properties")))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
		_tmp42 = NULL;
		_tmp41 = NULL;
		_tmp40 = NULL;
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp42 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp41 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ("obj")))), ((ValaCCodeExpression*) (ccall)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
		(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
		(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
		_tmp44 = NULL;
		_tmp43 = NULL;
		ccall = (_tmp44 = ((ValaCCodeFunctionCall*) (vala_instance_cast_new (((ValaCCodeExpression*) ((_tmp43 = vala_ccode_identifier_new ("obj")))), ((ValaTypeSymbol*) (cl))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp44);
		(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
		_tmp47 = NULL;
		_tmp46 = NULL;
		_tmp45 = NULL;
		cdecl_ = (_tmp47 = vala_ccode_declaration_new ((_tmp46 = g_strdup_printf ("%s *", (_tmp45 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp47);
		_tmp46 = (g_free (_tmp46), NULL);
		_tmp45 = (g_free (_tmp45), NULL);
		_tmp48 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp48 = vala_ccode_variable_declarator_new_with_initializer ("self", ((ValaCCodeExpression*) (ccall)))))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdecl_)));
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp50;
			ValaCCodeConstant* _tmp49;
			/* always separate error parameter and inner_error local variable
			 * as error may be set to NULL but we're always interested in inner errors
			 */
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp50 = NULL;
			_tmp49 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp50 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp49 = vala_ccode_constant_new ("NULL")))))))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
			(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdecl_)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		}
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_constructor_get_body (c)))));
		_tmp52 = NULL;
		_tmp51 = NULL;
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp52 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp51 = vala_ccode_identifier_new ("obj")))))))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
		(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
		vala_ccode_function_set_block (self->function, cblock);
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (c)))) != NULL) {
			ValaCCodeComment* _tmp53;
			_tmp53 = NULL;
			vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) ((_tmp53 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (c)))))))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (self->function)));
		(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
		(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
	} else {
		if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
			char* _tmp55;
			char* _tmp54;
			ValaCCodeFunction* _tmp56;
			ValaCCodeFunction* base_init;
			ValaCCodeFormalParameter* _tmp59;
			char* _tmp58;
			char* _tmp57;
			ValaCCodeFunction* _tmp60;
			ValaCCodeBlock* _tmp61;
			ValaCCodeBlock* block;
			/* class constructor*/
			_tmp55 = NULL;
			_tmp54 = NULL;
			_tmp56 = NULL;
			base_init = (_tmp56 = vala_ccode_function_new ((_tmp55 = g_strdup_printf ("%s_base_init", (_tmp54 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (cl)), NULL)))), "void"), (_tmp55 = (g_free (_tmp55), NULL)), (_tmp54 = (g_free (_tmp54), NULL)), _tmp56);
			_tmp59 = NULL;
			_tmp58 = NULL;
			_tmp57 = NULL;
			vala_ccode_function_add_parameter (base_init, (_tmp59 = vala_ccode_formal_parameter_new ("klass", (_tmp58 = g_strdup_printf ("%sClass *", (_tmp57 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
			_tmp58 = (g_free (_tmp58), NULL);
			_tmp57 = (g_free (_tmp57), NULL);
			vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
			_tmp60 = NULL;
			vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp60 = vala_ccode_function_copy (base_init)))));
			(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
			_tmp61 = NULL;
			block = (_tmp61 = VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_constructor_get_body (c))))), (_tmp61 == NULL ? NULL : vala_ccode_node_ref (_tmp61)));
			if (self->current_method_inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp63;
				ValaCCodeConstant* _tmp62;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp63 = NULL;
				_tmp62 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp63 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp62 = vala_ccode_constant_new ("NULL")))))))));
				(_tmp63 == NULL ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)));
				(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
				vala_ccode_block_prepend_statement (block, ((ValaCCodeNode*) (cdecl_)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
			vala_ccode_function_set_block (base_init, block);
			vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (base_init)));
			(base_init == NULL ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL)));
			(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
		} else {
			if (vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC) {
				/* static class constructor
				 add to class_init*/
				if (self->current_method_inner_error) {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp65;
					ValaCCodeConstant* _tmp64;
					/* always separate error parameter and inner_error local variable
					 * as error may be set to NULL but we're always interested in inner errors
					 */
					cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp65 = NULL;
					_tmp64 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp65 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp64 = vala_ccode_constant_new ("NULL")))))))));
					(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
					(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
					vala_ccode_fragment_append (self->class_init_fragment, ((ValaCCodeNode*) (cdecl_)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				}
				vala_ccode_fragment_append (self->class_init_fragment, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_constructor_get_body (c)))));
			} else {
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (c))), "internal error: constructors must have instance, class, or static binding");
			}
		}
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cfrag;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (d != NULL);
	self->current_method_inner_error = FALSE;
	vala_code_node_accept_children (((ValaCodeNode*) (d)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	cfrag = vala_ccode_fragment_new ();
	if (self->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp1;
		ValaCCodeConstant* _tmp0;
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_constant_new ("NULL")))))))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
		vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) (cdecl_)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_destructor_get_body (d)))));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (d)), ((ValaCCodeNode*) (cfrag)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
}


static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	GeeList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp14;
	ValaSymbol* _tmp13;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (b != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_symbol = (_tmp1 = (_tmp0 = ((ValaSymbol*) (b)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->current_symbol == NULL ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL))), _tmp1);
	vala_code_node_accept_children (((ValaCodeNode*) (b)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeList* local_collection;
		int local_it;
		local_collection = local_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				vala_symbol_set_active (((ValaSymbol*) (local)), FALSE);
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
	}
	cblock = vala_ccode_block_new ();
	{
		GeeList* stmt_collection;
		int stmt_it;
		stmt_collection = vala_block_get_statements (b);
		for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
			ValaCodeNode* stmt;
			stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)))));
			{
				ValaSourceReference* _tmp2;
				ValaSourceReference* src;
				if (vala_code_node_get_error (stmt)) {
					(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
					continue;
				}
				_tmp2 = NULL;
				src = (_tmp2 = vala_code_node_get_source_reference (stmt), (_tmp2 == NULL ? NULL : vala_source_reference_ref (_tmp2)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* _tmp3;
					_tmp3 = NULL;
					vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp3 = vala_ccode_comment_new (vala_source_reference_get_comment (src))))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
					{
						GeeList* cstmt_collection;
						int cstmt_it;
						cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
						for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
							ValaCCodeNode* cstmt;
							cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
							{
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
							}
						}
						(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
				}
				(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
				(src == NULL ? NULL : (src = (vala_source_reference_unref (src), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
	}
	{
		GeeList* local_collection;
		int local_it;
		local_collection = local_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				if (vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp7;
					ValaCCodeExpression* _tmp6;
					ValaCCodeIdentifier* _tmp5;
					char* _tmp4;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
					_tmp7 = NULL;
					_tmp6 = NULL;
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp7 = vala_ccode_expression_statement_new ((_tmp6 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))))))));
					(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
					(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
					(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
					_tmp4 = (g_free (_tmp4), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
	}
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (((ValaSymbol*) (b))))) {
		ValaMethod* _tmp8;
		ValaMethod* m;
		_tmp8 = NULL;
		m = (_tmp8 = VALA_METHOD (vala_symbol_get_parent_symbol (((ValaSymbol*) (b)))), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (m);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* _tmp12;
						ValaCCodeExpression* _tmp11;
						ValaCCodeIdentifier* _tmp10;
						char* _tmp9;
						ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (param))), NULL);
						vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (param)));
						_tmp12 = NULL;
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_expression_statement_new ((_tmp11 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (param))))))))), vala_formal_parameter_get_parameter_type (param), ((ValaExpression*) (ma)))))))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
						(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
						(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
						_tmp9 = (g_free (_tmp9), NULL);
						(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
		}
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	}
	vala_code_node_set_ccodenode (((ValaCodeNode*) (b)), ((ValaCCodeNode*) (cblock)));
	_tmp14 = NULL;
	_tmp13 = NULL;
	self->current_symbol = (_tmp14 = (_tmp13 = vala_symbol_get_parent_symbol (self->current_symbol), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (self->current_symbol == NULL ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL))), _tmp14);
	(local_vars == NULL ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
}


static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_empty_statement_new ()))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_declaration_statement_get_declaration (stmt)))));
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (stmt), (VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (local != NULL && vala_local_variable_get_initializer (local) != NULL) {
		vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_local_variable_get_initializer (local)->temp_vars)));
	}
	vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (self->temp_vars)));
	gee_collection_clear (((GeeCollection*) (self->temp_vars)));
	(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
}


char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_collection_contains (((GeeCollection*) (self->c_keywords)), name)) {
		return g_strconcat (name, "_", NULL);
	} else {
		const char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = name, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	}
}


static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* rhs;
	char* _tmp39;
	ValaCCodeVariableDeclarator* _tmp40;
	ValaCCodeVariableDeclarator* cvar;
	ValaCCodeFragment* cfrag;
	char* _tmp41;
	ValaCCodeDeclaration* _tmp42;
	ValaCCodeDeclaration* cdecl_;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (local != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (local)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
		ValaArrayType* _tmp0;
		ValaArrayType* array_type;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp2;
				ValaDataType* _tmp1;
				ValaLocalVariable* _tmp3;
				ValaLocalVariable* len_var;
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp3 = NULL;
				len_var = (_tmp3 = vala_local_variable_new ((_tmp1 = vala_data_type_copy (self->int_type)), (_tmp2 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (local))), dim)), NULL, NULL), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL))), _tmp3);
				gee_list_insert (((GeeList*) (self->temp_vars)), 0, len_var);
				(len_var == NULL ? NULL : (len_var = (vala_code_node_unref (len_var), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaDelegateType* _tmp4;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp5;
			ValaDelegate* d;
			_tmp4 = NULL;
			deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
			_tmp5 = NULL;
			d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp8;
				ValaPointerType* _tmp7;
				ValaVoidType* _tmp6;
				ValaLocalVariable* _tmp9;
				ValaLocalVariable* target_var;
				/* create variable to store delegate target*/
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp9 = NULL;
				target_var = (_tmp9 = vala_local_variable_new (((ValaDataType*) ((_tmp7 = vala_pointer_type_new (((ValaDataType*) ((_tmp6 = vala_void_type_new ()))), NULL)))), (_tmp8 = vala_ccode_base_module_get_delegate_target_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))), NULL, NULL), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL))), _tmp9);
				gee_list_insert (((GeeList*) (self->temp_vars)), 0, target_var);
				(target_var == NULL ? NULL : (target_var = (vala_code_node_unref (target_var), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	rhs = NULL;
	if (vala_local_variable_get_initializer (local) != NULL && vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_local_variable_get_initializer (local)))) != NULL) {
		ValaCCodeExpression* _tmp11;
		ValaCCodeExpression* _tmp10;
		_tmp11 = NULL;
		_tmp10 = NULL;
		rhs = (_tmp11 = (_tmp10 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_local_variable_get_initializer (local))))), (_tmp10 == NULL ? NULL : vala_ccode_node_ref (_tmp10))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp11);
		if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaArrayType* _tmp12;
			ValaArrayType* array_type;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_var;
			ValaCCodeAssignment* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeIdentifier* _tmp18;
			ValaCCodeExpression* _tmp20;
			ValaCCodeExpression* _tmp19;
			_tmp12 = NULL;
			array_type = (_tmp12 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
			ccomma = vala_ccode_comma_expression_new ();
			temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, ((ValaCodeNode*) (local)));
			gee_list_insert (((GeeList*) (self->temp_vars)), 0, temp_var);
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
			(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp15;
					ValaCCodeIdentifier* _tmp16;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp17;
					_tmp15 = NULL;
					_tmp16 = NULL;
					lhs_array_len = (_tmp16 = vala_ccode_identifier_new ((_tmp15 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (local))), dim))), (_tmp15 = (g_free (_tmp15), NULL)), _tmp16);
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_local_variable_get_initializer (local), dim);
					_tmp17 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_assignment_new (((ValaCCodeExpression*) (lhs_array_len)), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL)));
				}
			}
			_tmp18 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
			_tmp20 = NULL;
			_tmp19 = NULL;
			rhs = (_tmp20 = (_tmp19 = ((ValaCCodeExpression*) (ccomma)), (_tmp19 == NULL ? NULL : vala_ccode_node_ref (_tmp19))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp20);
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaDelegateType* _tmp21;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp22;
				ValaDelegate* d;
				_tmp21 = NULL;
				deleg_type = (_tmp21 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21)));
				_tmp22 = NULL;
				d = (_tmp22 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22)));
				if (vala_delegate_get_has_target (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp24;
					ValaCCodeIdentifier* _tmp23;
					char* _tmp25;
					ValaCCodeIdentifier* _tmp26;
					ValaCCodeIdentifier* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp27;
					ValaCCodeIdentifier* _tmp28;
					ValaCCodeExpression* _tmp30;
					ValaCCodeExpression* _tmp29;
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, ((ValaCodeNode*) (local)));
					gee_list_insert (((GeeList*) (self->temp_vars)), 0, temp_var);
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
					(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
					_tmp25 = NULL;
					_tmp26 = NULL;
					lhs_delegate_target = (_tmp26 = vala_ccode_identifier_new ((_tmp25 = vala_ccode_base_module_get_delegate_target_cname (self, vala_symbol_get_name (((ValaSymbol*) (local)))))), (_tmp25 = (g_free (_tmp25), NULL)), _tmp26);
					rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_local_variable_get_initializer (local));
					_tmp27 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp27 = vala_ccode_assignment_new (((ValaCCodeExpression*) (lhs_delegate_target)), rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
					_tmp28 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))));
					(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
					_tmp30 = NULL;
					_tmp29 = NULL;
					rhs = (_tmp30 = (_tmp29 = ((ValaCCodeExpression*) (ccomma)), (_tmp29 == NULL ? NULL : vala_ccode_node_ref (_tmp29))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp30);
					(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
					(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL)));
					(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
			}
		}
	} else {
		if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
			ValaCCodeExpression* _tmp31;
			_tmp31 = NULL;
			rhs = (_tmp31 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp31);
			if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaArrayType* _tmp32;
				ValaArrayType* array_type;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp38;
				ValaCCodeExpression* _tmp37;
				/* initialize array length variables*/
				_tmp32 = NULL;
				array_type = (_tmp32 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32)));
				ccomma = vala_ccode_comma_expression_new ();
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeAssignment* _tmp36;
						ValaCCodeConstant* _tmp35;
						ValaCCodeIdentifier* _tmp34;
						char* _tmp33;
						_tmp36 = NULL;
						_tmp35 = NULL;
						_tmp34 = NULL;
						_tmp33 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp36 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new ((_tmp33 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (local))), dim)))))), ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_constant_new ("0")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
						(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
						(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
						_tmp33 = (g_free (_tmp33), NULL);
					}
				}
				vala_ccode_comma_expression_append_expression (ccomma, rhs);
				_tmp38 = NULL;
				_tmp37 = NULL;
				rhs = (_tmp38 = (_tmp37 = ((ValaCCodeExpression*) (ccomma)), (_tmp37 == NULL ? NULL : vala_ccode_node_ref (_tmp37))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp38);
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			}
		}
	}
	_tmp39 = NULL;
	_tmp40 = NULL;
	cvar = (_tmp40 = vala_ccode_variable_declarator_new_with_initializer ((_tmp39 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))), rhs), (_tmp39 = (g_free (_tmp39), NULL)), _tmp40);
	cfrag = vala_ccode_fragment_new ();
	_tmp41 = NULL;
	_tmp42 = NULL;
	cdecl_ = (_tmp42 = vala_ccode_declaration_new ((_tmp41 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)))), (_tmp41 = (g_free (_tmp41), NULL)), _tmp42);
	vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (cvar)));
	vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) (cdecl_)));
	if (vala_local_variable_get_initializer (local) != NULL && vala_code_node_get_tree_can_fail (((ValaCodeNode*) (vala_local_variable_get_initializer (local))))) {
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaCodeNode*) (vala_local_variable_get_initializer (local))), cfrag);
	}
	/* try to initialize uninitialized variables */
	if (vala_ccode_variable_declarator_get_initializer (cvar) == NULL) {
		ValaCCodeExpression* _tmp43;
		_tmp43 = NULL;
		vala_ccode_variable_declarator_set_initializer (cvar, (_tmp43 = vala_ccode_base_module_default_value_for_type (self, vala_local_variable_get_variable_type (local), TRUE)));
		(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	}
	vala_code_node_set_ccodenode (((ValaCodeNode*) (local)), ((ValaCCodeNode*) (cfrag)));
	vala_symbol_set_active (((ValaSymbol*) (local)), TRUE);
	(rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)));
	(cvar == NULL ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
}


static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (list != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (list)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type (((ValaExpression*) (list)))))) {
		ValaStruct* _tmp0;
		ValaStruct* st;
		ValaCCodeInitializerList* clist;
		GeeList* _tmp1;
		GeeIterator* _tmp2;
		GeeIterator* field_it;
		/* initializer is used as struct initializer */
		_tmp0 = NULL;
		st = (_tmp0 = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type (((ValaExpression*) (list))))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		clist = vala_ccode_initializer_list_new ();
		_tmp1 = NULL;
		_tmp2 = NULL;
		field_it = (_tmp2 = gee_iterable_iterator (((GeeIterable*) ((_tmp1 = vala_struct_get_fields (st))))), (_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL))), _tmp2);
		{
			GeeList* expr_collection;
			int expr_it;
			expr_collection = vala_initializer_list_get_initializers (list);
			for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
				ValaExpression* expr;
				expr = ((ValaExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
				{
					ValaField* field;
					ValaCCodeExpression* _tmp5;
					ValaCCodeExpression* cexpr;
					char* ctype;
					field = NULL;
					while (field == NULL) {
						ValaField* _tmp3;
						gee_iterator_next (field_it);
						_tmp3 = NULL;
						field = (_tmp3 = ((ValaField*) (gee_iterator_get (field_it))), (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp3);
						if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
							ValaField* _tmp4;
							/* we only initialize instance fields*/
							_tmp4 = NULL;
							field = (_tmp4 = NULL, (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp4);
						}
					}
					_tmp5 = NULL;
					cexpr = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))), (_tmp5 == NULL ? NULL : vala_ccode_node_ref (_tmp5)));
					ctype = vala_field_get_ctype (field);
					if (ctype != NULL) {
						ValaCCodeExpression* _tmp6;
						_tmp6 = NULL;
						cexpr = (_tmp6 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (cexpr, ctype))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp6);
					}
					vala_ccode_initializer_list_append (clist, cexpr);
					(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
					(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
					(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
					ctype = (g_free (ctype), NULL);
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (gee_collection_object_unref (expr_collection), NULL)));
		}
		vala_code_node_set_ccodenode (((ValaCodeNode*) (list)), ((ValaCCodeNode*) (clist)));
		(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		(clist == NULL ? NULL : (clist = (vala_ccode_node_unref (clist), NULL)));
		(field_it == NULL ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL)));
	} else {
		ValaCCodeInitializerList* clist;
		clist = vala_ccode_initializer_list_new ();
		{
			GeeList* expr_collection;
			int expr_it;
			expr_collection = vala_initializer_list_get_initializers (list);
			for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
				ValaExpression* expr;
				expr = ((ValaExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))));
					(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (gee_collection_object_unref (expr_collection), NULL)));
		}
		vala_code_node_set_ccodenode (((ValaCodeNode*) (list)), ((ValaCCodeNode*) (clist)));
		(clist == NULL ? NULL : (clist = (vala_ccode_node_unref (clist), NULL)));
	}
}


ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference) {
	ValaDataType* var_type;
	char* _tmp0;
	ValaLocalVariable* _tmp1;
	ValaLocalVariable* local;
	ValaLocalVariable* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	var_type = vala_data_type_copy (type);
	vala_data_type_set_value_owned (var_type, value_owned);
	_tmp0 = NULL;
	_tmp1 = NULL;
	local = (_tmp1 = vala_local_variable_new (var_type, (_tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id)), NULL, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference (((ValaCodeNode*) (local)), vala_code_node_get_source_reference (node_reference));
	}
	self->next_temp_var_id++;
	_tmp2 = NULL;
	return (_tmp2 = local, (var_type == NULL ? NULL : (var_type = (vala_code_node_unref (var_type), NULL))), _tmp2);
}


static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* _tmp0;
		ValaCCodeExpression* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (type)))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL) {
			char* _tmp3;
			char* _tmp4;
			char* var_name;
			ValaCCodeMemberAccess* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeExpression* _tmp7;
			ValaCCodeExpression* _tmp8;
			_tmp3 = NULL;
			_tmp4 = NULL;
			var_name = (_tmp4 = g_strdup_printf ("%s_type", (_tmp3 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type)))), -1))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			_tmp8 = NULL;
			return (_tmp8 = (_tmp7 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("self")))), "priv")))), var_name))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), _tmp7), (var_name = (g_free (var_name), NULL)), _tmp8);
		} else {
			return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("G_TYPE_NONE")));
		}
	}
}


ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference) {
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (type), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (VALA_IS_ERROR_TYPE (type)) {
		ValaCCodeExpression* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("g_error_copy"))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp2);
	} else {
		if (vala_data_type_get_data_type (type) != NULL) {
			char* dup_function;
			ValaCCodeExpression* _tmp12;
			dup_function = NULL;
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
				char* _tmp3;
				_tmp3 = NULL;
				dup_function = (_tmp3 = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp3);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type)) && dup_function == NULL) {
					char* _tmp5;
					char* _tmp4;
					ValaCCodeExpression* _tmp6;
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_report_error (source_reference, (_tmp5 = g_strdup_printf ("missing class prerequisite for interface `%s'", (_tmp4 = vala_symbol_get_full_name (((ValaSymbol*) (vala_data_type_get_data_type (type))))))));
					_tmp5 = (g_free (_tmp5), NULL);
					_tmp4 = (g_free (_tmp4), NULL);
					_tmp6 = NULL;
					return (_tmp6 = NULL, (dup_function = (g_free (dup_function), NULL)), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp6);
				}
			} else {
				if (cl != NULL && vala_class_get_is_immutable (cl)) {
					char* _tmp7;
					/* allow duplicates of immutable instances as for example strings*/
					_tmp7 = NULL;
					dup_function = (_tmp7 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp7);
				} else {
					if (VALA_IS_VALUE_TYPE (type)) {
						if (vala_data_type_get_nullable (type)) {
							char* _tmp8;
							_tmp8 = NULL;
							dup_function = (_tmp8 = vala_ccode_base_module_generate_struct_dup_wrapper (self, VALA_VALUE_TYPE (type)), (dup_function = (g_free (dup_function), NULL)), _tmp8);
						} else {
							char* _tmp9;
							_tmp9 = NULL;
							dup_function = (_tmp9 = g_strdup (""), (dup_function = (g_free (dup_function), NULL)), _tmp9);
						}
					} else {
						char* _tmp10;
						ValaCCodeExpression* _tmp11;
						/* duplicating non-reference counted objects may cause side-effects (and performance issues)*/
						_tmp10 = NULL;
						vala_report_error (source_reference, (_tmp10 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_data_type (type)))))));
						_tmp10 = (g_free (_tmp10), NULL);
						_tmp11 = NULL;
						return (_tmp11 = NULL, (dup_function = (g_free (dup_function), NULL)), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp11);
					}
				}
			}
			_tmp12 = NULL;
			return (_tmp12 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (dup_function))), (dup_function = (g_free (dup_function), NULL)), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp12);
		} else {
			if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
				char* _tmp13;
				char* _tmp14;
				char* func_name;
				ValaCCodeMemberAccess* _tmp16;
				ValaCCodeIdentifier* _tmp15;
				ValaCCodeExpression* _tmp17;
				ValaCCodeExpression* _tmp18;
				_tmp13 = NULL;
				_tmp14 = NULL;
				func_name = (_tmp14 = g_strdup_printf ("%s_dup_func", (_tmp13 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type)))), -1))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp17 = NULL;
				_tmp18 = NULL;
				return (_tmp18 = (_tmp17 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("self")))), "priv")))), func_name))), (_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL))), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), _tmp17), (func_name = (g_free (func_name), NULL)), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp18);
			} else {
				if (VALA_IS_ARRAY_TYPE (type)) {
					char* _tmp19;
					ValaCCodeExpression* _tmp20;
					ValaCCodeExpression* _tmp21;
					_tmp19 = NULL;
					_tmp20 = NULL;
					_tmp21 = NULL;
					return (_tmp21 = (_tmp20 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp19 = vala_ccode_base_module_generate_array_dup_wrapper (self, VALA_ARRAY_TYPE (type)))))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp21);
				} else {
					if (VALA_IS_POINTER_TYPE (type)) {
						ValaPointerType* _tmp22;
						ValaPointerType* pointer_type;
						ValaCCodeExpression* _tmp23;
						_tmp22 = NULL;
						pointer_type = (_tmp22 = VALA_POINTER_TYPE (type), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22)));
						_tmp23 = NULL;
						return (_tmp23 = vala_ccode_base_module_get_dup_func_expression (self, vala_pointer_type_get_base_type (pointer_type), source_reference), (pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp23);
					} else {
						ValaCCodeExpression* _tmp24;
						_tmp24 = NULL;
						return (_tmp24 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp24);
					}
				}
			}
		}
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static char* vala_ccode_base_module_generate_array_dup_wrapper (ValaCCodeBaseModule* self, ValaArrayType* array_type) {
	char* dup_func;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp47;
	char* _tmp48;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_dup%d", (self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1));
	if (!vala_ccode_base_module_add_wrapper (self, dup_func)) {
		/* wrapper already defined*/
		return dup_func;
	}
	/* declaration*/
	_tmp1 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (dup_func, (_tmp1 = vala_data_type_get_cname (((ValaDataType*) (array_type))))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("self", (_tmp3 = vala_data_type_get_cname (((ValaDataType*) (array_type)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	/* total length over all dimensions*/
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp5 = vala_ccode_formal_parameter_new ("length", "int")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_ccode_base_module_requires_copy (self, vala_array_type_get_element_type (array_type))) {
		GeeArrayList* _tmp6;
		GeeArrayList* old_temp_vars;
		char* _tmp7;
		ValaCCodeDeclaration* _tmp8;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* cvardecl;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeFunctionCall* _tmp10;
		ValaCCodeFunctionCall* gnew;
		ValaCCodeIdentifier* _tmp12;
		char* _tmp11;
		ValaCCodeIdentifier* _tmp13;
		ValaCCodeDeclaration* idx_decl;
		ValaCCodeVariableDeclarator* _tmp14;
		ValaCCodeBlock* loop_body;
		ValaCCodeExpressionStatement* _tmp23;
		ValaCCodeAssignment* _tmp22;
		ValaCCodeExpression* _tmp21;
		ValaCCodeElementAccess* _tmp20;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeIdentifier* _tmp18;
		ValaCCodeElementAccess* _tmp17;
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeIdentifier* _tmp15;
		ValaCCodeBinaryExpression* _tmp26;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeForStatement* _tmp27;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp30;
		ValaCCodeConstant* _tmp29;
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeUnaryExpression* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeReturnStatement* _tmp34;
		ValaCCodeIdentifier* _tmp33;
		ValaCCodeFragment* cfrag;
		GeeArrayList* _tmp36;
		GeeArrayList* _tmp35;
		_tmp6 = NULL;
		old_temp_vars = (_tmp6 = self->temp_vars, (_tmp6 == NULL ? NULL : gee_collection_object_ref (_tmp6)));
		_tmp7 = NULL;
		_tmp8 = NULL;
		cdecl_ = (_tmp8 = vala_ccode_declaration_new ((_tmp7 = vala_data_type_get_cname (((ValaDataType*) (array_type))))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
		cvardecl = vala_ccode_variable_declarator_new ("result");
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (cvardecl)));
		_tmp9 = NULL;
		_tmp10 = NULL;
		gnew = (_tmp10 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("g_new0"))))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_function_call_add_argument (gnew, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		_tmp11 = (g_free (_tmp11), NULL);
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (gnew, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("length")))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
		vala_ccode_variable_declarator_set_initializer (cvardecl, ((ValaCCodeExpression*) (gnew)));
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cdecl_)));
		idx_decl = vala_ccode_declaration_new ("int");
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (idx_decl, ((ValaCCodeDeclarator*) ((_tmp14 = vala_ccode_variable_declarator_new ("i")))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (idx_decl)));
		loop_body = vala_ccode_block_new ();
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_block_add_statement (loop_body, ((ValaCCodeNode*) ((_tmp23 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp22 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_element_access_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("result")))), ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("i")))))))), (_tmp21 = vala_ccode_base_module_get_ref_cexpression (self, vala_array_type_get_element_type (array_type), ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_element_access_new (((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new ("self")))), ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ("i")))))))), NULL, ((ValaCodeNode*) (array_type)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
		(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
		(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
		(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp27 = NULL;
		cfor = (_tmp27 = vala_ccode_for_statement_new (((ValaCCodeExpression*) ((_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_identifier_new ("length")))))))), ((ValaCCodeStatement*) (loop_body))), (_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL))), (_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL))), (_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL))), _tmp27);
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp30 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new ("i")))), ((ValaCCodeExpression*) ((_tmp29 = vala_ccode_constant_new ("0")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
		(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
		(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, ((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new ("i")))))))));
		(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
		(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cfor)));
		_tmp34 = NULL;
		_tmp33 = NULL;
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp34 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp33 = vala_ccode_identifier_new ("result")))))))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
		(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) (cfrag)));
		_tmp36 = NULL;
		_tmp35 = NULL;
		self->temp_vars = (_tmp36 = (_tmp35 = old_temp_vars, (_tmp35 == NULL ? NULL : gee_collection_object_ref (_tmp35))), (self->temp_vars == NULL ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL))), _tmp36);
		(old_temp_vars == NULL ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
		(cvardecl == NULL ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL)));
		(gnew == NULL ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL)));
		(idx_decl == NULL ? NULL : (idx_decl = (vala_ccode_node_unref (idx_decl), NULL)));
		(loop_body == NULL ? NULL : (loop_body = (vala_ccode_node_unref (loop_body), NULL)));
		(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
		(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeFunctionCall* _tmp41;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeIdentifier* _tmp43;
		char* _tmp42;
		ValaCCodeBinaryExpression* _tmp45;
		ValaCCodeIdentifier* _tmp44;
		ValaCCodeReturnStatement* _tmp46;
		_tmp37 = NULL;
		_tmp38 = NULL;
		dup_call = (_tmp38 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp37 = vala_ccode_identifier_new ("g_memdup"))))), (_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL))), _tmp38);
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (dup_call, ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ("self")))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
		_tmp40 = NULL;
		_tmp41 = NULL;
		sizeof_call = (_tmp41 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ("sizeof"))))), (_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL))), _tmp41);
		_tmp43 = NULL;
		_tmp42 = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))))));
		(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
		_tmp42 = (g_free (_tmp42), NULL);
		_tmp45 = NULL;
		_tmp44 = NULL;
		vala_ccode_function_call_add_argument (dup_call, ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) ((_tmp44 = vala_ccode_identifier_new ("length")))), ((ValaCCodeExpression*) (sizeof_call)))))));
		(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
		(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
		_tmp46 = NULL;
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp46 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (dup_call)))))));
		(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
		(dup_call == NULL ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL)));
		(sizeof_call == NULL ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL)));
	}
	/* append to file*/
	_tmp47 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp47 = vala_ccode_function_copy (function)))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (function)));
	_tmp48 = NULL;
	return (_tmp48 = dup_func, (function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), _tmp48);
}


static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type) {
	char* _tmp0;
	char* _tmp1;
	char* dup_func;
	char* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* dup_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* sizeof_call;
	ValaCCodeIdentifier* _tmp13;
	char* _tmp12;
	ValaCCodeReturnStatement* _tmp14;
	ValaCCodeFunction* _tmp15;
	char* _tmp16;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	dup_func = (_tmp1 = g_strdup_printf ("_%sdup", (_tmp0 = vala_symbol_get_lower_case_cprefix (((ValaSymbol*) (vala_value_type_get_type_symbol (value_type)))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, dup_func)) {
		/* wrapper already defined*/
		return dup_func;
	}
	/* declaration*/
	_tmp3 = NULL;
	_tmp4 = NULL;
	function = (_tmp4 = vala_ccode_function_new (dup_func, (_tmp3 = vala_data_type_get_cname (((ValaDataType*) (value_type))))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp6 = vala_ccode_formal_parameter_new ("self", (_tmp5 = vala_data_type_get_cname (((ValaDataType*) (value_type)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp5 = (g_free (_tmp5), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	dup_call = (_tmp8 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("g_memdup"))))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (dup_call, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("self")))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	_tmp11 = NULL;
	sizeof_call = (_tmp11 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ("sizeof"))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (sizeof_call, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_typesymbol_get_cname (vala_value_type_get_type_symbol (value_type), FALSE)))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	_tmp12 = (g_free (_tmp12), NULL);
	vala_ccode_function_call_add_argument (dup_call, ((ValaCCodeExpression*) (sizeof_call)));
	_tmp14 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp14 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (dup_call)))))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	/* append to file*/
	_tmp15 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp15 = vala_ccode_function_copy (function)))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (function)));
	_tmp16 = NULL;
	return (_tmp16 = dup_func, (function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), (dup_call == NULL ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL))), (sizeof_call == NULL ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL))), _tmp16);
}


ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->glist_type) || vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gslist_type)) {
		gboolean elements_require_free;
		ValaCCodeExpression* element_destroy_func_expression;
		/* create wrapper function to free list elements if necessary*/
		elements_require_free = FALSE;
		element_destroy_func_expression = NULL;
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = vala_data_type_get_type_arguments (type);
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					elements_require_free = vala_ccode_base_module_requires_destroy (self, type_arg);
					if (elements_require_free) {
						ValaCCodeExpression* _tmp0;
						_tmp0 = NULL;
						element_destroy_func_expression = (_tmp0 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL))), _tmp0);
					}
					(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL)));
		}
		if (elements_require_free && VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression)) {
			char* _tmp1;
			ValaCCodeExpression* _tmp2;
			ValaCCodeExpression* _tmp3;
			_tmp1 = NULL;
			_tmp2 = NULL;
			_tmp3 = NULL;
			return (_tmp3 = (_tmp2 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp1 = vala_ccode_base_module_generate_glist_free_wrapper (self, type, VALA_CCODE_IDENTIFIER (element_destroy_func_expression)))))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL))), _tmp3);
		} else {
			char* _tmp4;
			ValaCCodeExpression* _tmp5;
			ValaCCodeExpression* _tmp6;
			_tmp4 = NULL;
			_tmp5 = NULL;
			_tmp6 = NULL;
			return (_tmp6 = (_tmp5 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)))))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL))), _tmp6);
		}
		(element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (type)) {
			return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("g_error_free")));
		} else {
			if (vala_data_type_get_data_type (type) != NULL) {
				char* unref_function;
				ValaCCodeExpression* _tmp18;
				unref_function = NULL;
				if (VALA_IS_REFERENCE_TYPE (type)) {
					if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
						char* _tmp8;
						_tmp8 = NULL;
						unref_function = (_tmp8 = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp8);
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type)) && unref_function == NULL) {
							char* _tmp10;
							char* _tmp9;
							ValaCCodeExpression* _tmp11;
							_tmp10 = NULL;
							_tmp9 = NULL;
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (type))), (_tmp10 = g_strdup_printf ("missing class prerequisite for interface `%s'", (_tmp9 = vala_symbol_get_full_name (((ValaSymbol*) (vala_data_type_get_data_type (type))))))));
							_tmp10 = (g_free (_tmp10), NULL);
							_tmp9 = (g_free (_tmp9), NULL);
							_tmp11 = NULL;
							return (_tmp11 = NULL, (unref_function = (g_free (unref_function), NULL)), _tmp11);
						}
					} else {
						char* _tmp12;
						_tmp12 = NULL;
						unref_function = (_tmp12 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp12);
					}
				} else {
					if (vala_data_type_get_nullable (type)) {
						char* _tmp13;
						_tmp13 = NULL;
						unref_function = (_tmp13 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp13);
						if (unref_function == NULL) {
							char* _tmp14;
							_tmp14 = NULL;
							unref_function = (_tmp14 = g_strdup ("g_free"), (unref_function = (g_free (unref_function), NULL)), _tmp14);
						}
					} else {
						ValaStruct* _tmp15;
						ValaStruct* st;
						char* _tmp16;
						_tmp15 = NULL;
						st = (_tmp15 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
						_tmp16 = NULL;
						unref_function = (_tmp16 = vala_typesymbol_get_destroy_function (((ValaTypeSymbol*) (st))), (unref_function = (g_free (unref_function), NULL)), _tmp16);
						(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					}
				}
				if (unref_function == NULL) {
					ValaCCodeExpression* _tmp17;
					_tmp17 = NULL;
					return (_tmp17 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (unref_function = (g_free (unref_function), NULL)), _tmp17);
				}
				_tmp18 = NULL;
				return (_tmp18 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (unref_function))), (unref_function = (g_free (unref_function), NULL)), _tmp18);
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
					char* _tmp19;
					char* _tmp20;
					char* func_name;
					ValaCCodeMemberAccess* _tmp22;
					ValaCCodeIdentifier* _tmp21;
					ValaCCodeExpression* _tmp23;
					ValaCCodeExpression* _tmp24;
					_tmp19 = NULL;
					_tmp20 = NULL;
					func_name = (_tmp20 = g_strdup_printf ("%s_destroy_func", (_tmp19 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type)))), -1))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20);
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp23 = NULL;
					_tmp24 = NULL;
					return (_tmp24 = (_tmp23 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp22 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ("self")))), "priv")))), func_name))), (_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), _tmp23), (func_name = (g_free (func_name), NULL)), _tmp24);
				} else {
					if (VALA_IS_ARRAY_TYPE (type)) {
						return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("g_free")));
					} else {
						if (VALA_IS_POINTER_TYPE (type)) {
							return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("g_free")));
						} else {
							return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
						}
					}
				}
			}
		}
	}
}


static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression) {
	char* _tmp0;
	char* _tmp1;
	char* destroy_func;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* element_free_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeCastExpression* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeIdentifier* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeFunction* _tmp18;
	char* _tmp19;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_type != NULL, NULL);
	g_return_val_if_fail (element_destroy_func_expression != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	destroy_func = (_tmp1 = g_strdup_printf ("_%s_%s", (_tmp0 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))), vala_ccode_identifier_get_name (element_destroy_func_expression)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		return destroy_func;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("self", (_tmp3 = vala_data_type_get_cname (list_type)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	element_free_call = NULL;
	if (vala_data_type_get_data_type (list_type) == VALA_TYPESYMBOL (self->glist_type)) {
		ValaCCodeFunctionCall* _tmp6;
		ValaCCodeIdentifier* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		element_free_call = (_tmp6 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ("g_list_foreach"))))), (element_free_call == NULL ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL))), _tmp6);
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	} else {
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		element_free_call = (_tmp8 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("g_slist_foreach"))))), (element_free_call == NULL ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL))), _tmp8);
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	}
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("self")))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (element_destroy_func_expression)), "GFunc")))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_constant_new ("NULL")))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (element_free_call)))))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp15 = NULL;
	cfreecall = (_tmp15 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type)))))))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (cfreecall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("self")))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cfreecall)))))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	/* append to file*/
	_tmp18 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp18 = vala_ccode_function_copy (function)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (function)));
	_tmp19 = NULL;
	return (_tmp19 = destroy_func, (function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL))), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), (element_free_call == NULL ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL))), _tmp19);
}


ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	ValaCCodeBinaryExpression* _tmp5;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* _tmp19;
	ValaCCodeAssignment* cassign;
	char* _tmp20;
	gboolean _tmp21;
	gboolean uses_gfree;
	ValaCCodeParenthesizedExpression* _tmp24;
	ValaCCodeConstant* _tmp23;
	ValaCCodeExpression* _tmp25;
	ValaCCodeExpression* _tmp26;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccall = (_tmp1 = vala_ccode_function_call_new ((_tmp0 = vala_ccode_base_module_get_destroy_func_expression (self, type))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	if (VALA_IS_VALUE_TYPE (type) && !vala_data_type_get_nullable (type)) {
		ValaCCodeUnaryExpression* _tmp2;
		/* normal value type, no null check*/
		_tmp2 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
		return ((ValaCCodeExpression*) (ccall));
	}
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	_tmp4 = NULL;
	_tmp5 = NULL;
	cisnull = (_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ("NULL"))))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp5);
	if (vala_data_type_get_type_parameter (type) != NULL) {
		ValaCCodeConstant* _tmp8;
		ValaCCodeExpression* _tmp7;
		ValaCCodeBinaryExpression* _tmp9;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp10;
		if (!(VALA_IS_CLASS (self->current_type_symbol)) || vala_class_get_is_compact (self->current_class)) {
			ValaCCodeExpression* _tmp6;
			_tmp6 = NULL;
			return (_tmp6 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), _tmp6);
		}
		/* unref functions are optional for type parameters*/
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp9 = NULL;
		cunrefisnull = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp7 = vala_ccode_base_module_get_destroy_func_expression (self, type)), ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_constant_new ("NULL"))))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp9);
		_tmp10 = NULL;
		cisnull = (_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, ((ValaCCodeExpression*) (cisnull)), ((ValaCCodeExpression*) (cunrefisnull))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), _tmp10);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (vala_ccode_node_unref (cunrefisnull), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	if (vala_data_type_get_data_type (type) == self->gstringbuilder_type) {
		ValaCCodeConstant* _tmp11;
		_tmp11 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_constant_new ("TRUE")))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaArrayType* _tmp12;
			ValaArrayType* array_type;
			_tmp12 = NULL;
			array_type = (_tmp12 = VALA_ARRAY_TYPE (type), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == NULL || vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)))) {
				gboolean first;
				ValaCCodeExpression* csizeexpr;
				ValaCCodeIdentifier* _tmp16;
				ValaCCodeCastExpression* _tmp18;
				ValaCCodeExpression* _tmp17;
				self->requires_array_free = TRUE;
				first = TRUE;
				csizeexpr = NULL;
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						if (first) {
							ValaCCodeExpression* _tmp13;
							_tmp13 = NULL;
							csizeexpr = (_tmp13 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL))), _tmp13);
							first = FALSE;
						} else {
							ValaCCodeExpression* _tmp15;
							ValaCCodeExpression* _tmp14;
							_tmp15 = NULL;
							_tmp14 = NULL;
							csizeexpr = (_tmp15 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (_tmp14 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), expr, dim))))), (csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL))), _tmp15);
							(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
						}
					}
				}
				_tmp16 = NULL;
				vala_ccode_function_call_set_call (ccall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("_vala_array_free")))));
				(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
				vala_ccode_function_call_add_argument (ccall, csizeexpr);
				_tmp18 = NULL;
				_tmp17 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_cast_expression_new ((_tmp17 = vala_ccode_base_module_get_destroy_func_expression (self, vala_array_type_get_element_type (array_type))), "GDestroyNotify")))));
				(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
				(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
				(csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)));
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ccall)));
	_tmp19 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_constant_new ("NULL")))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	cassign = vala_ccode_assignment_new (cvar, ((ValaCCodeExpression*) (ccomma)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	_tmp20 = NULL;
	uses_gfree = (_tmp21 = (vala_data_type_get_data_type (type) != NULL && !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type)) && _vala_strcmp0 ((_tmp20 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), "g_free") == 0), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
	uses_gfree = uses_gfree || VALA_IS_ARRAY_TYPE (type);
	if (uses_gfree) {
		ValaCCodeExpression* _tmp22;
		_tmp22 = NULL;
		return (_tmp22 = ((ValaCCodeExpression*) (vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) (cassign))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), (ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL))), _tmp22);
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp25 = NULL;
	_tmp26 = NULL;
	return (_tmp26 = (_tmp25 = ((ValaCCodeExpression*) (vala_ccode_conditional_expression_new (((ValaCCodeExpression*) (cisnull)), ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_constant_new ("NULL")))), ((ValaCCodeExpression*) ((_tmp24 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) (cassign))))))))), (_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL))), (_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL))), _tmp25), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), (ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL))), _tmp26);
}


static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* full_expr_var;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp7;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear (((GeeCollection*) (expr->temp_vars)));
	{
		GeeArrayList* local_collection;
		int local_it;
		local_collection = self->temp_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				gee_collection_add (((GeeCollection*) (expr->temp_vars)), local);
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
	}
	gee_collection_clear (((GeeCollection*) (self->temp_vars)));
	if (gee_collection_get_size (((GeeCollection*) ((GEE_LIST (self->temp_ref_vars))))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (expr_type == NULL ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL))), _tmp2);
	}
	full_expr_var = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, ((ValaCodeNode*) (expr)));
	gee_collection_add (((GeeCollection*) (expr->temp_vars)), full_expr_var);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (full_expr_var))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	{
		GeeArrayList* local_collection;
		int local_it;
		local_collection = self->temp_ref_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp6;
				ValaCCodeIdentifier* _tmp5;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
				vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (_tmp6 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (local))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			}
		}
	}
	_tmp7 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (full_expr_var))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (expr_list)));
	gee_collection_clear (((GeeCollection*) (self->temp_ref_vars)));
	(expr_type == NULL ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)));
	(full_expr_var == NULL ? NULL : (full_expr_var = (vala_code_node_unref (full_expr_var), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (vala_ccode_node_unref (expr_list), NULL)));
}


void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (temp_vars != NULL);
	{
		GeeList* local_collection;
		int local_it;
		local_collection = temp_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				ValaStruct* _tmp3;
				ValaTypeSymbol* _tmp2;
				ValaStruct* st;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) (local))));
				/* sets #line*/
				vala_code_node_set_ccodenode (((ValaCodeNode*) (local)), ((ValaCCodeNode*) (vardecl)));
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (vardecl)));
				_tmp3 = NULL;
				_tmp2 = NULL;
				st = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_local_variable_get_variable_type (local)), (VALA_IS_STRUCT (_tmp2) ? ((ValaStruct*) (_tmp2)) : NULL)), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
				if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
					ValaCCodeConstant* _tmp4;
					_tmp4 = NULL;
					vala_ccode_variable_declarator_set_initializer (vardecl, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ("NULL")))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
				} else {
					if (st != NULL && !vala_struct_is_simple_type (st)) {
						ValaCCodeInitializerList* clist;
						ValaCCodeConstant* _tmp5;
						/* 0-initialize struct with struct initializer { 0 }
						 necessary as they will be passed by reference*/
						clist = vala_ccode_initializer_list_new ();
						_tmp5 = NULL;
						vala_ccode_initializer_list_append (clist, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_constant_new ("0")))));
						(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
						vala_ccode_variable_declarator_set_initializer (vardecl, ((ValaCCodeExpression*) (clist)));
						(clist == NULL ? NULL : (clist = (vala_ccode_node_unref (clist), NULL)));
					}
				}
				vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) (cdecl_)));
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (vala_ccode_node_unref (vardecl), NULL)));
				(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
			}
		}
	}
}


static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpressionStatement* _tmp0;
	ValaInvocationExpression* _tmp2;
	ValaExpression* _tmp1;
	ValaInvocationExpression* invoc;
	ValaCCodeFragment* cfrag;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))))) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	invoc = (_tmp2 = (_tmp1 = vala_expression_statement_get_expression (stmt), (VALA_IS_INVOCATION_EXPRESSION (_tmp1) ? ((ValaInvocationExpression*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	if (invoc != NULL) {
		ValaMethod* _tmp4;
		ValaSymbol* _tmp3;
		ValaMethod* m;
		ValaMemberAccess* _tmp6;
		ValaExpression* _tmp5;
		ValaMemberAccess* ma;
		_tmp4 = NULL;
		_tmp3 = NULL;
		m = (_tmp4 = (_tmp3 = vala_expression_get_symbol_reference (vala_invocation_expression_get_call (invoc)), (VALA_IS_METHOD (_tmp3) ? ((ValaMethod*) (_tmp3)) : NULL)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
		_tmp6 = NULL;
		_tmp5 = NULL;
		ma = (_tmp6 = (_tmp5 = vala_invocation_expression_get_call (invoc), (VALA_IS_MEMBER_ACCESS (_tmp5) ? ((ValaMemberAccess*) (_tmp5)) : NULL)), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
		if (m != NULL && vala_method_get_coroutine (m) && (ma == NULL || _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0 || vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
			ValaCCodeFragment* cfrag;
			gint state;
			ValaCCodeExpressionStatement* _tmp12;
			ValaCCodeAssignment* _tmp11;
			ValaCCodeConstant* _tmp10;
			char* _tmp9;
			ValaCCodeMemberAccess* _tmp8;
			ValaCCodeIdentifier* _tmp7;
			ValaCCodeReturnStatement* _tmp14;
			ValaCCodeConstant* _tmp13;
			ValaCCodeCaseStatement* _tmp17;
			ValaCCodeConstant* _tmp16;
			char* _tmp15;
			cfrag = vala_ccode_fragment_new ();
			state = self->next_coroutine_state++;
			vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (stmt))));
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp12 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp11 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp8 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("data")))), "state")))), ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ((_tmp9 = g_strdup_printf ("%i", state)))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
			(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
			(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
			(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
			_tmp9 = (g_free (_tmp9), NULL);
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
			(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp14 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_constant_new ("FALSE")))))))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
			(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp15 = NULL;
			vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_case_statement_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_constant_new ((_tmp15 = g_strdup_printf ("%i", state)))))))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
			(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
			_tmp15 = (g_free (_tmp15), NULL);
			vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
			(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
		}
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
		(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	}
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (stmt))) && vala_code_node_get_tree_can_fail (((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (stmt))));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))), cfrag);
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
		(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (gee_collection_get_size (((GeeCollection*) ((GEE_LIST (self->temp_vars))))) == 0) {
		/* nothing to do without temporary variables */
		(invoc == NULL ? NULL : (invoc = (vala_code_node_unref (invoc), NULL)));
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) (stmt))));
	{
		GeeArrayList* local_collection;
		int local_it;
		local_collection = self->temp_ref_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp20;
				ValaCCodeExpression* _tmp19;
				ValaCCodeIdentifier* _tmp18;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
				vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp18 = NULL;
				vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp20 = vala_ccode_expression_statement_new ((_tmp19 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (local))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))))))));
				(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
				(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
				(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			}
		}
	}
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfrag)));
	gee_collection_clear (((GeeCollection*) (self->temp_vars)));
	gee_collection_clear (((GeeCollection*) (self->temp_ref_vars)));
	(invoc == NULL ? NULL : (invoc = (vala_code_node_unref (invoc), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
}


void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (temp_vars != NULL);
	/* declare temporary variables */
	if (gee_collection_get_size (((GeeCollection*) (temp_vars))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), ((ValaCCodeNode*) (cfrag)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
}


static void vala_ccode_base_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_if_statement_get_condition (stmt))))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_if_statement_get_true_statement (stmt))))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_if_statement_get_false_statement (stmt))))))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_if_statement_get_condition (stmt))))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_if_statement_get_true_statement (stmt))))), NULL)))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	}
	vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_if_statement_get_condition (stmt)->temp_vars)));
}


static void vala_ccode_base_module_visit_string_switch_statement (ValaCCodeBaseModule* self, ValaSwitchStatement* stmt) {
	ValaLocalVariable* temp_var;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeConstant* _tmp0;
	ValaCCodeBinaryExpression* _tmp1;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cquark;
	ValaCCodeConstant* _tmp4;
	ValaCCodeConditionalExpression* _tmp5;
	ValaCCodeConditionalExpression* ccond;
	ValaLocalVariable* _tmp6;
	gint label_count;
	ValaCCodeExpressionStatement* _tmp11;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeAssignment* _tmp13;
	ValaCCodeExpressionStatement* _tmp14;
	GeeList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	/* we need a temporary variable to save the property value*/
	temp_var = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), TRUE, ((ValaCodeNode*) (stmt)));
	gee_list_insert (((GeeList*) (vala_switch_statement_get_expression (stmt)->temp_vars)), 0, temp_var);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
	cinit = vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_switch_statement_get_expression (stmt))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cswitchblock)));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_constant_new ("NULL")))), ((ValaCCodeExpression*) (ctemp))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cquark = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("g_quark_from_string"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	vala_ccode_function_call_add_argument (cquark, ((ValaCCodeExpression*) (ctemp)));
	_tmp4 = NULL;
	_tmp5 = NULL;
	ccond = (_tmp5 = vala_ccode_conditional_expression_new (((ValaCCodeExpression*) (cisnull)), ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ("0")))), ((ValaCCodeExpression*) (cquark))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp5);
	_tmp6 = NULL;
	temp_var = (_tmp6 = vala_ccode_base_module_get_temp_variable (self, self->gquark_type, TRUE, NULL), (temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL))), _tmp6);
	gee_list_insert (((GeeList*) (vala_switch_statement_get_expression (stmt)->temp_vars)), 0, temp_var);
	label_count = 0;
	{
		GeeList* section_collection;
		int section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		for (section_it = 0; section_it < gee_collection_get_size (GEE_COLLECTION (section_collection)); section_it = section_it + 1) {
			ValaSwitchSection* section;
			section = ((ValaSwitchSection*) (gee_list_get (GEE_LIST (section_collection), section_it)));
			{
				if (vala_switch_section_has_default_label (section)) {
					(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
					continue;
				}
				{
					GeeList* label_collection;
					int label_it;
					label_collection = vala_switch_section_get_labels (section);
					for (label_it = 0; label_it < gee_collection_get_size (GEE_COLLECTION (label_collection)); label_it = label_it + 1) {
						ValaSwitchLabel* label;
						label = ((ValaSwitchLabel*) (gee_list_get (GEE_LIST (label_collection), label_it)));
						{
							ValaCCodeExpression* _tmp7;
							ValaCCodeExpression* cexpr;
							_tmp7 = NULL;
							cexpr = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_switch_label_get_expression (label))))), (_tmp7 == NULL ? NULL : vala_ccode_node_ref (_tmp7)));
							if (vala_ccode_base_module_is_constant_ccode_expression (self, cexpr)) {
								char* cname;
								char* _tmp8;
								ValaCCodeDeclaration* _tmp9;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeVariableDeclarator* _tmp10;
								cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name (((ValaSymbol*) (temp_var))), label_count++);
								_tmp8 = NULL;
								_tmp9 = NULL;
								cdecl_ = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = vala_data_type_get_cname (self->gquark_type))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
								vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
								_tmp10 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer (cname, ((ValaCCodeExpression*) (czero)))))));
								(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
								vala_ccode_fragment_append (cswitchblock, ((ValaCCodeNode*) (cdecl_)));
								cname = (g_free (cname), NULL);
								(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
							}
							(label == NULL ? NULL : (label = (vala_code_node_unref (label), NULL)));
							(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
						}
					}
					(label_collection == NULL ? NULL : (label_collection = (gee_collection_object_unref (label_collection), NULL)));
				}
				(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (gee_collection_object_unref (section_collection), NULL)));
	}
	_tmp11 = NULL;
	vala_ccode_fragment_append (cswitchblock, ((ValaCCodeNode*) ((_tmp11 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinit)))))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	ctemp = (_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var)))), (ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL))), _tmp12);
	_tmp13 = NULL;
	cinit = (_tmp13 = vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), ((ValaCCodeExpression*) (ccond)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_fragment_append (cswitchblock, ((ValaCCodeNode*) ((_tmp14 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinit)))))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_switch_statement_get_expression (stmt)->temp_vars)));
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeList* section_collection;
		int section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		for (section_it = 0; section_it < gee_collection_get_size (GEE_COLLECTION (section_collection)); section_it = section_it + 1) {
			ValaSwitchSection* section;
			section = ((ValaSwitchSection*) (gee_list_get (GEE_LIST (section_collection), section_it)));
			{
				ValaCCodeBinaryExpression* cor;
				ValaCCodeBlock* cblock;
				ValaCCodeConstant* _tmp31;
				ValaCCodeDoStatement* _tmp32;
				ValaCCodeDoStatement* cdo;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp36;
				ValaCCodeIfStatement* _tmp35;
				if (vala_switch_section_has_default_label (section)) {
					GeeList* _tmp15;
					_tmp15 = NULL;
					default_statements = (_tmp15 = vala_block_get_statements (((ValaBlock*) (section))), (default_statements == NULL ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL))), _tmp15);
					(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
					continue;
				}
				cor = NULL;
				{
					GeeList* label_collection;
					int label_it;
					label_collection = vala_switch_section_get_labels (section);
					for (label_it = 0; label_it < gee_collection_get_size (GEE_COLLECTION (label_collection)); label_it = label_it + 1) {
						ValaSwitchLabel* label;
						label = ((ValaSwitchLabel*) (gee_list_get (GEE_LIST (label_collection), label_it)));
						{
							ValaCCodeExpression* _tmp16;
							ValaCCodeExpression* cexpr;
							ValaCCodeBinaryExpression* ccmp;
							_tmp16 = NULL;
							cexpr = (_tmp16 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_switch_label_get_expression (label))))), (_tmp16 == NULL ? NULL : vala_ccode_node_ref (_tmp16)));
							if (vala_ccode_base_module_is_constant_ccode_expression (self, cexpr)) {
								char* _tmp17;
								ValaCCodeIdentifier* _tmp18;
								ValaCCodeIdentifier* cname;
								ValaCCodeBinaryExpression* ccond;
								ValaCCodeIdentifier* _tmp19;
								ValaCCodeFunctionCall* _tmp20;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeAssignment* _tmp21;
								ValaCCodeParenthesizedExpression* _tmp22;
								ValaCCodeParenthesizedExpression* cinit;
								ValaCCodeExpression* _tmp23;
								_tmp17 = NULL;
								_tmp18 = NULL;
								cname = (_tmp18 = vala_ccode_identifier_new ((_tmp17 = g_strdup_printf ("%s_label%d", vala_symbol_get_name (((ValaSymbol*) (temp_var))), label_count++))), (_tmp17 = (g_free (_tmp17), NULL)), _tmp18);
								ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) (czero)), ((ValaCCodeExpression*) (cname)));
								_tmp19 = NULL;
								_tmp20 = NULL;
								ccall = (_tmp20 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp19 = vala_ccode_identifier_new ("g_quark_from_static_string"))))), (_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL))), _tmp20);
								_tmp21 = NULL;
								_tmp22 = NULL;
								cinit = (_tmp22 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_assignment_new (((ValaCCodeExpression*) (cname)), ((ValaCCodeExpression*) (ccall)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), _tmp22);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								_tmp23 = NULL;
								cexpr = (_tmp23 = ((ValaCCodeExpression*) (vala_ccode_conditional_expression_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeExpression*) (cname)), ((ValaCCodeExpression*) (cinit))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp23);
								(cname == NULL ? NULL : (cname = (vala_ccode_node_unref (cname), NULL)));
								(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
								(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
								(cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)));
							} else {
								ValaCCodeIdentifier* _tmp24;
								ValaCCodeFunctionCall* _tmp25;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* _tmp27;
								ValaCCodeExpression* _tmp26;
								_tmp24 = NULL;
								_tmp25 = NULL;
								ccall = (_tmp25 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new ("g_quark_from_string"))))), (_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL))), _tmp25);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								_tmp27 = NULL;
								_tmp26 = NULL;
								cexpr = (_tmp27 = (_tmp26 = ((ValaCCodeExpression*) (ccall)), (_tmp26 == NULL ? NULL : vala_ccode_node_ref (_tmp26))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp27);
								(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							}
							ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) (ctemp)), cexpr);
							if (cor == NULL) {
								ValaCCodeBinaryExpression* _tmp29;
								ValaCCodeBinaryExpression* _tmp28;
								_tmp29 = NULL;
								_tmp28 = NULL;
								cor = (_tmp29 = (_tmp28 = ccmp, (_tmp28 == NULL ? NULL : vala_ccode_node_ref (_tmp28))), (cor == NULL ? NULL : (cor = (vala_ccode_node_unref (cor), NULL))), _tmp29);
							} else {
								ValaCCodeBinaryExpression* _tmp30;
								_tmp30 = NULL;
								cor = (_tmp30 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, ((ValaCCodeExpression*) (cor)), ((ValaCCodeExpression*) (ccmp))), (cor == NULL ? NULL : (cor = (vala_ccode_node_unref (cor), NULL))), _tmp30);
							}
							(label == NULL ? NULL : (label = (vala_code_node_unref (label), NULL)));
							(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
							(ccmp == NULL ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL)));
						}
					}
					(label_collection == NULL ? NULL : (label_collection = (gee_collection_object_unref (label_collection), NULL)));
				}
				cblock = vala_ccode_block_new ();
				{
					GeeList* body_stmt_collection;
					int body_stmt_it;
					body_stmt_collection = vala_block_get_statements (((ValaBlock*) (section)));
					for (body_stmt_it = 0; body_stmt_it < gee_collection_get_size (GEE_COLLECTION (body_stmt_collection)); body_stmt_it = body_stmt_it + 1) {
						ValaCodeNode* body_stmt;
						body_stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (body_stmt_collection), body_stmt_it)))));
						{
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
								{
									GeeList* cstmt_collection;
									int cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))));
									for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
							}
							(body_stmt == NULL ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL)));
						}
					}
					(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (gee_collection_object_unref (body_stmt_collection), NULL)));
				}
				_tmp31 = NULL;
				_tmp32 = NULL;
				cdo = (_tmp32 = vala_ccode_do_statement_new (((ValaCCodeStatement*) (cblock)), ((ValaCCodeExpression*) ((_tmp31 = vala_ccode_constant_new ("0"))))), (_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL))), _tmp32);
				cif = vala_ccode_if_statement_new (((ValaCCodeExpression*) (cor)), ((ValaCCodeStatement*) (cdo)), NULL);
				if (coldif != NULL) {
					vala_ccode_if_statement_set_false_statement (coldif, ((ValaCCodeStatement*) (cif)));
				} else {
					ValaCCodeStatement* _tmp34;
					ValaCCodeStatement* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					ctopstmt = (_tmp34 = (_tmp33 = ((ValaCCodeStatement*) (cif)), (_tmp33 == NULL ? NULL : vala_ccode_node_ref (_tmp33))), (ctopstmt == NULL ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL))), _tmp34);
				}
				_tmp36 = NULL;
				_tmp35 = NULL;
				coldif = (_tmp36 = (_tmp35 = cif, (_tmp35 == NULL ? NULL : vala_ccode_node_ref (_tmp35))), (coldif == NULL ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL))), _tmp36);
				(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
				(cor == NULL ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)));
				(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
				(cdo == NULL ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL)));
				(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (gee_collection_object_unref (section_collection), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp37;
		ValaCCodeDoStatement* _tmp38;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeList* body_stmt_collection;
			int body_stmt_it;
			body_stmt_collection = default_statements;
			for (body_stmt_it = 0; body_stmt_it < gee_collection_get_size (GEE_COLLECTION (body_stmt_collection)); body_stmt_it = body_stmt_it + 1) {
				ValaCodeNode* body_stmt;
				body_stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (body_stmt_collection), body_stmt_it)))));
				{
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL)));
				}
			}
		}
		_tmp37 = NULL;
		_tmp38 = NULL;
		cdo = (_tmp38 = vala_ccode_do_statement_new (((ValaCCodeStatement*) (cblock)), ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_constant_new ("0"))))), (_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL))), _tmp38);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp40;
			ValaCCodeStatement* _tmp39;
			/* there is only one section and that section
			 contains a default label*/
			_tmp40 = NULL;
			_tmp39 = NULL;
			ctopstmt = (_tmp40 = (_tmp39 = ((ValaCCodeStatement*) (cdo)), (_tmp39 == NULL ? NULL : vala_ccode_node_ref (_tmp39))), (ctopstmt == NULL ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL))), _tmp40);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, ((ValaCCodeStatement*) (cdo)));
		}
		(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, ((ValaCCodeNode*) (ctopstmt)));
	(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)));
	(czero == NULL ? NULL : (czero = (vala_ccode_node_unref (czero), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (vala_ccode_node_unref (cswitchblock), NULL)));
	(cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)));
	(cquark == NULL ? NULL : (cquark = (vala_ccode_node_unref (cquark), NULL)));
	(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL)));
}


static void vala_ccode_base_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeSwitchStatement* cswitch;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), self->string_type)) {
		vala_ccode_base_module_visit_string_switch_statement (self, stmt);
		return;
	}
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_switch_statement_get_expression (stmt))))));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cswitch)));
	{
		GeeList* section_collection;
		int section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		for (section_it = 0; section_it < gee_collection_get_size (GEE_COLLECTION (section_collection)); section_it = section_it + 1) {
			ValaSwitchSection* section;
			section = ((ValaSwitchSection*) (gee_list_get (GEE_LIST (section_collection), section_it)));
			{
				ValaCCodeBlock* cblock;
				if (vala_switch_section_has_default_label (section)) {
					ValaCCodeLabel* _tmp0;
					ValaCCodeBlock* cdefaultblock;
					_tmp0 = NULL;
					vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_label_new ("default")))));
					(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
					cdefaultblock = vala_ccode_block_new ();
					vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) (cdefaultblock)));
					{
						GeeList* default_stmt_collection;
						int default_stmt_it;
						default_stmt_collection = vala_block_get_statements (((ValaBlock*) (section)));
						for (default_stmt_it = 0; default_stmt_it < gee_collection_get_size (GEE_COLLECTION (default_stmt_collection)); default_stmt_it = default_stmt_it + 1) {
							ValaCodeNode* default_stmt;
							default_stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (default_stmt_collection), default_stmt_it)))));
							{
								vala_ccode_block_add_statement (cdefaultblock, vala_code_node_get_ccodenode (default_stmt));
								(default_stmt == NULL ? NULL : (default_stmt = (vala_code_node_unref (default_stmt), NULL)));
							}
						}
						(default_stmt_collection == NULL ? NULL : (default_stmt_collection = (gee_collection_object_unref (default_stmt_collection), NULL)));
					}
					(cdefaultblock == NULL ? NULL : (cdefaultblock = (vala_ccode_node_unref (cdefaultblock), NULL)));
					(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
					continue;
				}
				{
					GeeList* label_collection;
					int label_it;
					label_collection = vala_switch_section_get_labels (section);
					for (label_it = 0; label_it < gee_collection_get_size (GEE_COLLECTION (label_collection)); label_it = label_it + 1) {
						ValaSwitchLabel* label;
						label = ((ValaSwitchLabel*) (gee_list_get (GEE_LIST (label_collection), label_it)));
						{
							ValaCCodeCaseStatement* _tmp1;
							_tmp1 = NULL;
							vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) ((_tmp1 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_switch_label_get_expression (label))))))))));
							(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
							(label == NULL ? NULL : (label = (vala_code_node_unref (label), NULL)));
						}
					}
					(label_collection == NULL ? NULL : (label_collection = (gee_collection_object_unref (label_collection), NULL)));
				}
				cblock = vala_ccode_block_new ();
				vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) (cblock)));
				{
					GeeList* body_stmt_collection;
					int body_stmt_it;
					body_stmt_collection = vala_block_get_statements (((ValaBlock*) (section)));
					for (body_stmt_it = 0; body_stmt_it < gee_collection_get_size (GEE_COLLECTION (body_stmt_collection)); body_stmt_it = body_stmt_it + 1) {
						ValaCodeNode* body_stmt;
						body_stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (body_stmt_collection), body_stmt_it)))));
						{
							vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
							(body_stmt == NULL ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL)));
						}
					}
					(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (gee_collection_object_unref (body_stmt_collection), NULL)));
				}
				(section == NULL ? NULL : (section = (vala_code_node_unref (section), NULL)));
				(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (gee_collection_object_unref (section_collection), NULL)));
	}
	(cswitch == NULL ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL)));
}


static void vala_ccode_base_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_block (((ValaCCodeModule*) (self)), ((ValaBlock*) (section)));
}


static void vala_ccode_base_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeWhileStatement* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_while_statement_get_condition (stmt))))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_while_statement_get_body (stmt))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_while_statement_get_condition (stmt)->temp_vars)));
}


static void vala_ccode_base_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeDoStatement* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_do_statement_get_body (stmt))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_do_statement_get_condition (stmt))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_do_statement_get_condition (stmt)->temp_vars)));
}


static void vala_ccode_base_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* ccondition;
	ValaCCodeForStatement* cfor;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	ccondition = NULL;
	if (vala_for_statement_get_condition (stmt) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccondition = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_for_statement_get_condition (stmt))))), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0))), (ccondition == NULL ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL))), _tmp1);
	}
	cfor = vala_ccode_for_statement_new (ccondition, VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_for_statement_get_body (stmt))))));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfor)));
	{
		GeeList* init_expr_collection;
		int init_expr_it;
		init_expr_collection = vala_for_statement_get_initializer (stmt);
		for (init_expr_it = 0; init_expr_it < gee_collection_get_size (GEE_COLLECTION (init_expr_collection)); init_expr_it = init_expr_it + 1) {
			ValaExpression* init_expr;
			init_expr = ((ValaExpression*) (gee_list_get (GEE_LIST (init_expr_collection), init_expr_it)));
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (init_expr)))));
				vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (init_expr->temp_vars)));
				(init_expr == NULL ? NULL : (init_expr = (vala_code_node_unref (init_expr), NULL)));
			}
		}
		(init_expr_collection == NULL ? NULL : (init_expr_collection = (gee_collection_object_unref (init_expr_collection), NULL)));
	}
	{
		GeeList* it_expr_collection;
		int it_expr_it;
		it_expr_collection = vala_for_statement_get_iterator (stmt);
		for (it_expr_it = 0; it_expr_it < gee_collection_get_size (GEE_COLLECTION (it_expr_collection)); it_expr_it = it_expr_it + 1) {
			ValaExpression* it_expr;
			it_expr = ((ValaExpression*) (gee_list_get (GEE_LIST (it_expr_collection), it_expr_it)));
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (it_expr)))));
				vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (it_expr->temp_vars)));
				(it_expr == NULL ? NULL : (it_expr = (vala_code_node_unref (it_expr), NULL)));
			}
		}
		(it_expr_collection == NULL ? NULL : (it_expr_collection = (gee_collection_object_unref (it_expr_collection), NULL)));
	}
	if (vala_for_statement_get_condition (stmt) != NULL) {
		vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_for_statement_get_condition (stmt)->temp_vars)));
	}
	(ccondition == NULL ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL)));
	(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
}


static void vala_ccode_base_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaLocalVariable* _tmp0;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	char* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* ccolvardecl;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_element_variable (stmt))), TRUE);
	vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_collection_variable (stmt))), TRUE);
	if (vala_foreach_statement_get_iterator_variable (stmt) != NULL) {
		vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_iterator_variable (stmt))), TRUE);
	}
	vala_ccode_module_visit_block (((ValaCCodeModule*) (self)), ((ValaBlock*) (stmt)));
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cblock)));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (vala_foreach_statement_get_collection (stmt)->temp_vars)));
	vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfrag)));
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable (stmt), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	collection_type = vala_data_type_copy (vala_local_variable_get_variable_type (collection_backup));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccoldecl = (_tmp2 = vala_ccode_declaration_new ((_tmp1 = vala_data_type_get_cname (collection_type))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	ccolvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (((ValaSymbol*) (collection_backup))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))))));
	vala_ccode_node_set_line (((ValaCCodeNode*) (ccolvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
	vala_ccode_declaration_add_declarator (ccoldecl, ((ValaCCodeDeclarator*) (ccolvardecl)));
	vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (ccoldecl)));
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (stmt))) && vala_code_node_get_tree_can_fail (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))))) {
		ValaCCodeFragment* cfrag;
		/* exception handling*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))), cfrag);
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfrag)));
		(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp3;
		ValaArrayType* array_type;
		ValaCCodeExpression* array_len;
		ValaCCodeDeclaration* clendecl;
		ValaCCodeVariableDeclarator* _tmp5;
		char* _tmp4;
		_tmp3 = NULL;
		array_type = (_tmp3 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt))), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
		array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_foreach_statement_get_collection (stmt), -1);
		/* store array length for use by _vala_array_free*/
		clendecl = vala_ccode_declaration_new ("int");
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_declaration_add_declarator (clendecl, ((ValaCCodeDeclarator*) ((_tmp5 = vala_ccode_variable_declarator_new_with_initializer ((_tmp4 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (collection_backup))), 1)), array_len)))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp4 = (g_free (_tmp4), NULL);
		vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (clendecl)));
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* _tmp6;
			ValaCCodeDeclaration* _tmp7;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp8;
			ValaCCodeBlock* cbody;
			char* _tmp9;
			ValaCCodeExpression* _tmp10;
			ValaCCodeExpression* element_expr;
			ValaDataType* element_type;
			ValaCCodeExpression* _tmp11;
			ValaCCodeFragment* cfrag;
			char* _tmp12;
			ValaCCodeDeclaration* _tmp13;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp14;
			ValaCCodeConstant* _tmp22;
			ValaCCodeIdentifier* _tmp21;
			char* _tmp20;
			ValaCCodeBinaryExpression* _tmp23;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp26;
			ValaCCodeIdentifier* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeAssignment* _tmp31;
			ValaCCodeBinaryExpression* _tmp30;
			ValaCCodeConstant* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeIdentifier* _tmp27;
			/* the array has no length parameter i.e. it is NULL-terminated array*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp6 = NULL;
			_tmp7 = NULL;
			citdecl = (_tmp7 = vala_ccode_declaration_new ((_tmp6 = vala_data_type_get_cname (collection_type))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
			_tmp8 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) ((_tmp8 = vala_ccode_variable_declarator_new (it_name)))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (citdecl)));
			cbody = vala_ccode_block_new ();
			_tmp9 = NULL;
			_tmp10 = NULL;
			element_expr = (_tmp10 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("*%s", it_name))))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10);
			element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
			vala_data_type_set_value_owned (element_type, FALSE);
			_tmp11 = NULL;
			element_expr = (_tmp11 = vala_ccode_base_module_transform_expression (self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL))), _tmp11);
			cfrag = vala_ccode_fragment_new ();
			vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cfrag)));
			gee_collection_clear (((GeeCollection*) (self->temp_vars)));
			_tmp12 = NULL;
			_tmp13 = NULL;
			cdecl_ = (_tmp13 = vala_ccode_declaration_new ((_tmp12 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
			_tmp14 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp14 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr)))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
			/* add array length variable for stacked arrays*/
			if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
				ValaArrayType* _tmp15;
				ValaArrayType* inner_array_type;
				_tmp15 = NULL;
				inner_array_type = (_tmp15 = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (inner_array_type); dim++) {
						ValaCCodeDeclaration* _tmp16;
						ValaCCodeVariableDeclarator* _tmp19;
						ValaCCodeConstant* _tmp18;
						char* _tmp17;
						_tmp16 = NULL;
						cdecl_ = (_tmp16 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp16);
						_tmp19 = NULL;
						_tmp18 = NULL;
						_tmp17 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp19 = vala_ccode_variable_declarator_new_with_initializer ((_tmp17 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_foreach_statement_get_variable_name (stmt), dim)), ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_constant_new ("-1")))))))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
						(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
						_tmp17 = (g_free (_tmp17), NULL);
						vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
					}
				}
				(inner_array_type == NULL ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL)));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt)))));
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			_tmp23 = NULL;
			ccond = (_tmp23 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("*%s", it_name)))))), ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_constant_new ("NULL"))))), (_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), _tmp23);
			cfor = vala_ccode_for_statement_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeStatement*) (cbody)));
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp24 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp24 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
			(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp31 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp27 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp30 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp29 = vala_ccode_constant_new ("1")))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
			(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
			(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
			(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
			(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfor)));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
			(element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)));
			(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp32;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp34;
			ValaCCodeIdentifier* _tmp33;
			ValaCCodeExpression* _tmp35;
			ValaCCodeExpression* element_expr;
			ValaDataType* element_type;
			ValaCCodeExpression* _tmp36;
			ValaCCodeFragment* cfrag;
			char* _tmp37;
			ValaCCodeDeclaration* _tmp38;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp39;
			ValaCCodeConstant* _tmp45;
			ValaCCodeBinaryExpression* _tmp46;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* _tmp47;
			ValaCCodeBinaryExpression* _tmp48;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp66;
			ValaCCodeConstant* _tmp65;
			ValaCCodeIdentifier* _tmp64;
			ValaCCodeAssignment* _tmp71;
			ValaCCodeBinaryExpression* _tmp70;
			ValaCCodeConstant* _tmp69;
			ValaCCodeIdentifier* _tmp68;
			ValaCCodeIdentifier* _tmp67;
			/* the array has a length parameter*/
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			_tmp32 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) ((_tmp32 = vala_ccode_variable_declarator_new (it_name)))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (citdecl)));
			cbody = vala_ccode_block_new ();
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp35 = NULL;
			element_expr = (_tmp35 = ((ValaCCodeExpression*) (vala_ccode_element_access_new (((ValaCCodeExpression*) ((_tmp33 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new (it_name))))))), (_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL))), (_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL))), _tmp35);
			element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
			vala_data_type_set_value_owned (element_type, FALSE);
			_tmp36 = NULL;
			element_expr = (_tmp36 = vala_ccode_base_module_transform_expression (self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL))), _tmp36);
			cfrag = vala_ccode_fragment_new ();
			vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cfrag)));
			gee_collection_clear (((GeeCollection*) (self->temp_vars)));
			_tmp37 = NULL;
			_tmp38 = NULL;
			cdecl_ = (_tmp38 = vala_ccode_declaration_new ((_tmp37 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp37 = (g_free (_tmp37), NULL)), _tmp38);
			_tmp39 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp39 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr)))));
			(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
			/* add array length variable for stacked arrays*/
			if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
				ValaArrayType* _tmp40;
				ValaArrayType* inner_array_type;
				_tmp40 = NULL;
				inner_array_type = (_tmp40 = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (inner_array_type); dim++) {
						ValaCCodeDeclaration* _tmp41;
						ValaCCodeVariableDeclarator* _tmp44;
						ValaCCodeConstant* _tmp43;
						char* _tmp42;
						_tmp41 = NULL;
						cdecl_ = (_tmp41 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp41);
						_tmp44 = NULL;
						_tmp43 = NULL;
						_tmp42 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp44 = vala_ccode_variable_declarator_new_with_initializer ((_tmp42 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_foreach_statement_get_variable_name (stmt), dim)), ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_constant_new ("-1")))))))));
						(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
						(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
						_tmp42 = (g_free (_tmp42), NULL);
						vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
					}
				}
				(inner_array_type == NULL ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL)));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt)))));
			_tmp45 = NULL;
			_tmp46 = NULL;
			ccond_ind1 = (_tmp46 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_constant_new ("-1"))))), (_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL))), _tmp46);
			_tmp47 = NULL;
			_tmp48 = NULL;
			ccond_ind2 = (_tmp48 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, ((ValaCCodeExpression*) ((_tmp47 = vala_ccode_identifier_new (it_name)))), array_len), (_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL))), _tmp48);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, ((ValaCCodeExpression*) (ccond_ind1)), ((ValaCCodeExpression*) (ccond_ind2)));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
				ValaCCodeConstant* _tmp49;
				ValaCCodeBinaryExpression* _tmp50;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* _tmp54;
				ValaCCodeElementAccess* _tmp53;
				ValaCCodeIdentifier* _tmp52;
				ValaCCodeIdentifier* _tmp51;
				ValaCCodeBinaryExpression* _tmp55;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* _tmp58;
				ValaCCodeParenthesizedExpression* _tmp57;
				ValaCCodeParenthesizedExpression* _tmp56;
				_tmp49 = NULL;
				_tmp50 = NULL;
				ccond_term1 = (_tmp50 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, ((ValaCCodeExpression*) ((_tmp49 = vala_ccode_constant_new ("-1"))))), (_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL))), _tmp50);
				_tmp54 = NULL;
				_tmp53 = NULL;
				_tmp52 = NULL;
				_tmp51 = NULL;
				_tmp55 = NULL;
				ccond_term2 = (_tmp55 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp53 = vala_ccode_element_access_new (((ValaCCodeExpression*) ((_tmp51 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), ((ValaCCodeExpression*) ((_tmp52 = vala_ccode_identifier_new (it_name)))))))), ((ValaCCodeExpression*) ((_tmp54 = vala_ccode_constant_new ("NULL"))))), (_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL))), (_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL))), (_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL))), (_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL))), _tmp55);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, ((ValaCCodeExpression*) (ccond_term1)), ((ValaCCodeExpression*) (ccond_term2)));
				_tmp58 = NULL;
				_tmp57 = NULL;
				_tmp56 = NULL;
				ccond = (_tmp58 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, ((ValaCCodeExpression*) ((_tmp56 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) (ccond_ind)))))), ((ValaCCodeExpression*) ((_tmp57 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) (ccond_term))))))), (ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL))), _tmp58);
				(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
				(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (vala_ccode_node_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (vala_ccode_node_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (vala_ccode_node_unref (ccond_term), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp59;
				ValaCCodeFunctionCall* _tmp60;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* _tmp61;
				ValaCCodeBinaryExpression* _tmp63;
				ValaCCodeBinaryExpression* _tmp62;
				/* assert when trying to iterate over value-type arrays of unknown length */
				_tmp59 = NULL;
				_tmp60 = NULL;
				cassert = (_tmp60 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp59 = vala_ccode_identifier_new ("g_assert"))))), (_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL))), _tmp60);
				vala_ccode_function_call_add_argument (cassert, ((ValaCCodeExpression*) (ccond_ind1)));
				_tmp61 = NULL;
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp61 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cassert)))))));
				(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
				_tmp63 = NULL;
				_tmp62 = NULL;
				ccond = (_tmp63 = (_tmp62 = ccond_ind2, (_tmp62 == NULL ? NULL : vala_ccode_node_ref (_tmp62))), (ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL))), _tmp63);
				(cassert == NULL ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeStatement*) (cbody)));
			_tmp66 = NULL;
			_tmp65 = NULL;
			_tmp64 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp66 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp64 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp65 = vala_ccode_constant_new ("0")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
			(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
			(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
			_tmp71 = NULL;
			_tmp70 = NULL;
			_tmp69 = NULL;
			_tmp68 = NULL;
			_tmp67 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp71 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp67 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp70 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp68 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp69 = vala_ccode_constant_new ("1")))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
			(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
			(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
			(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
			(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfor)));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
			(element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)));
			(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (vala_ccode_node_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (vala_ccode_node_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (vala_ccode_node_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		(array_len == NULL ? NULL : (array_len = (vala_ccode_node_unref (array_len), NULL)));
		(clendecl == NULL ? NULL : (clendecl = (vala_ccode_node_unref (clendecl), NULL)));
	} else {
		ValaObjectType* _tmp73;
		ValaObjectType* _tmp72;
		gboolean _tmp74;
		_tmp73 = NULL;
		_tmp72 = NULL;
		if ((_tmp74 = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaDataType*) ((_tmp72 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->glist_type))))))) || vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaDataType*) ((_tmp73 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->gslist_type))))))), (_tmp73 == NULL ? NULL : (_tmp73 = (vala_code_node_unref (_tmp73), NULL))), (_tmp72 == NULL ? NULL : (_tmp72 = (vala_code_node_unref (_tmp72), NULL))), _tmp74)) {
			char* it_name;
			char* _tmp75;
			ValaCCodeDeclaration* _tmp76;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* citvardecl;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp77;
			ValaCCodeExpression* _tmp78;
			ValaCCodeExpression* element_expr;
			GeeList* _tmp79;
			gboolean _tmp80;
			ValaDataType* _tmp82;
			GeeList* _tmp81;
			ValaDataType* _tmp83;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp84;
			ValaCCodeFragment* cfrag;
			char* _tmp85;
			ValaCCodeDeclaration* _tmp86;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* cvardecl;
			ValaCCodeConstant* _tmp88;
			ValaCCodeIdentifier* _tmp87;
			ValaCCodeBinaryExpression* _tmp89;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp92;
			ValaCCodeIdentifier* _tmp91;
			ValaCCodeIdentifier* _tmp90;
			ValaCCodeAssignment* _tmp96;
			ValaCCodeMemberAccess* _tmp95;
			ValaCCodeIdentifier* _tmp94;
			ValaCCodeIdentifier* _tmp93;
			/* iterating over a GList or GSList*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp75 = NULL;
			_tmp76 = NULL;
			citdecl = (_tmp76 = vala_ccode_declaration_new ((_tmp75 = vala_data_type_get_cname (collection_type))), (_tmp75 = (g_free (_tmp75), NULL)), _tmp76);
			citvardecl = vala_ccode_variable_declarator_new (it_name);
			vala_ccode_node_set_line (((ValaCCodeNode*) (citvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
			vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) (citvardecl)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (citdecl)));
			cbody = vala_ccode_block_new ();
			_tmp77 = NULL;
			_tmp78 = NULL;
			element_expr = (_tmp78 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp77 = vala_ccode_identifier_new (it_name)))), "data"))), (_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL))), _tmp78);
			_tmp79 = NULL;
			if ((_tmp80 = gee_collection_get_size (((GeeCollection*) ((_tmp79 = vala_data_type_get_type_arguments (collection_type))))) != 1, (_tmp79 == NULL ? NULL : (_tmp79 = (gee_collection_object_unref (_tmp79), NULL))), _tmp80)) {
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "internal error: missing generic type argument");
				vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
				it_name = (g_free (it_name), NULL);
				(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
				(citvardecl == NULL ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL)));
				(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
				(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
				(collection_backup == NULL ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL)));
				(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
				(ccoldecl == NULL ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL)));
				(ccolvardecl == NULL ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL)));
				return;
			}
			_tmp82 = NULL;
			_tmp81 = NULL;
			_tmp83 = NULL;
			element_data_type = (_tmp83 = vala_data_type_copy ((_tmp82 = ((ValaDataType*) (gee_list_get ((_tmp81 = vala_data_type_get_type_arguments (collection_type)), 0))))), (_tmp82 == NULL ? NULL : (_tmp82 = (vala_code_node_unref (_tmp82), NULL))), (_tmp81 == NULL ? NULL : (_tmp81 = (gee_collection_object_unref (_tmp81), NULL))), _tmp83);
			vala_data_type_set_value_owned (element_data_type, FALSE);
			vala_data_type_set_is_type_argument (element_data_type, TRUE);
			_tmp84 = NULL;
			element_expr = (_tmp84 = vala_ccode_base_module_transform_expression (self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL))), _tmp84);
			cfrag = vala_ccode_fragment_new ();
			vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cfrag)));
			gee_collection_clear (((GeeCollection*) (self->temp_vars)));
			_tmp85 = NULL;
			_tmp86 = NULL;
			cdecl_ = (_tmp86 = vala_ccode_declaration_new ((_tmp85 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp85 = (g_free (_tmp85), NULL)), _tmp86);
			cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
			vala_ccode_node_set_line (((ValaCCodeNode*) (cvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
			vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (cvardecl)));
			vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt)))));
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp89 = NULL;
			ccond = (_tmp89 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp87 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp88 = vala_ccode_constant_new ("NULL"))))), (_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL))), (_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL))), _tmp89);
			cfor = vala_ccode_for_statement_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeStatement*) (cbody)));
			_tmp92 = NULL;
			_tmp91 = NULL;
			_tmp90 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp92 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp90 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp91 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)));
			(_tmp91 == NULL ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL)));
			(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
			_tmp96 = NULL;
			_tmp95 = NULL;
			_tmp94 = NULL;
			_tmp93 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp96 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp93 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp95 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp94 = vala_ccode_identifier_new (it_name)))), "next")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
			(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
			(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
			(_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)));
			vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfor)));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
			(citvardecl == NULL ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
			(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
			(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(cvardecl == NULL ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL)));
			(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
		} else {
			ValaObjectType* _tmp97;
			gboolean _tmp98;
			_tmp97 = NULL;
			if ((_tmp98 = self->list_type != NULL && vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaDataType*) ((_tmp97 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->list_type))))))), (_tmp97 == NULL ? NULL : (_tmp97 = (vala_code_node_unref (_tmp97), NULL))), _tmp98)) {
				char* it_name;
				ValaCCodeDeclaration* citdecl;
				ValaCCodeVariableDeclarator* _tmp99;
				ValaCCodeBlock* cbody;
				ValaMethod* get_method;
				ValaCCodeIdentifier* _tmp101;
				char* _tmp100;
				ValaCCodeFunctionCall* _tmp102;
				ValaCCodeFunctionCall* get_ccall;
				ValaInstanceCast* _tmp104;
				ValaCCodeIdentifier* _tmp103;
				ValaCCodeIdentifier* _tmp105;
				ValaCCodeExpression* _tmp106;
				ValaCCodeExpression* element_expr;
				ValaDataType* element_type;
				ValaCCodeExpression* _tmp107;
				ValaCCodeFragment* cfrag;
				char* _tmp108;
				ValaCCodeDeclaration* _tmp109;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* cvardecl;
				ValaCCodeIdentifier* _tmp110;
				ValaCCodeFunctionCall* _tmp111;
				ValaCCodeFunctionCall* list_len;
				ValaInstanceCast* _tmp113;
				ValaCCodeIdentifier* _tmp112;
				ValaCCodeIdentifier* _tmp114;
				ValaCCodeBinaryExpression* _tmp115;
				ValaCCodeBinaryExpression* ccond;
				ValaCCodeForStatement* cfor;
				ValaCCodeAssignment* _tmp118;
				ValaCCodeConstant* _tmp117;
				ValaCCodeIdentifier* _tmp116;
				ValaCCodeAssignment* _tmp123;
				ValaCCodeBinaryExpression* _tmp122;
				ValaCCodeConstant* _tmp121;
				ValaCCodeIdentifier* _tmp120;
				ValaCCodeIdentifier* _tmp119;
				/* iterating over a Gee.List, use integer to avoid the cost of an iterator object*/
				it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
				citdecl = vala_ccode_declaration_new ("int");
				_tmp99 = NULL;
				vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) ((_tmp99 = vala_ccode_variable_declarator_new (it_name)))));
				(_tmp99 == NULL ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL)));
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (citdecl)));
				cbody = vala_ccode_block_new ();
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->list_type))), "get"));
				_tmp101 = NULL;
				_tmp100 = NULL;
				_tmp102 = NULL;
				get_ccall = (_tmp102 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = vala_method_get_cname (get_method))))))), (_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL))), (_tmp100 = (g_free (_tmp100), NULL)), _tmp102);
				_tmp104 = NULL;
				_tmp103 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, ((ValaCCodeExpression*) ((_tmp104 = vala_instance_cast_new (((ValaCCodeExpression*) ((_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), ((ValaTypeSymbol*) (self->list_type)))))));
				(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
				(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
				_tmp105 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, ((ValaCCodeExpression*) ((_tmp105 = vala_ccode_identifier_new (it_name)))));
				(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
				_tmp106 = NULL;
				element_expr = (_tmp106 = ((ValaCCodeExpression*) (get_ccall)), (_tmp106 == NULL ? NULL : vala_ccode_node_ref (_tmp106)));
				element_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaSymbol*) (get_method)), vala_method_get_return_type (get_method), ((ValaCodeNode*) (stmt)));
				_tmp107 = NULL;
				element_expr = (_tmp107 = vala_ccode_base_module_transform_expression (self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL))), _tmp107);
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
				vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cfrag)));
				gee_collection_clear (((GeeCollection*) (self->temp_vars)));
				_tmp108 = NULL;
				_tmp109 = NULL;
				cdecl_ = (_tmp109 = vala_ccode_declaration_new ((_tmp108 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp108 = (g_free (_tmp108), NULL)), _tmp109);
				cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
				vala_ccode_node_set_line (((ValaCCodeNode*) (cvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (cvardecl)));
				vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt)))));
				_tmp110 = NULL;
				_tmp111 = NULL;
				list_len = (_tmp111 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp110 = vala_ccode_identifier_new ("gee_collection_get_size"))))), (_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL))), _tmp111);
				_tmp113 = NULL;
				_tmp112 = NULL;
				vala_ccode_function_call_add_argument (list_len, ((ValaCCodeExpression*) ((_tmp113 = vala_instance_cast_new (((ValaCCodeExpression*) ((_tmp112 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), ((ValaTypeSymbol*) (self->collection_type)))))));
				(_tmp113 == NULL ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL)));
				(_tmp112 == NULL ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL)));
				_tmp114 = NULL;
				_tmp115 = NULL;
				ccond = (_tmp115 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, ((ValaCCodeExpression*) ((_tmp114 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) (list_len))), (_tmp114 == NULL ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL))), _tmp115);
				cfor = vala_ccode_for_statement_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeStatement*) (cbody)));
				_tmp118 = NULL;
				_tmp117 = NULL;
				_tmp116 = NULL;
				vala_ccode_for_statement_add_initializer (cfor, ((ValaCCodeExpression*) ((_tmp118 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp116 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp117 = vala_ccode_constant_new ("0")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)));
				(_tmp117 == NULL ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL)));
				(_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)));
				_tmp123 = NULL;
				_tmp122 = NULL;
				_tmp121 = NULL;
				_tmp120 = NULL;
				_tmp119 = NULL;
				vala_ccode_for_statement_add_iterator (cfor, ((ValaCCodeExpression*) ((_tmp123 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp119 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp122 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ((ValaCCodeExpression*) ((_tmp120 = vala_ccode_identifier_new (it_name)))), ((ValaCCodeExpression*) ((_tmp121 = vala_ccode_constant_new ("1")))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
				(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
				(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
				(_tmp120 == NULL ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL)));
				(_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL)));
				vala_ccode_node_set_line (((ValaCCodeNode*) (cfor)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cfor)));
				it_name = (g_free (it_name), NULL);
				(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
				(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
				(get_method == NULL ? NULL : (get_method = (vala_code_node_unref (get_method), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (vala_ccode_node_unref (get_ccall), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
				(element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				(cvardecl == NULL ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL)));
				(list_len == NULL ? NULL : (list_len = (vala_ccode_node_unref (list_len), NULL)));
				(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
				(cfor == NULL ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)));
			} else {
				ValaObjectType* _tmp124;
				gboolean _tmp125;
				_tmp124 = NULL;
				if ((_tmp125 = self->iterable_type != NULL && vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaDataType*) ((_tmp124 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->iterable_type))))))), (_tmp124 == NULL ? NULL : (_tmp124 = (vala_code_node_unref (_tmp124), NULL))), _tmp125)) {
					char* it_name;
					char* _tmp127;
					char* _tmp126;
					ValaCCodeDeclaration* _tmp128;
					ValaCCodeDeclaration* citdecl;
					ValaMethod* it_method;
					ValaCCodeIdentifier* _tmp130;
					char* _tmp129;
					ValaCCodeFunctionCall* _tmp131;
					ValaCCodeFunctionCall* it_ccall;
					ValaInstanceCast* _tmp133;
					ValaCCodeIdentifier* _tmp132;
					ValaCCodeVariableDeclarator* citvardecl;
					ValaCCodeBlock* cbody;
					ValaMethod* get_method;
					ValaCCodeIdentifier* _tmp135;
					char* _tmp134;
					ValaCCodeFunctionCall* _tmp136;
					ValaCCodeFunctionCall* get_ccall;
					ValaCCodeIdentifier* _tmp137;
					ValaCCodeExpression* _tmp138;
					ValaCCodeExpression* element_expr;
					GeeList* _tmp139;
					GeeIterator* _tmp140;
					GeeIterator* type_arg_it;
					ValaDataType* _tmp141;
					ValaDataType* _tmp142;
					ValaDataType* it_type;
					ValaCCodeExpression* _tmp143;
					ValaCCodeFragment* cfrag;
					char* _tmp144;
					ValaCCodeDeclaration* _tmp145;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* cvardecl;
					ValaMethod* next_method;
					ValaCCodeIdentifier* _tmp147;
					char* _tmp146;
					ValaCCodeFunctionCall* _tmp148;
					ValaCCodeFunctionCall* next_ccall;
					ValaCCodeIdentifier* _tmp149;
					ValaCCodeWhileStatement* cwhile;
					/* iterating over a Gee.Iterable, use iterator*/
					it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
					_tmp127 = NULL;
					_tmp126 = NULL;
					_tmp128 = NULL;
					citdecl = (_tmp128 = vala_ccode_declaration_new ((_tmp127 = g_strconcat ((_tmp126 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (self->iterator_type)), FALSE)), "*", NULL))), (_tmp127 = (g_free (_tmp127), NULL)), (_tmp126 = (g_free (_tmp126), NULL)), _tmp128);
					it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->iterable_type))), "iterator"));
					_tmp130 = NULL;
					_tmp129 = NULL;
					_tmp131 = NULL;
					it_ccall = (_tmp131 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp130 = vala_ccode_identifier_new ((_tmp129 = vala_method_get_cname (it_method))))))), (_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL))), (_tmp129 = (g_free (_tmp129), NULL)), _tmp131);
					_tmp133 = NULL;
					_tmp132 = NULL;
					vala_ccode_function_call_add_argument (it_ccall, ((ValaCCodeExpression*) ((_tmp133 = vala_instance_cast_new (((ValaCCodeExpression*) ((_tmp132 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (collection_backup))))))), ((ValaTypeSymbol*) (self->iterable_type)))))));
					(_tmp133 == NULL ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL)));
					(_tmp132 == NULL ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)));
					citvardecl = vala_ccode_variable_declarator_new_with_initializer (it_name, ((ValaCCodeExpression*) (it_ccall)));
					vala_ccode_node_set_line (((ValaCCodeNode*) (citvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
					vala_ccode_declaration_add_declarator (citdecl, ((ValaCCodeDeclarator*) (citvardecl)));
					vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (citdecl)));
					cbody = vala_ccode_block_new ();
					get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->iterator_type))), "get"));
					_tmp135 = NULL;
					_tmp134 = NULL;
					_tmp136 = NULL;
					get_ccall = (_tmp136 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp135 = vala_ccode_identifier_new ((_tmp134 = vala_method_get_cname (get_method))))))), (_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL))), (_tmp134 = (g_free (_tmp134), NULL)), _tmp136);
					_tmp137 = NULL;
					vala_ccode_function_call_add_argument (get_ccall, ((ValaCCodeExpression*) ((_tmp137 = vala_ccode_identifier_new (it_name)))));
					(_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL)));
					_tmp138 = NULL;
					element_expr = (_tmp138 = ((ValaCCodeExpression*) (get_ccall)), (_tmp138 == NULL ? NULL : vala_ccode_node_ref (_tmp138)));
					_tmp139 = NULL;
					_tmp140 = NULL;
					type_arg_it = (_tmp140 = gee_iterable_iterator (((GeeIterable*) ((_tmp139 = vala_data_type_get_type_arguments (vala_method_get_return_type (it_method)))))), (_tmp139 == NULL ? NULL : (_tmp139 = (gee_collection_object_unref (_tmp139), NULL))), _tmp140);
					gee_iterator_next (type_arg_it);
					_tmp141 = NULL;
					_tmp142 = NULL;
					it_type = (_tmp142 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), ((ValaSymbol*) (it_method)), (_tmp141 = ((ValaDataType*) (gee_iterator_get (type_arg_it)))), ((ValaCodeNode*) (stmt))), (_tmp141 == NULL ? NULL : (_tmp141 = (vala_code_node_unref (_tmp141), NULL))), _tmp142);
					_tmp143 = NULL;
					element_expr = (_tmp143 = vala_ccode_base_module_transform_expression (self, element_expr, it_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL))), _tmp143);
					cfrag = vala_ccode_fragment_new ();
					vala_ccode_base_module_append_temp_decl (self, cfrag, ((GeeList*) (self->temp_vars)));
					vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cfrag)));
					gee_collection_clear (((GeeCollection*) (self->temp_vars)));
					_tmp144 = NULL;
					_tmp145 = NULL;
					cdecl_ = (_tmp145 = vala_ccode_declaration_new ((_tmp144 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp144 = (g_free (_tmp144), NULL)), _tmp145);
					cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
					vala_ccode_node_set_line (((ValaCCodeNode*) (cvardecl)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
					vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) (cvardecl)));
					vala_ccode_block_add_statement (cbody, ((ValaCCodeNode*) (cdecl_)));
					vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt)))));
					next_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->iterator_type))), "next"));
					_tmp147 = NULL;
					_tmp146 = NULL;
					_tmp148 = NULL;
					next_ccall = (_tmp148 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp147 = vala_ccode_identifier_new ((_tmp146 = vala_method_get_cname (next_method))))))), (_tmp147 == NULL ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL))), (_tmp146 = (g_free (_tmp146), NULL)), _tmp148);
					_tmp149 = NULL;
					vala_ccode_function_call_add_argument (next_ccall, ((ValaCCodeExpression*) ((_tmp149 = vala_ccode_identifier_new (it_name)))));
					(_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL)));
					cwhile = vala_ccode_while_statement_new (((ValaCCodeExpression*) (next_ccall)), ((ValaCCodeStatement*) (cbody)));
					vala_ccode_node_set_line (((ValaCCodeNode*) (cwhile)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
					vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cwhile)));
					it_name = (g_free (it_name), NULL);
					(citdecl == NULL ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL)));
					(it_method == NULL ? NULL : (it_method = (vala_code_node_unref (it_method), NULL)));
					(it_ccall == NULL ? NULL : (it_ccall = (vala_ccode_node_unref (it_ccall), NULL)));
					(citvardecl == NULL ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL)));
					(cbody == NULL ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)));
					(get_method == NULL ? NULL : (get_method = (vala_code_node_unref (get_method), NULL)));
					(get_ccall == NULL ? NULL : (get_ccall = (vala_ccode_node_unref (get_ccall), NULL)));
					(element_expr == NULL ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)));
					(type_arg_it == NULL ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL)));
					(it_type == NULL ? NULL : (it_type = (vala_code_node_unref (it_type), NULL)));
					(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					(cvardecl == NULL ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL)));
					(next_method == NULL ? NULL : (next_method = (vala_code_node_unref (next_method), NULL)));
					(next_ccall == NULL ? NULL : (next_ccall = (vala_ccode_node_unref (next_ccall), NULL)));
					(cwhile == NULL ? NULL : (cwhile = (vala_ccode_node_unref (cwhile), NULL)));
				}
			}
		}
	}
	{
		GeeList* local_collection;
		int local_it;
		local_collection = vala_block_get_local_variables (((ValaBlock*) (stmt)));
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				if (vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp152;
					ValaCCodeIdentifier* _tmp151;
					char* _tmp150;
					ValaCCodeExpressionStatement* _tmp153;
					ValaCCodeExpressionStatement* cunref;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
					_tmp152 = NULL;
					_tmp151 = NULL;
					_tmp150 = NULL;
					_tmp153 = NULL;
					cunref = (_tmp153 = vala_ccode_expression_statement_new ((_tmp152 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp151 = vala_ccode_identifier_new ((_tmp150 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma))))), (_tmp152 == NULL ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL))), (_tmp151 == NULL ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL))), (_tmp150 = (g_free (_tmp150), NULL)), _tmp153);
					vala_ccode_node_set_line (((ValaCCodeNode*) (cunref)), vala_ccode_node_get_line (((ValaCCodeNode*) (cblock))));
					vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cunref)));
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					(cunref == NULL ? NULL : (cunref = (vala_ccode_node_unref (cunref), NULL)));
				}
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
		(local_collection == NULL ? NULL : (local_collection = (gee_collection_object_unref (local_collection), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL)));
	(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
	(ccoldecl == NULL ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL)));
	(ccolvardecl == NULL ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL)));
}


static void vala_ccode_base_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeBreakStatement* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_break_statement_new ()))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	vala_ccode_base_module_create_local_free (self, ((ValaCodeNode*) (stmt)), TRUE);
}


static void vala_ccode_base_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeContinueStatement* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_continue_statement_new ()))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	vala_ccode_base_module_create_local_free (self, ((ValaCodeNode*) (stmt)), TRUE);
}


void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeList* local_collection;
		int local_it;
		local_collection = local_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				if (vala_symbol_get_active (((ValaSymbol*) (local))) && vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp4;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp4 = vala_ccode_expression_statement_new ((_tmp3 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))))))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
	}
	if (stop_at_loop) {
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (b)))) || VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (b)))) || VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (b)))) || VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (b)))) || VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (b))))) {
			(b == NULL ? NULL : (b = (vala_code_node_unref (b), NULL)));
			(local_vars == NULL ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL)));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL ? NULL : (b = (vala_code_node_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL)));
}


static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (cfrag != NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp3;
					ValaCCodeExpression* _tmp2;
					ValaCCodeIdentifier* _tmp1;
					char* _tmp0;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (param))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (param)));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					vala_ccode_fragment_append (cfrag, ((ValaCCodeNode*) ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (param))))))))), vala_formal_parameter_get_parameter_type (param), ((ValaExpression*) (ma)))))))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
					_tmp0 = (g_free (_tmp0), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
}


static void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, ((ValaCCodeNode*) (cfrag)));
	(cfrag == NULL ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)));
}


static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop) {
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeList* local_collection;
		int local_it;
		local_collection = local_vars;
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				if (vala_symbol_get_active (((ValaSymbol*) (local))) && vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (local))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (local)));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp3 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (local))))))))), vala_local_variable_get_variable_type (local), ((ValaExpression*) (ma)))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		found = vala_ccode_base_module_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop) || found;
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			found = vala_ccode_base_module_append_param_free_expr (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), ccomma) || found;
		}
	}
	return (_tmp4 = found, (b == NULL ? NULL : (b = (vala_code_node_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL))), _tmp4);
}


static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma) {
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp2;
					ValaCCodeIdentifier* _tmp1;
					char* _tmp0;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) (param))), NULL);
					vala_expression_set_symbol_reference (((ValaExpression*) (ma)), ((ValaSymbol*) (param)));
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp2 = vala_ccode_base_module_get_unref_expression (self, ((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (param))))))))), vala_formal_parameter_get_parameter_type (param), ((ValaExpression*) (ma)))));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
					_tmp0 = (g_free (_tmp0), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	return found;
}


static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (expr_type == NULL ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL))), _tmp2);
	}
	return_expr_decl = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, ((ValaCodeNode*) (expr)));
	ccomma = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (return_expr_decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	if (!vala_ccode_base_module_append_local_free_expr (self, self->current_symbol, ccomma, FALSE)) {
		/* no local variables need to be freed */
		(expr_type == NULL ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)));
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		return;
	}
	_tmp5 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (return_expr_decl))))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
	gee_collection_add (((GeeCollection*) (expr->temp_vars)), return_expr_decl);
	(expr_type == NULL ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)));
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
}


static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	/* avoid unnecessary ref/unref pair*/
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaLocalVariable* _tmp1;
		ValaSymbol* _tmp0;
		ValaLocalVariable* local;
		_tmp1 = NULL;
		_tmp0 = NULL;
		local = (_tmp1 = (_tmp0 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), (VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (vala_data_type_get_value_owned (self->current_return_type) && local != NULL && vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local))) {
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't ref expression*/
			vala_data_type_set_value_owned (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE);
		}
		(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp2;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp2 = vala_ccode_return_statement_new (NULL)))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
		vala_ccode_base_module_create_local_free (self, ((ValaCodeNode*) (stmt)), FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaLocalVariable* _tmp4;
		ValaSymbol* _tmp3;
		ValaLocalVariable* local;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		_tmp4 = NULL;
		_tmp3 = NULL;
		local = (_tmp4 = (_tmp3 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), (VALA_IS_LOCAL_VARIABLE (_tmp3) ? ((ValaLocalVariable*) (_tmp3)) : NULL)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
		if (vala_data_type_get_value_owned (self->current_return_type) && local != NULL && vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local))) {
			ValaSymbol* _tmp6;
			ValaSymbol* _tmp5;
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't unref variable*/
			_tmp6 = NULL;
			_tmp5 = NULL;
			return_expression_symbol = (_tmp6 = (_tmp5 = ((ValaSymbol*) (local)), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL))), _tmp6);
			vala_symbol_set_active (return_expression_symbol, FALSE);
		}
		/* return array length if appropriate*/
		if (self->current_method != NULL && !vala_method_get_no_array_length (self->current_method) && VALA_IS_ARRAY_TYPE (self->current_return_type)) {
			ValaLocalVariable* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp8;
			ValaCCodeIdentifier* _tmp7;
			ValaArrayType* _tmp9;
			ValaArrayType* array_type;
			ValaCCodeIdentifier* _tmp14;
			return_expr_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE, ((ValaCodeNode*) (stmt)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (return_expr_decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
			(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
			_tmp9 = NULL;
			array_type = (_tmp9 = VALA_ARRAY_TYPE (self->current_return_type), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeIdentifier* _tmp11;
					char* _tmp10;
					ValaCCodeUnaryExpression* _tmp12;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp13;
					_tmp11 = NULL;
					_tmp10 = NULL;
					_tmp12 = NULL;
					len_l = (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), "result", dim))))))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
					len_r = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_return_statement_get_return_expression (stmt), dim);
					_tmp13 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_assignment_new (((ValaCCodeExpression*) (len_l)), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
					(len_l == NULL ? NULL : (len_l = (vala_ccode_node_unref (len_l), NULL)));
					(len_r == NULL ? NULL : (len_r = (vala_ccode_node_unref (len_r), NULL)));
				}
			}
			_tmp14 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (return_expr_decl))))))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
			vala_code_node_set_ccodenode (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))), ((ValaCCodeNode*) (ccomma)));
			gee_collection_add (((GeeCollection*) (vala_return_statement_get_return_expression (stmt)->temp_vars)), return_expr_decl);
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		}
		vala_ccode_base_module_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		/* Property getters of non simple structs shall return the struct value as out parameter,
		 therefore replace any return statement with an assignment statement to the out formal
		 paramenter and insert an empty return statement afterwards.*/
		if (self->current_property_accessor != NULL && vala_property_accessor_get_readable (self->current_property_accessor) && vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (self->current_property_accessor)))) {
			ValaCCodeFragment* cfragment;
			ValaCCodeExpressionStatement* _tmp17;
			ValaCCodeAssignment* _tmp16;
			ValaCCodeIdentifier* _tmp15;
			ValaCCodeReturnStatement* _tmp18;
			cfragment = vala_ccode_fragment_new ();
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp15 = NULL;
			vala_ccode_fragment_append (cfragment, ((ValaCCodeNode*) ((_tmp17 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("*value")))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
			(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
			(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
			_tmp18 = NULL;
			vala_ccode_fragment_append (cfragment, ((ValaCCodeNode*) ((_tmp18 = vala_ccode_return_statement_new (NULL)))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
			vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cfragment)));
			(cfragment == NULL ? NULL : (cfragment = (vala_ccode_node_unref (cfragment), NULL)));
		} else {
			ValaCCodeReturnStatement* _tmp19;
			_tmp19 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp19 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))))))))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		}
		vala_ccode_base_module_create_temp_decl (self, ((ValaStatement*) (stmt)), ((GeeList*) (vala_return_statement_get_return_expression (stmt)->temp_vars)));
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL)));
		(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
	}
}


static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp7;
	char* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaMethod* _tmp8;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	char* _tmp15;
	ValaMethod* _tmp14;
	ValaCCodeUnaryExpression* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("self"))), (l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL))), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			l = (_tmp2 = ((ValaCCodeExpression*) (vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (inner_node)))), VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))))), (l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL))), _tmp2);
		} else {
			ValaCCodeExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			l = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (inner_node)))), (_tmp3 == NULL ? NULL : vala_ccode_node_ref (_tmp3))), (l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL))), _tmp4);
		}
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	l = (_tmp7 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_member_access_new_pointer (l, "priv")))), (_tmp6 = vala_ccode_base_module_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))))), (l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL))), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	fc = (_tmp11 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname ((_tmp8 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->mutex_type))), "lock"))))))))))), (fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp9 = (g_free (_tmp9), NULL);
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_ccode_fragment_append (cn, ((ValaCCodeNode*) ((_tmp13 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_lock_statement_get_body (stmt)))));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	fc = (_tmp17 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ((_tmp15 = vala_method_get_cname ((_tmp14 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->mutex_type))), "unlock"))))))))))), (fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp15 = (g_free (_tmp15), NULL);
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL)));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (fc, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_fragment_append (cn, ((ValaCCodeNode*) ((_tmp19 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (fc)))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) (cn)));
	(cn == NULL ? NULL : (cn = (vala_ccode_node_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (vala_ccode_node_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (vala_code_node_unref (inner_node), NULL)));
}


static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaPointerType* _tmp0;
	ValaPointerType* pointer_type;
	ValaDataType* _tmp1;
	ValaDataType* type;
	ValaCCodeExpression* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp6;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	pointer_type = (_tmp0 = VALA_POINTER_TYPE (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	type = (_tmp1 = ((ValaDataType*) (pointer_type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)))) {
		ValaDataType* _tmp3;
		ValaDataType* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		type = (_tmp3 = (_tmp2 = vala_pointer_type_get_base_type (pointer_type), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp3);
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	ccall = (_tmp5 = vala_ccode_function_call_new ((_tmp4 = vala_ccode_base_module_get_destroy_func_expression (self, type))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_delete_statement_get_expression (stmt))))));
	_tmp6 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (stmt)), ((ValaCCodeNode*) ((_tmp6 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
	(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
}


static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr))) != NULL && !vala_expression_get_lvalue (expr)) {
		ValaCCodeExpression* _tmp0;
		/* memory management, implicit casts, and boxing/unboxing*/
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_base_module_transform_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))), vala_expression_get_value_type (expr), vala_expression_get_target_type (expr), expr)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	}
}


static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE"))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr) {
	ValaCCodeBaseModule * self;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new (vala_character_literal_get_value (expr))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	} else {
		ValaCCodeConstant* _tmp2;
		char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("%uU", ((guint) (vala_character_literal_get_char (expr))))))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
		_tmp1 = (g_free (_tmp1), NULL);
	}
}


static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new (vala_real_literal_get_value (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_constant_new ("NULL")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_parenthesized_expression (ValaCCodeModule* base, ValaParenthesizedExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeParenthesizedExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_parenthesized_expression_get_inner (expr))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cname (self, delegate_cname);
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	g_assert_not_reached ();
}


ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cexpression (self, delegate_expr);
}


static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_destroy_notify_cname (self, delegate_cname);
}


static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr) {
	ValaCCodeBaseModule * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp1 = vala_instance_cast_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("self")))), vala_data_type_get_data_type (vala_expression_get_value_type (((ValaExpression*) (expr)))))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp7;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	ma = vala_ccode_base_module_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeBinaryExpression* _tmp5;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp6;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_property_get_property_type (prop), TRUE, ((ValaCodeNode*) (expr)));
		gee_list_insert (((GeeList*) (self->temp_vars)), 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_postfix_expression_get_inner (expr))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		cexpr = (_tmp5 = vala_ccode_binary_expression_new (op, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))), ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_constant_new ("1"))))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp5);
		ccall = vala_ccode_base_module_get_property_set_call (self, prop, ma, ((ValaCCodeExpression*) (cexpr)));
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ccall)));
		/* return previous value*/
		_tmp6 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
		(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		return;
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	_tmp7 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp7 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_postfix_expression_get_inner (expr))))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
}


static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaMemberAccess* _tmp3;
	ValaMemberAccess* ma;
	ValaMemberAccess* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_base_module_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (vala_code_node_unref (pe), NULL))), _tmp1);
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return NULL;
	}
	_tmp3 = NULL;
	ma = (_tmp3 = VALA_MEMBER_ACCESS (expr), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
		return ma;
	}
	_tmp5 = NULL;
	return (_tmp5 = NULL, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp5);
}


gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		if (!(VALA_IS_CLASS (self->current_type_symbol)) || vala_class_get_is_compact (self->current_class)) {
			return FALSE;
		}
	}
	return TRUE;
}


gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		if (!(VALA_IS_CLASS (self->current_type_symbol)) || vala_class_get_is_compact (self->current_class)) {
			return FALSE;
		}
	}
	return TRUE;
}


static ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (VALA_IS_VALUE_TYPE (expression_type) && !vala_data_type_get_nullable (expression_type)) {
		ValaLocalVariable* decl;
		ValaCCodeIdentifier* ctemp;
		ValaValueType* _tmp0;
		ValaValueType* vt;
		ValaStruct* _tmp1;
		ValaStruct* st;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeUnaryExpression* _tmp5;
		ValaCCodeUnaryExpression* _tmp6;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeExpression* _tmp7;
		/* normal value type, no null check
		 (copy (&expr, &temp), temp)*/
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert (((GeeList*) (self->temp_vars)), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (decl))));
		_tmp0 = NULL;
		vt = (_tmp0 = VALA_VALUE_TYPE (expression_type), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_value_type_get_type_symbol (vt)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp4 = NULL;
		copy_call = (_tmp4 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_typesymbol_get_copy_function (((ValaTypeSymbol*) (st))))))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), (_tmp2 = (g_free (_tmp2), NULL)), _tmp4);
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (copy_call, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (copy_call, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (ctemp)))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (copy_call)));
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ctemp)));
		_tmp7 = NULL;
		return (_tmp7 = ((ValaCCodeExpression*) (ccomma)), (decl == NULL ? NULL : (decl = (vala_code_node_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL))), (vt == NULL ? NULL : (vt = (vala_code_node_unref (vt), NULL))), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), (copy_call == NULL ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL))), _tmp7);
	}
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node));
	if (dupexpr == NULL) {
		ValaCCodeExpression* _tmp8;
		vala_code_node_set_error (node, TRUE);
		_tmp8 = NULL;
		return (_tmp8 = NULL, (dupexpr == NULL ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL))), _tmp8);
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	if (expr != NULL && vala_expression_is_non_null (expr)) {
		ValaCCodeExpression* _tmp9;
		/* expression is non-null*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))));
		_tmp9 = NULL;
		return (_tmp9 = ((ValaCCodeExpression*) (ccall)), (dupexpr == NULL ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL))), _tmp9);
	} else {
		ValaLocalVariable* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* _tmp10;
		ValaCCodeBinaryExpression* _tmp11;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp23;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp26;
		ValaCCodeExpression* _tmp27;
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert (((GeeList*) (self->temp_vars)), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (decl))));
		_tmp10 = NULL;
		_tmp11 = NULL;
		cisnull = (_tmp11 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) (ctemp)), ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ("NULL"))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeConstant* _tmp15;
			ValaCCodeExpression* _tmp14;
			ValaCCodeBinaryExpression* _tmp16;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp17;
			if (!(VALA_IS_CLASS (self->current_type_symbol))) {
				ValaCCodeExpression* _tmp12;
				ValaCCodeExpression* _tmp13;
				_tmp12 = NULL;
				_tmp13 = NULL;
				return (_tmp13 = (_tmp12 = cexpr, (_tmp12 == NULL ? NULL : vala_ccode_node_ref (_tmp12))), (decl == NULL ? NULL : (decl = (vala_code_node_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp13);
			}
			/* dup functions are optional for type parameters*/
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp16 = NULL;
			cdupisnull = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp14 = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node))), ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("NULL"))))), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), _tmp16);
			_tmp17 = NULL;
			cisnull = (_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, ((ValaCCodeExpression*) (cisnull)), ((ValaCCodeExpression*) (cdupisnull))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), _tmp17);
			(cdupisnull == NULL ? NULL : (cdupisnull = (vala_ccode_node_unref (cdupisnull), NULL)));
		}
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeCastExpression* _tmp18;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp18 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ctemp)), "gpointer")))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
		} else {
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (ctemp)));
		}
		if (VALA_IS_ARRAY_TYPE (expression_type)) {
			ValaArrayType* _tmp19;
			ValaArrayType* array_type;
			gboolean first;
			ValaCCodeExpression* csizeexpr;
			_tmp19 = NULL;
			array_type = (_tmp19 = VALA_ARRAY_TYPE (expression_type), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19)));
			first = TRUE;
			csizeexpr = NULL;
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					if (first) {
						ValaCCodeExpression* _tmp20;
						_tmp20 = NULL;
						csizeexpr = (_tmp20 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL))), _tmp20);
						first = FALSE;
					} else {
						ValaCCodeExpression* _tmp22;
						ValaCCodeExpression* _tmp21;
						_tmp22 = NULL;
						_tmp21 = NULL;
						csizeexpr = (_tmp22 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (_tmp21 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), expr, dim))))), (csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL))), _tmp22);
						(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
					}
				}
			}
			vala_ccode_function_call_add_argument (ccall, csizeexpr);
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			(csizeexpr == NULL ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp23 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		cifnull = NULL;
		if (vala_data_type_get_data_type (expression_type) != NULL) {
			ValaCCodeExpression* _tmp24;
			_tmp24 = NULL;
			cifnull = (_tmp24 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (cifnull == NULL ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL))), _tmp24);
		} else {
			ValaCCodeExpression* _tmp25;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp25 = NULL;
			cifnull = (_tmp25 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ctemp)), "gpointer"))), (cifnull == NULL ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL))), _tmp25);
		}
		_tmp26 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_conditional_expression_new (((ValaCCodeExpression*) (cisnull)), cifnull, ((ValaCCodeExpression*) (ccall)))))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		_tmp27 = NULL;
		return (_tmp27 = ((ValaCCodeExpression*) (ccomma)), (decl == NULL ? NULL : (decl = (vala_code_node_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL))), (cifnull == NULL ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp27);
	}
	(dupexpr == NULL ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
}


static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* instance;
	ValaCCodeExpression* creation_expr;
	ValaStruct* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaStruct* st;
	GeeList* _tmp2;
	gboolean _tmp3;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	instance = NULL;
	creation_expr = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	st = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), (VALA_IS_STRUCT (_tmp0) ? ((ValaStruct*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	if ((_tmp3 = (st != NULL && !vala_struct_is_simple_type (st)) || gee_collection_get_size (((GeeCollection*) ((_tmp2 = vala_object_creation_expression_get_object_initializer (expr))))) > 0, (_tmp2 == NULL ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL))), _tmp3)) {
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* _tmp5;
		char* _tmp4;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_object_creation_expression_get_type_reference (expr), FALSE, ((ValaCodeNode*) (expr)));
		gee_collection_add (((GeeCollection*) (self->temp_vars)), temp_decl);
		_tmp5 = NULL;
		_tmp4 = NULL;
		instance = (_tmp5 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp4 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (temp_decl)))))))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp5);
		_tmp4 = (g_free (_tmp4), NULL);
		(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
	}
	if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
		ValaCCodeFunctionCall* creation_call;
		ValaCCodeExpression* _tmp25;
		ValaCCodeExpression* _tmp24;
		creation_call = NULL;
		/* no creation method*/
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->glist_type) || vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->gslist_type)) {
			ValaCCodeConstant* _tmp6;
			/* NULL is an empty list*/
			_tmp6 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp6 = vala_ccode_constant_new ("NULL")))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type)) {
				ValaCCodeFunctionCall* _tmp8;
				ValaCCodeIdentifier* _tmp7;
				ValaCCodeConstant* _tmp10;
				char* _tmp9;
				ValaCCodeConstant* _tmp11;
				_tmp8 = NULL;
				_tmp7 = NULL;
				creation_call = (_tmp8 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ("g_object_new"))))), (creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL))), _tmp8);
				(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
				_tmp10 = NULL;
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_constant_new ((_tmp9 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))))))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
				_tmp9 = (g_free (_tmp9), NULL);
				_tmp11 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_constant_new ("NULL")))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp13;
					ValaCCodeIdentifier* _tmp12;
					ValaCCodeConstant* _tmp15;
					char* _tmp14;
					ValaCCodeConstant* _tmp16;
					_tmp13 = NULL;
					_tmp12 = NULL;
					creation_call = (_tmp13 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp12 = vala_ccode_identifier_new ("g_new0"))))), (creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL))), _tmp13);
					(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ((_tmp14 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE)))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
					_tmp14 = (g_free (_tmp14), NULL);
					_tmp16 = NULL;
					vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_constant_new ("1")))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp18;
						ValaCCodeIdentifier* _tmp17;
						ValaCCodeUnaryExpression* _tmp19;
						ValaCCodeConstant* _tmp20;
						ValaCCodeIdentifier* _tmp23;
						char* _tmp22;
						char* _tmp21;
						/* memset needs string.h*/
						self->string_h_needed = TRUE;
						_tmp18 = NULL;
						_tmp17 = NULL;
						creation_call = (_tmp18 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_identifier_new ("memset"))))), (creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL))), _tmp18);
						(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_constant_new ("0")))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
						_tmp23 = NULL;
						_tmp22 = NULL;
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new ((_tmp22 = g_strdup_printf ("sizeof (%s)", (_tmp21 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))))))))));
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
						_tmp22 = (g_free (_tmp22), NULL);
						_tmp21 = (g_free (_tmp21), NULL);
					}
				}
			}
		}
		_tmp25 = NULL;
		_tmp24 = NULL;
		creation_expr = (_tmp25 = (_tmp24 = ((ValaCCodeExpression*) (creation_call)), (_tmp24 == NULL ? NULL : vala_ccode_node_ref (_tmp24))), (creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL))), _tmp25);
		(creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)));
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
			ValaMethod* _tmp26;
			ValaMethod* m;
			GeeList* params;
			ValaCCodeFunctionCall* creation_call;
			ValaCCodeFunctionCall* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			char* _tmp27;
			ValaClass* _tmp32;
			ValaTypeSymbol* _tmp31;
			ValaClass* cl;
			GeeHashMap* carg_map;
			gboolean ellipsis;
			gint i;
			gint arg_pos;
			GeeIterator* params_it;
			gint last_pos;
			gint min_pos;
			ValaCCodeExpression* _tmp52;
			ValaCCodeExpression* _tmp51;
			char* _tmp53;
			gboolean _tmp54;
			/* use creation method*/
			_tmp26 = NULL;
			m = (_tmp26 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26)));
			params = vala_method_get_parameters (m);
			creation_call = NULL;
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			creation_call = (_tmp29 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = vala_method_get_cname (m))))))), (creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL))), _tmp29);
			(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
			_tmp27 = (g_free (_tmp27), NULL);
			if ((st != NULL && !vala_struct_is_simple_type (st)) && !(vala_method_get_cinstance_parameter_position (m) < 0)) {
				ValaCCodeUnaryExpression* _tmp30;
				_tmp30 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp30 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)))));
				(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
			}
			_tmp32 = NULL;
			_tmp31 = NULL;
			cl = (_tmp32 = (_tmp31 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), (VALA_IS_CLASS (_tmp31) ? ((ValaClass*) (_tmp31)) : NULL)), (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32)));
			if (cl != NULL && !vala_class_get_is_compact (cl)) {
				{
					GeeList* type_arg_collection;
					int type_arg_it;
					type_arg_collection = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
						ValaDataType* type_arg;
						type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
						{
							ValaCCodeExpression* _tmp33;
							_tmp33 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (_tmp33 = vala_ccode_base_module_get_type_id_expression (self, type_arg)));
							(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
							if (vala_ccode_base_module_requires_copy (self, type_arg)) {
								ValaCCodeExpression* dup_func;
								ValaCCodeCastExpression* _tmp34;
								ValaCCodeExpression* _tmp35;
								dup_func = vala_ccode_base_module_get_dup_func_expression (self, type_arg, vala_code_node_get_source_reference (((ValaCodeNode*) (type_arg))));
								if (dup_func == NULL) {
									/* type doesn't contain a copy function*/
									vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
									(dup_func == NULL ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL)));
									(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
									(type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL)));
									(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
									(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
									(creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)));
									(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
									(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
									(creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)));
									(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
									return;
								}
								_tmp34 = NULL;
								vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")))));
								(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
								_tmp35 = NULL;
								vala_ccode_function_call_add_argument (creation_call, (_tmp35 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg)));
								(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
								(dup_func == NULL ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL)));
							} else {
								ValaCCodeConstant* _tmp36;
								ValaCCodeConstant* _tmp37;
								_tmp36 = NULL;
								vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp36 = vala_ccode_constant_new ("NULL")))));
								(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
								_tmp37 = NULL;
								vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_constant_new ("NULL")))));
								(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
							}
							(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
						}
					}
					(type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL)));
				}
			}
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			ellipsis = FALSE;
			i = 1;
			arg_pos = 0;
			params_it = gee_iterable_iterator (((GeeIterable*) (params)));
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_object_creation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaCCodeExpression* _tmp38;
						ValaCCodeExpression* cexpr;
						ValaFormalParameter* param;
						_tmp38 = NULL;
						cexpr = (_tmp38 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (arg)))), (_tmp38 == NULL ? NULL : vala_ccode_node_ref (_tmp38)));
						param = NULL;
						if (gee_iterator_next (params_it)) {
							ValaFormalParameter* _tmp39;
							_tmp39 = NULL;
							param = (_tmp39 = ((ValaFormalParameter*) (gee_iterator_get (params_it))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp39);
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!ellipsis) {
								ValaCCodeExpression* _tmp44;
								if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaArrayType* _tmp40;
									ValaArrayType* array_type;
									_tmp40 = NULL;
									array_type = (_tmp40 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
									{
										gint dim;
										dim = 1;
										for (; dim <= vala_array_type_get_rank (array_type); dim++) {
											ValaCCodeExpression* _tmp41;
											_tmp41 = NULL;
											gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp41 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), arg, dim)));
											(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
										}
									}
									(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
								} else {
									if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
										ValaDelegateType* _tmp42;
										ValaDelegateType* deleg_type;
										ValaDelegate* _tmp43;
										ValaDelegate* d;
										_tmp42 = NULL;
										deleg_type = (_tmp42 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42)));
										_tmp43 = NULL;
										d = (_tmp43 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp43 == NULL ? NULL : vala_code_node_ref (_tmp43)));
										if (vala_delegate_get_has_target (d)) {
											ValaCCodeExpression* delegate_target;
											delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, arg);
											gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
											(delegate_target == NULL ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)));
										}
										(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
										(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
									}
								}
								_tmp44 = NULL;
								cexpr = (_tmp44 = vala_ccode_base_module_handle_struct_argument (self, param, arg, cexpr), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp44);
							}
							arg_pos = vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
						} else {
							/* default argument position*/
							arg_pos = vala_ccode_base_module_get_param_pos (self, ((double) (i)), ellipsis);
						}
						gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (arg_pos), cexpr);
						i++;
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp45;
					_tmp45 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp45 = g_strdup_printf ("no default expression for argument %d", i)));
					_tmp45 = (g_free (_tmp45), NULL);
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
					(creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)));
					(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
					(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
					(params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL)));
					(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
					(creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)));
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (((ValaCodeNode*) (vala_formal_parameter_get_default_expression (param))), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
				gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_formal_parameter_get_default_expression (param))))));
				i++;
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
			/* append C arguments in the right order*/
			last_pos = -1;
			min_pos = 0;
			while (TRUE) {
				ValaCCodeExpression* _tmp46;
				min_pos = -1;
				{
					GeeSet* pos_collection;
					GeeIterator* pos_it;
					pos_collection = gee_map_get_keys (((GeeMap*) (carg_map)));
					pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
					while (gee_iterator_next (pos_it)) {
						gint pos;
						pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
						{
							if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
								min_pos = pos;
							}
						}
					}
					(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
					(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
				}
				if (min_pos == -1) {
					break;
				}
				_tmp46 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (_tmp46 = ((ValaCCodeExpression*) (gee_map_get (((GeeMap*) (carg_map)), GINT_TO_POINTER (min_pos))))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
				last_pos = min_pos;
			}
			if ((st != NULL && !vala_struct_is_simple_type (st)) && vala_method_get_cinstance_parameter_position (m) < 0) {
				ValaCCodeUnaryExpression* _tmp47;
				/* instance parameter is at the end in a struct creation method*/
				_tmp47 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp47 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)))));
				(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
			}
			if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (expr)))) {
				ValaCCodeUnaryExpression* _tmp49;
				ValaCCodeIdentifier* _tmp48;
				/* method can fail*/
				self->current_method_inner_error = TRUE;
				_tmp49 = NULL;
				_tmp48 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp49 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp48 = vala_ccode_identifier_new ("inner_error")))))))));
				(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
				(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
			}
			if (ellipsis) {
				/* ensure variable argument list ends with NULL
				 * except when using printf-style arguments */
				if (!vala_method_get_printf_format (m) && _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0) {
					ValaCCodeConstant* _tmp50;
					_tmp50 = NULL;
					vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp50 = vala_ccode_constant_new (vala_method_get_sentinel (m))))));
					(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
				}
			}
			_tmp52 = NULL;
			_tmp51 = NULL;
			creation_expr = (_tmp52 = (_tmp51 = ((ValaCCodeExpression*) (creation_call)), (_tmp51 == NULL ? NULL : vala_ccode_node_ref (_tmp51))), (creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL))), _tmp52);
			/* cast the return value of the creation method back to the intended type if
			 it requested a special C return type*/
			_tmp53 = NULL;
			if ((_tmp54 = (_tmp53 = vala_ccode_module_get_custom_creturn_type (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), m)) != NULL, (_tmp53 = (g_free (_tmp53), NULL)), _tmp54)) {
				ValaCCodeExpression* _tmp56;
				char* _tmp55;
				_tmp56 = NULL;
				_tmp55 = NULL;
				creation_expr = (_tmp56 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (creation_expr, (_tmp55 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr)))))), (creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL))), _tmp56);
				_tmp55 = (g_free (_tmp55), NULL);
			}
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
			(creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)));
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
			(params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL)));
		} else {
			if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
				ValaErrorCode* _tmp57;
				ValaErrorCode* ecode;
				ValaErrorDomain* _tmp58;
				ValaErrorDomain* edomain;
				ValaCCodeFunctionCall* creation_call;
				ValaCCodeFunctionCall* _tmp60;
				ValaCCodeIdentifier* _tmp59;
				ValaCCodeIdentifier* _tmp62;
				char* _tmp61;
				ValaCCodeIdentifier* _tmp64;
				char* _tmp63;
				ValaCCodeExpression* _tmp66;
				ValaCCodeExpression* _tmp65;
				_tmp57 = NULL;
				ecode = (_tmp57 = VALA_ERROR_CODE (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp57 == NULL ? NULL : vala_code_node_ref (_tmp57)));
				_tmp58 = NULL;
				edomain = (_tmp58 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (((ValaSymbol*) (ecode)))), (_tmp58 == NULL ? NULL : vala_code_node_ref (_tmp58)));
				creation_call = NULL;
				_tmp60 = NULL;
				_tmp59 = NULL;
				creation_call = (_tmp60 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp59 = vala_ccode_identifier_new ("g_error_new"))))), (creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL))), _tmp60);
				(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
				_tmp62 = NULL;
				_tmp61 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp62 = vala_ccode_identifier_new ((_tmp61 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (edomain)), NULL)))))));
				(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
				_tmp61 = (g_free (_tmp61), NULL);
				_tmp64 = NULL;
				_tmp63 = NULL;
				vala_ccode_function_call_add_argument (creation_call, ((ValaCCodeExpression*) ((_tmp64 = vala_ccode_identifier_new ((_tmp63 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (ecode)), FALSE)))))));
				(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
				_tmp63 = (g_free (_tmp63), NULL);
				{
					GeeList* arg_collection;
					int arg_it;
					arg_collection = vala_object_creation_expression_get_argument_list (expr);
					for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
						ValaExpression* arg;
						arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
						{
							vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (arg)))));
							(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						}
					}
					(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
				}
				_tmp66 = NULL;
				_tmp65 = NULL;
				creation_expr = (_tmp66 = (_tmp65 = ((ValaCCodeExpression*) (creation_call)), (_tmp65 == NULL ? NULL : vala_ccode_node_ref (_tmp65))), (creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL))), _tmp66);
				(ecode == NULL ? NULL : (ecode = (vala_code_node_unref (ecode), NULL)));
				(edomain == NULL ? NULL : (edomain = (vala_code_node_unref (edomain), NULL)));
				(creation_call == NULL ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, creation_expr);
		} else {
			ValaCCodeAssignment* _tmp67;
			_tmp67 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp67 = vala_ccode_assignment_new (instance, creation_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
		}
		{
			GeeList* init_collection;
			int init_it;
			init_collection = vala_object_creation_expression_get_object_initializer (expr);
			for (init_it = 0; init_it < gee_collection_get_size (GEE_COLLECTION (init_collection)); init_it = init_it + 1) {
				ValaMemberInitializer* init;
				init = ((ValaMemberInitializer*) (gee_list_get (GEE_LIST (init_collection), init_it)));
				{
					if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
						ValaField* _tmp68;
						ValaField* f;
						ValaDataType* instance_target_type;
						ValaCCodeExpression* typed_inst;
						ValaCCodeExpression* lhs;
						ValaCCodeAssignment* _tmp73;
						_tmp68 = NULL;
						f = (_tmp68 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp68 == NULL ? NULL : vala_code_node_ref (_tmp68)));
						instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))));
						typed_inst = vala_ccode_base_module_transform_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type, NULL);
						lhs = NULL;
						if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
							ValaCCodeExpression* _tmp70;
							char* _tmp69;
							_tmp70 = NULL;
							_tmp69 = NULL;
							lhs = (_tmp70 = ((ValaCCodeExpression*) (vala_ccode_member_access_new (typed_inst, (_tmp69 = vala_field_get_cname (f)), FALSE))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp70);
							_tmp69 = (g_free (_tmp69), NULL);
						} else {
							ValaCCodeExpression* _tmp72;
							char* _tmp71;
							_tmp72 = NULL;
							_tmp71 = NULL;
							lhs = (_tmp72 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (typed_inst, (_tmp71 = vala_field_get_cname (f))))), (lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL))), _tmp72);
							_tmp71 = (g_free (_tmp71), NULL);
						}
						_tmp73 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp73 = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_initializer_get_initializer (init))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
						(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
						(instance_target_type == NULL ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL)));
						(typed_inst == NULL ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL)));
						(lhs == NULL ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)));
					} else {
						if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
							ValaMemberAccess* inst_ma;
							ValaMemberAccess* ma;
							ValaCCodeFunctionCall* _tmp74;
							inst_ma = vala_member_access_new_simple ("new", NULL);
							vala_expression_set_value_type (((ValaExpression*) (inst_ma)), vala_object_creation_expression_get_type_reference (expr));
							vala_code_node_set_ccodenode (((ValaCodeNode*) (inst_ma)), ((ValaCCodeNode*) (instance)));
							ma = vala_member_access_new (((ValaExpression*) (inst_ma)), vala_member_initializer_get_name (init), NULL);
							_tmp74 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp74 = vala_ccode_base_module_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_initializer_get_initializer (init))))))))));
							(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
							(inst_ma == NULL ? NULL : (inst_ma = (vala_code_node_unref (inst_ma), NULL)));
							(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
						}
					}
					(init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL)));
				}
			}
			(init_collection == NULL ? NULL : (init_collection = (gee_collection_object_unref (init_collection), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
	} else {
		if (creation_expr != NULL) {
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (creation_expr)));
		}
	}
	(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
	(creation_expr == NULL ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)));
	(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
}


ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr) {
	ValaCCodeExpression* _tmp10;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	/* pass non-simple struct instances always by reference*/
	if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))))) {
		/* we already use a reference for arguments of ref, out, and nullable parameters*/
		if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
			ValaCCodeUnaryExpression* _tmp1;
			ValaCCodeExpression* _tmp0;
			ValaCCodeUnaryExpression* unary;
			_tmp1 = NULL;
			_tmp0 = NULL;
			unary = (_tmp1 = (_tmp0 = cexpr, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp0) ? ((ValaCCodeUnaryExpression*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp2;
				ValaCCodeExpression* _tmp3;
				/* *expr => expr*/
				_tmp2 = NULL;
				_tmp3 = NULL;
				return (_tmp3 = (_tmp2 = vala_ccode_unary_expression_get_inner (unary), (_tmp2 == NULL ? NULL : vala_ccode_node_ref (_tmp2))), (unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL))), _tmp3);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (cexpr) || VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
					ValaCCodeExpression* _tmp4;
					_tmp4 = NULL;
					return (_tmp4 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr))), (unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL))), _tmp4);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp6;
					ValaCCodeIdentifier* _tmp5;
					ValaCCodeUnaryExpression* _tmp8;
					ValaCCodeIdentifier* _tmp7;
					ValaCCodeExpression* _tmp9;
					/* if cexpr is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (arg), TRUE, NULL);
					gee_list_insert (((GeeList*) (self->temp_vars)), 0, temp_var);
					_tmp6 = NULL;
					_tmp5 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
					(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
					_tmp8 = NULL;
					_tmp7 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))))))));
					(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
					(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
					_tmp9 = NULL;
					return (_tmp9 = ((ValaCCodeExpression*) (ccomma)), (temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL))), (unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL))), _tmp9);
				}
			}
			(unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)));
		}
	}
	_tmp10 = NULL;
	return (_tmp10 = cexpr, (_tmp10 == NULL ? NULL : vala_ccode_node_ref (_tmp10)));
}


static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("sizeof"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_data_type_get_cname (vala_sizeof_expression_get_type_reference (expr))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (csizeof)));
	(csizeof == NULL ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL)));
}


static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_base_module_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	op = 0;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_unary_expression_get_inner (expr))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	ValaInterface* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaInterface* iface;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	iface = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), (VALA_IS_INTERFACE (_tmp2) ? ((ValaInterface*) (_tmp2)) : NULL)), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	if (iface != NULL || (cl != NULL && !vala_class_get_is_compact (cl))) {
		/* checked cast for strict subtypes of GTypeInstance*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeExpression* ccheck;
			char* _tmp4;
			ValaCCodeCastExpression* _tmp5;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp6;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_cast_expression_get_inner (expr)), TRUE, ((ValaCodeNode*) (expr)));
			gee_collection_add (((GeeCollection*) (self->temp_vars)), temp_decl);
			ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))));
			cinit = vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_cast_expression_get_inner (expr))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_base_module_create_type_check (self, ((ValaCCodeNode*) (ctemp)), vala_cast_expression_get_type_reference (expr));
			_tmp4 = NULL;
			_tmp5 = NULL;
			ccast = (_tmp5 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ctemp)), (_tmp4 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cinit)));
			_tmp6 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_conditional_expression_new (ccheck, ((ValaCCodeExpression*) (ccast)), ((ValaCCodeExpression*) (cnull)))))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
			(ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)));
			(cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)));
			(ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)));
			(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
			(cnull == NULL ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL)));
		} else {
			ValaInstanceCast* _tmp7;
			_tmp7 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp7 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_cast_expression_get_inner (expr))))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)))))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		}
	} else {
		ValaCCodeCastExpression* _tmp9;
		char* _tmp8;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Operation not supported for this type");
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
			return;
		}
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp9 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_cast_expression_get_inner (expr))))), (_tmp8 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr))))))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		_tmp8 = (g_free (_tmp8), NULL);
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
}


static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_pointer_indirection_get_inner (expr))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_addressof_expression_get_inner (expr))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE, ((ValaCodeNode*) (expr)));
	gee_list_insert (((GeeList*) (self->temp_vars)), 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_assignment_new (((ValaCCodeExpression*) (cvar)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_reference_transfer_expression_get_inner (expr))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_reference_transfer_expression_get_inner (expr))))), ((ValaCCodeExpression*) ((_tmp1 = vala_ccode_constant_new ("NULL")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cvar)));
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
	(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL)));
}


static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	ValaCCodeBinaryExpression* _tmp47;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_binary_expression_get_left (expr))))), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_binary_expression_get_right (expr))))), (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1)));
	op = 0;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaTypeSymbol* _tmp2;
																				ValaTypeSymbol* container_type;
																				ValaCCodeBinaryExpression* _tmp18;
																				ValaCCodeParenthesizedExpression* _tmp17;
																				ValaCCodeParenthesizedExpression* _tmp16;
																				ValaCCodeBinaryExpression* _tmp15;
																				ValaCCodeParenthesizedExpression* _tmp14;
																				ValaCCodeParenthesizedExpression* _tmp13;
																				_tmp2 = NULL;
																				container_type = (_tmp2 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
																				if (container_type != NULL && self->collection_type != NULL && self->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->collection_type))) || vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->map_type))))) {
																					ValaMethod* contains_method;
																					contains_method = NULL;
																					if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->collection_type)))) {
																						ValaMethod* _tmp3;
																						ValaCCodeIdentifier* _tmp5;
																						char* _tmp4;
																						ValaCCodeFunctionCall* _tmp6;
																						ValaCCodeFunctionCall* contains_ccall;
																						ValaInstanceCast* _tmp7;
																						_tmp3 = NULL;
																						contains_method = (_tmp3 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->collection_type))), "contains")), (contains_method == NULL ? NULL : (contains_method = (vala_code_node_unref (contains_method), NULL))), _tmp3);
																						g_assert (contains_method != NULL);
																						_tmp5 = NULL;
																						_tmp4 = NULL;
																						_tmp6 = NULL;
																						contains_ccall = (_tmp6 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_method_get_cname (contains_method))))))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp6);
																						_tmp7 = NULL;
																						vala_ccode_function_call_add_argument (contains_ccall, ((ValaCCodeExpression*) ((_tmp7 = vala_instance_cast_new (cright, ((ValaTypeSymbol*) (self->collection_type)))))));
																						(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
																						vala_ccode_function_call_add_argument (contains_ccall, cleft);
																						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (contains_ccall)));
																						(contains_ccall == NULL ? NULL : (contains_ccall = (vala_ccode_node_unref (contains_ccall), NULL)));
																					} else {
																						ValaMethod* _tmp8;
																						ValaCCodeIdentifier* _tmp10;
																						char* _tmp9;
																						ValaCCodeFunctionCall* _tmp11;
																						ValaCCodeFunctionCall* contains_ccall;
																						ValaInstanceCast* _tmp12;
																						_tmp8 = NULL;
																						contains_method = (_tmp8 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->map_type))), "contains")), (contains_method == NULL ? NULL : (contains_method = (vala_code_node_unref (contains_method), NULL))), _tmp8);
																						g_assert (contains_method != NULL);
																						_tmp10 = NULL;
																						_tmp9 = NULL;
																						_tmp11 = NULL;
																						contains_ccall = (_tmp11 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname (contains_method))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
																						_tmp12 = NULL;
																						vala_ccode_function_call_add_argument (contains_ccall, ((ValaCCodeExpression*) ((_tmp12 = vala_instance_cast_new (cright, ((ValaTypeSymbol*) (self->map_type)))))));
																						(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
																						vala_ccode_function_call_add_argument (contains_ccall, cleft);
																						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (contains_ccall)));
																						(contains_ccall == NULL ? NULL : (contains_ccall = (vala_ccode_node_unref (contains_ccall), NULL)));
																					}
																					(contains_method == NULL ? NULL : (contains_method = (vala_code_node_unref (contains_method), NULL)));
																					(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
																					(cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)));
																					(cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)));
																					return;
																				}
																				_tmp18 = NULL;
																				_tmp17 = NULL;
																				_tmp16 = NULL;
																				_tmp15 = NULL;
																				_tmp14 = NULL;
																				_tmp13 = NULL;
																				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp18 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_parenthesized_expression_new (cright)))), ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_parenthesized_expression_new (cleft)))))))))))), ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_parenthesized_expression_new (cleft)))))))));
																				(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
																				(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
																				(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
																				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
																				(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
																				(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
																				(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
																				(cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)));
																				(cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)));
																				return;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		ValaStruct* _tmp20;
		ValaTypeSymbol* _tmp19;
		ValaStruct* left_type_as_struct;
		ValaStruct* _tmp22;
		ValaTypeSymbol* _tmp21;
		ValaStruct* right_type_as_struct;
		_tmp20 = NULL;
		_tmp19 = NULL;
		left_type_as_struct = (_tmp20 = (_tmp19 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))), (VALA_IS_STRUCT (_tmp19) ? ((ValaStruct*) (_tmp19)) : NULL)), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
		_tmp22 = NULL;
		_tmp21 = NULL;
		right_type_as_struct = (_tmp22 = (_tmp21 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), (VALA_IS_STRUCT (_tmp21) ? ((ValaStruct*) (_tmp21)) : NULL)), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22)));
		if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) && !vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))))) && VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) && !vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))))))) {
			ValaClass* _tmp23;
			ValaClass* left_cl;
			ValaClass* _tmp24;
			ValaClass* right_cl;
			_tmp23 = NULL;
			left_cl = (_tmp23 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))), (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23)));
			_tmp24 = NULL;
			right_cl = (_tmp24 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (left_cl)), ((ValaTypeSymbol*) (right_cl)))) {
					ValaCCodeExpression* _tmp25;
					_tmp25 = NULL;
					cleft = (_tmp25 = ((ValaCCodeExpression*) (vala_instance_cast_new (cleft, ((ValaTypeSymbol*) (right_cl))))), (cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL))), _tmp25);
				} else {
					if (vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (right_cl)), ((ValaTypeSymbol*) (left_cl)))) {
						ValaCCodeExpression* _tmp26;
						_tmp26 = NULL;
						cright = (_tmp26 = ((ValaCCodeExpression*) (vala_instance_cast_new (cright, ((ValaTypeSymbol*) (left_cl))))), (cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL))), _tmp26);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (vala_code_node_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (vala_code_node_unref (right_cl), NULL)));
		} else {
			if (left_type_as_struct != NULL && VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
				ValaCCodeExpression* _tmp27;
				_tmp27 = NULL;
				cleft = (_tmp27 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cleft))), (cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL))), _tmp27);
			} else {
				if (right_type_as_struct != NULL && VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
					ValaCCodeExpression* _tmp28;
					_tmp28 = NULL;
					cright = (_tmp28 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cright))), (cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL))), _tmp28);
				}
			}
		}
		(left_type_as_struct == NULL ? NULL : (left_type_as_struct = (vala_code_node_unref (left_type_as_struct), NULL)));
		(right_type_as_struct == NULL ? NULL : (right_type_as_struct = (vala_code_node_unref (right_type_as_struct), NULL)));
	}
	if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) && vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->string_type) && !(VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) && vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->string_type)) {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
			/* string concatenation*/
			if (vala_expression_is_constant (vala_binary_expression_get_left (expr)) && vala_expression_is_constant (vala_binary_expression_get_right (expr))) {
				char* left;
				char* right;
				ValaCCodeConstant* _tmp38;
				char* _tmp37;
				left = NULL;
				right = NULL;
				if (VALA_IS_CCODE_IDENTIFIER (cleft)) {
					char* _tmp30;
					const char* _tmp29;
					_tmp30 = NULL;
					_tmp29 = NULL;
					left = (_tmp30 = (_tmp29 = vala_ccode_identifier_get_name ((VALA_CCODE_IDENTIFIER (cleft))), (_tmp29 == NULL ? NULL : g_strdup (_tmp29))), (left = (g_free (left), NULL)), _tmp30);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cleft)) {
						char* _tmp32;
						const char* _tmp31;
						_tmp32 = NULL;
						_tmp31 = NULL;
						left = (_tmp32 = (_tmp31 = vala_ccode_constant_get_name ((VALA_CCODE_CONSTANT (cleft))), (_tmp31 == NULL ? NULL : g_strdup (_tmp31))), (left = (g_free (left), NULL)), _tmp32);
					}
				}
				if (VALA_IS_CCODE_IDENTIFIER (cright)) {
					char* _tmp34;
					const char* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					right = (_tmp34 = (_tmp33 = vala_ccode_identifier_get_name ((VALA_CCODE_IDENTIFIER (cright))), (_tmp33 == NULL ? NULL : g_strdup (_tmp33))), (right = (g_free (right), NULL)), _tmp34);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cright)) {
						char* _tmp36;
						const char* _tmp35;
						_tmp36 = NULL;
						_tmp35 = NULL;
						right = (_tmp36 = (_tmp35 = vala_ccode_constant_get_name ((VALA_CCODE_CONSTANT (cright))), (_tmp35 == NULL ? NULL : g_strdup (_tmp35))), (right = (g_free (right), NULL)), _tmp36);
					}
				}
				_tmp38 = NULL;
				_tmp37 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp38 = vala_ccode_constant_new ((_tmp37 = g_strdup_printf ("%s %s", left, right)))))));
				(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
				_tmp37 = (g_free (_tmp37), NULL);
				left = (g_free (left), NULL);
				right = (g_free (right), NULL);
				(cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)));
				(cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)));
				return;
			} else {
				ValaCCodeIdentifier* _tmp39;
				ValaCCodeFunctionCall* _tmp40;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp41;
				/* convert to g_strconcat (a, b, NULL)*/
				_tmp39 = NULL;
				_tmp40 = NULL;
				ccall = (_tmp40 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ("g_strconcat"))))), (_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL))), _tmp40);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp41 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp41 = vala_ccode_constant_new ("NULL")))));
				(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
				(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
				(cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)));
				(cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)));
				return;
			}
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
				ValaCCodeIdentifier* _tmp42;
				ValaCCodeFunctionCall* _tmp43;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp45;
				ValaCCodeExpression* _tmp44;
				ValaCCodeExpression* _tmp46;
				self->requires_strcmp0 = TRUE;
				_tmp42 = NULL;
				_tmp43 = NULL;
				ccall = (_tmp43 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp42 = vala_ccode_identifier_new ("_vala_strcmp0"))))), (_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL))), _tmp43);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp45 = NULL;
				_tmp44 = NULL;
				cleft = (_tmp45 = (_tmp44 = ((ValaCCodeExpression*) (ccall)), (_tmp44 == NULL ? NULL : vala_ccode_node_ref (_tmp44))), (cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL))), _tmp45);
				_tmp46 = NULL;
				cright = (_tmp46 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("0"))), (cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL))), _tmp46);
				(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
			}
		}
	}
	_tmp47 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp47 = vala_ccode_binary_expression_new (op, cleft, cright)))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
	(cleft == NULL ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)));
}


char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type) {
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = type, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (cl != NULL && vala_class_get_type_check_function (cl) != NULL) {
		const char* _tmp2;
		char* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = vala_class_get_type_check_function (cl), (_tmp2 == NULL ? NULL : g_strdup (_tmp2))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp3);
	} else {
		char* _tmp4;
		_tmp4 = NULL;
		return (_tmp4 = vala_typesymbol_get_upper_case_cname (type, "IS_"), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp4);
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type) {
	ValaErrorType* _tmp1;
	ValaDataType* _tmp0;
	ValaErrorType* et;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ccodenode != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	et = (_tmp1 = (_tmp0 = type, (VALA_IS_ERROR_TYPE (_tmp0) ? ((ValaErrorType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (et != NULL && vala_error_type_get_error_code (et) != NULL) {
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeFunctionCall* _tmp3;
		ValaCCodeFunctionCall* matches_call;
		ValaCCodeIdentifier* _tmp5;
		char* _tmp4;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeExpression* _tmp8;
		_tmp2 = NULL;
		_tmp3 = NULL;
		matches_call = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("g_error_matches"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
		vala_ccode_function_call_add_argument (matches_call, VALA_CCODE_EXPRESSION (ccodenode));
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_function_call_add_argument (matches_call, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (vala_error_type_get_error_domain (et))), NULL)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (matches_call, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (vala_error_type_get_error_code (et))), FALSE)))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
		_tmp8 = NULL;
		return (_tmp8 = ((ValaCCodeExpression*) (matches_call)), (et == NULL ? NULL : (et = (vala_code_node_unref (et), NULL))), _tmp8);
	} else {
		if (et != NULL && vala_error_type_get_error_domain (et) != NULL) {
			ValaCCodeMemberAccess* instance_domain;
			char* _tmp9;
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeIdentifier* type_domain;
			ValaCCodeExpression* _tmp11;
			instance_domain = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccodenode), "domain");
			_tmp9 = NULL;
			_tmp10 = NULL;
			type_domain = (_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (vala_error_type_get_error_domain (et))), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10);
			_tmp11 = NULL;
			return (_tmp11 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) (instance_domain)), ((ValaCCodeExpression*) (type_domain))))), (instance_domain == NULL ? NULL : (instance_domain = (vala_ccode_node_unref (instance_domain), NULL))), (type_domain == NULL ? NULL : (type_domain = (vala_ccode_node_unref (type_domain), NULL))), (et == NULL ? NULL : (et = (vala_code_node_unref (et), NULL))), _tmp11);
		} else {
			ValaCCodeIdentifier* _tmp13;
			char* _tmp12;
			ValaCCodeFunctionCall* _tmp14;
			ValaCCodeFunctionCall* ccheck;
			ValaCCodeExpression* _tmp15;
			_tmp13 = NULL;
			_tmp12 = NULL;
			_tmp14 = NULL;
			ccheck = (_tmp14 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_ccode_base_module_get_type_check_function (self, vala_data_type_get_data_type (type)))))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp14);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
			_tmp15 = NULL;
			return (_tmp15 = ((ValaCCodeExpression*) (ccheck)), (et == NULL ? NULL : (et = (vala_code_node_unref (et), NULL))), _tmp15);
		}
	}
	(et == NULL ? NULL : (et = (vala_code_node_unref (et), NULL)));
}


static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_base_module_create_type_check (self, vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_typecheck_get_expression (expr)))), vala_typecheck_get_type_reference (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_conditional_expression (ValaCCodeModule* base, ValaConditionalExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConditionalExpression* _tmp0;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_conditional_expression_get_condition (expr))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_conditional_expression_get_true_expression (expr))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_conditional_expression_get_false_expression (expr))))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
}


static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l) {
	ValaCCodeBaseModule * self;
	ValaDelegateType* _tmp0;
	ValaDelegateType* dt;
	GeeArrayList* _tmp1;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp2;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp3;
	GeeArrayList* _tmp4;
	GeeArrayList* _tmp6;
	GeeArrayList* _tmp5;
	GeeArrayList* _tmp8;
	GeeArrayList* _tmp7;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	self = ((ValaCCodeBaseModule*) (base));
	g_return_if_fail (l != NULL);
	/* use instance position from delegate*/
	_tmp0 = NULL;
	dt = (_tmp0 = VALA_DELEGATE_TYPE (vala_expression_get_target_type (((ValaExpression*) (l)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	vala_method_set_cinstance_parameter_position (vala_lambda_expression_get_method (l), vala_delegate_get_cinstance_parameter_position (vala_delegate_type_get_delegate_symbol (dt)));
	_tmp1 = NULL;
	old_temp_vars = (_tmp1 = self->temp_vars, (_tmp1 == NULL ? NULL : gee_collection_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_temp_ref_vars = (_tmp2 = self->temp_ref_vars, (_tmp2 == NULL ? NULL : gee_collection_object_ref (_tmp2)));
	_tmp3 = NULL;
	self->temp_vars = (_tmp3 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal), (self->temp_vars == NULL ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL))), _tmp3);
	_tmp4 = NULL;
	self->temp_ref_vars = (_tmp4 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal), (self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL))), _tmp4);
	vala_code_node_accept_children (((ValaCodeNode*) (l)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->temp_vars = (_tmp6 = (_tmp5 = old_temp_vars, (_tmp5 == NULL ? NULL : gee_collection_object_ref (_tmp5))), (self->temp_vars == NULL ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->temp_ref_vars = (_tmp8 = (_tmp7 = old_temp_ref_vars, (_tmp7 == NULL ? NULL : gee_collection_object_ref (_tmp7))), (self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode (((ValaCodeNode*) (l)), ((ValaCCodeNode*) ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname (vala_lambda_expression_get_method (l))))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp9 = (g_free (_tmp9), NULL);
	(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
	(old_temp_vars == NULL ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL)));
	(old_temp_ref_vars == NULL ? NULL : (old_temp_ref_vars = (gee_collection_object_unref (old_temp_ref_vars), NULL)));
}


ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeExpression* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("GPOINTER_TO_UINT"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = (_tmp4 = ((ValaCCodeExpression*) (cconv)), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4))), (result == NULL ? NULL : (result = (vala_ccode_node_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeExpression* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new ("GPOINTER_TO_INT"))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = (_tmp8 = ((ValaCCodeExpression*) (cconv)), (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (result == NULL ? NULL : (result = (vala_ccode_node_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
	} else {
		if (vala_data_type_get_data_type (actual_type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (actual_type))) {
			ValaCCodeExpression* _tmp11;
			char* _tmp10;
			_tmp11 = NULL;
			_tmp10 = NULL;
			result = (_tmp11 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (cexpr, (_tmp10 = vala_data_type_get_cname (actual_type))))), (result == NULL ? NULL : (result = (vala_ccode_node_unref (result), NULL))), _tmp11);
			_tmp10 = (g_free (_tmp10), NULL);
		}
	}
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeExpression* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("GUINT_TO_POINTER"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = (_tmp4 = ((ValaCCodeExpression*) (cconv)), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4))), (result == NULL ? NULL : (result = (vala_ccode_node_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeExpression* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp6 = vala_ccode_identifier_new ("GINT_TO_POINTER"))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = (_tmp8 = ((ValaCCodeExpression*) (cconv)), (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (result == NULL ? NULL : (result = (vala_ccode_node_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
	}
	return result;
}


/* manage memory and implicit casts*/
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	gboolean boxing;
	gboolean unboxing;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	if (expression_type == NULL) {
		return cexpr;
	}
	if (vala_data_type_get_value_owned (expression_type) && vala_data_type_get_floating_reference (expression_type)) {
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeFunctionCall* _tmp3;
		ValaCCodeFunctionCall* csink;
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* _tmp4;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		_tmp2 = NULL;
		_tmp3 = NULL;
		csink = (_tmp3 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_identifier_new ("g_object_ref_sink"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
		vala_ccode_function_call_add_argument (csink, cexpr);
		_tmp5 = NULL;
		_tmp4 = NULL;
		cexpr = (_tmp5 = (_tmp4 = ((ValaCCodeExpression*) (csink)), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp5);
		(csink == NULL ? NULL : (csink = (vala_ccode_node_unref (csink), NULL)));
	}
	boxing = (VALA_IS_VALUE_TYPE (expression_type) && !vala_data_type_get_nullable (expression_type) && VALA_IS_VALUE_TYPE (target_type) && vala_data_type_get_nullable (target_type));
	unboxing = (VALA_IS_VALUE_TYPE (expression_type) && vala_data_type_get_nullable (expression_type) && VALA_IS_VALUE_TYPE (target_type) && !vala_data_type_get_nullable (target_type));
	if (vala_data_type_get_value_owned (expression_type) && (target_type == NULL || !vala_data_type_get_value_owned (target_type) || boxing || unboxing)) {
		ValaPointerType* _tmp7;
		ValaDataType* _tmp6;
		ValaPointerType* pointer_type;
		/* value leaked, destroy it*/
		_tmp7 = NULL;
		_tmp6 = NULL;
		pointer_type = (_tmp7 = (_tmp6 = target_type, (VALA_IS_POINTER_TYPE (_tmp6) ? ((ValaPointerType*) (_tmp6)) : NULL)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
		if (pointer_type != NULL && !(VALA_IS_VOID_TYPE (vala_pointer_type_get_base_type (pointer_type)))) {
		} else {
			if (vala_ccode_base_module_requires_destroy (self, expression_type)) {
				ValaLocalVariable* decl;
				ValaCCodeExpression* _tmp11;
				ValaCCodeAssignment* _tmp10;
				ValaCCodeIdentifier* _tmp9;
				char* _tmp8;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, TRUE, ((ValaCodeNode*) (expression_type)));
				gee_list_insert (((GeeList*) (self->temp_vars)), 0, decl);
				gee_list_insert (((GeeList*) (self->temp_ref_vars)), 0, decl);
				_tmp11 = NULL;
				_tmp10 = NULL;
				_tmp9 = NULL;
				_tmp8 = NULL;
				cexpr = (_tmp11 = ((ValaCCodeExpression*) (vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp10 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (decl))))))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp11);
				(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
				(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
				_tmp8 = (g_free (_tmp8), NULL);
				if (VALA_IS_ARRAY_TYPE (expression_type) && expr != NULL) {
					ValaArrayType* _tmp12;
					ValaArrayType* array_type;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeIdentifier* _tmp21;
					char* _tmp20;
					ValaCCodeExpression* _tmp23;
					ValaCCodeExpression* _tmp22;
					_tmp12 = NULL;
					array_type = (_tmp12 = VALA_ARRAY_TYPE (expression_type), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, cexpr);
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp14;
							ValaDataType* _tmp13;
							ValaLocalVariable* _tmp15;
							ValaLocalVariable* len_decl;
							ValaCCodeAssignment* _tmp19;
							ValaCCodeExpression* _tmp18;
							ValaCCodeIdentifier* _tmp17;
							char* _tmp16;
							_tmp14 = NULL;
							_tmp13 = NULL;
							_tmp15 = NULL;
							len_decl = (_tmp15 = vala_local_variable_new ((_tmp13 = vala_data_type_copy (self->int_type)), (_tmp14 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (decl))), dim)), NULL, NULL), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_code_node_unref (_tmp13), NULL))), _tmp15);
							gee_list_insert (((GeeList*) (self->temp_vars)), 0, len_decl);
							_tmp19 = NULL;
							_tmp18 = NULL;
							_tmp17 = NULL;
							_tmp16 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (len_decl))))))))), (_tmp18 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), expr, dim)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
							(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
							(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
							_tmp16 = (g_free (_tmp16), NULL);
							(len_decl == NULL ? NULL : (len_decl = (vala_code_node_unref (len_decl), NULL)));
						}
					}
					_tmp21 = NULL;
					_tmp20 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (decl))))))))));
					(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
					_tmp20 = (g_free (_tmp20), NULL);
					_tmp23 = NULL;
					_tmp22 = NULL;
					cexpr = (_tmp23 = (_tmp22 = ((ValaCCodeExpression*) (ccomma)), (_tmp22 == NULL ? NULL : vala_ccode_node_ref (_tmp22))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp23);
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (vala_code_node_unref (decl), NULL)));
			}
		}
		(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
	}
	if (target_type == NULL) {
		/* value will be destroyed, no need for implicit casts*/
		return cexpr;
	}
	if (boxing) {
		ValaCCodeUnaryExpression* _tmp26;
		ValaCCodeExpression* _tmp25;
		ValaCCodeUnaryExpression* unary;
		/* value needs to be boxed*/
		_tmp26 = NULL;
		_tmp25 = NULL;
		unary = (_tmp26 = (_tmp25 = cexpr, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp25) ? ((ValaCCodeUnaryExpression*) (_tmp25)) : NULL)), (_tmp26 == NULL ? NULL : vala_ccode_node_ref (_tmp26)));
		if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
			ValaCCodeExpression* _tmp28;
			ValaCCodeExpression* _tmp27;
			/* *expr => expr*/
			_tmp28 = NULL;
			_tmp27 = NULL;
			cexpr = (_tmp28 = (_tmp27 = vala_ccode_unary_expression_get_inner (unary), (_tmp27 == NULL ? NULL : vala_ccode_node_ref (_tmp27))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp28);
		} else {
			if (VALA_IS_CCODE_IDENTIFIER (cexpr) || VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
				ValaCCodeExpression* _tmp29;
				_tmp29 = NULL;
				cexpr = (_tmp29 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp29);
			} else {
				ValaLocalVariable* decl;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeAssignment* _tmp32;
				ValaCCodeIdentifier* _tmp31;
				char* _tmp30;
				ValaCCodeUnaryExpression* _tmp35;
				ValaCCodeIdentifier* _tmp34;
				char* _tmp33;
				ValaCCodeExpression* _tmp37;
				ValaCCodeExpression* _tmp36;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, vala_data_type_get_value_owned (expression_type), ((ValaCodeNode*) (expression_type)));
				gee_list_insert (((GeeList*) (self->temp_vars)), 0, decl);
				ccomma = vala_ccode_comma_expression_new ();
				_tmp32 = NULL;
				_tmp31 = NULL;
				_tmp30 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp32 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (decl))))))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
				(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
				_tmp30 = (g_free (_tmp30), NULL);
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp33 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new ((_tmp33 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) (decl))))))))))))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
				(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
				_tmp33 = (g_free (_tmp33), NULL);
				_tmp37 = NULL;
				_tmp36 = NULL;
				cexpr = (_tmp37 = (_tmp36 = ((ValaCCodeExpression*) (ccomma)), (_tmp36 == NULL ? NULL : vala_ccode_node_ref (_tmp36))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp37);
				(decl == NULL ? NULL : (decl = (vala_code_node_unref (decl), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			}
		}
		(unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)));
	} else {
		if (unboxing) {
			ValaCCodeExpression* _tmp38;
			/* unbox value*/
			_tmp38 = NULL;
			cexpr = (_tmp38 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cexpr))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp38);
		} else {
			ValaCCodeExpression* _tmp39;
			_tmp39 = NULL;
			cexpr = (_tmp39 = vala_ccode_base_module_get_implicit_cast_expression (self, cexpr, expression_type, target_type, expr), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp39);
		}
	}
	if (vala_data_type_get_is_type_argument (expression_type)) {
		ValaCCodeExpression* _tmp40;
		_tmp40 = NULL;
		cexpr = (_tmp40 = vala_ccode_base_module_convert_from_generic_pointer (self, cexpr, target_type), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp40);
	} else {
		if (vala_data_type_get_is_type_argument (target_type)) {
			ValaCCodeExpression* _tmp41;
			_tmp41 = NULL;
			cexpr = (_tmp41 = vala_ccode_base_module_convert_to_generic_pointer (self, cexpr, expression_type), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp41);
		}
	}
	if (vala_data_type_get_value_owned (target_type) && (!vala_data_type_get_value_owned (expression_type) || boxing || unboxing)) {
		/* need to copy value*/
		if (vala_ccode_base_module_requires_copy (self, target_type) && !(VALA_IS_NULL_TYPE (expression_type))) {
			ValaCodeNode* _tmp42;
			ValaCodeNode* node;
			ValaCCodeExpression* _tmp45;
			_tmp42 = NULL;
			node = (_tmp42 = ((ValaCodeNode*) (expr)), (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42)));
			if (node == NULL) {
				ValaCodeNode* _tmp44;
				ValaCodeNode* _tmp43;
				_tmp44 = NULL;
				_tmp43 = NULL;
				node = (_tmp44 = (_tmp43 = ((ValaCodeNode*) (expression_type)), (_tmp43 == NULL ? NULL : vala_code_node_ref (_tmp43))), (node == NULL ? NULL : (node = (vala_code_node_unref (node), NULL))), _tmp44);
			}
			_tmp45 = NULL;
			cexpr = (_tmp45 = vala_ccode_base_module_get_ref_cexpression (self, target_type, cexpr, expr, node), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp45);
			(node == NULL ? NULL : (node = (vala_code_node_unref (node), NULL)));
		}
	}
	return cexpr;
}


static ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	ValaClass* _tmp4;
	ValaTypeSymbol* _tmp3;
	ValaClass* cl;
	ValaInterface* _tmp6;
	ValaTypeSymbol* _tmp5;
	ValaInterface* iface;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	if (vala_data_type_get_data_type (expression_type) != NULL && vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type)) {
		/* same type, no cast required*/
		return cexpr;
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		/* null literal, no cast required when not converting to generic type pointer*/
		return cexpr;
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	cl = (_tmp4 = (_tmp3 = vala_data_type_get_data_type (target_type), (VALA_IS_CLASS (_tmp3) ? ((ValaClass*) (_tmp3)) : NULL)), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	iface = (_tmp6 = (_tmp5 = vala_data_type_get_data_type (target_type), (VALA_IS_INTERFACE (_tmp5) ? ((ValaInterface*) (_tmp5)) : NULL)), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
	if (vala_code_context_get_checking (self->priv->_context) && (iface != NULL || (cl != NULL && !vala_class_get_is_compact (cl)))) {
		ValaCCodeExpression* _tmp7;
		/* checked cast for strict subtypes of GTypeInstance*/
		_tmp7 = NULL;
		return (_tmp7 = ((ValaCCodeExpression*) (vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type)))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp7);
	} else {
		char* _tmp9;
		char* _tmp8;
		gboolean _tmp10;
		_tmp9 = NULL;
		_tmp8 = NULL;
		if ((_tmp10 = vala_data_type_get_data_type (target_type) != NULL && _vala_strcmp0 ((_tmp8 = vala_data_type_get_cname (expression_type)), (_tmp9 = vala_data_type_get_cname (target_type))) != 0, (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp10)) {
			ValaStruct* _tmp12;
			ValaTypeSymbol* _tmp11;
			ValaStruct* st;
			_tmp12 = NULL;
			_tmp11 = NULL;
			st = (_tmp12 = (_tmp11 = vala_data_type_get_data_type (target_type), (VALA_IS_STRUCT (_tmp11) ? ((ValaStruct*) (_tmp11)) : NULL)), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type)) || (st != NULL && vala_struct_is_simple_type (st))) {
				char* _tmp13;
				ValaCCodeExpression* _tmp14;
				ValaCCodeExpression* _tmp15;
				/* don't cast non-simple structs*/
				_tmp13 = NULL;
				_tmp14 = NULL;
				_tmp15 = NULL;
				return (_tmp15 = (_tmp14 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (cexpr, (_tmp13 = vala_data_type_get_cname (target_type))))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp15);
			} else {
				ValaCCodeExpression* _tmp16;
				_tmp16 = NULL;
				return (_tmp16 = cexpr, (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp16);
			}
			(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (target_type) && VALA_IS_METHOD_TYPE (expression_type)) {
				ValaDelegateType* _tmp17;
				ValaDelegateType* dt;
				ValaMethodType* _tmp18;
				ValaMethodType* mt;
				ValaMethod* _tmp19;
				ValaMethod* method;
				char* _tmp24;
				ValaCCodeExpression* _tmp25;
				ValaCCodeExpression* _tmp26;
				_tmp17 = NULL;
				dt = (_tmp17 = VALA_DELEGATE_TYPE (target_type), (_tmp17 == NULL ? NULL : vala_code_node_ref (_tmp17)));
				_tmp18 = NULL;
				mt = (_tmp18 = VALA_METHOD_TYPE (expression_type), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
				_tmp19 = NULL;
				method = (_tmp19 = vala_method_type_get_method_symbol (mt), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19)));
				if (vala_method_get_base_method (method) != NULL) {
					ValaMethod* _tmp21;
					ValaMethod* _tmp20;
					_tmp21 = NULL;
					_tmp20 = NULL;
					method = (_tmp21 = (_tmp20 = vala_method_get_base_method (method), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20))), (method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL))), _tmp21);
				} else {
					if (vala_method_get_base_interface_method (method) != NULL) {
						ValaMethod* _tmp23;
						ValaMethod* _tmp22;
						_tmp23 = NULL;
						_tmp22 = NULL;
						method = (_tmp23 = (_tmp22 = vala_method_get_base_interface_method (method), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22))), (method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL))), _tmp23);
					}
				}
				_tmp24 = NULL;
				_tmp25 = NULL;
				_tmp26 = NULL;
				return (_tmp26 = (_tmp25 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp24 = vala_ccode_base_module_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt)))))), (_tmp24 = (g_free (_tmp24), NULL)), _tmp25), (dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL))), (mt == NULL ? NULL : (mt = (vala_code_node_unref (mt), NULL))), (method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp26);
			} else {
				ValaCCodeExpression* _tmp27;
				_tmp27 = NULL;
				return (_tmp27 = cexpr, (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp27);
			}
		}
	}
	(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
}


static char* vala_ccode_base_module_generate_delegate_wrapper (ValaCCodeBaseModule* self, ValaMethod* m, ValaDelegate* d) {
	char* delegate_name;
	ValaSignal* _tmp1;
	ValaSymbol* _tmp0;
	ValaSignal* sig;
	ValaDynamicSignal* _tmp3;
	ValaSignal* _tmp2;
	ValaDynamicSignal* dynamic_sig;
	char* _tmp10;
	char* _tmp11;
	char* wrapper_name;
	char* _tmp13;
	ValaCCodeFunction* _tmp14;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	GeeList* _tmp19;
	gboolean _tmp20;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	GeeList* _tmp36;
	gboolean _tmp37;
	ValaCCodeIdentifier* _tmp40;
	char* _tmp39;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp45;
	char* _tmp46;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	delegate_name = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	sig = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (((ValaSymbol*) (d))), (VALA_IS_SIGNAL (_tmp0) ? ((ValaSignal*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	dynamic_sig = (_tmp3 = (_tmp2 = sig, (VALA_IS_DYNAMIC_SIGNAL (_tmp2) ? ((ValaDynamicSignal*) (_tmp2)) : NULL)), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	if (dynamic_sig != NULL) {
		char* _tmp4;
		_tmp4 = NULL;
		delegate_name = (_tmp4 = vala_ccode_module_get_dynamic_signal_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), dynamic_sig), (delegate_name = (g_free (delegate_name), NULL)), _tmp4);
	} else {
		if (sig != NULL) {
			char* _tmp7;
			char* _tmp6;
			char* _tmp5;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			delegate_name = (_tmp7 = g_strconcat ((_tmp5 = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol (((ValaSymbol*) (sig))))), (_tmp6 = vala_signal_get_cname (sig)), NULL), (delegate_name = (g_free (delegate_name), NULL)), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		} else {
			char* _tmp9;
			char* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			delegate_name = (_tmp9 = vala_symbol_camel_case_to_lower_case ((_tmp8 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (d)), FALSE))), (delegate_name = (g_free (delegate_name), NULL)), _tmp9);
			_tmp8 = (g_free (_tmp8), NULL);
		}
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	wrapper_name = (_tmp11 = g_strdup_printf ("_%s_%s", (_tmp10 = vala_method_get_cname (m)), delegate_name), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	if (!vala_ccode_base_module_add_wrapper (self, wrapper_name)) {
		char* _tmp12;
		/* wrapper already defined*/
		_tmp12 = NULL;
		return (_tmp12 = wrapper_name, (delegate_name = (g_free (delegate_name), NULL)), (sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL))), (dynamic_sig == NULL ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL))), _tmp12);
	}
	/* declaration*/
	_tmp13 = NULL;
	_tmp14 = NULL;
	function = (_tmp14 = vala_ccode_function_new (wrapper_name, (_tmp13 = vala_data_type_get_cname (vala_method_get_return_type (m)))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode (((ValaCodeNode*) (m)), ((ValaCCodeNode*) (function)));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = d_params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				/* ensure that C code node has been generated*/
				vala_code_node_accept (((ValaCodeNode*) (param)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
				gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) (param)))));
				/* handle array parameters*/
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp15;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp15 = NULL;
					array_type = (_tmp15 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp16;
						_tmp16 = NULL;
						length_ctype = (_tmp16 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp16);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp17;
							ValaCCodeFormalParameter* _tmp18;
							ValaCCodeFormalParameter* cparam;
							_tmp17 = NULL;
							_tmp18 = NULL;
							cparam = (_tmp18 = vala_ccode_formal_parameter_new ((_tmp17 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), dim)), length_ctype), (_tmp17 = (g_free (_tmp17), NULL)), _tmp18);
							gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	_tmp19 = NULL;
	if ((_tmp20 = gee_collection_get_size (((GeeCollection*) ((_tmp19 = vala_code_node_get_error_types (((ValaCodeNode*) (m))))))) > 0, (_tmp19 == NULL ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL))), _tmp20)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, ((double) (-1)), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp21;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (((GeeMap*) (cparam_map)));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp21 = NULL;
		vala_ccode_function_add_parameter (function, (_tmp21 = ((ValaCCodeFormalParameter*) (gee_map_get (((GeeMap*) (cparam_map)), GINT_TO_POINTER (min_pos))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp22;
			_tmp22 = NULL;
			arg = (_tmp22 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("self"))), (arg == NULL ? NULL : (arg = (vala_ccode_node_unref (arg), NULL))), _tmp22);
		} else {
			ValaCCodeExpression* _tmp25;
			ValaFormalParameter* _tmp23;
			ValaCCodeNode* _tmp24;
			/* use first delegate parameter as instance*/
			_tmp25 = NULL;
			_tmp23 = NULL;
			_tmp24 = NULL;
			arg = (_tmp25 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp24 = vala_code_node_get_ccodenode (((ValaCodeNode*) ((_tmp23 = ((ValaFormalParameter*) (gee_list_get (d_params, 0))))))), (VALA_IS_CCODE_FORMAL_PARAMETER (_tmp24) ? ((ValaCCodeFormalParameter*) (_tmp24)) : NULL))))))), (arg == NULL ? NULL : (arg = (vala_ccode_node_unref (arg), NULL))), _tmp25);
			(_tmp23 == NULL ? NULL : (_tmp23 = (vala_code_node_unref (_tmp23), NULL)));
			i = 1;
		}
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		(arg == NULL ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)));
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaCCodeExpression* arg;
				ValaCCodeExpression* _tmp28;
				ValaFormalParameter* _tmp26;
				ValaCCodeNode* _tmp27;
				arg = NULL;
				_tmp28 = NULL;
				_tmp26 = NULL;
				_tmp27 = NULL;
				arg = (_tmp28 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp27 = vala_code_node_get_ccodenode (((ValaCodeNode*) ((_tmp26 = ((ValaFormalParameter*) (gee_list_get (d_params, i))))))), (VALA_IS_CCODE_FORMAL_PARAMETER (_tmp27) ? ((ValaCCodeFormalParameter*) (_tmp27)) : NULL))))))), (arg == NULL ? NULL : (arg = (vala_ccode_node_unref (arg), NULL))), _tmp28);
				(_tmp26 == NULL ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL)));
				gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
				/* handle array arguments*/
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp29;
					ValaArrayType* array_type;
					_tmp29 = NULL;
					array_type = (_tmp29 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29)));
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							ValaCCodeExpression* clength;
							ValaFormalParameter* _tmp30;
							gboolean _tmp31;
							clength = NULL;
							_tmp30 = NULL;
							if ((_tmp31 = vala_formal_parameter_get_no_array_length ((_tmp30 = ((ValaFormalParameter*) (gee_list_get (d_params, i))))), (_tmp30 == NULL ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL))), _tmp31)) {
								ValaCCodeExpression* _tmp32;
								_tmp32 = NULL;
								clength = (_tmp32 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("-1"))), (clength == NULL ? NULL : (clength = (vala_ccode_node_unref (clength), NULL))), _tmp32);
							} else {
								ValaCCodeExpression* _tmp35;
								char* _tmp34;
								ValaFormalParameter* _tmp33;
								_tmp35 = NULL;
								_tmp34 = NULL;
								_tmp33 = NULL;
								clength = (_tmp35 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp34 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) ((_tmp33 = ((ValaFormalParameter*) (gee_list_get (d_params, i))))))), dim))))), (clength == NULL ? NULL : (clength = (vala_ccode_node_unref (clength), NULL))), _tmp35);
								_tmp34 = (g_free (_tmp34), NULL);
								(_tmp33 == NULL ? NULL : (_tmp33 = (vala_code_node_unref (_tmp33), NULL)));
							}
							gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), clength);
							(clength == NULL ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
				}
				i++;
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(arg == NULL ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	_tmp36 = NULL;
	if ((_tmp37 = gee_collection_get_size (((GeeCollection*) ((_tmp36 = vala_code_node_get_error_types (((ValaCodeNode*) (m))))))) > 0, (_tmp36 == NULL ? NULL : (_tmp36 = (gee_collection_object_unref (_tmp36), NULL))), _tmp37)) {
		ValaCCodeIdentifier* _tmp38;
		_tmp38 = NULL;
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, ((double) (-1)), FALSE)), ((ValaCCodeExpression*) ((_tmp38 = vala_ccode_identifier_new ("error")))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
	}
	_tmp40 = NULL;
	_tmp39 = NULL;
	_tmp41 = NULL;
	ccall = (_tmp41 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp40 = vala_ccode_identifier_new ((_tmp39 = vala_method_get_cname (m))))))), (_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL))), (_tmp39 = (g_free (_tmp39), NULL)), _tmp41);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp42;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (((GeeMap*) (carg_map)));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp42 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp42 = ((ValaCCodeExpression*) (gee_map_get (((GeeMap*) (carg_map)), GINT_TO_POINTER (min_pos))))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp43;
		_tmp43 = NULL;
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp43 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccall)))))));
		(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	} else {
		ValaCCodeReturnStatement* _tmp44;
		_tmp44 = NULL;
		vala_ccode_block_add_statement (block, ((ValaCCodeNode*) ((_tmp44 = vala_ccode_return_statement_new (((ValaCCodeExpression*) (ccall)))))));
		(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
	}
	/* append to file*/
	_tmp45 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp45 = vala_ccode_function_copy (function)))));
	(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, ((ValaCCodeNode*) (function)));
	_tmp46 = NULL;
	return (_tmp46 = wrapper_name, (delegate_name = (g_free (delegate_name), NULL)), (sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL))), (dynamic_sig == NULL ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL))), (function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL))), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), (d_params == NULL ? NULL : (d_params = (gee_collection_object_unref (d_params), NULL))), (carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), _tmp46);
}


ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr) {
	char* set_func;
	ValaProperty* _tmp23;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* _tmp37;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (ma != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma))) {
		if (vala_property_get_base_property (prop) != NULL) {
			ValaClass* _tmp0;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp3;
			char* _tmp2;
			char* _tmp1;
			ValaCCodeFunctionCall* _tmp4;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp7;
			char* _tmp6;
			char* _tmp5;
			ValaCCodeMemberAccess* _tmp9;
			char* _tmp8;
			ValaCCodeFunctionCall* _tmp10;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* _tmp11;
			ValaCCodeFunctionCall* _tmp12;
			_tmp0 = NULL;
			base_class = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_property (prop))))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp4 = NULL;
			vcast = (_tmp4 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = g_strdup_printf ("%s_CLASS", (_tmp1 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (base_class)), NULL))))))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), _tmp4);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = g_strdup_printf ("%s_parent_class", (_tmp5 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (self->current_class)), NULL)))))))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			ccall = (_tmp10 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp9 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), (_tmp8 = g_strdup_printf ("set_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp10);
			_tmp11 = NULL;
			vala_ccode_function_call_add_argument (ccall, (_tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, ((ValaCodeNode*) (vala_member_access_get_inner (ma)))))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
			vala_ccode_function_call_add_argument (ccall, cexpr);
			_tmp12 = NULL;
			return (_tmp12 = ccall, (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp12);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaInterface* _tmp13;
				ValaInterface* base_iface;
				char* _tmp15;
				char* _tmp14;
				char* _tmp16;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp19;
				char* _tmp18;
				ValaCCodeIdentifier* _tmp17;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp21;
				ValaCCodeFunctionCall* _tmp22;
				_tmp13 = NULL;
				base_iface = (_tmp13 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_interface_property (prop))))), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13)));
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp16 = NULL;
				parent_iface_var = (_tmp16 = g_strdup_printf ("%s_%s_parent_iface", (_tmp14 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (self->current_class)), NULL)), (_tmp15 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (base_iface)), NULL))), (_tmp15 = (g_free (_tmp15), NULL)), (_tmp14 = (g_free (_tmp14), NULL)), _tmp16);
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp17 = NULL;
				_tmp20 = NULL;
				ccall = (_tmp20 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp19 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp17 = vala_ccode_identifier_new (parent_iface_var)))), (_tmp18 = g_strdup_printf ("set_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), (_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL))), _tmp20);
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (ccall, (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, ((ValaCodeNode*) (vala_member_access_get_inner (ma)))))));
				(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
				vala_ccode_function_call_add_argument (ccall, cexpr);
				_tmp22 = NULL;
				return (_tmp22 = ccall, (base_iface == NULL ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL))), (parent_iface_var = (g_free (parent_iface_var), NULL)), _tmp22);
			}
		}
	}
	set_func = g_strdup ("g_object_set");
	_tmp23 = NULL;
	base_property = (_tmp23 = prop, (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23)));
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaTypeSymbol* _tmp28;
		ValaTypeSymbol* base_property_type;
		char* _tmp30;
		char* _tmp29;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp25;
			ValaProperty* _tmp24;
			_tmp25 = NULL;
			_tmp24 = NULL;
			base_property = (_tmp25 = (_tmp24 = vala_property_get_base_property (prop), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp25);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp27;
				ValaProperty* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				base_property = (_tmp27 = (_tmp26 = vala_property_get_base_interface_property (prop), (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp27);
			}
		}
		_tmp28 = NULL;
		base_property_type = (_tmp28 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (base_property)))), (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28)));
		_tmp30 = NULL;
		_tmp29 = NULL;
		set_func = (_tmp30 = g_strdup_printf ("%s_set_%s", (_tmp29 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (base_property_type)), NULL)), vala_symbol_get_name (((ValaSymbol*) (base_property)))), (set_func = (g_free (set_func), NULL)), _tmp30);
		_tmp29 = (g_free (_tmp29), NULL);
		if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
			char* _tmp31;
			_tmp31 = NULL;
			set_func = (_tmp31 = vala_ccode_module_get_dynamic_property_setter_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), VALA_DYNAMIC_PROPERTY (prop)), (set_func = (g_free (set_func), NULL)), _tmp31);
		}
		(base_property_type == NULL ? NULL : (base_property_type = (vala_code_node_unref (base_property_type), NULL)));
	}
	_tmp32 = NULL;
	_tmp33 = NULL;
	ccall = (_tmp33 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new (set_func))))), (_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL))), _tmp33);
	if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp34;
		/* target instance is first argument */
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp34 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, ((ValaCodeNode*) (vala_member_access_get_inner (ma)))))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	}
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp35;
		/* property name is second argument of g_object_set */
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp35 = vala_property_get_canonical_cconstant (prop)))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp36;
		_tmp36 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp36 = vala_ccode_constant_new ("NULL")))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	}
	_tmp37 = NULL;
	return (_tmp37 = ccall, (set_func = (g_free (set_func), NULL)), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp37);
}


/* indicates whether a given Expression eligable for an ADDRESS_OF operator
 * from a vala to C point of view all expressions denoting locals, fields and
 * parameters are eligable to an ADDRESS_OF operator */
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = e, (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (ma == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp2);
	}
	if (vala_expression_get_symbol_reference (((ValaExpression*) (ma))) == NULL) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp3);
	}
	if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
		gboolean _tmp4;
		return (_tmp4 = TRUE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp4);
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
		gboolean _tmp5;
		return (_tmp5 = TRUE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp5);
	}
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
		gboolean _tmp6;
		return (_tmp6 = TRUE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp6);
	}
	return (_tmp7 = FALSE, (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp7);
}


/* retrieve the correct address_of expression for a give expression, creates temporary variables
 * where necessary, ce is the corresponding ccode expression for e */
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce) {
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeUnaryExpression* _tmp2;
	ValaCCodeExpression* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	g_return_val_if_fail (ce != NULL, NULL);
	/* is address of trivially possible?*/
	if (vala_ccode_base_module_is_address_of_possible (self, e)) {
		return ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ce)));
	}
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (e), TRUE, NULL);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))));
	gee_collection_add (((GeeCollection*) (self->temp_vars)), temp_decl);
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp1 = vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), ce, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (ctemp)))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	return (_tmp3 = ((ValaCCodeExpression*) (ccomma)), (temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL))), _tmp3);
}


gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wrapper_name != NULL, FALSE);
	return gee_collection_add (((GeeCollection*) (self->wrappers)), wrapper_name);
}


ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_CLASS (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp0);
	} else {
		if (VALA_IS_INTERFACE (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp1);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				type = (_tmp2 = ((ValaDataType*) (vala_value_type_new (((ValaTypeSymbol*) (VALA_STRUCT (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp2);
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = ((ValaDataType*) (vala_value_type_new (((ValaTypeSymbol*) (VALA_ENUM (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp3);
				} else {
					if (VALA_IS_ERROR_DOMAIN (sym)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = ((ValaDataType*) (vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp4);
					} else {
						if (VALA_IS_ERROR_CODE (sym)) {
							ValaDataType* _tmp5;
							_tmp5 = NULL;
							type = (_tmp5 = ((ValaDataType*) (vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (((ValaSymbol*) (sym)))), VALA_ERROR_CODE (sym), NULL))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp5);
						} else {
							char* _tmp7;
							char* _tmp6;
							ValaDataType* _tmp8;
							_tmp7 = NULL;
							_tmp6 = NULL;
							vala_report_error (NULL, (_tmp7 = g_strdup_printf ("internal error: `%s' is not a supported type", (_tmp6 = vala_symbol_get_full_name (((ValaSymbol*) (sym)))))));
							_tmp7 = (g_free (_tmp7), NULL);
							_tmp6 = (g_free (_tmp6), NULL);
							_tmp8 = NULL;
							return (_tmp8 = ((ValaDataType*) (vala_invalid_type_new ())), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp8);
						}
					}
				}
			}
		}
	}
	return type;
}


ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if ((vala_data_type_get_data_type (type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type))) || VALA_IS_POINTER_TYPE (type) || VALA_IS_ARRAY_TYPE (type)) {
		return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
	} else {
		char* _tmp1;
		gboolean _tmp2;
		_tmp1 = NULL;
		if ((_tmp2 = vala_data_type_get_data_type (type) != NULL && (_tmp1 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL, (_tmp1 = (g_free (_tmp1), NULL)), _tmp2)) {
			char* _tmp3;
			ValaCCodeExpression* _tmp4;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = ((ValaCCodeExpression*) (vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type)))))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type)) && initializer_expression) {
				ValaCCodeInitializerList* clist;
				ValaCCodeConstant* _tmp6;
				/* 0-initialize struct with struct initializer { 0 }
				 only allowed as initializer expression in C*/
				clist = vala_ccode_initializer_list_new ();
				_tmp6 = NULL;
				vala_ccode_initializer_list_append (clist, ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("0")))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
				return ((ValaCCodeExpression*) (clist));
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL) {
					return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
				} else {
					if (VALA_IS_ERROR_TYPE (type)) {
						return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
					}
				}
			}
		}
	}
	return NULL;
}


static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (check_return_type) {
		return vala_ccode_base_module_create_type_check_statement (self, ((ValaCodeNode*) (prop)), vala_property_get_property_type (prop), t, non_null, var_name);
	} else {
		ValaVoidType* _tmp1;
		ValaCCodeStatement* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = vala_ccode_base_module_create_type_check_statement (self, ((ValaCodeNode*) (prop)), ((ValaDataType*) ((_tmp1 = vala_void_type_new ()))), t, non_null, var_name), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL))), _tmp2);
	}
}


ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp18;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if (vala_code_context_get_checking (self->priv->_context) && ((VALA_IS_CLASS (t) && !vala_class_get_is_compact ((VALA_CLASS (t)))) || VALA_IS_INTERFACE (t))) {
		ValaCCodeIdentifier* _tmp1;
		char* _tmp0;
		ValaCCodeFunctionCall* _tmp2;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeExpression* _tmp4;
		ValaCCodeExpression* cexpr;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		ctype_check = (_tmp2 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_ccode_base_module_get_type_check_function (self, t))))))), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, ((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new (var_name)))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		cexpr = (_tmp4 = ((ValaCCodeExpression*) (ctype_check)), (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4)));
		if (!non_null) {
			ValaCCodeConstant* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeBinaryExpression* _tmp7;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp8;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			cnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new (var_name)))), ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("NULL"))))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), _tmp7);
			_tmp8 = NULL;
			cexpr = (_tmp8 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, ((ValaCCodeExpression*) (cnull)), ((ValaCCodeExpression*) (ctype_check))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp8);
			(cnull == NULL ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (vala_ccode_node_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			ValaCCodeStatement* _tmp9;
			_tmp9 = NULL;
			return (_tmp9 = NULL, (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp9);
		} else {
			ValaCCodeConstant* _tmp11;
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeBinaryExpression* _tmp12;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp12 = NULL;
			cnonnull = (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_identifier_new (var_name)))), ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_constant_new ("NULL"))))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp12);
			vala_ccode_function_call_add_argument (ccheck, ((ValaCCodeExpression*) (cnonnull)));
			(cnonnull == NULL ? NULL : (cnonnull = (vala_ccode_node_unref (cnonnull), NULL)));
		}
	}
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp13;
		/* void function */
		_tmp13 = NULL;
		vala_ccode_function_call_set_call (ccheck, ((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("g_return_if_fail")))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeExpression* cdefault;
		_tmp14 = NULL;
		vala_ccode_function_call_set_call (ccheck, ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ("g_return_val_if_fail")))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		cdefault = vala_ccode_base_module_default_value_for_type (self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp15;
			ValaCCodeStatement* _tmp16;
			ValaCCodeStatement* _tmp17;
			_tmp15 = NULL;
			_tmp16 = NULL;
			_tmp17 = NULL;
			return (_tmp17 = (_tmp16 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp15 = vala_ccode_constant_new ("0"))))))), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), _tmp16), (cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp17);
		}
		(cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)));
	}
	_tmp18 = NULL;
	return (_tmp18 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccheck))))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp18);
}


gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis) {
	g_return_val_if_fail (self != NULL, 0);
	if (!ellipsis) {
		if (param_pos >= 0) {
			return ((gint) ((param_pos * 1000)));
		} else {
			return ((gint) (((100 + param_pos) * 1000)));
		}
	} else {
		if (param_pos >= 0) {
			return ((gint) (((100 + param_pos) * 1000)));
		} else {
			return ((gint) (((200 + param_pos) * 1000)));
		}
	}
}


ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node) {
	ValaCCodeNode* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (vala_code_node_get_ccodenode (node) == NULL) {
		vala_code_node_accept (node, ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	}
	_tmp0 = NULL;
	return (_tmp0 = vala_code_node_get_ccodenode (node), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
}


ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_context_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL))), _tmp2);
}


static void vala_ccode_base_module_class_init (ValaCCodeBaseModuleClass * klass) {
	vala_ccode_base_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_base_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBaseModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->get_value_setter_function = vala_ccode_base_module_real_get_value_setter_function;
	VALA_CCODE_MODULE_CLASS (klass)->get_construct_property_assignment = vala_ccode_base_module_real_get_construct_property_assignment;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_base_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_base_module_real_append_vala_array_move;
	VALA_CCODE_MODULE_CLASS (klass)->visit_source_file = vala_ccode_base_module_real_visit_source_file;
	VALA_CCODE_MODULE_CLASS (klass)->emit = vala_ccode_base_module_real_emit;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum = vala_ccode_base_module_real_visit_enum;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum_value = vala_ccode_base_module_real_visit_enum_value;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member = vala_ccode_base_module_real_visit_member;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constant = vala_ccode_base_module_real_visit_constant;
	VALA_CCODE_MODULE_CLASS (klass)->visit_field = vala_ccode_base_module_real_visit_field;
	VALA_CCODE_MODULE_CLASS (klass)->visit_formal_parameter = vala_ccode_base_module_real_visit_formal_parameter;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property = vala_ccode_base_module_real_visit_property;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property_accessor = vala_ccode_base_module_real_visit_property_accessor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constructor = vala_ccode_base_module_real_visit_constructor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_destructor = vala_ccode_base_module_real_visit_destructor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_block = vala_ccode_base_module_real_visit_block;
	VALA_CCODE_MODULE_CLASS (klass)->visit_empty_statement = vala_ccode_base_module_real_visit_empty_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_declaration_statement = vala_ccode_base_module_real_visit_declaration_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_local_variable = vala_ccode_base_module_real_visit_local_variable;
	VALA_CCODE_MODULE_CLASS (klass)->visit_initializer_list = vala_ccode_base_module_real_visit_initializer_list;
	VALA_CCODE_MODULE_CLASS (klass)->visit_end_full_expression = vala_ccode_base_module_real_visit_end_full_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression_statement = vala_ccode_base_module_real_visit_expression_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_if_statement = vala_ccode_base_module_real_visit_if_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_statement = vala_ccode_base_module_real_visit_switch_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_section = vala_ccode_base_module_real_visit_switch_section;
	VALA_CCODE_MODULE_CLASS (klass)->visit_while_statement = vala_ccode_base_module_real_visit_while_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_do_statement = vala_ccode_base_module_real_visit_do_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_for_statement = vala_ccode_base_module_real_visit_for_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_foreach_statement = vala_ccode_base_module_real_visit_foreach_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_break_statement = vala_ccode_base_module_real_visit_break_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_continue_statement = vala_ccode_base_module_real_visit_continue_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_ccode_base_module_real_visit_return_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lock_statement = vala_ccode_base_module_real_visit_lock_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delete_statement = vala_ccode_base_module_real_visit_delete_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression = vala_ccode_base_module_real_visit_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_boolean_literal = vala_ccode_base_module_real_visit_boolean_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_character_literal = vala_ccode_base_module_real_visit_character_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_integer_literal = vala_ccode_base_module_real_visit_integer_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_real_literal = vala_ccode_base_module_real_visit_real_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_string_literal = vala_ccode_base_module_real_visit_string_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_null_literal = vala_ccode_base_module_real_visit_null_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_parenthesized_expression = vala_ccode_base_module_real_visit_parenthesized_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_base_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_base_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_MODULE_CLASS (klass)->visit_base_access = vala_ccode_base_module_real_visit_base_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_postfix_expression = vala_ccode_base_module_real_visit_postfix_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_object_creation_expression = vala_ccode_base_module_real_visit_object_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_sizeof_expression = vala_ccode_base_module_real_visit_sizeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_typeof_expression = vala_ccode_base_module_real_visit_typeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_unary_expression = vala_ccode_base_module_real_visit_unary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_ccode_base_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_pointer_indirection = vala_ccode_base_module_real_visit_pointer_indirection;
	VALA_CCODE_MODULE_CLASS (klass)->visit_addressof_expression = vala_ccode_base_module_real_visit_addressof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_base_module_real_visit_reference_transfer_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_binary_expression = vala_ccode_base_module_real_visit_binary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_type_check = vala_ccode_base_module_real_visit_type_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_conditional_expression = vala_ccode_base_module_real_visit_conditional_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lambda_expression = vala_ccode_base_module_real_visit_lambda_expression;
}


static void vala_ccode_base_module_instance_init (ValaCCodeBaseModule * self) {
	self->priv = VALA_CCODE_BASE_MODULE_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
	self->temp_ref_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
	self->next_temp_var_id = 0;
	self->priv->next_array_dup_id = 0;
	self->in_creation_method = FALSE;
	self->in_constructor = FALSE;
	self->in_static_or_class_ctor = FALSE;
	self->current_method_inner_error = FALSE;
	self->next_coroutine_state = 1;
	self->in_plugin = FALSE;
}


static void vala_ccode_base_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeBaseModule * self;
	self = VALA_CCODE_BASE_MODULE (obj);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)));
	(self->root_symbol == NULL ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)));
	(self->current_symbol == NULL ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)));
	(self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (vala_code_node_unref (self->current_type_symbol), NULL)));
	(self->current_class == NULL ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL)));
	(self->current_method == NULL ? NULL : (self->current_method = (vala_code_node_unref (self->current_method), NULL)));
	(self->current_return_type == NULL ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)));
	(self->current_try == NULL ? NULL : (self->current_try = (vala_code_node_unref (self->current_try), NULL)));
	(self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)));
	(self->header_begin == NULL ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL)));
	(self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL)));
	(self->header_type_definition == NULL ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL)));
	(self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL)));
	(self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL)));
	(self->source_begin == NULL ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL)));
	(self->source_include_directives == NULL ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL)));
	(self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL)));
	(self->source_type_definition == NULL ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL)));
	(self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL)));
	(self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL)));
	(self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)));
	(self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)));
	(self->class_init_fragment == NULL ? NULL : (self->class_init_fragment = (vala_ccode_node_unref (self->class_init_fragment), NULL)));
	(self->instance_init_fragment == NULL ? NULL : (self->instance_init_fragment = (vala_ccode_node_unref (self->instance_init_fragment), NULL)));
	(self->instance_finalize_fragment == NULL ? NULL : (self->instance_finalize_fragment = (vala_ccode_node_unref (self->instance_finalize_fragment), NULL)));
	(self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)));
	(self->module_init_fragment == NULL ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL)));
	(self->param_spec_struct == NULL ? NULL : (self->param_spec_struct = (vala_ccode_node_unref (self->param_spec_struct), NULL)));
	(self->instance_struct == NULL ? NULL : (self->instance_struct = (vala_ccode_node_unref (self->instance_struct), NULL)));
	(self->type_struct == NULL ? NULL : (self->type_struct = (vala_ccode_node_unref (self->type_struct), NULL)));
	(self->instance_priv_struct == NULL ? NULL : (self->instance_priv_struct = (vala_ccode_node_unref (self->instance_priv_struct), NULL)));
	(self->prop_enum == NULL ? NULL : (self->prop_enum = (vala_ccode_node_unref (self->prop_enum), NULL)));
	(self->cenum == NULL ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL)));
	(self->function == NULL ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)));
	(self->block == NULL ? NULL : (self->block = (vala_ccode_node_unref (self->block), NULL)));
	(self->temp_vars == NULL ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)));
	(self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)));
	(self->user_marshal_set == NULL ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL)));
	(self->predefined_marshal_set == NULL ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL)));
	(self->c_keywords == NULL ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL)));
	(self->bool_type == NULL ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)));
	(self->char_type == NULL ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL)));
	(self->uchar_type == NULL ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)));
	(self->unichar_type == NULL ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)));
	(self->short_type == NULL ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)));
	(self->ushort_type == NULL ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)));
	(self->int_type == NULL ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)));
	(self->uint_type == NULL ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)));
	(self->long_type == NULL ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)));
	(self->ulong_type == NULL ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)));
	(self->int8_type == NULL ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)));
	(self->uint8_type == NULL ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL)));
	(self->int32_type == NULL ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL)));
	(self->uint32_type == NULL ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL)));
	(self->int64_type == NULL ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL)));
	(self->uint64_type == NULL ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)));
	(self->string_type == NULL ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)));
	(self->float_type == NULL ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL)));
	(self->double_type == NULL ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)));
	(self->gtype_type == NULL ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL)));
	(self->gobject_type == NULL ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL)));
	(self->gerror_type == NULL ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)));
	(self->glist_type == NULL ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)));
	(self->gslist_type == NULL ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)));
	(self->gstringbuilder_type == NULL ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL)));
	(self->garray_type == NULL ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)));
	(self->gquark_type == NULL ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL)));
	(self->mutex_type == NULL ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL)));
	(self->type_module_type == NULL ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL)));
	(self->iterable_type == NULL ? NULL : (self->iterable_type = (vala_code_node_unref (self->iterable_type), NULL)));
	(self->iterator_type == NULL ? NULL : (self->iterator_type = (vala_code_node_unref (self->iterator_type), NULL)));
	(self->collection_type == NULL ? NULL : (self->collection_type = (vala_code_node_unref (self->collection_type), NULL)));
	(self->list_type == NULL ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL)));
	(self->map_type == NULL ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL)));
	(self->dbus_object_type == NULL ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL)));
	(self->substring_method == NULL ? NULL : (self->substring_method = (vala_code_node_unref (self->substring_method), NULL)));
	self->module_init_param_name = (g_free (self->module_init_param_name), NULL);
	(self->wrappers == NULL ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL)));
	VALA_CCODE_MODULE_CLASS (vala_ccode_base_module_parent_class)->finalize (obj);
}


GType vala_ccode_base_module_get_type (void) {
	static GType vala_ccode_base_module_type_id = 0;
	if (vala_ccode_base_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBaseModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_base_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBaseModule), 0, (GInstanceInitFunc) vala_ccode_base_module_instance_init, NULL };
		vala_ccode_base_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MODULE, "ValaCCodeBaseModule", &g_define_type_info, 0);
	}
	return vala_ccode_base_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




