/* valaccodeidentifier.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeidentifier.h>




struct _ValaCCodeIdentifierPrivate {
	char* _name;
};

#define VALA_CCODE_IDENTIFIER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifierPrivate))
enum  {
	VALA_CCODE_IDENTIFIER_DUMMY_PROPERTY
};
static void vala_ccode_identifier_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_identifier_parent_class = NULL;
static void vala_ccode_identifier_finalize (ValaCCodeNode* obj);



ValaCCodeIdentifier* vala_ccode_identifier_construct (GType object_type, const char* _name) {
	ValaCCodeIdentifier* self;
	g_return_val_if_fail (_name != NULL, NULL);
	self = ((ValaCCodeIdentifier*) (g_type_create_instance (object_type)));
	vala_ccode_identifier_set_name (self, _name);
	return self;
}


ValaCCodeIdentifier* vala_ccode_identifier_new (const char* _name) {
	return vala_ccode_identifier_construct (VALA_TYPE_CCODE_IDENTIFIER, _name);
}


static void vala_ccode_identifier_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeIdentifier * self;
	self = ((ValaCCodeIdentifier*) (base));
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
}


const char* vala_ccode_identifier_get_name (ValaCCodeIdentifier* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_identifier_set_name (ValaCCodeIdentifier* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


static void vala_ccode_identifier_class_init (ValaCCodeIdentifierClass * klass) {
	vala_ccode_identifier_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_identifier_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeIdentifierPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_identifier_real_write;
}


static void vala_ccode_identifier_instance_init (ValaCCodeIdentifier * self) {
	self->priv = VALA_CCODE_IDENTIFIER_GET_PRIVATE (self);
}


static void vala_ccode_identifier_finalize (ValaCCodeNode* obj) {
	ValaCCodeIdentifier * self;
	self = VALA_CCODE_IDENTIFIER (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_identifier_parent_class)->finalize (obj);
}


GType vala_ccode_identifier_get_type (void) {
	static GType vala_ccode_identifier_type_id = 0;
	if (vala_ccode_identifier_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeIdentifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_identifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeIdentifier), 0, (GInstanceInitFunc) vala_ccode_identifier_instance_init, NULL };
		vala_ccode_identifier_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeIdentifier", &g_define_type_info, 0);
	}
	return vala_ccode_identifier_type_id;
}




