/* valavapigen.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vapigen/valavapigen.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodecontext.h>
#include <vala/valareport.h>
#include <stdio.h>
#include <vala/valasourcefile.h>
#include <glib/gstdio.h>
#include <vala/valasourcereference.h>
#include <vala/valaparser.h>
#include <vala/valaattributeprocessor.h>
#include <vala/valasymbolresolver.h>
#include <vala/valainterfacewriter.h>
#include <config.h>
#include "vapigen/valagidlparser.h"


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};



struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static char* vala_vapi_gen_directory;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_quiet_mode;
static char** vala_vapi_gen_sources;
static char** vala_vapi_gen_vapi_directories;
static char* vala_vapi_gen_library;
static char** vala_vapi_gen_packages;
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg);
static char** vala_vapi_gen_get_packages_from_depsfile (const char* depsfile, int* result_length1);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gint vala_vapi_gen_main (char** args, int args_length1);
static ValaVAPIGen* vala_vapi_gen_new (void);
static gpointer vala_vapi_gen_parent_class = NULL;
static void vala_vapi_gen_finalize (GObject * obj);
static GType vala_vapi_gen_get_type (void);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry VALA_VAPI_GEN_options[] = {{"vapidir", ((gchar) (0)), 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", ((gchar) (0)), 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", ((gchar) (0)), 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"version", ((gchar) (0)), 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", ((gchar) (0)), 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};


static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), 0);
	if (vala_report_get_errors () == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings ());
		}
		return 0;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (), vala_report_get_warnings ());
		}
		return 1;
	}
}


static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg) {
	char* package_path;
	ValaSourceFile* _tmp2;
	gboolean _tmp3;
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (vala_code_context_has_package (self->priv->context, pkg)) {
		/* ignore multiple occurences of the same package*/
		return TRUE;
	}
	package_path = vala_code_context_get_package_path (self->priv->context, pkg, -1, vala_vapi_gen_vapi_directories);
	if (package_path == NULL) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, (package_path = (g_free (package_path), NULL)), _tmp1);
	}
	vala_code_context_add_package (self->priv->context, pkg);
	_tmp2 = NULL;
	vala_code_context_add_source_file (self->priv->context, (_tmp2 = vala_source_file_new (self->priv->context, package_path, TRUE)));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	return (_tmp3 = TRUE, (package_path = (g_free (package_path), NULL)), _tmp3);
}


static char** vala_vapi_gen_get_packages_from_depsfile (const char* depsfile, int* result_length1) {
	GError * inner_error;
	g_return_val_if_fail (depsfile != NULL, NULL);
	inner_error = NULL;
	{
		char* contents;
		char* _tmp2;
		gboolean _tmp1;
		char* _tmp0;
		char** _tmp3;
		char** _tmp4;
		contents = NULL;
		_tmp2 = NULL;
		_tmp0 = NULL;
		_tmp1 = g_file_get_contents (depsfile, &_tmp0, NULL, &inner_error);
		contents = (_tmp2 = _tmp0, (contents = (g_free (contents), NULL)), _tmp2);
		_tmp1;
		if (inner_error != NULL) {
			if (inner_error->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = g_strsplit (g_strstrip (contents), "\n", 0), (*result_length1) = -1, _tmp3), (contents = (g_free (contents), NULL)), _tmp4);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gpointer _tmp5;
			char** _tmp6;
			/* deps files are optional*/
			_tmp6 = NULL;
			return (_tmp6 = (_tmp5 = NULL, (*result_length1) = 0, _tmp5), (e == NULL ? NULL : (e = (g_error_free (e), NULL))), _tmp6);
		}
	}
	__finally2:
	;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	ValaCodeContext* _tmp0;
	char** _tmp16;
	ValaParser* parser;
	ValaAttributeProcessor* attributeprocessor;
	ValaGIdlParser* gidlparser;
	ValaSymbolResolver* resolver;
	gint _tmp24;
	g_return_val_if_fail (VALA_IS_VAPI_GEN (self), 0);
	_tmp0 = NULL;
	self->priv->context = (_tmp0 = vala_code_context_new (), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), _tmp0);
	/* default package */
	if (!vala_vapi_gen_add_package (self, "glib-2.0")) {
		vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
	}
	/* load packages from .deps file */
	{
		char** source_collection;
		int source_collection_length1;
		char** source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = -1;
		for (source_it = source_collection; *source_it != NULL; source_it = source_it + 1) {
			const char* _tmp8;
			char* source;
			_tmp8 = NULL;
			source = (_tmp8 = *source_it, (_tmp8 == NULL ? NULL : g_strdup (_tmp8)));
			{
				char* _tmp2;
				char* _tmp1;
				char* _tmp3;
				char* depsfile;
				char** _tmp5;
				gint deps_length1;
				gint _tmp4;
				char** deps;
				if (!g_str_has_suffix (source, ".gi")) {
					source = (g_free (source), NULL);
					continue;
				}
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp3 = NULL;
				depsfile = (_tmp3 = g_strconcat ((_tmp2 = (_tmp1 = g_utf8_offset_to_pointer (source, ((glong) (0))), g_strndup (_tmp1, g_utf8_offset_to_pointer (_tmp1, g_utf8_strlen (source, -1) - g_utf8_strlen ("gi", -1)) - _tmp1))), "deps", NULL), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
				if (!g_file_test (depsfile, G_FILE_TEST_EXISTS)) {
					source = (g_free (source), NULL);
					depsfile = (g_free (depsfile), NULL);
					continue;
				}
				_tmp5 = NULL;
				deps = (_tmp5 = vala_vapi_gen_get_packages_from_depsfile (depsfile, &_tmp4), deps_length1 = _tmp4, _tmp5);
				{
					char** dep_collection;
					int dep_collection_length1;
					int dep_it;
					dep_collection = deps;
					dep_collection_length1 = deps_length1;
					for (dep_it = 0; (deps_length1 != -1 && dep_it < deps_length1) || (deps_length1 == -1 && dep_collection[dep_it] != NULL); dep_it = dep_it + 1) {
						const char* _tmp7;
						char* dep;
						_tmp7 = NULL;
						dep = (_tmp7 = dep_collection[dep_it], (_tmp7 == NULL ? NULL : g_strdup (_tmp7)));
						{
							if (!vala_vapi_gen_add_package (self, dep)) {
								char* _tmp6;
								_tmp6 = NULL;
								vala_report_error (NULL, (_tmp6 = g_strdup_printf ("%s not found in specified Vala API directories", dep)));
								_tmp6 = (g_free (_tmp6), NULL);
							}
							dep = (g_free (dep), NULL);
						}
					}
				}
				source = (g_free (source), NULL);
				depsfile = (g_free (depsfile), NULL);
				deps = (_vala_array_free (deps, deps_length1, ((GDestroyNotify) (g_free))), NULL);
			}
		}
	}
	if (vala_vapi_gen_packages != NULL) {
		char** _tmp11;
		{
			char** package_collection;
			int package_collection_length1;
			char** package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = -1;
			for (package_it = package_collection; *package_it != NULL; package_it = package_it + 1) {
				const char* _tmp10;
				char* package;
				_tmp10 = NULL;
				package = (_tmp10 = *package_it, (_tmp10 == NULL ? NULL : g_strdup (_tmp10)));
				{
					if (!vala_vapi_gen_add_package (self, package)) {
						char* _tmp9;
						_tmp9 = NULL;
						vala_report_error (NULL, (_tmp9 = g_strdup_printf ("%s not found in specified Vala API directories", package)));
						_tmp9 = (g_free (_tmp9), NULL);
					}
					package = (g_free (package), NULL);
				}
			}
		}
		_tmp11 = NULL;
		vala_vapi_gen_packages = (_tmp11 = NULL, (vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, -1, ((GDestroyNotify) (g_free))), NULL)), _tmp11);
	}
	if (vala_report_get_errors () > 0) {
		return vala_vapi_gen_quit (self);
	}
	{
		char** source_collection;
		int source_collection_length1;
		char** source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = -1;
		for (source_it = source_collection; *source_it != NULL; source_it = source_it + 1) {
			const char* _tmp15;
			char* source;
			_tmp15 = NULL;
			source = (_tmp15 = *source_it, (_tmp15 == NULL ? NULL : g_strdup (_tmp15)));
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* _tmp13;
					_tmp13 = NULL;
					vala_code_context_add_source_file (self->priv->context, (_tmp13 = vala_source_file_new (self->priv->context, source, FALSE)));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
				} else {
					char* _tmp14;
					_tmp14 = NULL;
					vala_report_error (NULL, (_tmp14 = g_strdup_printf ("%s not found", source)));
					_tmp14 = (g_free (_tmp14), NULL);
				}
				source = (g_free (source), NULL);
			}
		}
	}
	_tmp16 = NULL;
	vala_vapi_gen_sources = (_tmp16 = NULL, (vala_vapi_gen_sources = (_vala_array_free (vala_vapi_gen_sources, -1, ((GDestroyNotify) (g_free))), NULL)), _tmp16);
	if (vala_report_get_errors () > 0) {
		return vala_vapi_gen_quit (self);
	}
	parser = vala_parser_new ();
	vala_parser_parse (parser, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint _tmp18;
		return (_tmp18 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), _tmp18);
	}
	attributeprocessor = vala_attribute_processor_new ();
	vala_attribute_processor_process (attributeprocessor, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint _tmp19;
		return (_tmp19 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), _tmp19);
	}
	gidlparser = vala_gidl_parser_new ();
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint _tmp20;
		return (_tmp20 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), _tmp20);
	}
	resolver = vala_symbol_resolver_new ();
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	if (vala_report_get_errors () > 0) {
		gint _tmp21;
		return (_tmp21 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), (resolver == NULL ? NULL : (resolver = (g_object_unref (resolver), NULL))), _tmp21);
	}
	if (vala_vapi_gen_library != NULL) {
		ValaInterfaceWriter* interface_writer;
		char* _tmp22;
		char* _tmp23;
		interface_writer = vala_interface_writer_new ();
		_tmp22 = NULL;
		vala_interface_writer_write_file (interface_writer, self->priv->context, (_tmp22 = g_strdup_printf ("%s.vapi", vala_vapi_gen_library)));
		_tmp22 = (g_free (_tmp22), NULL);
		_tmp23 = NULL;
		vala_vapi_gen_library = (_tmp23 = NULL, (vala_vapi_gen_library = (g_free (vala_vapi_gen_library), NULL)), _tmp23);
		(interface_writer == NULL ? NULL : (interface_writer = (g_object_unref (interface_writer), NULL)));
	}
	return (_tmp24 = vala_vapi_gen_quit (self), (parser == NULL ? NULL : (parser = (g_object_unref (parser), NULL))), (attributeprocessor == NULL ? NULL : (attributeprocessor = (g_object_unref (attributeprocessor), NULL))), (gidlparser == NULL ? NULL : (gidlparser = (g_object_unref (gidlparser), NULL))), (resolver == NULL ? NULL : (resolver = (g_object_unref (resolver), NULL))), _tmp24);
}


static gint vala_vapi_gen_main (char** args, int args_length1) {
	GError * inner_error;
	ValaVAPIGen* vapigen;
	gint _tmp3;
	inner_error = NULL;
	{
		GOptionContext* opt_context;
		opt_context = g_option_context_new ("- Vala API Generator");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		(opt_context == NULL ? NULL : (opt_context = (g_option_context_free (opt_context), NULL)));
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp0;
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			return (_tmp0 = 1, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), _tmp0);
		}
	}
	__finally3:
	;
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", PACKAGE_VERSION);
		return 0;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		return 1;
	}
	vapigen = vala_vapi_gen_new ();
	return (_tmp3 = vala_vapi_gen_run (vapigen), (vapigen == NULL ? NULL : (vapigen = (g_object_unref (vapigen), NULL))), _tmp3);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


static ValaVAPIGen* vala_vapi_gen_new (void) {
	ValaVAPIGen * self;
	self = g_object_newv (VALA_TYPE_VAPI_GEN, 0, NULL);
	return self;
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject * obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


static GType vala_vapi_gen_get_type (void) {
	static GType vala_vapi_gen_type_id = 0;
	if (vala_vapi_gen_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init };
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
	}
	return vala_vapi_gen_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}




