/* valaclassregisterfunction.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaclassregisterfunction.h>
#include <vala/valadatatype.h>
#include <vala/valainterface.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpressionstatement.h>




struct _ValaClassRegisterFunctionPrivate {
	ValaClass* _class_reference;
};

#define VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionPrivate))
enum  {
	VALA_CLASS_REGISTER_FUNCTION_DUMMY_PROPERTY,
	VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE
};
static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base);
static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_class_register_function_parent_class = NULL;
static void vala_class_register_function_dispose (GObject * obj);



/**
 * Creates a new C function to register the specified class at runtime.
 *
 * @param cl a class
 * @return   newly created class register function
 */
ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl) {
	ValaClassRegisterFunction * self;
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	self = g_object_newv (VALA_TYPE_CLASS_REGISTER_FUNCTION, 0, NULL);
	vala_class_register_function_set_class_reference (self, cl);
	return self;
}


static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaTypeSymbol* _tmp0;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	_tmp0 = NULL;
	return (_tmp0 = VALA_TYPESYMBOL (self->priv->_class_reference), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%sClass", (_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_class_reference), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	if (vala_class_get_class_constructor (self->priv->_class_reference) != NULL) {
		char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = g_strdup_printf ("%s_base_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_class_reference), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		return g_strdup ("NULL");
	}
}


static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s_class_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_class_reference), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("sizeof (%s)", (_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_class_reference), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s_instance_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_class_reference), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	return vala_typesymbol_get_type_id (VALA_TYPESYMBOL (vala_class_get_base_class (self->priv->_class_reference)));
}


static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	if (vala_class_get_is_abstract (self->priv->_class_reference)) {
		return g_strdup ("G_TYPE_FLAG_ABSTRACT");
	} else {
		return g_strdup ("0");
	}
}


static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	return vala_symbol_get_access (VALA_SYMBOL (self->priv->_class_reference));
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	frag = vala_ccode_fragment_new ();
	{
		GeeList* base_type_collection;
		int base_type_it;
		base_type_collection = vala_class_get_base_types (self->priv->_class_reference);
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				ValaInterface* _tmp0;
				ValaInterface* iface;
				char* _tmp1;
				char* _tmp2;
				char* iface_info_name;
				ValaCCodeDeclaration* ctypedecl;
				ValaCCodeVariableDeclarator* _tmp7;
				ValaCCodeConstant* _tmp6;
				char* _tmp5;
				char* _tmp4;
				char* _tmp3;
				if (!(VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type)))) {
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				_tmp0 = NULL;
				iface = (_tmp0 = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
				_tmp1 = NULL;
				_tmp2 = NULL;
				iface_info_name = (_tmp2 = g_strdup_printf ("%s_info", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
				ctypedecl = vala_ccode_declaration_new ("const GInterfaceInfo");
				vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp7 = vala_ccode_variable_declarator_new_with_initializer (iface_info_name, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ((_tmp5 = g_strdup_printf ("{ (GInterfaceInitFunc) %s_%s_interface_init, (GInterfaceFinalizeFunc) NULL, NULL}", (_tmp3 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_class_reference), NULL)), (_tmp4 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))))))))));
				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				_tmp5 = (g_free (_tmp5), NULL);
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp3 = (g_free (_tmp3), NULL);
				vala_ccode_fragment_append (frag, VALA_CCODE_NODE (ctypedecl));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
				iface_info_name = (g_free (iface_info_name), NULL);
				(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
	}
	return frag;
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = VALA_CLASS_REGISTER_FUNCTION (base);
	frag = vala_ccode_fragment_new ();
	{
		GeeList* base_type_collection;
		int base_type_it;
		base_type_collection = vala_class_get_base_types (self->priv->_class_reference);
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				ValaInterface* _tmp0;
				ValaInterface* iface;
				char* _tmp1;
				char* _tmp2;
				char* iface_info_name;
				ValaCCodeIdentifier* _tmp3;
				ValaCCodeFunctionCall* _tmp4;
				ValaCCodeFunctionCall* reg_call;
				ValaCCodeIdentifier* _tmp7;
				char* _tmp6;
				char* _tmp5;
				ValaCCodeIdentifier* _tmp9;
				char* _tmp8;
				ValaCCodeIdentifier* _tmp11;
				char* _tmp10;
				ValaCCodeExpressionStatement* _tmp12;
				if (!(VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type)))) {
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				_tmp0 = NULL;
				iface = (_tmp0 = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
				_tmp1 = NULL;
				_tmp2 = NULL;
				iface_info_name = (_tmp2 = g_strdup_printf ("%s_info", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
				_tmp3 = NULL;
				_tmp4 = NULL;
				reg_call = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("g_type_add_interface_static")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = g_strdup_printf ("%s_type_id", (_tmp5 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_class_reference), NULL))))))));
				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp5 = (g_free (_tmp5), NULL);
				_tmp9 = NULL;
				_tmp8 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (iface)))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				_tmp8 = (g_free (_tmp8), NULL);
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = g_strdup_printf ("&%s", iface_info_name))))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp12 = NULL;
				vala_ccode_fragment_append (frag, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (reg_call)))));
				(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
				iface_info_name = (g_free (iface_info_name), NULL);
				(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
	}
	return frag;
}


ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_CLASS_REGISTER_FUNCTION (self), NULL);
	return self->priv->_class_reference;
}


void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value) {
	g_return_if_fail (VALA_IS_CLASS_REGISTER_FUNCTION (self));
	self->priv->_class_reference = value;
}


static void vala_class_register_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE:
		g_value_set_object (value, vala_class_register_function_get_class_reference (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_register_function_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE:
		vala_class_register_function_set_class_reference (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_register_function_class_init (ValaClassRegisterFunctionClass * klass) {
	vala_class_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaClassRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_class_register_function_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_class_register_function_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_class_register_function_dispose;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_class_register_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_class_register_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_class_register_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_class_register_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_class_register_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_class_register_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_class_register_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_class_register_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_class_register_function_real_get_accessibility;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_class_register_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_class_register_function_real_get_type_interface_init_statements;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE, g_param_spec_object ("class-reference", "class-reference", "class-reference", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_class_register_function_instance_init (ValaClassRegisterFunction * self) {
	self->priv = VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_class_register_function_dispose (GObject * obj) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (obj);
	G_OBJECT_CLASS (vala_class_register_function_parent_class)->dispose (obj);
}


GType vala_class_register_function_get_type (void) {
	static GType vala_class_register_function_type_id = 0;
	if (G_UNLIKELY (vala_class_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassRegisterFunction), 0, (GInstanceInitFunc) vala_class_register_function_instance_init };
		vala_class_register_function_type_id = g_type_register_static (VALA_TYPE_TYPEREGISTER_FUNCTION, "ValaClassRegisterFunction", &g_define_type_info, 0);
	}
	return vala_class_register_function_type_id;
}




