/* valamethodtype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valamethodtype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valasymbol.h>




struct _ValaMethodTypePrivate {
	ValaMethod* _method_symbol;
};
#define VALA_METHOD_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_TYPE, ValaMethodTypePrivate))
enum  {
	VALA_METHOD_TYPE_DUMMY_PROPERTY,
	VALA_METHOD_TYPE_METHOD_SYMBOL
};
static gboolean vala_method_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base);
static GeeCollection* vala_method_type_real_get_parameters (ValaDataType* base);
static ValaDataType* vala_method_type_real_copy (ValaDataType* base);
static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static char* vala_method_type_real_to_string (ValaCodeNode* base);
static char* vala_method_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type);
static gpointer vala_method_type_parent_class = NULL;
static void vala_method_type_dispose (GObject * obj);



ValaMethodType* vala_method_type_new (ValaMethod* method_symbol) {
	ValaMethodType * self;
	g_return_val_if_fail (VALA_IS_METHOD (method_symbol), NULL);
	self = g_object_newv (VALA_TYPE_METHOD_TYPE, 0, NULL);
	vala_method_type_set_method_symbol (self, method_symbol);
	return self;
}


static gboolean vala_method_type_real_is_invokable (ValaDataType* base) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (base);
	return TRUE;
}


static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base) {
	ValaMethodType * self;
	ValaDataType* _tmp0;
	self = VALA_METHOD_TYPE (base);
	_tmp0 = NULL;
	return (_tmp0 = vala_method_get_return_type (self->priv->_method_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static GeeCollection* vala_method_type_real_get_parameters (ValaDataType* base) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (base);
	return vala_method_get_parameters (self->priv->_method_symbol);
}


static ValaDataType* vala_method_type_real_copy (ValaDataType* base) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (base);
	return VALA_DATA_TYPE (vala_method_type_new (self->priv->_method_symbol));
}


static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaMethodType * self;
	ValaDelegateType* _tmp1;
	ValaDataType* _tmp0;
	ValaDelegateType* dt;
	gboolean _tmp3;
	self = VALA_METHOD_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	dt = (_tmp1 = (_tmp0 = target_type, (VALA_IS_DELEGATE_TYPE (_tmp0) ? ((ValaDelegateType*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (dt == NULL) {
		gboolean _tmp2;
		/* method types incompatible to anything but delegates*/
		return (_tmp2 = FALSE, (dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL))), _tmp2);
	}
	return (_tmp3 = vala_delegate_matches_method (vala_delegate_type_get_delegate_symbol (dt), self->priv->_method_symbol), (dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL))), _tmp3);
}


static char* vala_method_type_real_to_string (ValaCodeNode* base) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (base);
	return vala_symbol_get_full_name (VALA_SYMBOL (self->priv->_method_symbol));
}


static char* vala_method_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (base);
	return g_strdup ("gpointer");
}


ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self) {
	g_return_val_if_fail (VALA_IS_METHOD_TYPE (self), NULL);
	return self->priv->_method_symbol;
}


void vala_method_type_set_method_symbol (ValaMethodType* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_METHOD_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_method_symbol == NULL ? NULL : (self->priv->_method_symbol = (g_object_unref (self->priv->_method_symbol), NULL))), _tmp2);
}


static void vala_method_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (object);
	switch (property_id) {
		case VALA_METHOD_TYPE_METHOD_SYMBOL:
		g_value_set_object (value, vala_method_type_get_method_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_method_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (object);
	switch (property_id) {
		case VALA_METHOD_TYPE_METHOD_SYMBOL:
		vala_method_type_set_method_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_method_type_class_init (ValaMethodTypeClass * klass) {
	vala_method_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMethodTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_method_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_method_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_method_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_method_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_method_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_method_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_method_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_method_type_real_compatible;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_method_type_real_to_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_method_type_real_get_cname;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_METHOD_TYPE_METHOD_SYMBOL, g_param_spec_object ("method-symbol", "method-symbol", "method-symbol", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_method_type_init (ValaMethodType * self) {
	self->priv = VALA_METHOD_TYPE_GET_PRIVATE (self);
}


static void vala_method_type_dispose (GObject * obj) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (obj);
	(self->priv->_method_symbol == NULL ? NULL : (self->priv->_method_symbol = (g_object_unref (self->priv->_method_symbol), NULL)));
	G_OBJECT_CLASS (vala_method_type_parent_class)->dispose (obj);
}


GType vala_method_type_get_type (void) {
	static GType vala_method_type_type_id = 0;
	if (G_UNLIKELY (vala_method_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodType), 0, (GInstanceInitFunc) vala_method_type_init };
		vala_method_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaMethodType", &g_define_type_info, 0);
	}
	return vala_method_type_type_id;
}




