/* valaccodeinitializerlist.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeinitializerlist.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeInitializerListPrivate {
	GeeList* initializers;
};
#define VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListPrivate))
enum  {
	VALA_CCODE_INITIALIZER_LIST_DUMMY_PROPERTY
};
static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_initializer_list_parent_class = NULL;
static void vala_ccode_initializer_list_dispose (GObject * obj);



/**
 * Appends the specified expression to this initializer list.
 *
 * @param expr an expression
 */
void vala_ccode_initializer_list_append (ValaCCodeInitializerList* self, ValaCCodeExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_INITIALIZER_LIST (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->initializers), expr);
}


static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeInitializerList * self;
	gboolean first;
	self = VALA_CCODE_INITIALIZER_LIST (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "{");
	first = TRUE;
	{
		GeeList* expr_collection;
		GeeIterator* expr_it;
		expr_collection = self->priv->initializers;
		expr_it = gee_iterable_iterator (GEE_ITERABLE (expr_collection));
		while (gee_iterator_next (expr_it)) {
			ValaCCodeExpression* expr;
			expr = ((ValaCCodeExpression*) gee_iterator_get (expr_it));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
				}
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			}
		}
		(expr_it == NULL ? NULL : (expr_it = (g_object_unref (expr_it), NULL)));
	}
	vala_ccode_writer_write_string (writer, "}");
}


/**
 * Represents a struct or array initializer list in the C code.
 */
ValaCCodeInitializerList* vala_ccode_initializer_list_new (void) {
	ValaCCodeInitializerList * self;
	self = g_object_newv (VALA_TYPE_CCODE_INITIALIZER_LIST, 0, NULL);
	return self;
}


static void vala_ccode_initializer_list_class_init (ValaCCodeInitializerListClass * klass) {
	vala_ccode_initializer_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInitializerListPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_initializer_list_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_initializer_list_real_write;
}


static void vala_ccode_initializer_list_init (ValaCCodeInitializerList * self) {
	self->priv = VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE (self);
	self->priv->initializers = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_ccode_initializer_list_dispose (GObject * obj) {
	ValaCCodeInitializerList * self;
	self = VALA_CCODE_INITIALIZER_LIST (obj);
	(self->priv->initializers == NULL ? NULL : (self->priv->initializers = (g_object_unref (self->priv->initializers), NULL)));
	G_OBJECT_CLASS (vala_ccode_initializer_list_parent_class)->dispose (obj);
}


GType vala_ccode_initializer_list_get_type (void) {
	static GType vala_ccode_initializer_list_type_id = 0;
	if (G_UNLIKELY (vala_ccode_initializer_list_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInitializerList), 0, (GInstanceInitFunc) vala_ccode_initializer_list_init };
		vala_ccode_initializer_list_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeInitializerList", &g_define_type_info, 0);
	}
	return vala_ccode_initializer_list_type_id;
}




