/* valaccodeifstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEIFSTATEMENT_H__
#define __CCODE_VALACCODEIFSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_IF_STATEMENT (vala_ccode_if_statement_get_type ())
#define VALA_CCODE_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_IF_STATEMENT, ValaCCodeIfStatement))
#define VALA_CCODE_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_IF_STATEMENT, ValaCCodeIfStatementClass))
#define VALA_IS_CCODE_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_IF_STATEMENT))
#define VALA_IS_CCODE_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_IF_STATEMENT))
#define VALA_CCODE_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_IF_STATEMENT, ValaCCodeIfStatementClass))

typedef struct _ValaCCodeIfStatement ValaCCodeIfStatement;
typedef struct _ValaCCodeIfStatementClass ValaCCodeIfStatementClass;
typedef struct _ValaCCodeIfStatementPrivate ValaCCodeIfStatementPrivate;

/**
 * Represents an if selection statement in the C code.
 */
struct _ValaCCodeIfStatement {
	ValaCCodeStatement parent_instance;
	ValaCCodeIfStatementPrivate * priv;
};
struct _ValaCCodeIfStatementClass {
	ValaCCodeStatementClass parent_class;
};

ValaCCodeIfStatement* vala_ccode_if_statement_new (ValaCCodeExpression* cond, ValaCCodeStatement* true_stmt, ValaCCodeStatement* false_stmt);
ValaCCodeExpression* vala_ccode_if_statement_get_condition (ValaCCodeIfStatement* self);
void vala_ccode_if_statement_set_condition (ValaCCodeIfStatement* self, ValaCCodeExpression* value);
ValaCCodeStatement* vala_ccode_if_statement_get_true_statement (ValaCCodeIfStatement* self);
void vala_ccode_if_statement_set_true_statement (ValaCCodeIfStatement* self, ValaCCodeStatement* value);
ValaCCodeStatement* vala_ccode_if_statement_get_false_statement (ValaCCodeIfStatement* self);
void vala_ccode_if_statement_set_false_statement (ValaCCodeIfStatement* self, ValaCCodeStatement* value);
gboolean vala_ccode_if_statement_get_else_if (ValaCCodeIfStatement* self);
void vala_ccode_if_statement_set_else_if (ValaCCodeIfStatement* self, gboolean value);
GType vala_ccode_if_statement_get_type (void);


G_END_DECLS

#endif
