/*
 * $Id: proto.h,v 2.0.1.5 1996/06/26 18:39:38 alexis Exp alexis $
 *
 * UPS Daemon
 * The Wild Wind Communications, 1995, 1996
 *
 * See file LICENSE for the distribution terms of this software.
 */

/* upsd.c */
extern struct ups *upsp;
extern struct ups_model *upslist[];
extern struct ups_trig *zero_trig;
extern time_t current_time;
extern time_t next_time;
extern void signal_handler(int, int, struct sigcontext *);
extern void usage(void);

/* port.c */
extern int closeport(void);
extern int listenport(void);
extern int openport(void);
extern int readport(char *, int, int);
extern int writeport(char *, int);
extern size_t queuelength(void);
extern void flushport(void);


/* misc.c */
#define xfree(ptr) free(ptr)
extern char *expand(char *);
extern char *xstrdup(char *);
extern int execute(char *);
extern int getcurrenttime(void);
extern int mkpid(char *);
extern int rmpid(char *);
extern int snprintval(char *, size_t, struct ups_val *);
extern void *whereid(int, void *, size_t);
extern void *wherename(char *, void *, size_t);
extern void *xalloc(size_t);
extern void traverse(struct chain *, void *());
extern void traverse2(struct chain *, void *(), void *);

/* config.y */
extern int configure(char *);
extern struct action *newaction(int, void *);
extern struct event *newevent(struct ups_trig *, struct ups_val *,
				int, struct when *, struct action *);
extern struct ups_val *newval(struct ups_reg *, void *, int);

/* event.c */
extern int checkcondition(struct event *);
extern struct ups_trig *checktrigger(char *, size_t);
extern void act(struct action *);
extern void atrig(struct action *, struct ups_trig *);
extern void drop(struct event *, struct ups_trig *);
extern void process(struct event *);
extern void trig(struct event *, struct ups_trig *);
