/*
 * $Id: apc.h,v 2.0.1.5 1996/06/26 18:39:38 alexis Exp alexis $
 *
 * UPS Daemon
 * The Wild Wind Communications, 1995, 1996
 *
 * See file LICENSE for the distribution terms of this software.
 */

/*
 * APC Specific Methods.
 */
#define	APC_WRITE		1
#define	APC_TOGGLE		2

/*
 * American Power Conversions Corp. SmartUPS(R) commands.
 */
#define	SMART_BREPL		1
#define	SMART_COPYRIGHT		2
#define	SMART_FIRMWARE		3
#define	SMART_HTPOINT		4
#define	SMART_INIT		5
#define	SMART_LABEL		6
#define	SMART_LASTTEST		7
#define	SMART_LFREQUENCY	8
#define	SMART_LIGHTTEST		9
#define	SMART_LINEALARM		10
#define	SMART_LINESENS		11
#define	SMART_LMAXVAC		12
#define	SMART_LMINVAC		13
#define	SMART_LOAD		14
#define	SMART_LOWBATDUR		15
#define	SMART_LTPOINT		16
#define	SMART_LVOLTAGE		17
#define	SMART_MANUFACTURED	18
#define	SMART_MODIFY		19
#define	SMART_NVOLTAGE		20
#define	SMART_POWERTEST		21
#define	SMART_RECHARGE		22
#define	SMART_SELFTEST		23
#define	SMART_SERIAL		24
#define	SMART_SHUTDELAY		25
#define	SMART_SHUTDOWN		26
#define	SMART_TEMP		27
#define	SMART_VDC		28
#define	SMART_VOLTAGE		29
#define	SMART_WAKEUPBCAP	30
#define	SMART_WAKEUPDELAY	31
#define	SMART_WRITE		32
#define SMART_MODEL             33
#define SMART_STATUS            34

/*
 * APC SmartUPS(R) specific triggers.
 */
#define	SMART_TLINEFAIL		1
#define	SMART_TLINERSTR		2
#define	SMART_TTEST		3
#define	SMART_TBLOW		4
#define	SMART_TBRST		5

#define	MAXAPCWRITEBUFFER	256
#define	APCWRITEDELAY		{0, 200}

extern int apc_poll(struct ups_val *);
extern int apc_tune(struct ups_val *);

extern struct ups_model apc_SmartUPS_230;
extern struct ups_model apc_SmartUPS_vs_420;
extern char apc_SmartUPS_OK[];
extern char apc_SmartUPS_NO[];
extern char apc_SmartUPS_NA[];
extern char apc_SmartWriteBuffer[MAXAPCWRITEBUFFER];
