; This is the executable header for OS/2 2.x version of the icon programming
; language.  The executable built from this source is the prefix of every 
; file created by the translator and allows direct execution of a translated 
; module.
; This file should be assembled with Turbo Assembler (for OS/2) and linked
; either with TLINK or LINK386.  LINK386 is preferred as it provides 
; a smaller executable.
;   For TLINK:
;       tasm header.asm
;       tlink header,,,os2;
;
;   Using LINK386
;       tasm /oi header.asm
;       LINK386 /noi /exepack /pmtype:vio /base:65536 /align:4 header,,,os2386;
;
; Author: Darren Merrill
; Date: March 28, 1993
;
; PS - this is my first crack at 80386 assembly, so be gentle.
 
ideal
p386

model use32 flat

; result structure from DosExecPgm
STRUC RESULTCODES
resc_codeTerminate      DD      ?       ; termination code/child id
resc_codeResult         DD      ?       ; result code of child
ENDS RESULTCODES

codeseg
extrn DOSEXECPGM:near,DOSEXIT:near,DOSWRITE:near

stack 8000h

dataseg
LOADERRSIZE     = 100
EXEC_ASYNC      = 1
EXEC_BACKGROUND = 4
STDERR          = 2
MAXCMDLINE      = 2048

; errors from DosExecPgm
NO_ERROR                        = 0     
ERROR_INVALID_FUNCTION          = 1     
ERROR_FILE_NOT_FOUND            = 2     
ERROR_PATH_NOT_FOUND            = 3
ERROR_ACCESS_DENIED             = 5
ERROR_NOT_ENOUGH_MEMORY         = 8
ERROR_BAD_ENVIRONMENT           = 10
ERROR_BAD_FORMAT                = 11
ERROR_INVALID_DATA              = 13
ERROR_NOT_DOS_DISK              = 26
ERROR_SHARING_VIOLATION         = 32
ERROR_LOCK_VIOLATION            = 33
ERROR_NO_PROC_SLOTS             = 89
ERROR_INVALID_MODULETYPE        = 190
ERROR_INVALID_EXE_SIGNATURE     = 191
ERROR_EXE_MARKED_INVALID        = 192

; ------------------- initialized data --------------------
retval          dd 0    ; the value to DosExit with

errmsg1         db 'The runtime system could not be found or executed.',13,10
                db 'Please ensure that ICONX.EXE is in your PATH.',13,10
errmsg1len      = $ - errmsg1
errmsg2         db 'The system could not gain access to ICONX.EXE.',13,10
errmsg2len      = $ - errmsg2
errmsg3         db 'Not enough memory to start up runtime system.',13,10
errmsg3len      = $ - errmsg3
errmsg4         db 'The file ICONX.EXE is not recognized as a valid ',13,10
                db 'executable.  Please obtain a new version of this file.',13,10
errmsg4len      = $ - errmsg4
errmsg5         db 'The file ICONX.EXE is locked by another application.',13,10
                db 'The requested program cannot be executed.',13,10
errmsg5len      = $ - errmsg5
errmsg6         db 'Process table is full.  Close a dormant application and ',13,10
                db 'try again.',13,10
errmsg6len      = $ - errmsg6
cmdlineerr      db 'Command line exceeds maximum allowable length of ',13,10
                db '2048 characters.  Execution cannot continue.',13,10
cmderrlen       = $ - cmdlineerr
cmdline         db 'iconx.exe',0                ; our prepend
pgmlen          = $ - cmdline                   ; length of the program name
                db MAXCMDLINE DUP (?)           ; the rest of the buffer

; -------------------- uninitialized data ------------------
; the return code of the child process started with DosExecPgm.  Since
;  we are running async, this doesn't really get used - just a formality
retcodes        RESULTCODES     ?
; address of the environment block
environ         dd ?
; number of bytes written by DosWrite
numwritten      dd ?
; the buffer that DosExecPgm fills with the error
loaderror       db LOADERRSIZE DUP (?)

codeseg
start:
        ; grab the environment and command line
        mov     ebx, [esp + 12]         ; load the environment pointer
        mov     [environ], ebx          ; store the address in our var
        mov     ebx, [esp + 16]         ; load the command line pointer

        ; count the length of the current command line
        cld                             ; set autoincrement (edi, esi)
        mov     edi, ebx                ; idest <- address of command line
        mov     ecx, 0FFFFFFFFh         ; max the counter out
        xor     eax, eax                ; search for NULL
        repne   scasb                   ; repeat 
        repne   scasb                   ; second NULL indicates end of args
        not     ecx                     ; ones complement (flip)

        ; check for potential buffer overrun
        cmp     ecx, MAXCMDLINE
        ja      CmdLineOverRun

        ; copy the command line over to our buffer
        mov     edi, offset cmdline + pgmlen   ; setup destination
        mov     esi, ebx                ; set the source to current cmd
        rep     movsb                   ; move while cx > 0

        ; search for the 2nd NULL and knock it out
        mov     edi, offset cmdline + pgmlen
        not     ecx                     ; 0 ->> FFFFFFFFh
        repne   scasb                   ; search
        mov     [BYTE edi - 1], ' '     ; '\0' ->> ' '

        ; call DosExecPgm to launch our child
        call    DOSEXECPGM C, \
                offset loaderror, \
                LOADERRSIZE, \
                EXEC_ASYNC, \
                offset cmdline, \
                [environ], \ 
                offset retcodes, \
                offset cmdline


        ; check the return of the DosExecPgm call
        cmp     eax, NO_ERROR           ; rc == NO_ERROR?
        je      Exit                    ; no error, get out
        ; set the error message
        cmp     eax, ERROR_ACCESS_DENIED
        je      SHORT NoAccess
        cmp     eax, ERROR_NOT_ENOUGH_MEMORY
        je      SHORT OutOfMem
        cmp     eax, ERROR_INVALID_EXE_SIGNATURE
        je      SHORT InvalExe
        cmp     eax, ERROR_INVALID_MODULETYPE
        je      SHORT InvalExe
        cmp     eax, ERROR_EXE_MARKED_INVALID
        je      SHORT InvalExe
        cmp     eax, ERROR_LOCK_VIOLATION
        je      SHORT ExeLock
       
FileNoFind:                              ; the default
        mov     ebx, offset errmsg1
        mov     eax, errmsg1len
        jmp     ErrorDisplay

OutOfProcs:
        mov     ebx, offset errmsg6
        mov     eax, errmsg6len
        jmp     SHORT ErrorDisplay

ExeLock:
        mov     ebx, offset errmsg5
        mov     eax, errmsg5len
        jmp     SHORT ErrorDisplay

InvalExe:
        mov     ebx, offset errmsg4
        mov     eax, errmsg4len
        jmp     SHORT ErrorDisplay

OutOfMem:
        mov     ebx, offset errmsg3
        mov     eax, errmsg3len
        jmp     SHORT ErrorDisplay

NoAccess:
        mov     ebx, offset errmsg2
        mov     eax, errmsg2len
        jmp     SHORT ErrorDisplay


CmdLineOverRun:
        mov     ebx, offset cmdlineerr
        mov     eax, cmderrlen
        ; fall through
ErrorDisplay:
        mov     [retval], -1            ; exit code <- -1
        call    DOSWRITE C, \
                STDERR, \
                ebx, \
                eax, \
                offset numwritten

Exit:
        call    DOSEXIT C, 0, [retval]  ; Goodbye
end start

