/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2000 - 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
 *  Copyright (C) 2004 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA  02111-1307  USA
 *
 *  $Id: uim-tomoe-gtk.c,v 1.10 2005/10/06 06:30:33 makeinu Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h> 
#endif /* HAVE_CONFIG_H */
#include <gtk/gtk.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>
#include <tomoe-gtk.h>
#include "intl.h"

/*  for uim */
static void     helper_disconnect_cb    (void);
static gboolean check_helper_connection (void);
static int uim_fd = -1;


static void
char_clicked_cb (TomoeCandidatesView *view, gpointer user_data)
{
    gchar *str = tomoe_candidates_view_get_selected_letter (view);

    GString *tmp = g_string_new ("commit_string\n");
    g_string_append (tmp, str);
    g_string_append (tmp, "\n");

    if (check_helper_connection ())
        uim_helper_send_message (uim_fd, tmp->str);

    g_string_free (tmp, TRUE);
}


/*
 *  for uim
 */
static void
helper_disconnect_cb (void)
{
    uim_fd = -1;
}

static gboolean
check_helper_connection (void)
{
    if (uim_fd < 0)
    {
        uim_fd = uim_helper_init_client_fd (helper_disconnect_cb);
        if (uim_fd < 0)
            return FALSE;
    }

    return TRUE;
}


/*
 *  main
 */
static void
quit (void)
{
    gtk_exit (0);
}

int
main (int argc, char *argv[])
{
    setlocale (LC_ALL, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
    bind_textdomain_codeset (PACKAGE, "UTF-8");

    gtk_init (&argc, &argv);

    /* confirm helper connection */
    check_helper_connection ();

    GtkWidget *window = tomoe_window_new ();
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
    gtk_widget_show (window);
    g_signal_connect (G_OBJECT (window), "response",
                      G_CALLBACK (gtk_main_quit), NULL);
    g_signal_connect (GTK_OBJECT (window), "destroy",
                      G_CALLBACK (quit), NULL);

    /* add software keyboard button */
    TomoeWindow *tomoe = TOMOE_WINDOW (window);

    /* add hooks */
    g_signal_connect (G_OBJECT (tomoe->candidates_view), "selected",
                      G_CALLBACK (char_clicked_cb),
                      (gpointer) tomoe);

    /* run */
    gtk_main ();

    return 0;
}
