/*
 *  snmp_rip2.h
 *
 */
#ifndef _MIBGROUP_SNMP_RIP2_H
#define _MIBGROUP_SNMP_RIP2_H

config_require(smux/smux)

extern FindVarMethod var_rip2;;


#define RIP2GLOBALROUTECHANGES  0
#define RIP2GLOBALQUERIES       1
#define RIP2IFSTATADDRESS       2
#define RIP2IFSTATRCVBADPKTS    3
#define RIP2IFSTATRCVBADROUTES  4
#define RIP2IFSTATSENTUPDATES   5
#define RIP2IFSTATSTATUS        6
#define RIP2IFCONFADDRESS       7
#define RIP2IFCONFDOMAIN        8
#define RIP2IFCONFAUTHTYPE      9
#define RIP2IFCONFAUTHKEY       10
#define RIP2IFCONFSEND          11
#define RIP2IFCONFRECEIVE       12
#define RIP2IFCONFDEFAULTMETRIC 13
#define RIP2IFCONFSTATUS        14
#define RIP2IFCONFSRCADDRESS    15
#define RIP2PEERADDRESS         16
#define RIP2PEERDOMAIN          17
#define RIP2PEERLASTUPDATE      18
#define RIP2PEERVERSION         19
#define RIP2PEERRCVBADPKTS      20
#define RIP2PEERRCVBADROUTES    21

#ifdef IN_SNMP_VARS_C

struct variable13 rip2_variables[] = {
	{RIP2GLOBALROUTECHANGES, ASN_COUNTER, RONLY, var_rip2, 2, {1, 1}},
	{RIP2GLOBALQUERIES, ASN_COUNTER, RONLY, var_rip2, 2, {1, 2}},
	{RIP2IFSTATADDRESS, ASN_IPADDRESS, RONLY, var_rip2, 3, {2, 1, 1}},
	{RIP2IFSTATRCVBADPKTS, ASN_COUNTER, RONLY, var_rip2, 3, {2, 1, 2}},
	{RIP2IFSTATRCVBADROUTES, ASN_COUNTER, RONLY, var_rip2, 3, {2, 1, 3}},
	{RIP2IFSTATSENTUPDATES, ASN_COUNTER, RONLY, var_rip2, 3, {2, 1, 4}},
	{RIP2IFSTATSTATUS, ASN_INTEGER, RWRITE, var_rip2, 3, {2, 1, 5}},
	{RIP2IFCONFADDRESS, ASN_IPADDRESS, RONLY, var_rip2, 3, {3, 1, 1}},
	{RIP2IFCONFDOMAIN, ASN_OCTET_STR, RWRITE, var_rip2, 3, {3, 1, 2}},
	{RIP2IFCONFAUTHTYPE, ASN_INTEGER, RWRITE, var_rip2, 3, {3, 1, 3}},
	{RIP2IFCONFAUTHKEY, ASN_OCTET_STR, RWRITE, var_rip2, 3, {3, 1, 4}},
	{RIP2IFCONFSEND, ASN_INTEGER, RWRITE, var_rip2, 3, {3, 1, 5}},
	{RIP2IFCONFRECEIVE, ASN_INTEGER, RWRITE, var_rip2, 3, {3, 1, 6}},
        {RIP2IFCONFDEFAULTMETRIC,ASN_INTEGER, RWRITE, var_rip2, 3, {3, 1, 7}},
	{RIP2IFCONFSTATUS, ASN_INTEGER, RWRITE, var_rip2, 3, {3, 1, 8}},
	{RIP2IFCONFSRCADDRESS, ASN_IPADDRESS, RWRITE, var_rip2, 3, {3, 1, 9}},
	{RIP2PEERADDRESS, ASN_IPADDRESS, RONLY, var_rip2, 3, {4, 1, 1}},
	{RIP2PEERDOMAIN, ASN_OCTET_STR, RONLY, var_rip2, 3, {4, 1, 2}},
	{RIP2PEERLASTUPDATE, ASN_TIMETICKS, RONLY, var_rip2, 3, {4, 1, 3}},
	{RIP2PEERVERSION, ASN_INTEGER, RONLY, var_rip2, 3, {4, 1, 4}},
	{RIP2PEERRCVBADPKTS, ASN_COUNTER, RONLY, var_rip2, 3, {4, 1, 5}},
	{RIP2PEERRCVBADROUTES, ASN_COUNTER, RONLY, var_rip2, 3, {4, 1, 6}}
};

config_load_mib( MIB.23, 7, rip2_variables)

#endif
#endif /* _MIBGROUP_SNMP_RIP2_H */
