<?php
/**
 * Turba base inclusion file.
 *
 * $Horde: turba/lib/base.php,v 1.62.10.8 2005/10/14 16:26:24 chuck Exp $
 *
 * This file brings in all of the dependencies that every Turba script
 * will need, and sets up objects that all scripts use.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/core.php';

// Registry.
$registry = &Registry::singleton();
if (is_a(($pushed = $registry->pushApp('turba', !defined('AUTH_HANDLER'))), 'PEAR_Error')) {
    if ($pushed->getCode() == 'permission_denied') {
        Horde::authenticationFailureRedirect();
    }
    Horde::fatal($pushed, __FILE__, __LINE__, false);
}
$conf = $GLOBALS['conf'];
@define('TURBA_TEMPLATES', $registry->get('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Find the base file path of Turba.
@define('TURBA_BASE', dirname(__FILE__) . '/..');

// Turba base library.
require_once TURBA_BASE . '/lib/Turba.php';
require_once TURBA_BASE . '/lib/Driver.php';

// Turba source and attribute configuration.
require TURBA_BASE . '/config/attributes.php';
require TURBA_BASE . '/config/sources.php';
$GLOBALS['cfgSources'] = Turba::permissionsFilter($cfgSources, 'source');
$GLOBALS['attributes'] = $attributes;

/* Build the directory sources select widget. */
if (!isset($source)) {
    $source = Util::getFormData('source', $GLOBALS['prefs']->getValue('default_dir'));
}
$add_source_options = $source_options = '';
$source_count = 0;
$addSources = array();
foreach ($cfgSources as $key => $curSource) {
    if (!empty($curSource['export'])) {
        $selected = ($key == $source) ? ' selected="selected"' : '';
        $source_options .= '<option value="' . $key . '" ' . $selected . '>' .
            htmlspecialchars($curSource['title']) . '</option>';
        $source_count++;
        if (empty($source)) {
            $source = $key;
        }
    }
    if ($GLOBALS['perms']->hasPermission('turba:sources:' . $key, Auth::getAuth(), PERMS_EDIT) ||
        (!$GLOBALS['perms']->exists('turba:sources:' . $key) &&
         (empty($curSource['readonly']) ||
          (isset($curSource['admin']) &&
           in_array(Auth::getAuth(), $curSource['admin']))))) {
        $addSources[$key] = $curSource['title'];
        if ($key != $source) {
            $add_source_options .= '<option value="' . $key . '">' .
                htmlspecialchars($curSource['title']) . '</option>';
        }
    }
}

// Help.
require_once 'Horde/Help.php';

/* Start compression, if requested. */
Horde::compressOutput();
