// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software

#include <string>
#include <sys/types.h>
#include <dirent.h>
#include <fstream>
#include "imap4boxlist.h"
#include "tgws.h"
#include "unix.h"

void
tty_grin_imap4__edit(tgws::clist_node *ent) {
  tgws::active_screen->push();
  {
    tgws::title *t=new tgws::title(_("IMAP4 profiles"));
    t->size(1, COLS);
    t->position(0, 0);
    t->show();
    tgws::keyblock *k=new tgws::keyblock;
    k->add("^C", _("Cancel"));
    k->size(1, COLS);
    k->position(LINES-1, 0);
    k->show();
    for(int i=0;i<4;i++) {
      tgws::label *l=new tgws::label(ent->get_parent()->get_title(i));
      l->size(1, 15);
      l->position(i+2, 0);
      l->show();
    }
  }
  tgws::entry *e[4];
  for(int i=0;i<4;i++) {
    if(i<3) e[i]=new tgws::entry;
    else e[i]=new tgws::password;
    e[i]->set_text(ent->get_text(i));
    e[i]->size(1, COLS-15);
    e[i]->position(i+2, 15);
    e[i]->show();
  }
  int state(0), key;
  do {
    key=e[state]->run();
    switch(key) {
    case KEY_UP: if(!(state--)) state=2; break;
    case KEY_DOWN: if((++state)>=4) state=0; break;
    }
  } while(key!='\n'&&key!=3);
  if(key=='\n')
    for(int i=0;i<4;i++) ent->set_text(i, e[i]->get_text());
  tgws::active_screen->pop();
}

void
tty_grin_imap4(void) {
  tgws::active_screen->push();
  
  {
    tgws::title *t=new tgws::title(_("IMAP4 profiles"));
    t->size(1, COLS);
    t->position(0, 0);
    t->show();
    tgws::keyblock *k=new tgws::keyblock;
    k->add("<", _("Back"));
    k->add("^N", _("New"));
    k->add("^K", _("Delete"));
    k->add("^E", _("Edit"));
    k->size(1, COLS);
    k->position(LINES-1, 0);
    k->show();
  }

  tgws::clist *p=new tgws::clist(4);

  string imapdb_path(getenv("HOME"));
  imapdb_path+="/.ttygrin/imap4";
  {
    ifstream in(imapdb_path.c_str());
    if(in.good()) {
      char buf[1024];
      in.getline(buf, sizeof(buf));
      while(!in.fail()) {
	tgws::clist_node *n=p->insert(0);
	n->set_text(0, strtok(buf, "\t"));
	n->set_text(1, strtok(0, "\t"));
	n->set_text(2, strtok(0, "\t"));
	n->set_text(3, strtok(0, "\t"));
	in.getline(buf, sizeof(buf));
      }
      in.close();
    }
  }

  p->set_width(0, COLS/3);
  p->set_width(1, COLS/3);
  p->set_width(2, COLS);
  p->size(LINES-4, COLS);
  p->set_title(0, _("Hostname"));
  p->set_title(1, _("User"));
  p->set_title(2, _("Prefix"));
  p->set_title(3, _("Password"));
  p->position(2, 0);
  p->show();

  int key;
  do {
    switch(key=p->run()) {
    case 14:
      {
	tgws::clist_node *n=p->insert(0);
	tty_grin_imap4__edit(n);
      }
      break;
    case 5: if(p->get_cursor()) tty_grin_imap4__edit(p->get_cursor()); break;
    case 11:
      if(p->get_cursor()&&
	 tgws::yes_or_no(_("Delete this profile (yes or no)?")))
	delete p->get_cursor();
      break;
    case ' ':
    case '>':
    case '.':
    case KEY_RIGHT:
    case '\n':
      if(p->get_cursor()) {
	tgws::clist_node *n=p->get_cursor();
	imap4boxlist imap4(n->get_text(0), n->get_text(1), n->get_text(2),
			   n->get_text(3));
	tty_grin_mail(imap4, n->get_text(0));
      }
      break;
    }
  } while(key!='<'&&key!=','&&key!=KEY_LEFT);

  ofstream out(imapdb_path.c_str());
  if(out.good()) {
    for(tgws::clist_node *n=p->get_first();n;n=n->get_next()) {
      for(int i=0;i<4;i++) out<<n->get_text(i)<<'\t';
      out<<endl;
    }
    out.close();
  }

  tgws::active_screen->pop();
}
