// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _TGWS_H
#define _TGWS_H

#include <termios.h>
#include <curses.h>

#undef erase
#undef clear
#undef move

#include <iostream>
#include <vector>
#include <list>
#include <string>
#include <rope_fixed>

namespace tgws {
  class screen;
  class style;
  class widget;
  class input;

  extern bool use_color;
  extern screen *active_screen;
  extern style default_style;
  extern struct termios old;

  void init(void);
  void end(void);
  void suspend(void);
  void unsuspend(void);
}

#include "style.h"
#include "widget.h"
#include "input.h"
#include "screen.h"

#include "label.h"
#include "entry.h"
#include "clist.h"
#include "ctree.h"
#include "edit.h"
#include "pager.h"
#include "menu.h"
#include "title.h"
#include "pilot.h"
#include "keylabel.h"
#include "menubar.h"
#include "keyblock.h"
#include "modal.h"
#include "messageedit.h"
#include "messagepager.h"
#include "pinemenu.h"
#include "password.h"

#endif
