// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class pager : public input {
  public:
    pager(void) { rewrap(); }

    virtual void size(int, int);
    virtual void draw(bool=false);
    virtual int run(void);

    void set_text(const char *what) { buffer=what; rewrap(); }
    const char *get_text(void) { return buffer.c_str(); }

    void read_file(istream&);

  protected:
    typedef vector<unsigned int> wrap_t;

    crope buffer;
    wrap_t wrap;
    wrap_t::iterator scr_line;
    unsigned int scr, scr_line_number;
    string last_pattern;

    virtual void draw_line(unsigned int, unsigned int);

    void rewrap(void);
    void up(void);
    void down(void);
    void home(void);
    void end(void);
  };
};
