// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

tgws::menubar::~menubar(void) {
  for(menubar_t::iterator i=menus.begin();i!=menus.end();i++)
    delete (*i).second;
}

void
tgws::menubar::draw(bool running) {
  wbkgdset(win, look->get_attr(LIST));
  werase(win);

  menubar_t::iterator i;
  int w=0;
  for(i=menus.begin();w<width&&i!=menus.end();++i) {
    waddch(win, ' ');
    if(running&&i==current) wattrset(win, look->get_attr(SELECTION));
    waddch(win, ' ');
    waddstr(win, (*i).first.c_str());
    waddch(win, ' ');
    wattrset(win, look->get_attr(LIST));
    waddch(win, ' ');
    w+=(*i).first.size()+4;
  }
  while(w++<width) waddch(win, ' ');

  input::draw(running);
}

int
tgws::menubar::run(void) {
  (*current).second->show();
  for(;;) {
    draw(true);
    switch(int key=(*current).second->run()) {
    case KEY_LEFT:
      (*current).second->hide();
      if(current==menus.begin()) current=menus.end();
      --current;
      if(--current_number<0) current_number=menus.size()-1;
      (*current).second->show();
      break;
    case KEY_RIGHT:
      (*current).second->hide();
      ++current;
      if(++current_number>=(signed)menus.size()) current_number=0;
      if(current==menus.end()) current=menus.begin();
      (*current).second->show();
      break;
    default:
      (*current).second->hide();
      draw();
      return key;
    }
  }
}

void
tgws::menubar::add_menu(const char *name, menu *m) {
  string s(name);
  m->position(line+1, widthcount);
  widthcount+=s.size()+4;
  menus.push_back(pair<string, menu *>(s, m));
  if(menus.size()==1) {
    current=menus.begin();
    current_number=0;
  }
}
