// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <string.h>
#include "tgws.h"

void
tgws::entry::draw(bool running) {
  if(cursor<scr||scr+(width-2)<cursor) {
    if(cursor>((unsigned)width-2)/2) scr=cursor-(width-2)/2;
    else scr=0;
  }
  wbkgdset(win, look->get_attr(enabled?ENTRY:ENTRY_DISABLED));
  werase(win);
  waddch(win, scr?'<':' ');
  waddstr(win, text.c_str()+scr);
  mvwaddch(win, 0, width-1, scr+(width-2)<text.size()?'>':' ');
  mvwaddstr(win, 0, cursor-scr+1, "");
  input::draw();
}

int
tgws::entry::run(void) {
  for(;;) {
    draw(true);
    doupdate();
    switch(int key=wgetch(win)) {
    case 1: cursor=0; break;
    case 5: cursor=text.size(); break;
    case 11: text.erase(cursor, text.size()-cursor); break;
    case 21:
      text.erase(0, cursor);
      cursor=0;
      break;
    case KEY_LEFT:
      if(cursor) cursor--;
      break;
    case KEY_RIGHT:
      if(cursor<text.size()) cursor++;
      break;
    case 4:
      if(cursor<text.size()) text.erase(cursor, 1);
      break;
    case 8:
    case 127:
      if(cursor) text.erase(--cursor, 1);
      break;
    default:
      if(key>=' '&&key<256) text.insert(cursor++, 1, (char)key);
      else {
	draw();
	return key;
      }
      break;
    }
  }
}

void
tgws::entry::set_text(const char *what) {
  text=what;
  cursor=text.size();
}

void
tgws::entry::append_text(const char *what) {
  text.append(what);
  cursor=text.size();
}

void
tgws::entry::prepend_text(const char *what) {
  text.insert(0, what);
  cursor+=strlen(what);
}
