// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class variable {
  public:
    variable(void);
    virtual ~variable(void);

    virtual string print(void) const=0;
    virtual bool equal(object) const=0;
    virtual int recursive_mark(void)=0;
    virtual const char *get_typeof(void) const=0;

    bool get_mark(void) const { return gc_mark; }
    void set_mark(bool m) { gc_mark=m; }

    int get_references(void) const { return count; }
    void add_reference(void) { count++; }
    void remove_reference(void) { count--; }

  private:
    int count;
    bool gc_mark;

    static int total;
  };
};
