// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class std_library : public library {
  public:
    std_library(void);

  private:
    static object print(library&, int, object *);
    static object make_cons(library&, int, object *);
    static object car(library&, int, object *);
    static object setf_car(library&, int, object *);
    static object cdr(library&, int, object *);
    static object setf_cdr(library&, int, object *);
    static object make_array(library&, int, object *);
    static object aref(library&, int, object *);
    static object setf_aref(library&, int, object *);
    static object macroexpand(library&, int, object *);
    static object eq(library&, int, object *);
    static object equal(library&, int, object *);
    static object eql(library&, int, object *);
    static object make_hash_table(library&, int, object *);
    static object gethash(library&, int, object *);
    static object setf_gethash(library&, int, object *);
    static object execute(library&, int, object *);
    static object concatenate(library&, int, object *);
    static object loadf(library&, int, object *);
    static object apply(library&, int, object *);
    static object mapcar(library&, int, object *);
    static object eval(library&, int, object *);
    static object type_of(library&, int, object *);
    static object typep(library&, int, object *);

    static object add(library&, int, object *);
    static object subtract(library&, int, object *);
    static object multiply(library&, int, object *);
    static object divide(library&, int, object *);
    static object num_eq(library&, int, object *);
    static object num_noteq(library&, int, object *);
    static object num_lt(library&, int, object *);
    static object num_gt(library&, int, object *);
    static object num_lteq(library&, int, object *);
    static object num_gteq(library&, int, object *);

    static object read_from_string(library&, int, object *);
    static object reverse_sequence(library&, int, object *);
    static object nth(library&, int, object *);
    static object setf_nth(library&, int, object *);
    static object length(library&, int, object *);
    static object subseq(library&, int, object *);

    static object make_character(library&, int, object *);
    static object char_code(library&, int, object *);
    static object string_char(library&, int, object *);
    static object setf_string_char(library&, int, object *);

    static object user_error(library&, int, object *);
  };
};
