// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class real : public number {
  public:
    real(float v) : number(REAL), value(v) { }

    float get_value(void) const { return value; }
    void set_value(float v) { value=v; }

    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual object convert(enum contagion_level) const;
    virtual object unary(enum unary_op) const;
    virtual object binary(enum binary_op, object) const;
    virtual const char *get_typeof(void) const;

  private:
    float value;
  };

  inline bool is_real(const object x) {
    return dynamic_cast<const real *>(x.get_const_data())!=0;
  }

  inline real& assume_real(object x) {
    return *(real *)x.get_data();
  }

  inline real& as_real(object x) {
    real *r=dynamic_cast<real *>(x.get_data());
    if(r) return *r;
    throw error(x, _("Type mismatch"));
  }
};
