// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include "lisp.h"

string
lisp::real::print(void) const {
  char tmp[128];

  sprintf(tmp, "%g", value);
  return string(tmp);
}

bool
lisp::real::equal(object x) const {
  return is_real(x)&&assume_real(x).value==value;
}

lisp::object
lisp::real::convert(enum contagion_level l) const {
  switch(l) {
  case INTEGER: return object(new integer((int)value));
  case REAL: return object(new real(value));
  }
  return nil;
}

lisp::object
lisp::real::unary(enum unary_op o) const {
  return nil;
}

lisp::object
lisp::real::binary(enum binary_op o, object p) const {
  {
    enum contagion_level l=as_number(p).get_level();
    if(l>get_level()) {
      object m=convert(l);
      return assume_number(m).binary(o, p);
    }
    if(l<get_level()) p=assume_number(p).convert(get_level());
  }

  float v=assume_real(p).get_value(), r=0;

  switch(o) {
  case ADD: r=value+v; break;
  case SUBTRACT: r=value-v; break;
  case MULTIPLY: r=value*v; break;
  case DIVIDE: r=value/v; break;

  case LT: return (value<v)?t:nil;
  case LTEQ: return (value<=v)?t:nil;
  case GT: return (value>v)?t:nil;
  case GTEQ: return (value>=v)?t:nil;
  case EQ: return (value==v)?t:nil;
  }

  return object(new real(r));
}

const char *
lisp::real::get_typeof(void) const {
  return "REAL";
}
