// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class object;
  class weak_object;

  class object {
    friend weak_object;

  public:
    object(variable *v=nil.get_data()) : data(v) { data->add_reference(); }
    object(const object& o) : data(o.data) { data->add_reference(); }
    object(const weak_object&);
    ~object(void) { data->remove_reference(); }
    object& operator=(const object& o) {
      data->remove_reference();
      (data=o.data)->add_reference();
      return *this;
    }
    object& operator=(const weak_object&);
    
    variable *get_data(void) { return data; }
    const variable *get_const_data(void) const { return data; }
    bool eq(object x) const { return data==x.data; }
    bool equal(object x) const { return data->equal(x); }
    string print(void) const { return data->print(); }

  private:
    variable *data;
  };

  class weak_object {
    friend object;

  public:
    weak_object(variable *v=nil.get_data()) : data(v) { }
    weak_object(const weak_object& w) : data(w.data) { }
    weak_object(const object& o) : data(o.data) { }
    ~weak_object(void) { }
    weak_object& operator=(const weak_object& w) { data=w.data; return *this; }
    weak_object& operator=(const object& o) { data=o.data; return *this; }

    variable *get_data(void) { return data; }
    const variable *get_const_data(void) const { return data; }
    bool eq(object x) const { return data==x.data; }
    bool equal(object x) const { return data->equal(x); }
    string print(void) const { return data->print(); }

  private:
    variable *data;
  };

  inline
  object::object(const weak_object& w) : data(w.data) {
    data->add_reference();
  }

  inline object&
  object::operator=(const weak_object& w) {
    data->remove_reference();
    (data=w.data)->add_reference();
    return *this;
  }

  int scget(istream&);
  int cget(istream&);
};

inline ostream& operator<<(ostream& out, const lisp::object& o) {
  out<<o.print();
  return out;
}

istream& operator>>(istream& in, lisp::object& o);
