// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _LISP_H
#define _LISP_H

#include <iostream>
#include <string>
#include <vector>
#include <list>
#include <map>
#include <set>

#define isatomchar(x) (!(isspace(x)||x=='('||x==')'||x=='"'))

namespace lisp {
  class object;
  class domain;
  class variable;
  extern object t, nil;
};

#include "gc.h"
#include "variable.h"
#include "object.h"
#include "error.h"
#include "library.h"
#include "std_library.h"
#include "domain.h"
#include "return_from.h"

#include "atom.h"
#include "cons.h"
#include "function.h"
#include "real_function.h"
#include "system_function.h"
#include "number.h"
#include "integer.h"
#include "real.h"
#include "array.h"
#include "str.h"
#include "structure.h"
#include "hash_table.h"
#include "character.h"

#endif
