// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include <string.h>
#include "lisp.h"

char *lisp::character::names[]={
  "Null",         "Soh",          "Stx",          "Etx",
  "Eot",          "Enq",          "Ack",          "Bell",
  "Backspace",    "Tab",          "Newline",      "Vt",
  "Page",         "Return",       "So",           "Si",
  "Dle",          "Dc1",          "Dc2",          "Dc3",
  "Dc4",          "Nak",          "Syn",          "Etb",
  "Can",          "Em",           "Sub",          "Escape",
  "Fs",           "Gs",           "Rs",           "Us",
  "Space",
  0
};

lisp::character::character(const char *name) {
  if(!*name) throw error(_("Syntax error"));

  if(!name[1]) data=*name;
  else {
    unsigned int i;
    for(i=0;names[i]&&strcasecmp(name, names[i]);i++);
    if(!names[i]) sscanf(name+1, "%X", &i);
    data=i;
  }
}

lisp::character::~character(void) {
}

string
lisp::character::print(void) const {
  string text("#\\");

  if(data<=32) text+=names[data];
  else if(data>=127) {
    char tmp[6];

    sprintf(tmp, "U00%02X", data);
    text+=tmp;
  } else text+=data;

  return text;
}

bool
lisp::character::equal(object x) const {
  return is_character(x)&&assume_character(x).get_char()==data;
}

int
lisp::character::recursive_mark(void) {
  if(get_mark()) return 0;
  set_mark(true);
  return 1;
}

const char *
lisp::character::get_typeof(void) const {
  return "CHAR";
}
