// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <ctype.h>
#include "lisp.h"

lisp::object lisp::t(new lisp::atom("T")), lisp::nil(new lisp::atom("NIL"));

string
lisp::atom::print(void) const {
  return data;
}

bool
lisp::atom::equal(object x) const {
  return is_atom(x)&&!strcmp(assume_atom(x).get_text(), get_text());
}

int
lisp::atom::recursive_mark(void) {
  if(get_mark()) return 0;
  set_mark(true);
  return 0;
}

const char *
lisp::atom::get_typeof(void) const {
  return "ATOM";
}
