// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _NEWSGROUP_H
#define _NEWSGROUP_H

#include <vector>
#include <string>
#include <netinet/in.h>
#include "message_descriptor.h"

#define MAX_ARTICLES 4096

struct group_flags {
  int first, last;
  unsigned char flags[MAX_ARTICLES];
};

class newsgroup;

class newsgroup_message : public message_descriptor {
  friend newsgroup;

public:
  newsgroup_message(newsgroup *n) : parent(n), in_reply_to(0) { }
  newsgroup_message *get_parent(void) { return in_reply_to; }
  int get_xref(void) const { return xref; }
  virtual bool extract(ostream&) const;

private:
  int xref;
  newsgroup *parent;
  newsgroup_message *in_reply_to;
};

class newsgroup {
  friend newsgroup_message;

public:
  newsgroup(const char *, const char *);
  ~newsgroup(void);
  newsgroup_message& operator[](int which) { return messages[which]; }
  int size(void) const { return messages.size(); }
  void expunge(void);
  const char *get_group_name(void) const { return group_name.c_str(); }
  const char *get_server_name(void) const { return server_name.c_str(); }

private:
  vector<newsgroup_message> messages;
  struct sockaddr_in addr;
  string server_name, group_name;

  void fetch_index(void);
};

#endif
