// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <fstream>
#include "message.h"

message::message(const char *filename) : source_filename(filename) {
  ifstream in(filename);

  index=new mime(in);
  in.close();
}

message::message(const message& src) : source_filename(src.source_filename) {
  index=new mime(*src.index);
}

message&
message::operator=(const message& src) {
  source_filename=src.source_filename;
  delete index;
  index=new mime(*src.index);
  return *this;
}

message::~message(void) {
  delete index;
}

bool
message::extract(int which, ostream& out) const {
  ifstream in(source_filename.c_str());

  if(in.fail()) return false;
  (*index)[which].extract(in, out);
  in.close();
  return true;
}

bool
message::extract_raw(int which, ostream& out) const {
  ifstream in(source_filename.c_str());

  if(in.fail()) return false;
  (*index)[which].extract_raw(in, out);
  in.close();
  return true;
}

bool
message::extract(ostream& out) const {
  ifstream in(source_filename.c_str());

  if(in.good()) {
    int c;
    while((c=in.get())>=0) out<<(char)c;
    in.close();
    return true;
  }
  return false;
}
