// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include "imap4item.h"
#include "imap4mailbox.h"

imap4mailbox_message::~imap4mailbox_message(void) {
}

bool
imap4mailbox_message::extract(ostream& out) const {
  int sock=imap4login(parent->addr, parent->user.c_str(),
		      parent->password.c_str());
  if(sock<0) return false;
  fstream imap4(sock);
  char buf[1024];
  (imap4<<"0 SELECT "<<
   imap4item(imap4item::STRING, parent->boxname.c_str())<<"\r\n").flush();
  imap4.getline(buf, sizeof(buf));
  while(!imap4.fail()&&buf[0]=='*')
    imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return false;
  }
  (imap4<<"0 FETCH "<<num<<" RFC822\r\n").flush();
  imap4.getline(buf, sizeof(buf));
  if(buf[0]!='*') {
    imap4.close();
    return false;
  }
  char *x=strchr(buf, '{');
  if(!x) {
    imap4.close();
    return false;
  }
  char *y=strchr(x+1, '}');
  if(y) *y=0;
  int size=atoi(x+1);

  int c;
  for(int i=0;i<size;i++) {
    c=imap4.get();
    if(c!='\r') out<<(char)c;
  }

  (imap4<<"0 LOGOUT\r\n").flush();
  imap4.close();
  return true;
}

imap4mailbox::~imap4mailbox(void) {
  // Test to see if any flags have changed
  unsigned int i;
  for(i=0;i<messages.size()&&
	messages[i].oldflags==messages[i].get_flags();i++);

  if(i<messages.size()) {
    int sock=imap4login(addr, user.c_str(), password.c_str());
    if(sock<0) return;
    fstream imap4(sock);
    (imap4<<"0 SELECT "<<
     imap4item(imap4item::STRING, boxname.c_str())<<"\r\n").flush();
    {
      char buf[1024];
      imap4.getline(buf, sizeof(buf));
      while(!imap4.fail()&&buf[0]=='*') imap4.getline(buf, sizeof(buf));
      if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
	imap4.close();
	return;
      }
    }
    for(unsigned int j=0;j<messages.size();j++)
      if(messages[j].oldflags!=messages[j].get_flags()) {
	(imap4<<"0 STORE "<<messages[j].num<<
	 " FLAGS.SILENT "<<flags_to_list(messages[j].get_flags())<<
	 "\r\n").flush();
	while(!imap4.fail()&&imap4.get()!='\n');
	if(imap4.fail()) {
	  imap4.close();
	  return;
	}
      }
    (imap4<<"0 LOGOUT\r\n").flush();
    imap4.close();
  }
}

imap4mailbox::imap4mailbox(const struct sockaddr_in& a, const char *u,
			   const char *p, const char *bn) :
  addr(a), user(u), password(p), boxname(bn) {
  int sock=imap4login(a, u, p);
  if(sock<0) return;
  fstream imap4(sock);
  (imap4<<"0 SELECT "<<imap4item(imap4item::STRING, bn)<<"\r\n").flush();

  char buf[1024];
  int sob=0;

  imap4.getline(buf, sizeof(buf));
  while(buf[0]=='*') {
    char *one=strtok(buf+2, " \r\t"), *two=strtok(0, " \r\t");
    if(two&&!strcmp(two, "EXISTS")) sob=atoi(one);
    imap4.getline(buf, sizeof(buf));
  }

  if(sob) {
    (imap4<<"0 FETCH 1:"<<sob<<" FULL\r\n").flush();
    int num=1;
    for(;;) {
      imap4item stuff;
      imap4>>stuff;
      if(imap4.fail()||*stuff.get_text()!='*') {
	imap4.close();
	return;
      }
      imap4>>stuff>>stuff>>stuff;
      imap4mailbox_message msg(this, num++);
      for(int i=0;i<stuff.size();i++) {
	if(!strcmp(stuff[i].get_text(), "ENVELOPE")) {
	  msg.set_date(stuff[i+1][0].get_text());
	  msg.set_subject(stuff[i+1][1].get_text());

	  imap4item x(stuff[i+1][2][0]);
	  string from;
	  if(x[0].get_type()!=imap4item::NIL) {
	    from=x[0].get_text();
	    from+=" <";
	  }
	  from+=x[2].get_text();
	  from+='@';
	  from+=x[3].get_text();
	  if(x[0].get_type()!=imap4item::NIL) from+='>';
	  msg.set_from(from.c_str());
	  i++;
	} else if(!strcmp(stuff[i].get_text(), "FLAGS")) {
	  i++;
	  for(int j=0;j<stuff[i].size();j++) {
	    const char *what=stuff[i][j].get_text();
	    if(!strcasecmp(what, "\\Seen"))
	      msg.set_flag(message_descriptor::READ);
	    else if(!strcasecmp(what, "\\Deleted"))
	      msg.set_flag(message_descriptor::DELETED);
	    else if(!strcasecmp(what, "\\Flagged"))
	      msg.set_flag(message_descriptor::MARKED);
	    else if(!strcasecmp(what, "\\Answered"))
	      msg.set_flag(message_descriptor::ANSWERED);
	  }
	}
      }
      msg.oldflags=msg.get_flags();
      messages.push_back(msg);
    }
  }

  imap4.close();
}

message_descriptor&
imap4mailbox::operator[](int which) {
  return messages[which];
}

int
imap4mailbox::size(void) const {
  return messages.size();
}

bool
imap4mailbox::append(const message_descriptor& msg) {
  // FIXME
  return false;
}

bool
imap4mailbox::append(const message& msg, unsigned char fl) {
  ifstream msgin(msg.get_filename());
  if(msgin.bad()) return false;
  struct stat info;
  stat(msg.get_filename(), &info);

  int sock=imap4login(addr, user.c_str(), password.c_str());
  if(sock<0) {
    msgin.close();
    return false;
  }
  fstream imap4(sock);
  (imap4<<"0 APPEND "<<imap4item(imap4item::STRING, boxname.c_str())<<
   ' '<<flags_to_list(fl)<<" {"<<info.st_size<<"}\r\n").flush();
  while(!imap4.fail()&&imap4.get()!='\n');
  if(imap4.fail()) {
    msgin.close();
    imap4.close();
    return false;
  }
  int c;
  while((c=msgin.get())>=0) imap4<<(char)c;
  msgin.close();
  (imap4<<"\r\n").flush();
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  (imap4<<"0 LOGOUT\r\n").flush();
  imap4.close();
  return !strncmp(buf, "0 OK", 4);
}

void
imap4mailbox::expunge(void) {
  int sock=imap4login(addr, user.c_str(), password.c_str());
  if(sock<0) return;
  fstream imap4(sock);
  (imap4<<"0 SELECT "<<imap4item(imap4item::STRING, boxname.c_str())<<
   "\r\n").flush();
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  while(!imap4.fail()&&buf[0]=='*') imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return;
  }
  (imap4<<"0 EXPUNGE\r\n").flush();
  while(!imap4.fail()&&imap4.get()!='\r');
  (imap4<<"0 LOGOUT\r\n").flush();
  imap4.close();
}

imap4item
imap4mailbox::flags_to_list(unsigned char f) {
  imap4item flags;
  flags.set_type(imap4item::LIST);
  if(f&message_descriptor::READ)
    flags.add_child(imap4item(imap4item::ATOM, "\\Seen"));
  if(f&message_descriptor::MARKED)
    flags.add_child(imap4item(imap4item::ATOM, "\\Flagged"));
  if(f&message_descriptor::ANSWERED)
    flags.add_child(imap4item(imap4item::ATOM, "\\Answered"));
  if(f&message_descriptor::DELETED)
    flags.add_child(imap4item(imap4item::ATOM, "\\Deleted"));
  return flags;
}
