// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _IMAP4ITEM_H
#define _IMAP4ITEM_H

#include <iostream>
#include <string>
#include <vector>
#include <netinet/in.h>

class imap4item {
public:
  enum type {NIL, ATOM, STRING, LIST};

  imap4item(void) : whattype(NIL) { }
  imap4item(const char *t) : whattype(STRING), text(t) { }
  imap4item(enum type p, const char *t) : whattype(p), text(t) { }

  enum type get_type(void) const { return whattype; }
  void set_type(enum type t) { whattype=t; }
  const char *get_text(void) const { return text.c_str(); }
  void set_text(const char *what) { text=what; }
  int size(void) const { return children.size(); }
  const imap4item& operator[](int which) const { return children[which]; }
  void add_child(const imap4item& item) { children.push_back(item); }
  void clear(void) { children.clear(); }

private:
  enum type whattype;
  string text;
  vector<imap4item> children;
};

int imap4login(const struct sockaddr_in&, const char *, const char *);
istream& operator>>(istream&, imap4item&);
ostream& operator<<(ostream&, const imap4item&);

#endif
