// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <fstream>
#include <string.h>
#include "addressbook.h"

void
addressbook_entry::set_key(const char *text) {
  if(key!=text) {
    key=text;
    parent->commit=true;
  }
}

void
addressbook_entry::set_comment(const char *text) {
  if(comment!=text) {
    comment=text;
    parent->commit=true;
  }
}

void
addressbook_entry::set_address(const char *text) {
  if(address!=text) {
    address=text;
    parent->commit=true;
  }
}

addressbook::addressbook(const char *filename) : commit(false),
						 source_filename(filename) {
  ifstream in(filename);

  if(!in.fail()) {
    char buf[1024];

    in.getline(buf, sizeof(buf));
    while(!in.fail()) {
      addressbook_entry e(this);
      e.key=strtok(buf, "\t");
      e.comment=strtok(NULL, "\t");
      e.address=strtok(NULL, "\t");
      entries.push_back(e);
      in.getline(buf, sizeof(buf));
    }
    in.close();
  }
}

addressbook::~addressbook(void) {
  if(commit) {
    ofstream out(source_filename.c_str());
    if(out.fail()) return;
    vector<addressbook_entry>::const_iterator i;

    for(i=entries.begin();i!=entries.end();i++)
      out<<(*i).get_key()<<'\t'<<(*i).get_comment()<<'\t'<<
	(*i).get_address()<<endl;
    out.close();
  }
}
