// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

int
tgws::pinemenu::run(void) {
  if(current==items.end()) current=items.begin();

  for(;;) {
    draw(true);
    int key;
    switch((key=wgetch(win))) {
    case KEY_UP:
      if((current--)==items.begin()) {
	current=items.end();
	current--;
      }
      break;
    case KEY_DOWN:
      if((++current)==items.end()) current=items.begin();
      break;
    case KEY_HOME: current=items.begin(); break;
    case KEY_LL:
    case KEY_END:
      current=items.end();
      current--;
      break;
    case '>':
    case '.':
    case ' ':
    case KEY_RIGHT:
    case '\n': return (*current).key;
    default: return key;
    }
  }
}

void
tgws::pinemenu::draw(bool running) {
  wbkgdset(win, look->get_attr(MENU));
  werase(win);

  list<item>::const_iterator it=items.begin();
  int r=0;
  while(r<height&&it!=items.end()) {
    wattrset(win, look->get_attr(running&&it==current?SELECTION:MENU));
    mvwaddch(win, r, 0, ' ');
    int j;
    for(j=0;j<left-2&&j<(signed)(*it).left.size();j++)
      waddch(win, (unsigned char)(*it).left[j]);
    while(j++<left+1) waddch(win, ' ');
    for(j=0;j<width-left-4&&j<(signed)(*it).right.size();j++)
      waddch(win, (unsigned char)(*it).right[j]);
    while(j++<width-left-3) waddch(win, ' ');
    it++;
    r+=spacing;
  }
}

void
tgws::pinemenu::add_item(int key, const char *left, const char *right) {
  struct item it;

  it.key=key;
  it.left=left;
  it.right=right;
  items.push_back(it);
}
