// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <ctype.h>
#include "tgws.h"

void
tgws::messagepager::draw(bool running) {
  signature=false;
  pager::draw(running);
}

void
tgws::messagepager::draw_line(unsigned int begin, unsigned int len) {
  if(!signature&&len>=2&&buffer[begin]=='-'&&buffer[begin+1]=='-') {
    signature=true;
    for(unsigned int i=2;i<len;i++)
    if(!isspace(buffer[begin+i])) signature=false;
  }

  if(buffer[begin]==1) {
    signature=false;
    wbkgdset(win, look->get_attr(FRAME));
    for(int i=0;i<width-1;i++) waddch(win, ACS_HLINE);
    waddch(win, '\n');
    return;
  }

  if(signature) wbkgdset(win, look->get_attr(SIGNATURE));
  else if(len&&strchr(">:|", buffer[begin]))
    wbkgdset(win, look->get_attr(QUOTED));
  else wbkgdset(win, look->get_attr(TEXT));

  for(unsigned int i=0;i<len;i++) waddch(win, (unsigned char)buffer[begin+i]);
  waddch(win, '\n');
}
