// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class menubar : public input {
  public:
    menubar(void) : widthcount(0) { }
    virtual ~menubar(void);

    virtual int run(void);
    virtual void draw(bool=false);

    void add_menu(const char *, menu *);
    const char *get_menu_name(void) const { return (*current).first.c_str(); }
    int get_menu_number(void) const { return current_number; }
    const char *get_item_name(void) const {
      return (*current).second->get_cursor_name();
    }
    int get_item_number(void) const {
      return (*current).second->get_cursor_number();
    }

  protected:
    typedef list<pair<string, menu *> > menubar_t;

    menubar_t menus;
    menubar_t::iterator current;
    int widthcount, current_number;
  };
};
