// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class entry : public input {
  public:
    entry(void) : cursor(0), scr(0) { }

    virtual void draw(bool=false);
    virtual int run(void);

    const char *get_text(void) const { return text.c_str(); }
    void set_text(const char *);
    void append_text(const char *);
    void prepend_text(const char *);
    int length(void) const { return text.size(); }

  protected:
    string text;
    unsigned int cursor, scr;
  };
};
