// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class clist;

  class clist_node {
    friend clist;

  public:
    clist_node(clist *);
    ~clist_node(void);

    const char *get_text(int which) const { return text[which].c_str(); }
    void set_text(int which, const char *what);
    void *get_user_data(int which) const { return user_data[which]; }
    void set_user_data(int which, void *what) { user_data[which]=what; }
    clist_node *get_next(void) { return next; }
    clist_node *get_prev(void) { return prev; }
    clist *get_parent(void) { return parent; }

  protected:
    clist *parent;
    clist_node *prev, *next;
    string *text;
    void **user_data;
  };

  class clist : public input {
    friend clist_node;

  public:
    clist(int);
    virtual ~clist(void);

    virtual void draw(bool=false);
    virtual int run(void);

    clist_node *insert(clist_node *);
    clist_node *get_first(void) { return first; }
    clist_node *get_last(void) { return last; }
    clist_node *get_cursor(void) { return cursor; }

    void go_up(void) { if(cursor->prev) cursor=cursor->prev; }
    void go_down(void) { if(cursor->next) cursor=cursor->next; }

    void clear(void);
    bool empty(void) const { return first==0; }
    int get_count(void) const { return count; }
    bool get_headings(void) const { return headings; }
    void set_headings(bool what) { headings=what; }
    int get_num(void) const { return num; }
    const char *get_title(int which) const { return title[which].c_str(); }
    void set_title(int which, const char *what) { title[which]=what; }
    int get_width(int which) const { return columns[which]; }
    void set_width(int which, int what) { columns[which]=what; }

  protected:
    int num, count;
    bool headings;
    string *title;
    int *columns;
    clist_node *first, *last, *cursor, *scr;
    string last_pattern;

  private:
    void draw_line(const string *);
  };

  inline
  void
  clist_node::set_text(int which, const char *what) {
    text[which]=what;
    if(parent->visible) parent->draw();
  }
};
