// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class real_function : public function {
  public:
    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);

    void set_name(object x) { name=x; }
    object get_name(void) const { return name; }
    void add_form(object x) { content.push_back(x); }
    int size(void) const { return content.size(); }
    object operator[](int x) const { return content[x]; }

    virtual object funcall(library&, int, object *);

  private:
    weak_object name;
    vector<weak_object> content;
  };

  inline real_function& assume_real_function(object x) {
    return *(real_function *)x.get_data();
  }

  inline bool is_real_function(const object x) {
    return dynamic_cast<const real_function *>(x.get_const_data())!=0;
  }

  inline real_function& as_real_function(object x) {
    real_function *f=dynamic_cast<real_function *>(x.get_data());
    if(f) return *f;
    throw error(x, _("Type mismatch"));
  }
};
