// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>
#include <ctype.h>
#include "lisp.h"

int
lisp::scget(istream& in) {
  return in.get();
}

int
lisp::cget(istream& in) {
  int x=in.get();
  while(x==';') {
    while(!in.fail()&&!in.eof()&&x!='\n') x=in.get();
    x=in.get();
  }
  return x;
}

istream&
operator>>(istream& in, lisp::object& o) {
  int x;
  
  while(isspace(x=lisp::cget(in))) if(in.fail()||in.eof()) return in;
  if(x=='(') {
    lisp::object f=lisp::nil, end=f;
    do {
      while(isspace(x=lisp::cget(in))) if(in.fail()||in.eof()) return in;
      if(x!=')') {
	in.unget();
	lisp::object n;
	in>>n;
	if(!(in.fail()||in.eof())) {
	  if(f.eq(lisp::nil)) end=f=lisp::object(new lisp::cons(n, lisp::nil));
	  else end=assume_cons(end).cdr=
		 lisp::object(new lisp::cons(n, lisp::nil));
	}
      }
    } while(x!=')');
    o=f;
  } else if(x=='"') {
    string s;
    x=lisp::scget(in);
    while(x!='"') {
      if(in.fail()||in.eof()) return in;
      s+=(char)x;
      x=lisp::scget(in);
    }
    o=lisp::object(new lisp::str(s.c_str()));
  } else if(x=='\'') {
    lisp::object w;
    in>>w;
    w=lisp::object(new lisp::cons(w, lisp::nil));
    w=lisp::object(new lisp::cons(lisp::object(new lisp::atom("QUOTE")), w));
    o=w;
  } else if(x=='#') {
    x=lisp::cget(in);
    if(x=='\'') {
      lisp::object w;
      in>>w;
      o=lisp::object(new lisp::cons(w, lisp::nil));
      o=lisp::object(new lisp::cons(lisp::object(new lisp::atom("FUNCTION")),
				    o));
    } else if(x=='\\') {
      x=lisp::cget(in);
      if(!isatomchar(x)) throw lisp::error(_("Syntax error"));
      string s;
      while(isatomchar(x)&&!(in.fail()||in.eof())) {
	if(x=='\\') x=lisp::cget(in);
	s+=x;
	x=lisp::cget(in);
      }
      in.unget();
      o=lisp::object(new lisp::character(s.c_str()));
    }
  } else {
    if(!isatomchar(x)) throw lisp::error(_("Syntax error"));
    string s;
    while(isatomchar(x)&&!(in.fail()||in.eof())) {
      if(x=='\\') x=lisp::cget(in);
      s+=toupper(x);
      x=lisp::cget(in);
    }
    in.unget();
    const char *t=s.c_str();

    bool numeric=false;
    if(isdigit(*t)||*t=='-'||*t=='.') {
      const char *x=t+1;
      if(*x) {
	while(isdigit(*x)||*x=='.') x++;
	numeric=!*x;
      } else numeric=isdigit(*t);
    }

    if(!strcmp(t, "T")) o=lisp::t;
    else if(!strcmp(t, "NIL")) o=lisp::nil;
    else if(numeric) {
      if(strchr(t, '.')) o=lisp::object(new lisp::real(atof(t)));
      else o=lisp::object(new lisp::integer(atoi(t)));
    } else if(*t==':') {
      o=lisp::object(new lisp::cons(lisp::object(new lisp::atom(t)),
				    lisp::nil));
      o=lisp::object(new lisp::cons(lisp::object(new lisp::atom("QUOTE")),
				    o));
    } else o=lisp::object(new lisp::atom(t));
  }
  return in;
}
