// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class number : public variable {
  public:
    enum contagion_level {
      INTEGER=0, REAL=16
    };

    enum unary_op {
    };

    enum binary_op {
      ADD, SUBTRACT, MULTIPLY, DIVIDE, LT, LTEQ, GT, GTEQ, EQ
    };

    number(enum contagion_level c, const char *t) : variable(t), level(c) { }

    virtual int recursive_mark(void);

    enum contagion_level get_level(void) const { return level; }

    virtual object convert(enum contagion_level) const=0;
    virtual object unary(enum unary_op) const=0;
    virtual object binary(enum binary_op, object) const=0;

  private:
    enum contagion_level level;
  };

  inline bool is_number(const object x) {
    return dynamic_cast<const number *>(x.get_const_data())!=0;
  }

  inline number& assume_number(object x) {
    return *(number *)x.get_data();
  }

  inline number& as_number(object x) {
    number *n=dynamic_cast<number *>(x.get_data());
    if(n) return *n;
    throw error(x, _("Type mismatch"));
  }
};
