// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  typedef vector<string> structdef;

  class library {
  public:
    library(void);
    virtual ~library(void);
    virtual object evaluate(domain&, object);

    void load(const char *);

    void set_function(const char *, object);
    object get_function(const char *) const;

    void set_macro(const char *, object);
    object expand_macro(object);

    void set_variable(const char *, object);
    object get_variable(const char *);
    object *get_variable_reference(const char *);

    void defstruct(const char *name, structdef& s);
    structdef *getstruct(const char *name) { return &structures[name]; }

    void defvar(const char *name) {
      string n(name);
      dynamics.insert(n);
    }
    bool is_dynamic(const char *name) const {
      string n(name);
      return dynamics.find(n)!=dynamics.end();
    }

  private:
    class lt_string {
    public:
      bool operator()(const string& a, const string& b) const { return a<b; }
    };

    map<string, object, lt_string> functions, variables, macros;
    map<string, structdef, lt_string> structures;
    set<string, lt_string> dynamics;

    void defstruct_1(const char *name, structdef& s);
    void defstruct_2(const char *name, structdef& s);
    void defstruct_3(const char *name, structdef& s);

    static bool eql(object, object);

    static object structread(library&, int, object *);
    static object structwrite(library&, int, object *);
    static object structbuild(library&, int, object *);
    static object structp(library&, int, object *);

    static object form_block(library&, domain&, const char *, int, object *);
    static object form_defun(library&, domain&, const char *, int, object *);
    static object form_defstruct(library&, domain&,
				 const char *, int, object *);
    static object form_defvar(library&, domain&, const char *, int, object *);
    static object form_function(library&, domain&,
				const char *, int, object *);
    static object form_if(library&, domain&, const char *, int, object *);
    static object form_lambda(library&, domain&, const char *, int, object *);
    static object form_let(library&, domain&, const char *, int, object *);
    static object form_loop(library&, domain&, const char *, int, object *);
    static object form_progn(library&, domain&, const char *, int, object *);
    static object form_quote(library&, domain&, const char *, int, object *);
    static object form_return_from(library&, domain&,
				   const char *, int, object *);
    static object form_setq(library&, domain&, const char *, int, object *);
    static object form_setf(library&, domain&, const char *, int, object *);
  };
};
