// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class domain {
  public:
    domain(library& l) : global(&l), parent(0) { }
    domain(domain& d) : global(d.global), parent(&d) { }
    ~domain(void);

    void lex(const char *, object=nil);

    void set(const char *, object);
    object get(const char *);
    object *get_reference(const char *);

  private:
    class lt_string {
    public:
      bool operator()(const string& a, const string& b) const { return a<b; }
    };

    library *global;
    domain *parent;
    map<string, pair<object, bool>, lt_string> lexical;
  };
};
