// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _MIME_H
#define _MIME_H

#include <ctype.h>
#include <vector>
#include <map>
#include <string>

#ifndef _LT_STRING
#define _LT_STRING

class lt_string {
public:
  bool operator()(const string& a, const string& b) const { return a<b; }
};

#endif

class mime;

class mime_part {
  friend mime;

public:
  void extract(istream&, ostream&) const;
  const char *operator[](const char *) const;
  bool is_container(void) const { return container; }
  int size(void) const { return end-begin; }
  
private:
  map<string, string, lt_string> headers;
  streampos begin, end;
  bool container;

  unsigned char hex_digit(char k) const {
    if(isupper(k)) return k+10-'A';
    if(islower(k)) return k+10-'a';
    return k-'0';
  };
  unsigned char base64_digit(char k) const {
    if(isupper(k)) return k-'A';
    if(islower(k)) return k+26-'a';
    if(isdigit(k)) return k+52-'0';
    if(k=='+') return 62;
    return 63;
  }
  void add_header(const string&);
};

class mime {
public:
  mime(istream&);
  const mime_part& operator[](int which) const { return parts[which]; }
  int size(void) const { return parts.size(); }

private:
  vector<mime_part> parts;

  bool add_part(istream&, const char * =0);
};

#endif
