// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _MAILBOX_H
#define _MAILBOX_H

#include <vector>
#include <time.h>
#include "message.h"
#include "message_descriptor.h"

class mailbox {
public:
  virtual ~mailbox(void);
  virtual message_descriptor& operator[](int which)=0;
  virtual int size(void) const=0;
  virtual bool append(const message_descriptor&)=0;
  virtual bool append(const message&, unsigned char=0)=0;
  virtual void expunge(void)=0;
};

#endif
