// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <ctype.h>
#include <unistd.h>
#include <fstream>
#include "imap4item.h"

int
imap4login(const struct sockaddr_in& peer, const char *user,
	   const char *password) {
  int sock=socket(PF_INET, SOCK_STREAM, 0);
  if(sock<0) return -1;
  if(connect(sock, (struct sockaddr *)&peer, sizeof(peer))<0) {
    close(sock);
    return -1;
  }
  fstream imap4(sock);
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  if(imap4.fail()&&strncmp(buf, "* OK", 4)) {
    imap4.close();
    return -1;
  }
  imap4<<"0 LOGIN "<<imap4item(imap4item::STRING, user)<<' '<<
    imap4item(imap4item::STRING, password)<<"\r\n";
  imap4.flush();
  imap4.getline(buf, sizeof(buf));
  while(!imap4.fail()&&buf[0]=='*') imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return -1;
  }
  return sock;
}

istream&
operator>>(istream& in, imap4item& item) {
  int c;

  item.clear();
  while((c=in.get())>=0&&isspace(c));
  if(c<0) return in;
  switch(c) {
  case '(':
    {
      while((c=in.get())>=0&&isspace(c));
      while(c>=0&&c!=')') {
	in.unget();
	imap4item child;
	in>>child;
	item.add_child(child);
	while((c=in.get())>=0&&isspace(c));
      }
      item.set_type(imap4item::LIST);
    }
    break;
  case '"':
    {
      string txt;
      while((c=in.get())>=0&&c!='"') {
	if(c=='\\') txt+=(char)in.get();
	else txt+=(char)c;
      }
      item.set_type(imap4item::STRING);
      item.set_text(txt.c_str());
    }
    break;
  default:
    {
      string txt;
      while(c>=0&&!isspace(c)&&c!=')') {
	txt+=(char)c;
	c=in.get();
      }
      if(c>=0) in.unget();
      if(txt=="NIL") item.set_type(imap4item::NIL);
      else {
	item.set_type(imap4item::ATOM);
	item.set_text(txt.c_str());
      }
    }
    break;
  }
  return in;
}

ostream&
operator<<(ostream& out, const imap4item& item) {
  switch(item.get_type()) {
  case imap4item::NIL: out<<"NIL"; break;
  case imap4item::ATOM: out<<item.get_text(); break;
  case imap4item::STRING:
    {
      const char *text=item.get_text();
      out<<'"';
      for(int i=0;text[i];i++) {
	if(text[i]=='"'||text[i]=='\\') out<<'\\'<<text[i];
	else out<<text[i];
      }
      out<<'"';
    }
    break;
  case imap4item::LIST:
    out<<'(';
    if(item.size()) {
      out<<item[0];
      for(int i=1;i<item.size();i++)
	out<<' '<<item[i];
    }
    out<<')';
    break;
  }
  return out;
}
