/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#include "uehandler.h"
#include "clienttree.h"
#include "icon.h"
#include "sceme.h"
#include "action.h"
#include "menu.h"
#include "menuinfo.h"
#include <X11/keysym.h>


const MenuItem ClientMenu[] = {
  {"Raise","Alt+Space",0,0},               //  1
  {"Lower","Shift+Alt+Space",0,0},         //  2
  {"Create Desktop","Shift+Alt+F7",0,0},   //  3
  {"Iconify","Shift+Alt+F3",0,0},          //  4
  {"Shade","Alt+F3",0,0},                  //  5
  {"(Un)Stick","",0,0},                    //  6
  {"Maximize Full","Alt+F6",0,0},          //  7
  {"Maximize Half","Shift+Alt+F6",0,0},    //  8
  {"Move","Alt+F5",0,0},                   //  9
  {"Resize","Shift+Alt+F5",0,0},           // 10
  {"Move Up","Alt+PgUp",0,0},              // 11
  {"Move Down","Alt+PgDown",0,0},          // 12
#ifdef SHAPE
  {"Add Hole","",0,0},                     // 13
  {"Delete Holes","",0,0},                 // 14
#endif
  {"Toggle Taskbar Entry","",0},           // LCSHAPE+1
  {"Toggle Title","",0},                   // LCSHAPE+2
  {"Destroy!","Shift+Alt+F4",0,0},         // LCSHAPE+3
  {"Close","Alt+F4",0,0},                  // LCSHAPE+4
  {"Show/Hide Icons","Alt+F7",0,0},        // LCSHAPE+5
  {"Toggle Tiling","",0,0},                // LCSHAPE+6
  {"Toggle Autoscroll","",0,0}             // LCSHAPE+7
};
#ifdef SHAPE
#define LCSHAPE 14 // last client that uses shape
#else
#define LCSHAPE 12
#endif


const int ClientMenuNum = LCSHAPE+4;
const int DesktopMenuNum = LCSHAPE+7;


UEHandler *UEH;


#define GRABKEY(key,mods) XGrabKey(dpy,XKeysymToKeycode(dpy,key),mods,root,false,GrabModeAsync,GrabModeAsync);


UEHandler::UEHandler() {
  UEH = this;
  MoveWin   = 0;
  Seltype   = 0;
  downtime  = 0;
  NewTarget = 0;
  SelEntry  = 0;
  SelClient = 0;
  SelDesktop= 0;
  RefClient = 0;
  menu      = 0;
  menuitems = 0;
  for (int i = 0;i!=QA_NUM;++i)
    qa[i] = 0;

  act[0] = (Action *)rman->GetInfo(SE_ACTION,"key1");
  act[1] = (Action *)rman->GetInfo(SE_ACTION,"key2");


  GRABKEY(XK_space, Mod1Mask);
  GRABKEY(XK_space, Mod1Mask | ShiftMask);
  GRABKEY(XK_space, Mod1Mask | ControlMask);
  GRABKEY(XK_space, Mod1Mask | ControlMask | ShiftMask);
  GRABKEY(XK_F1,    Mod1Mask);
  GRABKEY(XK_F1,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F3,    Mod1Mask);
  GRABKEY(XK_F3,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F4,    Mod1Mask);
  GRABKEY(XK_F4,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F5,    Mod1Mask);
  GRABKEY(XK_F5,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F6,    Mod1Mask);
  GRABKEY(XK_F6,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F7,    Mod1Mask);
  GRABKEY(XK_F7,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F8,    Mod1Mask);
  GRABKEY(XK_F8,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F9,    Mod1Mask);
  GRABKEY(XK_F9,    Mod1Mask | ShiftMask);
  GRABKEY(XK_F10,   Mod1Mask);
  GRABKEY(XK_F10,   Mod1Mask | ShiftMask);
  GRABKEY(XK_F11,   Mod1Mask);
  GRABKEY(XK_F11,   Mod1Mask | ShiftMask);
  GRABKEY(XK_F12,   Mod1Mask);
  GRABKEY(XK_F12,   Mod1Mask | ShiftMask);

  GRABKEY(XK_Tab,   Mod1Mask);
  GRABKEY(XK_Tab,   Mod1Mask | ShiftMask);
  GRABKEY(XK_Escape,Mod1Mask);
//  GRABKEY(XK_BackSpace,Mod1Mask); !!


  GRABKEY(XK_Left,  Mod1Mask);
  GRABKEY(XK_Right, Mod1Mask);
  GRABKEY(XK_Up,    Mod1Mask);
  GRABKEY(XK_Down,  Mod1Mask);
  GRABKEY(XK_Page_Up,    Mod1Mask);
  GRABKEY(XK_Page_Down,  Mod1Mask);
  GRABKEY(XK_Left,  Mod1Mask | ShiftMask);
  GRABKEY(XK_Right, Mod1Mask | ShiftMask);
  GRABKEY(XK_Up,    Mod1Mask | ShiftMask);
  GRABKEY(XK_Down,  Mod1Mask | ShiftMask);
  GRABKEY(XK_Left,  Mod1Mask | ControlMask);
  GRABKEY(XK_Right, Mod1Mask | ControlMask);
  GRABKEY(XK_Up,    Mod1Mask | ControlMask);
  GRABKEY(XK_Down,  Mod1Mask | ControlMask);
  GRABKEY(XK_Left,  Mod1Mask | ControlMask | ShiftMask);
  GRABKEY(XK_Right, Mod1Mask | ControlMask | ShiftMask);
  GRABKEY(XK_Up,    Mod1Mask | ControlMask | ShiftMask);
  GRABKEY(XK_Down,  Mod1Mask | ControlMask | ShiftMask);


}
UEHandler::~UEHandler(){
  XUngrabKey(dpy,AnyKey,AnyModifier,root);
}



void UEHandler::Press(XButtonEvent &e) {
  motion = false;
  SelIcon = 0;
  Client *c = ct->FindClient(e.window, &SelIcon);
  if (c)
    SelDesktop = c->DesktopAbove();
  if (c && (e.window == c->window)) {
    if ((e.state & Mod1Mask) && (c->o.Sc->flags & SC_GRABALTCLICK)) {
      if (c->flags & CF_GRABBED)
        XAllowEvents(dpy, AsyncPointer, CurrentTime);
      if (e.state & ControlMask) {
        c = c->parent;
        SelDesktop = SelDesktop->parent;
      }
    } else {
      if (c->flags & CF_GRABBED) {
        if (c->o.Sc->flags & SC_PASSFIRSTCLICK)
          XAllowEvents(dpy, ReplayPointer, CurrentTime);
        else
          XAllowEvents(dpy, AsyncPointer, CurrentTime);
      }
      if (c->o.Sc->flags & SC_FOCUSONCLICK)
        c->GetFocus();
      if (!dynamic_cast<Desktop *>(c)) {
        if (c->o.Sc->flags & SC_RAISEONCLICK) {
          c->Raise(R_PARENT|R_INDIRECT);
        }
      }
    }
  }

  if (c && !((xdown-e.x_root)/2) && !((ydown-e.y_root)/2) && (e.time-downtime < c->o.Sc->DCTime)) {
    if ((Seltype & e.button) == e.button)
      Seltype = T_DC; else
      Seltype = T_SDC;
  } else Seltype=0;
  if (e.state & ShiftMask)
    Seltype |= T_SHIFT;


  SelClient = c;
  if (c) {

    xdown=e.x_root;
    ydown=e.y_root;
    downtime=e.time;

    bool tmp=false;

    SelEntry=NULL;
    Seltype = e.button | c->GetRegionMask(e.x_root,e.y_root,SelEntry) | (Seltype & (T_DC | T_SDC | T_SHIFT));
    if (SelEntry && SelClient)
      SelClient->ReDrawTBEntry(SelEntry,false);
    if ((Seltype & T_SDC) && SelClient) {
      SelClient->Shade();
    }
    if (!SelEntry)
      SelEntry = SelClient;
    switch (Seltype) {
      case T_B1 | T_DC | T_F2:
        // it's enough now
        if (SelEntry)
          SelEntry->SendWMDelete(false);// just kill
        break;
      case T_B1 | T_BAR | T_DC:
        c->Raise(0);
        if (SelEntry)
          SelEntry->RequestDesktop();
        break;
      case T_B2 | T_DC:
      case T_B2 | T_BAR | T_DC:
      {
        Client *cc = SelEntry;
        if (!cc) cc = SelClient;
        if (NewTarget) {
          if (cc && cc!=NewTarget)
            NewTarget->target = cc->DesktopAbove(); else
            NewTarget->target=NULL;
          ct->RootDesktop->GetFocus();
          XDefineCursor(dpy, root,ct->RootDesktop->o.Sc->cursors[CU_STD]);
          NewTarget = NULL;
        } else {
          if (cc) {
            NewTarget = cc;
            XDefineCursor(dpy, root,ct->RootDesktop->o.Sc->cursors[CU_NEWTARGET]);
          }
        }
      }
      break;
      case T_B1 | T_DC:
        c->Raise(0);
        c->RequestDesktop();
        break;
      case T_B3 | T_SHIFT:
        tmp = true;
      case T_B2 | T_SHIFT:
      {
        menuitems = new MenuItem[ct->windows.size()/3];
        int i = 0;
        ct->RootDesktop->GetWindowList(menuitems,i,tmp,xdown,ydown,0);
        if (!i) {
          delete menuitems;
          menuitems = 0;
          break;
        }
        menu = new Menu(menuitems,i,c->o.Sc,xdown,ydown);
        menu->Init();
        break;
      }
      case T_B1:
        if (SelClient->parent)
          break;
      case T_B1 | T_SHIFT: {
        MenuInfo * mi = (MenuInfo *)rman->GetInfo(SE_MENUINFO,"");
        if (!mi)
          break;
        menuitems = mi->menu;
        menu = new Menu(menuitems,mi->n,c->o.Sc,xdown,ydown);
        menu->Init();
      }

    };

  };

  if (SelIcon) {
    xdown=e.x_root;
    ydown=e.y_root;
    downtime=e.time;
    SelEntry=NULL;
    Seltype=e.button | (Seltype & (T_DC | T_SDC));
  }


};


void UEHandler::Release(XButtonEvent &e) {
  if (MoveWin) {
    XUnmapWindow(dpy,MoveWin);
    XDestroyWindow(dpy,MoveWin);
  }

  if (menu) {
    int m = menu->Remove();
    delete menu;
    if (menuitems) {
      if (m) {
        long button = Seltype & T_MOUSEBUTTON;
        if (button == T_B3 || button == T_B2) {
          ((Client *)(menuitems[m-1].data))->Raise(
                ((button == T_B2) ? R_MOVEMOUSE : 0) | R_INDIRECT | R_PARENT);
          delete menuitems;
        }
        if (button == T_B1) {
          ((Action *)(menuitems[m-1].data))->Execute();
        }
      }
      menuitems = 0;
    } else {
      switch (m) {
        case 1:
          SelEntry->Raise(R_INDIRECT);
          break;
        case 2:
          SelEntry->Lower(false);
          break;
        case 3:
          SelEntry->RequestDesktop();
          break;
        case 4:
          SelEntry->Hide();
          break;
        case 5:
          SelEntry->Shade();
          break;
        case 6:
          SelEntry->flags |= CF_STICKY;
          break;
        case 7:
          SelEntry->Maximize(MAX_FULL);
          break;
        case 8:
          SelEntry->Maximize(MAX_HALF);
          break;
        case 9:
          SelEntry->MoveResize(0,0,false,e.x_root,e.y_root);
          break;
        case 10:
          SelEntry->MoveResize(S_BOTTOM|S_RIGHT,0,true,0,0);
          break;
        case 11:
          SelEntry->StackingUp();
          break;
        case 12:
          SelEntry->StackingDown();
          break;
  #ifdef SHAPE
        case 13:
          SelEntry->MakeHole(true);
          break;
        case 14:
          SelEntry->MakeHole(false);
          break;
  #endif
        case LCSHAPE+1:
          SelEntry->o.HasTBEntry = !SelEntry->o.HasTBEntry;
          if (SelEntry->parent)
            SelEntry->parent->UpdateTB();
          break;
        case LCSHAPE+2:
          SelEntry->ToggleHasTitle();
          break;
        case LCSHAPE+3:
          SelEntry->SendWMDelete(false);
          break;
        case LCSHAPE+4:
          SelEntry->SendWMDelete(true);
          break;
        case LCSHAPE+5:
          ((Desktop *)SelEntry)->ShowIcons(true);
          break;
        case LCSHAPE+6:
          SelEntry->flags ^= DF_TILE;
          if (SelEntry->flags & DF_TILE)
            ((Desktop *)SelEntry)->Tile();
          break;
        case LCSHAPE+7:
          SelEntry->flags ^= DF_AUTOSCROLL;
          break;
      }
    }
}

  Client *c = SelClient;
  if (c) {
    if (SelEntry && (Seltype == (Button2 | T_BAR)) && MoveWin) {
      Client *tb=0;
      Desktop *d = ct->FindPointerClient()->DesktopAbove();

      // Try to reparent SelEntry under d
      if (d != SelEntry->parent) {
        Desktop *dd;
        for (dd=d;dd;dd=dd->parent)
          if (dd==SelEntry) break;
        if (d && !dd) { //Don't try to reparent a desktop under itself
          Desktop *oldparent = SelEntry->parent;
          oldparent->GiveAway(SelEntry);
          if (tb)
            d->Take(SelEntry,SelEntry->x,SelEntry->y); else
            d->Take(SelEntry,
              e.x_root - xdown + SelEntry->x_root  -  d->x_root - SelEntry->o.Sc->BW,
              e.y_root - ydown + SelEntry->y_root  -  d->y_root - SelEntry->o.Sc->BW);
              /*  movement  */
              /*         absolute position        */
            oldparent->AutoClose();
        }
      }
    }
    Client *t=NULL;
    if (RefClient && Seltype != (T_B2 | T_BAR) && Seltype != T_B2)
      RefClient = 0;
    if ((T_DC |Seltype) == (T_DC | e.button | c->GetRegionMask(e.x_root,e.y_root,t)))
      if (SelEntry == (t ? t : SelClient)/* && !SelIcon*/)
        switch (Seltype) {
          case Button1 | T_BAR:
            {
              if (motion)
                break;
              Client *i;
              for (i=t;i->transfor;i=i->transfor);
              i->Raise((t!=c) ? R_MOVEMOUSE : 0);
              t->GetFocus();
            }
            break;
          case Button2:
          case Button2 | T_BAR:
            if (RefClient) {
              if (RefClient == SelEntry || RefClient->parent != SelEntry->parent)
                break;
              XWindowChanges wc;
              wc.sibling = SelEntry->frame;
              wc.stack_mode = Below;
              XConfigureWindow(dpy,RefClient->frame,CWStackMode|CWSibling,&wc);
              // move to function!
              if (RefClient->parent->LastRaised[RefClient->stacking] == RefClient) {
                RefClient->GrabButtons();
                RefClient->parent->LastRaised[RefClient->stacking] = 0;
              }
              if (RefClient->mapped)
                RefClient->GrabButtons();
              RefClient = 0;

            } else {
              RefClient = SelEntry;
            }
            break;
          case Button3 | T_BAR:
            {
              if (menu)
                break;
              Client *i;
              for (i=t;i->trans;i=i->trans);
              i->Lower(false);
            }
            break;
          case Button1 | T_F1 | T_DC:
          case Button1 | T_F1:
            t->Maximize(MAX_FULL);
            break;
          case Button2 | T_F1:
          case Button2 | T_F1 | T_DC:
            t->Maximize(MAX_HALF);
            break;
          case Button3 | T_F1:
            t->MoveResize(S_BOTTOM|S_RIGHT,0,true,0,0);
            break;
          case Button1 | T_F2:
            t->SendWMDelete(true);
            break;
          case Button2 | T_F2:
            t->Hide();
            if (t->parent) SelClient = 0;
            break;
          case Button3 | T_F2:
            if (t == c) {
              c->MoveResize(0,0,false,e.x_root, e.y_root);
            } else {
              t->MoveResize(0,0,true,0,0);
              setmouse(root, e.x_root, e.y_root);
            };
            break;
          case T_B1:
            if (!motion)
              c->Raise(0);
            break;
          case T_B3:
            if (!menu)
              c->Lower(false);
            break;


        };

  }

  if (SelIcon && Seltype == e.button && SelIcon->IsIn(e.window,e.x,e.y)) {
    switch (Seltype) {
      case T_B1:
        SelIcon->parent->Client::GetFocus(); //!!!!!
        if (SelIcon->action)
          SelIcon->action->Execute();
        if (SelIcon->client)
          SelIcon->client->Map();
        break;
      case T_B3:
        SelIcon->parent->ShowIcons(true);
        break;
    }
  }

  menu = 0;
  MoveWin = 0;
  c = SelClient;
  SelClient = 0;

  if (c && SelEntry)
    c->ReDrawTBEntry(SelEntry,false);


}



void UEHandler::Motion(XMotionEvent &e) {
  if (!motion)
    if (((e.x_root-xdown)/2) || ((e.y_root-ydown)/2))
      motion = true; else
      return;

// new client menu?
  if (SelEntry && !menu && (Seltype == (T_B3 | T_BAR) || Seltype == T_B3)) {
    menu = new Menu(ClientMenu,
                   dynamic_cast<Desktop *>(SelEntry) ? DesktopMenuNum : ClientMenuNum,
                   SelClient->o.Sc,xdown,ydown);
    menu->Init();
  }

//
  if (Seltype == T_B1)
    if (SelClient->parent) {
      int mode=0;
      if (!(SelClient->flags & CF_FIXEDSIZE)) {
        if (xdown-SelClient->x_root <= SelClient->width/RESIZERATIO)
          mode |= S_LEFT;
        if (xdown-SelClient->x_root >= (RESIZERATIO - 1)*SelClient->width/RESIZERATIO)
          mode |= S_RIGHT;
        if (ydown-SelClient->y_root <= SelClient->height/RESIZERATIO)
          mode |= S_TOP;
        if (ydown-SelClient->y_root >= (RESIZERATIO - 1)*SelClient->height/RESIZERATIO)
          mode |= S_BOTTOM;
      }
      SelClient->MoveResize(mode,0,false,xdown,ydown);
    }


  if (SelDesktop && Seltype == T_B2) {
    SelDesktop->Goto(3*(e.x_root - xdown),3*(e.y_root - ydown),GOTO_RELATIVE | GOTO_SNAP);
    xdown = e.x_root;
    ydown = e.y_root;
  }
  if (menu)
    menu->Mouse(e.x_root,e.y_root);


  if (SelClient && SelClient->parent && Seltype == (T_BAR | T_B1)) {
    SelClient->x += e.x_root - xdown;
    SelClient->y += e.y_root - ydown;
    int oldx=SelClient->x;
    int oldy=SelClient->y;
    SelClient->Snap(0);
    xdown=e.x_root+SelClient->x-oldx;
    ydown=e.y_root+SelClient->y-oldy;
    xdown -= SelClient->x; // make xdown/down relative to window
    ydown -= SelClient->y;
    if (SelClient->parent->Leave(e.x_root,e.y_root,false))
      SelClient->ChangePos();
    xdown += SelClient->x; // make xdown/ydown absolute
    ydown += SelClient->y;
  }



  if (SelIcon && (Seltype == T_B2)) {
    SelIcon->x += e.x_root - xdown;
    SelIcon->y += e.y_root - ydown;
    int oldx=SelIcon->x;
    int oldy=SelIcon->y;
    SelIcon->Move();
    xdown=e.x_root+SelIcon->x-oldx;
    ydown=e.y_root+SelIcon->y-oldy;
  }


  Client *c=SelClient;
  if (c) {

    if (SelEntry && SelEntry->parent && Seltype == (T_BAR | T_B2)) {
      int x1=c->x_root - 1 + (SelEntry==SelClient ? SelEntry->TBx : SelEntry->TBEx);
      int y1=c->y_root - 1 - c->THeight;
      if (!MoveWin) {
        XSetWindowAttributes pattr;
        pattr.override_redirect = True;
        pattr.background_pixel = c->o.Sc->colors[C_TBG].pixel;
        pattr.border_pixel = c->o.Sc->colors[C_BD].pixel;
        pattr.event_mask = ButtonReleaseMask|ExposureMask;
        pattr.save_under = true;
        int w1 = SelEntry==SelClient ? SelEntry->TBy - SelEntry->TBx :
                                       SelEntry->TBEy - SelEntry->TBEx;
        int h1=c->THeight-1;
        MoveWin = XCreateWindow(dpy, root, x1, y1 + c->THeight, w1, h1,
            1, DefaultDepth(dpy, screen), CopyFromParent, DefaultVisual(dpy, screen),
            CWOverrideRedirect|CWBackPixel|CWBorderPixel|CWEventMask|CWSaveUnder, &pattr);

        XMapWindow(dpy,MoveWin);

        XCopyArea(dpy,c->title,MoveWin,*(c->o.Sc->title_gc),
          SelEntry == SelClient ? SelEntry->TBx : SelEntry->TBEx,0,w1,h1,0,0);

      }

      XMoveWindow(dpy, MoveWin, x1 + e.x_root-xdown, y1 + e.y_root-ydown);
    }
  }
}


void UEHandler::Key(XKeyEvent &e) {
  if (e.type != KeyPress)
    return;
  if (menu && e.window == menu->window) {
    menu->Key(e);
    return;
  }
  Client *c = 0;
  KeySym keysym = XLookupKeysym(&e,0);
  int i = 0;
  Client *OldMax = ct->MaxWindow;
  if (OldMax) {
    ct->MaxWindow->Maximize(MAX_FULLSCREEN);
    if (keysym == XK_Escape)
      return;
  }

  switch (keysym) {
    case XK_Escape:
      if (ct->Current)
        ct->Current->Maximize(MAX_FULLSCREEN);
      break;
    case XK_Right:
      if (ct->Current) {
        if (e.state & ControlMask) {
          ct->Current->MoveRight();
          if (e.state & ShiftMask)
            ct->Current->Raise(0);
        } else {
          c = ct->Current->Next(true);
          if (c)  {
            c->GetFocus();
            if (e.state & ShiftMask)
              c->Raise(0);
          }
        }
      }
      break;
    case XK_Left:
      if (ct->Current) {
        if (e.state & ControlMask) {
          ct->Current->MoveLeft();
          if (e.state & ShiftMask)
            ct->Current->Raise(0);
        } else {
          c = ct->Current->Prev(true);
          if (c) {
            c->GetFocus();
            if (e.state & ShiftMask)
              c->Raise(0);
          }
        }
      }
      break;
    case XK_Up:
      if (ct->Current) {
        if (e.state & ControlMask) {
          ct->Current->MoveUp();
        } else {
          c = ct->Current->parent;
          if (c)  {
            c->GetFocus();
            if (e.state & ShiftMask)
              c->Raise(0);
          }
        }
      }
      break;
    case XK_Down:
      if (ct->Current) {
        if (e.state & ControlMask) {
          ct->Current->MoveDown();
        } else {
          Desktop *d =ct->Current->DesktopAbove();
          c = d->focus ? d->focus : d->firstchild;
          if (c) {
            c->GetFocus();
            if (e.state & ShiftMask)
              c->Raise(0);
          }
        }
      }
      break;
    case XK_Tab:
      if (ct->Current) {
        c = ct->Current->Focus();
        if (c) {
          c = (e.state & ShiftMask) ? c->Prev(false) : c->Next(false);
          if (c) {
            c->Raise(R_MOVEMOUSE | R_PARENT);
            c->GetFocus();
          }
        }
      }
      break;
    case XK_space:
      if (ct->Current) {
        if (e.state & ShiftMask)
          ct->Current->Lower(e.state & ControlMask); else
          ct->Current->Raise((e.state & ControlMask) ? R_PARENT : 0);
      }
      break;
    case XK_BackSpace:
/*
      if (!ct->Last)
        break;
        ct->Last->Raise(0);
        ct->Last->GetFocus();
*/
      if (ct->Current && ct->Current->parent) {
        XWindowChanges wc;
        wc.sibling = ct->Current->frame;
        wc.stack_mode = Below;
        XConfigureWindow(dpy, ct->Current->frame, CWStackMode|CWSibling, &wc);

      }
//      ct->
//      ct->Last->
      break;
    case XK_F1:
      {
        int i = (e.state & ShiftMask) ? 1 : 0;
        if (act[i])
          act[i]->Execute();
      }
      break;
    case XK_F3:
      if (ct->Current) {
        if (e.state & ShiftMask)
          ct->Current->Hide(); else
          ct->Current->Shade();
      }
      break;
    case XK_F4:
      if (ct->Current)
        if (!dynamic_cast<Desktop *>(ct->Current)) {
          ct->Current->SendWMDelete(!(e.state & ShiftMask));
        } else {
          if (e.state & ShiftMask)
            ct->Current->SendWMDelete(true);
        }
      break;
    case XK_F5:
      if (ct->Current) {
        if (e.state & ShiftMask)
          ct->Current->MoveResize(S_RIGHT | S_BOTTOM,0,true,0,0); else
          ct->Current->MoveResize(0,0,true,0,0);
      }
      break;
    case XK_F6:
      if (ct->Current) {
        ct->Current->Maximize((e.state & ShiftMask) ? MAX_HALF : MAX_FULL);
      }
      break;
    case XK_F7:
      if (ct->Current)
        if (e.state & ShiftMask)
          ct->Current->RequestDesktop(); else
          ct->Current->DesktopAbove()->ShowIcons(true);
      break;
    case XK_F12:
      ++i;
    case XK_F11:
      ++i;
    case XK_F10:
      ++i;
    case XK_F9:
      ++i;
    case XK_F8:
        if ((e.state & ShiftMask) || !qa[i]) {
          qa[i] = ct->Current;
        } else {
          if (!qa[i]->visible) qa[i]->Map();
          qa[i]->Raise(R_MOVEMOUSE | R_PARENT);
          qa[i]->GetFocus();
        }
      break;
    case XK_Page_Up:
      if (ct->Current)
        ct->Current->StackingUp();
      break;
    case XK_Page_Down:
      if (ct->Current)
        ct->Current->StackingDown();
      break;

  }
  if (OldMax && ct->Current)
    ct->Current->Maximize(MAX_FULLSCREEN);


}


void UEHandler::RemoveClientReferences(Client *c) {
  if (NewTarget == c) {
    XDefineCursor(dpy, root,ct->RootDesktop->o.Sc->cursors[CU_STD]);
    NewTarget = NULL;
  }
  if (SelEntry == c)
    SelEntry = 0;
  if (SelClient == c)
    SelClient = 0;
  if (SelDesktop == c)
    SelDesktop = 0;
  for (int i = 0; i!=QA_NUM; ++i)
    if (qa[i] == c)
      qa[i] = 0;
}
