/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef RESMANAGER_H
#define RESMANAGER_H

#include "global.h"
#include <hash_map>

struct eqstr {
  bool operator() (const char* s1, const char* s2) const  {
    return strcmp(s1, s2) == 0;
  }
};

typedef hash_map<const char *,Info *, hash<const char*>, eqstr> InfoList;
typedef InfoList::iterator InfoListIter;

struct Entry {
  char *tag, *value;
  Entry *next;
};

#define SE_SCEME      0
#define SE_ACTION     1
#define SE_CLIENTINFO 2
#define SE_MENUINFO   3
#define SE_NUM        4


class Section {
  public:
    ~Section();
    void SetEntry(char *,char *);
    char *GetEntry(char *);
    void IncludeSection(char *);
    bool GetIntEntry(char *, int &);
    int type;
    char *name;
    Entry *fe;
    Section *next;
};

class RPixmap {
  public:
    ~RPixmap();
    Pixmap GetPixmap();
    void FreePixmap();
    int n,w,h;
    char *path;
    Pixmap pm;
    RPixmap *next;

};

class ResManager {
public: 
	ResManager(char *);
	~ResManager();
  Section *GotoSection(char *,char *);
  void DeleteSections();
	Info *GetInfo(int,char *);
	void CreateScemes();
	void LoadCFGFile();
	RPixmap *GetPixmap(const char *);
	RPixmap *pixmaps;
	InfoList *infos[SE_NUM];
	Section *sections;
	char *config;
	
};

#endif
