/******************************************************************************
 *                                                                            *
 * File:   readtab .h         Version  1.20            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.20                                                   *
 *        - see readtab.c                                                     *
 *                                                                            *
 *****************************************************************************/

#ifndef	HANDY_DATA_TYPES

	#include "datatype.h"

#endif

/******************************************************************************

	Function Prototypes

 *****************************************************************************/

extern	int	ReadCodeTable
(
	char	*FileName,
	char	*Names		[],
	ushort	*Codes,
	ushort	MaxTableEntries,
	char	*Encoding,
	char	*Comment	[],
	int	include
) ;

extern	void	FreeCodeTable
(
	char	*Names		[],
	ushort	MaxTableEntries
) ;

extern	void	DumpCodeTable
(
	FILE	*Fout,
	char	*FileName,
	char	*Names		[],
	ushort	*Codes,
	ushort	MaxTableEntries
) ;

extern	ushort	FindCode
(
	char	*Key,
	char	*Names		[],
	ushort	*Codes,
	ushort	MaxTableEntries
) ;

/******************************************************************************

	Function Constants

 *****************************************************************************/

#define	READ_INCL	"#include "

#define	READ_ROOT	0
#define	READ_SUBFILE	1

