/******************************************************************************
 *                                                                            *
 * File:   trans   .h         Version  1.23            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.23                                                   *
 *        - see trans.c                                                       *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************

	Program Return Codes

 *****************************************************************************/

#define ERR_NONE                0       /* everything seemed to work    */

#define ERR_BAD                 1       /* unconv. characters in input  */
#define ERR_SYNTAX              2       /* syntax error                 */
#define ERR_SRC                 3       /* unable to open input file    */
#define ERR_DST                 4       /* unable to create output file */

/******************************************************************************

	Program Messages

 *****************************************************************************/

#define MSG_COPYRIGHT           \
"Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)\n"
#define MSG_VERSION             "%s %s\n"
#define MSG_FROM_TO             \
"\nSource character encoding:\n\n\
\t%s\n\
\t%s\n\
\t%s\n\
\t%s\n\
\nDestination character encoding:\n\n\
\t%s\n\
\t%s\n\
\t%s\n\
\t%s\n\n"

/******************************************************************************

	Program Error Messages

 *****************************************************************************/

#define ERR_MSG_SYNTAX          "Syntax: %s {-b*} {src} {dst}\n"
#define ERR_MSG_SRC             "%s: unable to open input file %s!\n"
#define ERR_MSG_DST             "%s: unable to create output file %s\n"

/******************************************************************************

	Program Constants/Macros/Switches

 *****************************************************************************/

/******************************************************************************

	The function utime () is used to preserve the file date stamp
	when calling the program with only one filename, eg.

		trans myfile

	This will convert "myfile" from one encoding to another. It
	is achieved by writing a temporary file and then renaming it
	to the original file. This alters the file dates. If one wants
	to preserve them, one has to stat () the file before it is
	altered and utime () the file afterwards. On the other hand
	it's not ANSI-C and it is not supported by all compilers.

 *****************************************************************************/

/*
	if you want to use non-ANSI utime (), uncomment the following line
*/
/* #define	USE_UTIMBUF */

/*
	if your compiler doesn't define utimbuf, ...
*/
/* #define	NO_UTIMBUF */

/******************************************************************************

	Sample combinations depending on your OS:

	MS-DOS BCC	-DUSE_UTIMBUF
	NeXTSTEP	-DUSE_UTIMBUF -DNO_UTIMBUF

 *****************************************************************************/
