/*
 *	Copyright (c) 1993-1997 JSC Rinet, Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/* keyb.c -- keyboard functions */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/time.h>
#ifdef	HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
#include <unistd.h>
#ifdef	TIME_WITH_SYS_TIME
#include <time.h>
#endif

#include "trafshow.h"

/* Is input pending on fd */
int
kbhit(fd)
	register int fd;
{
#if defined(FIONREAD)
	int inqueue = 0;
	ioctl(fd, FIONREAD, &inqueue);
	return inqueue;
#elif defined(FIORDCHK)
	int inqueue = 0;
	ioctl(fd, FIORDCHK, &inqueue);
	return inqueue;
#elif defined(HAVE_SELECT)
	struct timeval timeout = {0, 0};
	fd_set ready;

	FD_ZERO(&ready);
	FD_SET(fd, &ready);
	if (select(fd + 1, &ready, NULL, NULL, &timeout) <= 0) return 0;
	return FD_ISSET(fd, &ready);
#else
	return 0;
#endif
}

int
get_arrowkey(get1ch)
	int (*get1ch)();
{
	int ch, ch1;

	ch = (*get1ch)();
	if (ch == '[' || ch == 'O')
		ch = (*get1ch)();
	switch (ch) {
		case '\0':	/* xterm */
			return KEYMAP_HOME;
		case 'A':
		case 'i':
			return KEYMAP_UP;

		case 'B':
			return KEYMAP_DOWN;

		case 'D':
			return KEYMAP_LEFT;

		case 'C':
			return KEYMAP_RIGHT;

		case 'I':		/* ansi  PgUp */
		case 'V':		/* at386 PgUp */
		case 'S':		/* 97801 PgUp */
		case 'v':		/* emacs style */
			return KEYMAP_PAGE_UP;

		case 'G':		/* ansi  PgDn */
		case 'U':		/* at386 PgDn */
		case 'T':		/* 97801 PgDn */
			return KEYMAP_PAGE_DOWN;

		case 'H':		/* at386  Home */
			return KEYMAP_HOME;
					
		case 'F':		/* ansi   End */
		case 'Y':		/* at386  End */
			return KEYMAP_END;

		case '5':		/* vt200 PgUp */
			ch = (*get1ch)();	/* eat the ~ (interesting use of words :) */
			return KEYMAP_PAGE_UP;

		case '6':		/* vt200 PgUp */
			ch = (*get1ch)();	/* eat the ~  */
			return KEYMAP_PAGE_DOWN;

		case '1':		/* vt200 PgUp */
			ch = (*get1ch)();
			switch(ch) {	/* xterm */
				case '1':
					ch1 = (*get1ch)();	/* eat the ~ */
					return KEYMAP_F1;
				case '2':
					ch1 = (*get1ch)();	/* eat the ~ */
					return KEYMAP_F2;
				case '3':
					ch1 = (*get1ch)();	/* eat the ~ */
					return KEYMAP_F3;
				case '4':
					ch1 = (*get1ch)();	/* eat the ~ */
					return KEYMAP_F4;
				case '5':	/* RS/6000 PgUp is 150g, PgDn is 154g */
					ch = (*get1ch)();
					ch1 = (*get1ch)();	/* eat the ~ */
					if (ch == '0')
						return KEYMAP_PAGE_UP;
					if (ch == '4') 
						return KEYMAP_PAGE_DOWN;
			}
			return KEYMAP_HOME;

		case '4':		/* vt200 PgUp */
			ch = (*get1ch)();	/* eat the ~  */
			return KEYMAP_END;

		case '2':	/* xterm */
			ch = (*get1ch)();	/* eat the ~  */
		case 'L':
			return KEYMAP_INS;
		case 'M':
			return KEYMAP_F1;
		case 'N':
			return KEYMAP_F2;
		case 'O':
			return KEYMAP_F3;
		case 'P':
			return KEYMAP_F4;

		default:
			return KEYMAP_UNKNOWN;
	}
}
